/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.entity.spawn;

import com.mojang.minecraft.client.gui.IProgressUpdate;
import com.mojang.minecraft.core.entity.EntityLiving;
import com.mojang.minecraft.core.entity.EntityPlayer;
import com.mojang.minecraft.core.entity.EntitySkeleton;
import com.mojang.minecraft.core.entity.EntitySpider;
import com.mojang.minecraft.core.entity.spawn.SpawnerMonsters;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.chunk.ChunkCoordIntPair;
import com.mojang.minecraft.core.level.chunk.ChunkPosition;
import com.mojang.minecraft.core.level.tile.material.Material;
import com.mojang.minecraft.core.util.MathHelper;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpawnerAnimals {
    private int maxSpawns;
    private Class<?> spawnBaseClass;
    private Class<?>[] spawnSubclasses;
    private Set<ChunkCoordIntPair> nearbyChunkSet = new HashSet<ChunkCoordIntPair>();

    public SpawnerAnimals(int spawnLimit, Class<?> baseclass, Class<?>[] subclasses) {
        this.maxSpawns = spawnLimit;
        this.spawnBaseClass = baseclass;
        this.spawnSubclasses = subclasses;
    }

    public void trySpawn(World world) {
        int mobCap = world.getMatchingEntities(this.spawnBaseClass);
        float ratio = 1.0f;
        ratio = !(this instanceof SpawnerMonsters) ? world.getCurrentSeason().getMobRatio() : 2.0f - world.getCurrentSeason().getMobRatio();
        if ((float)mobCap < (float)this.maxSpawns * ratio) {
            int j = 0;
            while (j < 3) {
                this.rollForMobSpawn(world, 1, null);
                ++j;
            }
        }
    }

    protected ChunkPosition randomPosWithinChunk(World world, int x, int z) {
        int tryX = x + world.rand.nextInt(16);
        int tryY = world.rand.nextInt(128);
        int tryZ = z + world.rand.nextInt(16);
        return new ChunkPosition(tryX, tryY, tryZ);
    }

    private int rollForMobSpawn(World world, int recurse, IProgressUpdate iprogressupdate) {
        this.nearbyChunkSet.clear();
        int player = 0;
        while (player < world.playerEntities.size()) {
            EntityPlayer entityplayer = world.playerEntities.get(player);
            int playerXChunk = MathHelper.floor_double(entityplayer.posX / 16.0);
            int playerZchunk = MathHelper.floor_double(entityplayer.posZ / 16.0);
            int checks = 4;
            int checkX = -checks;
            while (checkX <= checks) {
                int checkZ = -checks;
                while (checkZ <= checks) {
                    this.nearbyChunkSet.add(new ChunkCoordIntPair(checkX + playerXChunk, checkZ + playerZchunk));
                    ++checkZ;
                }
                ++checkX;
            }
            ++player;
        }
        int k = 0;
        Iterator<ChunkCoordIntPair> iterator = this.nearbyChunkSet.iterator();
        int hostileAttempts = world.difficulty;
        while (iterator.hasNext()) {
            ChunkCoordIntPair chunkcoordintpair = iterator.next();
            if (world.rand.nextInt(10) != 0) continue;
            int j1 = world.rand.nextInt(this.spawnSubclasses.length);
            ChunkPosition chunkposition = this.randomPosWithinChunk(world, chunkcoordintpair.chunkX * 16, chunkcoordintpair.chunkZ * 16);
            int checkX = chunkposition.x;
            int checkY = chunkposition.y;
            int checkZ = chunkposition.z;
            if (world.isBlockNormalCube(checkX, checkY, checkZ)) {
                if (checkY < 64 && this instanceof SpawnerMonsters && world.skyLightSubtracted < 3 && hostileAttempts > 0) {
                    --hostileAttempts;
                    continue;
                }
                return 0;
            }
            if (world.getMaterialXYZ(checkX, checkY, checkZ) != Material.air) {
                if (checkY < 64 && this instanceof SpawnerMonsters && world.skyLightSubtracted < 3 && hostileAttempts > 0) {
                    --hostileAttempts;
                    continue;
                }
                return 0;
            }
            int l2 = 0;
            while (l2 < 3) {
                int i3 = checkX;
                int j3 = checkY;
                int k3 = checkZ;
                int byte1 = 6;
                int l3 = 0;
                while (l3 < 2) {
                    float f5;
                    float f4;
                    float f3;
                    float f6;
                    float f2;
                    float f1;
                    float f;
                    if (!(!world.isBlockNormalCube(i3 += world.rand.nextInt(byte1) - world.rand.nextInt(byte1), (j3 += world.rand.nextInt(1) - world.rand.nextInt(1)) - 1, k3 += world.rand.nextInt(byte1) - world.rand.nextInt(byte1)) || world.isBlockNormalCube(i3, j3, k3) || world.getMaterialXYZ(i3, j3, k3).getIsGroundCover() || world.isBlockNormalCube(i3, j3 + 1, k3) || world.getClosestPlayer(f = (float)i3 + 0.5f, f1 = (float)j3, f2 = (float)k3 + 0.5f, 24.0) != null || (f6 = (f3 = f - (float)world.spawnX) * f3 + (f4 = f1 - (float)world.spawnY) * f4 + (f5 = f2 - (float)world.spawnZ) * f5) < 576.0f)) {
                        EntityLiving entityliving;
                        try {
                            entityliving = (EntityLiving)this.spawnSubclasses[j1].getConstructor(World.class).newInstance(world);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            return k;
                        }
                        entityliving.setLocationAndAngles(f, f1, f2, world.rand.nextFloat() * 360.0f, 0.0f);
                        if (entityliving.shouldSpawnOnTile()) {
                            ++k;
                            world.entityJoinedWorld(entityliving);
                            if (entityliving instanceof EntitySpider && world.rand.nextInt(100) == 0) {
                                EntitySkeleton entityskeleton = new EntitySkeleton(world);
                                entityskeleton.setLocationAndAngles(f, f1, f2, entityliving.rotationYaw, 0.0f);
                                world.entityJoinedWorld(entityskeleton);
                                entityskeleton.mountEntity(entityliving);
                            }
                        }
                    }
                    ++l3;
                }
                ++l2;
            }
        }
        return k;
    }
}

