/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.level;

import com.mojang.minecraft.MinecraftException;
import com.mojang.minecraft.client.Minecraft;
import com.mojang.minecraft.client.gui.IProgressUpdate;
import com.mojang.minecraft.client.render.IWorldAccess;
import com.mojang.minecraft.client.render.Vec3D;
import com.mojang.minecraft.client.sound.ThreadThunderSound;
import com.mojang.minecraft.core.entity.Entity;
import com.mojang.minecraft.core.entity.EntityGiant;
import com.mojang.minecraft.core.entity.EntityItem;
import com.mojang.minecraft.core.entity.EntityLiving;
import com.mojang.minecraft.core.entity.EntityPlayer;
import com.mojang.minecraft.core.entity.Explosion;
import com.mojang.minecraft.core.entity.MovingObjectPosition;
import com.mojang.minecraft.core.entity.path.PathEntity;
import com.mojang.minecraft.core.entity.path.Pathfinder;
import com.mojang.minecraft.core.entity.tile.GearGroup;
import com.mojang.minecraft.core.entity.tile.IBlockAccess;
import com.mojang.minecraft.core.entity.tile.TileEntity;
import com.mojang.minecraft.core.entity.tile.TileEntityGear;
import com.mojang.minecraft.core.enums.EnumSeason;
import com.mojang.minecraft.core.enums.EnumSkyBlock;
import com.mojang.minecraft.core.enums.EnumWeather;
import com.mojang.minecraft.core.level.NextTickListEntry;
import com.mojang.minecraft.core.level.chunk.Chunk;
import com.mojang.minecraft.core.level.chunk.ChunkCache;
import com.mojang.minecraft.core.level.chunk.ChunkCoordIntPair;
import com.mojang.minecraft.core.level.chunk.ChunkCoordinates;
import com.mojang.minecraft.core.level.chunk.ChunkLoader;
import com.mojang.minecraft.core.level.chunk.ChunkProviderCorruption;
import com.mojang.minecraft.core.level.chunk.ChunkProviderDesert;
import com.mojang.minecraft.core.level.chunk.ChunkProviderGenerate;
import com.mojang.minecraft.core.level.chunk.ChunkProviderIndev;
import com.mojang.minecraft.core.level.chunk.ChunkProviderLoadOrGenerate;
import com.mojang.minecraft.core.level.chunk.ChunkProviderSky;
import com.mojang.minecraft.core.level.chunk.LightZone;
import com.mojang.minecraft.core.level.generate.IChunkProvider;
import com.mojang.minecraft.core.level.generate.noise.NoiseGeneratorPerlin;
import com.mojang.minecraft.core.level.region.RegionFileCache;
import com.mojang.minecraft.core.level.tile.Block;
import com.mojang.minecraft.core.level.tile.BlockBurntCloth;
import com.mojang.minecraft.core.level.tile.BlockFluids;
import com.mojang.minecraft.core.level.tile.material.Material;
import com.mojang.minecraft.core.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.core.nbt.NBTTagCompound;
import com.mojang.minecraft.core.util.CompressedStreamTools;
import com.mojang.minecraft.core.util.MathHelper;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class World
implements IBlockAccess {
    public static final int NORMAL = 0;
    public static final int FLOATING = 1;
    public static final int CORRUPTION = 2;
    public static final int DESERT = 3;
    public static final int INDEV = 4;
    public static final HashMap<Integer, String> TYPENAMES = new HashMap<Integer, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(0, "NORMAL");
            this.put(1, "FLOATING");
            this.put(2, "CORRUPTION");
            this.put(3, "DESERT");
            this.put(4, "OLD-TIMEY");
        }
    };
    public float cloudHeight = 108.0f;
    private List<LightZone> lightingZones;
    public List<Entity> loadedEntityList;
    private List<Object> unloadedEntityList;
    private TreeSet<NextTickListEntry> field_1023_B;
    private Set<NextTickListEntry> field_1022_C;
    public List<Object> field_1049_b;
    public long worldTime;
    public boolean snowCovered;
    private long skyTopColor;
    private long skyEdgeColor;
    private long fogColor;
    public int skyLightSubtracted;
    protected int randomInt;
    protected int someOtherNumber;
    public boolean etitingBlocks;
    public static float[] field_1042_i = new float[16];
    private final long field_1018_G;
    protected int saveRate;
    public List<EntityPlayer> playerEntities;
    public List<Entity> weatherEffects;
    public int difficulty;
    public Object field_1038_m;
    public Random rand;
    public int spawnX;
    public int spawnY;
    public int spawnZ;
    public boolean isNewWorld;
    protected List<IWorldAccess> worldAccesses;
    public IChunkProvider chunkProvider;
    public File worldFolder;
    public long randomSeed;
    private NBTTagCompound nbtCompoundPlayer;
    public long sizeOnDisk;
    public final String field_1028_w;
    public boolean findingSpawnPoint;
    private ArrayList<AxisAlignedBB> field_1015_J;
    private Set<ChunkCoordIntPair> setOfTickableChunks;
    private int ambienceChance;
    private List<Entity> field_1012_M;
    public boolean multiplayerWorld;
    public boolean cheatsDisabled;
    public int worldType;
    public ArrayList<GearGroup> gearGroups;
    public int multiplayerDifficulty;
    public Minecraft mc;
    public boolean justLoaded;
    public EnumSeason season;
    public EnumSeason lastSeason;
    public long lastDay;
    public EnumWeather weather;
    public boolean loadedSinceOneOneTwelve;
    public boolean experiencedFirstSnow = false;
    public int daysInSeason = 14;
    public float seasonProgress = 0.0f;
    private NoiseGeneratorPerlin foliage;
    public boolean seasonChanged = false;
    public boolean dayChanged = false;

    static {
        float f = 0.05f;
        int i = 0;
        while (i <= 15) {
            float f1 = 1.0f - (float)i / 15.0f;
            World.field_1042_i[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f) + f;
            ++i;
        }
    }

    public static NBTTagCompound func_629_a(File file, String s) {
        File file1 = new File(file, "NSSSsaves");
        File file2 = new File(file1, s);
        if (!file2.exists()) {
            return null;
        }
        File file3 = new File(file2, "level.dat");
        if (file3.exists()) {
            try {
                FileInputStream fis = new FileInputStream(file3);
                NBTTagCompound nbttagcompound = CompressedStreamTools.func_1138_a(fis);
                NBTTagCompound nbttagcompound1 = nbttagcompound.getCompoundTag("Data");
                fis.close();
                return nbttagcompound1;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public static void func_615_b(File file, String s) {
        File file1 = new File(file, "NSSSsaves");
        File file2 = new File(file1, s);
        if (!file2.exists()) {
            return;
        }
        World.func_653_a(file2.listFiles());
        file2.delete();
    }

    public static void func_615_b2(File file, String s) {
        File file1 = new File(file, "NSSSservers");
        File file2 = new File(file1, s);
        if (!file2.exists()) {
            return;
        }
        World.func_653_a(file2.listFiles());
        file2.delete();
    }

    private static void func_653_a(File[] afile) {
        RegionFileCache.clear();
        int i = 0;
        while (i < afile.length) {
            if (afile[i].isDirectory()) {
                World.func_653_a(afile[i].listFiles());
            }
            afile[i].delete();
            ++i;
        }
    }

    public World(File file, String s, EnumSeason seasons, EnumWeather weathers, boolean cheatsDisabled, int worldType, Minecraft mine) {
        this(file, s, new Random().nextLong(), seasons, weathers, cheatsDisabled, worldType, mine);
    }

    public World(String s, Minecraft mine) {
        this.lightingZones = new ArrayList<LightZone>();
        this.loadedEntityList = new ArrayList<Entity>();
        this.unloadedEntityList = new ArrayList<Object>();
        this.field_1023_B = new TreeSet();
        this.field_1022_C = new HashSet<NextTickListEntry>();
        this.field_1049_b = new ArrayList<Object>();
        this.worldTime = 0L;
        this.snowCovered = false;
        this.season = EnumSeason.summer;
        this.weather = EnumWeather.clear;
        this.skyTopColor = 0x88BBFFL;
        this.skyEdgeColor = 12638463L;
        this.fogColor = 0xFFFFFFL;
        this.skyLightSubtracted = 0;
        this.randomInt = new Random().nextInt();
        this.someOtherNumber = 1013904223;
        this.etitingBlocks = false;
        this.field_1018_G = System.currentTimeMillis();
        this.saveRate = 40;
        this.playerEntities = new ArrayList<EntityPlayer>();
        this.weatherEffects = new ArrayList<Entity>();
        this.rand = new Random();
        this.isNewWorld = false;
        this.worldAccesses = new ArrayList<IWorldAccess>();
        this.randomSeed = 0L;
        this.sizeOnDisk = 0L;
        this.field_1015_J = new ArrayList();
        this.setOfTickableChunks = new HashSet<ChunkCoordIntPair>();
        this.ambienceChance = this.rand.nextInt(12000);
        this.field_1012_M = new ArrayList<Entity>();
        this.multiplayerWorld = false;
        this.field_1028_w = s;
        this.chunkProvider = this.getWorldChunkProvider(this.worldFolder);
        this.gearGroups = new ArrayList();
        this.mc = mine;
        this.justLoaded = false;
        this.loadedSinceOneOneTwelve = true;
        this.experiencedFirstSnow = false;
        this.foliage = new NoiseGeneratorPerlin();
        this.func_644_f();
    }

    public World(File file, String s, long seed, EnumSeason seasons, EnumWeather weathers, boolean cheatsDisableds, int worldTypes, Minecraft mine) {
        this.cheatsDisabled = cheatsDisableds;
        this.lightingZones = new ArrayList<LightZone>();
        this.loadedEntityList = new ArrayList<Entity>();
        this.unloadedEntityList = new ArrayList<Object>();
        this.field_1023_B = new TreeSet();
        this.field_1022_C = new HashSet<NextTickListEntry>();
        this.field_1049_b = new ArrayList<Object>();
        this.worldTime = 0L;
        this.snowCovered = seasons == EnumSeason.winter;
        this.season = seasons;
        this.weather = weathers;
        this.worldType = worldTypes;
        this.skyTopColor = 0x88BBFFL;
        this.skyEdgeColor = 12638463L;
        this.fogColor = 0xFFFFFFL;
        this.skyLightSubtracted = 0;
        this.randomInt = new Random().nextInt();
        this.someOtherNumber = 1013904223;
        this.etitingBlocks = false;
        this.field_1018_G = System.currentTimeMillis();
        this.saveRate = 40;
        this.playerEntities = new ArrayList<EntityPlayer>();
        this.weatherEffects = new ArrayList<Entity>();
        this.rand = new Random();
        this.isNewWorld = false;
        this.worldAccesses = new ArrayList<IWorldAccess>();
        this.randomSeed = 0L;
        this.sizeOnDisk = 0L;
        this.field_1015_J = new ArrayList();
        this.setOfTickableChunks = new HashSet<ChunkCoordIntPair>();
        this.ambienceChance = this.rand.nextInt(12000);
        this.field_1012_M = new ArrayList<Entity>();
        this.multiplayerWorld = false;
        this.field_1028_w = s;
        file.mkdirs();
        this.worldFolder = new File(file, s);
        this.worldFolder.mkdirs();
        this.gearGroups = new ArrayList();
        this.mc = mine;
        this.experiencedFirstSnow = false;
        try {
            File file1 = new File(this.worldFolder, "session.lock");
            DataOutputStream dataoutputstream = new DataOutputStream(new FileOutputStream(file1));
            try {
                dataoutputstream.writeLong(this.field_1018_G);
            }
            finally {
                dataoutputstream.close();
            }
        }
        catch (IOException ioexception) {
            throw new RuntimeException("Failed to check session lock, aborting");
        }
        File file2 = new File(this.worldFolder, "level.dat");
        boolean bl = this.isNewWorld = !file2.exists();
        if (file2.exists()) {
            try {
                NBTTagCompound nbttagcompound1;
                FileInputStream fis;
                block15: {
                    fis = new FileInputStream(file2);
                    NBTTagCompound nbttagcompound = CompressedStreamTools.func_1138_a(fis);
                    nbttagcompound1 = nbttagcompound.getCompoundTag("Data");
                    this.randomSeed = nbttagcompound1.getLong("RandomSeed");
                    this.spawnX = nbttagcompound1.getInteger("SpawnX");
                    this.spawnY = nbttagcompound1.getInteger("SpawnY");
                    this.spawnZ = nbttagcompound1.getInteger("SpawnZ");
                    this.worldTime = nbttagcompound1.getLong("Time");
                    this.sizeOnDisk = nbttagcompound1.getLong("SizeOnDisk");
                    this.snowCovered = nbttagcompound1.getBoolean("SnowCovered");
                    this.cheatsDisabled = nbttagcompound1.getBoolean("cheatsDisabled");
                    this.loadedSinceOneOneTwelve = nbttagcompound1.getBoolean("loadedSinceOneOneTwelve");
                    this.experiencedFirstSnow = nbttagcompound1.getBoolean("experiencedFirstSnow");
                    try {
                        this.weather = EnumWeather.valueOf(nbttagcompound1.getString("weather"));
                        this.season = EnumSeason.valueOf(nbttagcompound1.getString("season"));
                    }
                    catch (Exception ex) {
                        System.out.println("Failed to load season or weather data!");
                        if (!this.snowCovered || this.loadedSinceOneOneTwelve) break block15;
                        this.season = EnumSeason.winter;
                        this.weather = EnumWeather.precipitation;
                    }
                }
                System.out.println("Loaded? : " + this.loadedSinceOneOneTwelve + " weather: " + (Object)((Object)this.weather) + ", season: " + (Object)((Object)this.season));
                this.worldType = nbttagcompound1.getBoolean("isFloating") ? 1 : nbttagcompound1.getInteger("WorldType");
                if (nbttagcompound1.hasKey("Player")) {
                    this.nbtCompoundPlayer = nbttagcompound1.getCompoundTag("Player");
                }
                fis.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        boolean flag = false;
        if (this.randomSeed == 0L) {
            this.randomSeed = seed;
            flag = true;
        }
        this.chunkProvider = this.getWorldChunkProvider(this.worldFolder);
        Random ramd = new Random();
        ramd.setSeed(this.randomSeed);
        this.foliage = new NoiseGeneratorPerlin(ramd);
        if (flag) {
            this.findingSpawnPoint = true;
            this.spawnX = 0;
            this.spawnY = 64;
            this.spawnZ = 0;
            while (!this.isThisBlockSpawnable(this.spawnX, this.spawnZ)) {
                this.spawnX += this.rand.nextInt(64) - this.rand.nextInt(64);
                this.spawnZ += this.rand.nextInt(64) - this.rand.nextInt(64);
            }
            this.findingSpawnPoint = false;
        }
        this.func_644_f();
    }

    protected IChunkProvider getWorldChunkProvider(File file) {
        if (this.worldType == 1) {
            return new ChunkProviderLoadOrGenerate(this, new ChunkLoader(file, true), new ChunkProviderSky(this, this.randomSeed));
        }
        if (this.worldType == 2) {
            return new ChunkProviderLoadOrGenerate(this, new ChunkLoader(file, true), new ChunkProviderCorruption(this, this.randomSeed));
        }
        if (this.worldType == 3) {
            return new ChunkProviderLoadOrGenerate(this, new ChunkLoader(file, true), new ChunkProviderDesert(this, this.randomSeed));
        }
        if (this.worldType == 4) {
            return new ChunkProviderLoadOrGenerate(this, new ChunkLoader(file, true), new ChunkProviderIndev(this, this.randomSeed));
        }
        return new ChunkProviderLoadOrGenerate(this, new ChunkLoader(file, true), new ChunkProviderGenerate(this, this.randomSeed));
    }

    public void func_622_a() {
        if (this.spawnY <= 0) {
            this.spawnY = 64;
        }
        while (this.getLowestSpawnableBlock(this.spawnX, this.spawnZ) == 0) {
            this.spawnX += this.rand.nextInt(8) - this.rand.nextInt(8);
            this.spawnZ += this.rand.nextInt(8) - this.rand.nextInt(8);
        }
    }

    public void setSpawnLocation() {
        if (this.spawnY <= 0) {
            this.spawnY = 64;
        }
        int i = this.spawnX;
        int j = this.spawnZ;
        while (this.getFirstUncoveredBlock(i, j) == 0) {
            i += this.rand.nextInt(8) - this.rand.nextInt(8);
            j += this.rand.nextInt(8) - this.rand.nextInt(8);
        }
        this.spawnX = i;
        this.spawnZ = j;
    }

    public int getFirstUncoveredBlock(int i, int j) {
        int k = 63;
        while (!this.isAirBlock(i, k + 1, j)) {
            ++k;
        }
        return this.getBlockId(i, k, j);
    }

    private boolean isThisBlockSpawnable(int x, int z) {
        int k = this.getLowestSpawnableBlock(x, z);
        if (this.worldType == 1 || this.worldType == 2 || this.worldType == 3) {
            return k == Block.grass.blockID;
        }
        return k == Block.sand.blockID;
    }

    private int getLowestSpawnableBlock(int x, int z) {
        int k = 63;
        while (this.getBlockId(x, k + 1, z) != 0) {
            ++k;
        }
        return this.getBlockId(x, k, z);
    }

    public void spawnPlayerWithLoadedChunks(EntityPlayer entityplayer) {
        try {
            if (this.nbtCompoundPlayer != null) {
                entityplayer.readFromNBT(this.nbtCompoundPlayer);
                this.nbtCompoundPlayer = null;
            }
            this.entityJoinedWorld(entityplayer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.mc.bindClouds();
    }

    public void saveAllChunks(boolean flag, IProgressUpdate iprogressupdate) {
        if (!this.chunkProvider.canSave()) {
            return;
        }
        if (iprogressupdate != null) {
            iprogressupdate.func_594_b("Saving level");
        }
        this.loadWorldSaveInfo();
        if (iprogressupdate != null) {
            iprogressupdate.func_595_d("Saving chunks");
        }
        this.chunkProvider.saveChunks(flag, iprogressupdate);
        if (iprogressupdate != null) {
            RegionFileCache.clear();
        }
    }

    public void setSpawn(int x, int y, int z) {
        this.spawnX = x;
        this.spawnY = y;
        this.spawnZ = z;
    }

    private void loadWorldSaveInfo() {
        this.checkSessionLock();
        File getName = new File(this.worldFolder, "name.data");
        String lvlName = "New World";
        if (getName.exists()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(getName));
                lvlName = br.readLine().replace("\u0000", "");
                br.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.setLong("RandomSeed", this.randomSeed);
        nbttagcompound.setString("LevelName", lvlName);
        nbttagcompound.setInteger("SpawnX", this.spawnX);
        nbttagcompound.setInteger("SpawnY", this.spawnY);
        nbttagcompound.setInteger("SpawnZ", this.spawnZ);
        nbttagcompound.setLong("Time", this.worldTime);
        nbttagcompound.setLong("SizeOnDisk", this.sizeOnDisk);
        nbttagcompound.setBool("SnowCovered", this.snowCovered);
        nbttagcompound.setBool("cheatsDisabled", this.cheatsDisabled);
        nbttagcompound.setInteger("WorldType", this.worldType);
        nbttagcompound.setLong("LastPlayed", System.currentTimeMillis());
        nbttagcompound.setBool("loadedSinceOneOneTwelve", true);
        nbttagcompound.setBool("experiencedFirstSnow", this.experiencedFirstSnow);
        nbttagcompound.setString("weather", this.weather.toString());
        nbttagcompound.setString("season", this.season.toString());
        EntityPlayer entityplayer = null;
        if (this.playerEntities.size() > 0) {
            entityplayer = this.playerEntities.get(0);
        }
        if (entityplayer != null) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            entityplayer.writeToNBT(nbttagcompound1);
            nbttagcompound.func_763_a("Player", nbttagcompound1);
        }
        NBTTagCompound nbttagcompound2 = new NBTTagCompound();
        nbttagcompound2.setList("Data", nbttagcompound);
        try {
            File file = new File(this.worldFolder, "level.dat_new");
            File file1 = new File(this.worldFolder, "level.dat_old");
            File file2 = new File(this.worldFolder, "level.dat");
            FileOutputStream fos = new FileOutputStream(file);
            CompressedStreamTools.writeGzippedCompoundToOutputStream(nbttagcompound2, fos);
            if (file1.exists()) {
                file1.delete();
            }
            file2.renameTo(file1);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            if (file.exists()) {
                file.delete();
            }
            fos.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean func_650_a(int i) {
        if (!this.chunkProvider.canSave()) {
            return true;
        }
        if (i == 0) {
            this.loadWorldSaveInfo();
        }
        return this.chunkProvider.saveChunks(false, null);
    }

    @Override
    public int getBlockId(int x, int y, int z) {
        if (x < -32000000 || z < -32000000 || x >= 32000000 || z > 32000000 || y < 0 || y >= 128) {
            return 0;
        }
        return this.getChunkFromChunkCoords(x >> 4, z >> 4).getBlockId(x & 0xF, y, z & 0xF);
    }

    public ArrayList<Vec3D> getBlockConnectedGears(int i, int j, int k) {
        ArrayList<Vec3D> gears = new ArrayList<Vec3D>();
        if (this.getBlockId(i - 1, j, k) == Block.gear.blockID) {
            gears.add(Vec3D.createVectorHelper(i - 1, j, k));
            this.notifyBlockChange(i - 1, j, k, 0);
        }
        if (this.getBlockId(i + 1, j, k) == Block.gear.blockID) {
            gears.add(Vec3D.createVectorHelper(i + 1, j, k));
            this.notifyBlockChange(i - 1, j, k, 0);
        }
        if (this.getBlockId(i, j, k - 1) == Block.gear.blockID) {
            gears.add(Vec3D.createVectorHelper(i, j, k - 1));
            this.notifyBlockChange(i - 1, j, k, 0);
        }
        if (this.getBlockId(i, j, k + 1) == Block.gear.blockID) {
            gears.add(Vec3D.createVectorHelper(i, j, k + 1));
            this.notifyBlockChange(i - 1, j, k, 0);
        }
        return gears;
    }

    public boolean isSolidBlockTowardDirection(int posX, int posY, int posZ, int dirX, int dirZ) {
        return this.isBlockNormalCube(posX + dirX, posY, posZ + dirZ);
    }

    public int getGearPower(int x, int y, int z) {
        TileEntity gearEntity = this.getBlockTileEntity(x, y, z);
        if (gearEntity != null && gearEntity instanceof TileEntityGear) {
            return ((TileEntityGear)gearEntity).getGearPower();
        }
        return 0;
    }

    public int getGearTextureIndex(int x, int y, int z) {
        int power = this.getGearPower(x, y, z);
        if (power > 0) {
            return 78;
        }
        return 62;
    }

    public ArrayList<Vec3D> getGearConnectedGears(int i, int j, int k) {
        ArrayList<Vec3D> gears = new ArrayList<Vec3D>();
        return gears;
    }

    public void addToGearList(TileEntityGear origin, TileEntityGear toAdd) {
        this.gearListCleanup();
        if (toAdd != null && !toAdd.isInGroup) {
            if (this.gearGroups.size() <= 1) {
                this.gearGroups.add(new GearGroup(this));
            }
            int i = 0;
            while (i < this.gearGroups.size() - 1) {
                if (this.gearGroups.get(i).hasGear(origin) && !this.gearGroups.get(i).hasGear(toAdd)) {
                    this.gearGroups.get(i).addToGearGroup(toAdd);
                } else if (!this.gearGroups.get(i).hasGear(origin)) {
                    this.gearGroups.add(new GearGroup(this));
                    this.gearGroups.get(this.gearGroups.size() - 1).addToGearGroup(origin);
                    this.gearGroups.get(this.gearGroups.size() - 1).addToGearGroup(toAdd);
                }
                ++i;
            }
            toAdd.isInGroup = true;
        }
    }

    public GearGroup getGearGroupFromGear(TileEntityGear reference) {
        this.gearListCleanup();
        if (reference != null) {
            if (this.gearGroups.size() <= 1) {
                this.gearGroups.add(new GearGroup(this));
                this.gearGroups.get(0).addToGearGroup(reference);
                return this.gearGroups.get(0);
            }
            int i = 0;
            while (i < this.gearGroups.size()) {
                if (this.gearGroups.get(i).hasGear(reference)) {
                    return this.gearGroups.get(i);
                }
                ++i;
            }
            this.gearGroups.add(new GearGroup(this));
            this.gearGroups.get(this.gearGroups.size() - 1).addToGearGroup(reference);
            return this.gearGroups.get(this.gearGroups.size() - 1);
        }
        return null;
    }

    public void addToGearList(TileEntityGear toAdd) {
        if (toAdd != null) {
            if (this.gearGroups.size() <= 1) {
                this.gearGroups.add(new GearGroup(this));
            }
            ArrayList<GearGroup> groups = new ArrayList<GearGroup>();
            groups.add(this.getGearGroupFromGear(this.getGearAt(toAdd.x + 1, toAdd.y, toAdd.z)));
            groups.add(this.getGearGroupFromGear(this.getGearAt(toAdd.x - 1, toAdd.y, toAdd.z)));
            groups.add(this.getGearGroupFromGear(this.getGearAt(toAdd.x, toAdd.y + 1, toAdd.z)));
            groups.add(this.getGearGroupFromGear(this.getGearAt(toAdd.x, toAdd.y - 1, toAdd.z)));
            groups.add(this.getGearGroupFromGear(this.getGearAt(toAdd.x, toAdd.y, toAdd.z + 1)));
            groups.add(this.getGearGroupFromGear(this.getGearAt(toAdd.x, toAdd.y, toAdd.z - 1)));
            ArrayList<GearGroup> filteredGroup = new ArrayList<GearGroup>();
            int i = 0;
            while (i < groups.size()) {
                if (groups.get(i) != null) {
                    filteredGroup.add((GearGroup)groups.get(i));
                }
                ++i;
            }
            if (filteredGroup.size() != 0) {
                i = 0;
                while (i < filteredGroup.size()) {
                    if (filteredGroup.size() > 3) {
                        ((GearGroup)filteredGroup.get(0)).mergeGroup((GearGroup)filteredGroup.get(1));
                        filteredGroup.remove(1);
                    }
                    ++i;
                }
                System.out.println(filteredGroup.size());
                ((GearGroup)filteredGroup.get(0)).addToGearGroup(toAdd);
            } else {
                GearGroup groupNew = new GearGroup(this);
                groupNew.addToGearGroup(toAdd);
                this.gearGroups.add(groupNew);
            }
            toAdd.isInGroup = true;
        }
    }

    public void removeFromGearList(TileEntityGear toRemove) {
        if (toRemove != null) {
            int i = 0;
            while (i < this.gearGroups.size()) {
                if (this.gearGroups.get(i).hasGear(toRemove)) {
                    this.gearGroups.get(i).removeFromGearGroup(toRemove);
                }
                ++i;
            }
            toRemove.isInGroup = false;
        }
        this.gearListCleanup();
    }

    public void gearListCleanup() {
        int i = 0;
        while (i < this.gearGroups.size()) {
            if (this.gearGroups.get(i).getGearGroupSize() == 0) {
                this.gearGroups.remove(i);
            }
            ++i;
        }
    }

    public boolean applyGearPower(TileEntityGear powered, int amount) {
        this.gearListCleanup();
        System.out.println("APPLYING " + powered);
        if (powered != null) {
            int i = 0;
            while (i < this.gearGroups.size() - 1) {
                System.out.println(this.gearGroups.get(i));
                if (this.gearGroups.get(i).hasGear(powered)) {
                    this.gearGroups.get(i).setLimit(amount);
                    return this.gearGroups.get(i).powerGearCache();
                }
                this.addToGearList(null, powered);
                ++i;
            }
        }
        return false;
    }

    public boolean removeGearPower(TileEntityGear powered, int amount) {
        this.gearListCleanup();
        System.out.println("REMOVING " + powered);
        if (powered != null) {
            int i = 0;
            while (i < this.gearGroups.size() - 1) {
                System.out.println(this.gearGroups.get(i));
                if (this.gearGroups.get(i).hasGear(powered)) {
                    this.gearGroups.get(i).setLimit(0);
                    return this.gearGroups.get(i).unPowerGearCache();
                }
                this.addToGearList(null, powered);
                ++i;
            }
        }
        return false;
    }

    public boolean checkGearPower(TileEntityGear toCheck) {
        this.gearListCleanup();
        if (toCheck != null) {
            int i = 0;
            while (i < this.gearGroups.size() - 1) {
                if (this.gearGroups.get(i).hasGear(toCheck)) {
                    return this.gearGroups.get(i).checkPowered();
                }
                ++i;
            }
        }
        return false;
    }

    public TileEntityGear getGearAt(int x, int y, int z) {
        TileEntity entity = this.getBlockTileEntity(x, y, z);
        TileEntityGear gearEntity = null;
        if (entity instanceof TileEntityGear) {
            gearEntity = (TileEntityGear)entity;
        }
        return gearEntity;
    }

    public boolean blockExists(int i, int j, int k) {
        if (j < 0 || j >= 128) {
            return false;
        }
        return this.chunkExists(i >> 4, k >> 4);
    }

    public boolean doChunksNearChunkExist(int i, int j, int k, int l) {
        return this.checkChunksExist(i - l, j - l, k - l, i + l, j + l, k + l);
    }

    public boolean checkChunksExist(int i, int j, int k, int l, int i1, int j1) {
        if (i1 < 0 || j >= 128) {
            return false;
        }
        i >>= 4;
        j >>= 4;
        k >>= 4;
        l >>= 4;
        i1 >>= 4;
        j1 >>= 4;
        int k1 = i;
        while (k1 <= l) {
            int l1 = k;
            while (l1 <= j1) {
                if (!this.chunkExists(k1, l1)) {
                    return false;
                }
                ++l1;
            }
            ++k1;
        }
        return true;
    }

    private boolean chunkExists(int i, int j) {
        return this.chunkProvider.chunkExists(i, j);
    }

    public Chunk getChunkFromBlockCoords(int i, int j) {
        return this.getChunkFromChunkCoords(i >> 4, j >> 4);
    }

    public Chunk getChunkFromChunkCoords(int i, int j) {
        return this.chunkProvider.provideChunk(i, j);
    }

    public Chunk getChunkFromChunkCoordsIfLoaded(int i, int j) {
        if (this.chunkExists(i, j)) {
            return this.chunkProvider.provideChunk(i, j);
        }
        return null;
    }

    public boolean setBlockAndMetadata(int i, int j, int k, int l, int i1) {
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return false;
        }
        if (j < 0) {
            return false;
        }
        if (j >= 128) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
        return chunk.setBlockIDWithMetadata(i & 0xF, j, k & 0xF, l, i1);
    }

    public boolean setBlock(int i, int j, int k, int l) {
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return false;
        }
        if (j < 0) {
            return false;
        }
        if (j >= 128) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
        return chunk.setBlockID(i & 0xF, j, k & 0xF, l);
    }

    @Override
    public Material getMaterialXYZ(int i, int j, int k) {
        int l = this.getBlockId(i, j, k);
        if (l == 0) {
            return Material.air;
        }
        return Block.allBlocks[l].blockMaterial;
    }

    @Override
    public boolean isTouchingAir(int x, int y, int z) {
        return this.getBlockId(x - 1, y, z) == 0 || this.getBlockId(x + 1, y, z) == 0 || this.getBlockId(x, y - 1, z) == 0 || this.getBlockId(x, y + 1, z) == 0 || this.getBlockId(x, y, z - 1) == 0 || this.getBlockId(x, y, z + 1) == 0;
    }

    public boolean isAirBlock(int i, int j, int k) {
        int l = this.getBlockId(i, j, k);
        return l == 0;
    }

    @Override
    public int getBlockMetadata(int i, int j, int k) {
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return 0;
        }
        if (j < 0) {
            return 0;
        }
        if (j >= 128) {
            return 0;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
        return chunk.getBlockMetadata(i &= 0xF, j, k &= 0xF);
    }

    public void setBlockMetadataWithNotify(int i, int j, int k, int l) {
        this.setBlockMetadata(i, j, k, l);
        this.notifyBlockChange(i, j, k, l);
    }

    public boolean setBlockMetadata(int i, int j, int k, int l) {
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return false;
        }
        if (j < 0) {
            return false;
        }
        if (j >= 128) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
        chunk.setBlockMetadata(i &= 0xF, j, k &= 0xF, l);
        return true;
    }

    public boolean setBlockWithNotify(int i, int j, int k, int l) {
        if (this.setBlock(i, j, k, l)) {
            this.notifyBlockChange(i, j, k, l);
            return true;
        }
        return false;
    }

    public boolean setBlockAndMetadataWithNotify(int i, int j, int k, int l, int i1) {
        if (this.setBlockAndMetadata(i, j, k, l, i1)) {
            this.notifyBlockChange(i, j, k, l);
            return true;
        }
        return false;
    }

    public void markBlockNeedsUpdate(int i, int j, int k) {
        int l = 0;
        while (l < this.worldAccesses.size()) {
            this.worldAccesses.get(l).func_934_a(i, j, k);
            ++l;
        }
    }

    protected void notifyBlockChange(int i, int j, int k, int l) {
        this.markBlockNeedsUpdate(i, j, k);
        this.notifyBlocksOfNeighborChange(i, j, k, l);
    }

    public void markBlocksDirtyVertical(int i, int j, int k, int l) {
        if (k > l) {
            int i1 = l;
            l = k;
            k = i1;
        }
        this.markBlocksDirty(i, k, j, i, l, j);
    }

    public void markBlocksDirty(int i, int j, int k, int l, int i1, int j1) {
        int k1 = 0;
        while (k1 < this.worldAccesses.size()) {
            this.worldAccesses.get(k1).markBlockRangeNeedsUpdate(i, j, k, l, i1, j1);
            ++k1;
        }
    }

    public void notifyBlocksOfNeighborChange(int i, int j, int k, int l) {
        this.notifyBlockOfNeighborChange(i - 1, j, k, l);
        this.notifyBlockOfNeighborChange(i + 1, j, k, l);
        this.notifyBlockOfNeighborChange(i, j - 1, k, l);
        this.notifyBlockOfNeighborChange(i, j + 1, k, l);
        this.notifyBlockOfNeighborChange(i, j, k - 1, l);
        this.notifyBlockOfNeighborChange(i, j, k + 1, l);
    }

    private void notifyBlockOfNeighborChange(int i, int j, int k, int l) {
        if (this.etitingBlocks || this.multiplayerWorld) {
            return;
        }
        Block block = Block.allBlocks[this.getBlockId(i, j, k)];
        if (block != null) {
            block.onNeighborBlockChange(this, i, j, k, l);
        }
    }

    public boolean func_647_i(int i, int j, int k) {
        return this.getChunkFromChunkCoords(i >> 4, k >> 4).canBlockSeeTheSky(i & 0xF, j, k & 0xF);
    }

    public int getBlockLightValue(int i, int j, int k) {
        return this.getLightValueAtLocation(i, j, k, true);
    }

    public int getLightValueAtLocation(int i, int j, int k, boolean flag) {
        int l;
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return 15;
        }
        if (flag && ((l = this.getBlockId(i, j, k)) == Block.stepSingle.blockID || l == Block.tilledField.blockID)) {
            int j1 = this.getLightValueAtLocation(i, j + 1, k, false);
            int k1 = this.getLightValueAtLocation(i + 1, j, k, false);
            int l1 = this.getLightValueAtLocation(i - 1, j, k, false);
            int i2 = this.getLightValueAtLocation(i, j, k + 1, false);
            int j2 = this.getLightValueAtLocation(i, j, k - 1, false);
            if (k1 > j1) {
                j1 = k1;
            }
            if (l1 > j1) {
                j1 = l1;
            }
            if (i2 > j1) {
                j1 = i2;
            }
            if (j2 > j1) {
                j1 = j2;
            }
            return j1;
        }
        if (j < 0) {
            return 0;
        }
        if (j >= 128) {
            int i1 = 15 - this.skyLightSubtracted;
            if (i1 < 0) {
                i1 = 0;
            }
            return i1;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
        return chunk.getBlockLightValue(i &= 0xF, j, k &= 0xF, this.skyLightSubtracted);
    }

    public boolean canBlockSeeTheSky(int i, int j, int k) {
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return false;
        }
        if (j < 0) {
            return false;
        }
        if (j >= 128) {
            return true;
        }
        if (!this.chunkExists(i >> 4, k >> 4)) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
        return chunk.canBlockSeeTheSky(i &= 0xF, j, k &= 0xF);
    }

    public int getHeightValue(int i, int j) {
        if (i < -32000000 || j < -32000000 || i >= 32000000 || j > 32000000) {
            return 0;
        }
        if (!this.chunkExists(i >> 4, j >> 4)) {
            return 0;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, j >> 4);
        return chunk.getHeightValue(i & 0xF, j & 0xF);
    }

    public void getLightValueAtBlock(EnumSkyBlock enumskyblock, int i, int j, int k, int light) {
        int blockId;
        if (!this.blockExists(i, j, k)) {
            return;
        }
        if (enumskyblock == EnumSkyBlock.Sky) {
            if (this.canBlockSeeTheSky(i, j, k)) {
                light = 15;
            }
        } else if (enumskyblock == EnumSkyBlock.Block && Block.lightValue[blockId = this.getBlockId(i, j, k)] > light) {
            light = Block.lightValue[blockId];
        }
        if (this.getBlockLighting(enumskyblock, i, j, k) != light) {
            this.scheduleLightingUpdate(enumskyblock, i, j, k, i, j, k);
        }
    }

    public int getBlockLighting(EnumSkyBlock enumskyblock, int i, int j, int k) {
        if (j < 0 || j >= 128 || i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return enumskyblock.field_1722_c;
        }
        int l = i >> 4;
        int i1 = k >> 4;
        if (!this.chunkExists(l, i1)) {
            return 0;
        }
        Chunk chunk = this.getChunkFromChunkCoords(l, i1);
        return chunk.getSavedLightValue(enumskyblock, i & 0xF, j, k & 0xF);
    }

    public void setBlockLightValue(EnumSkyBlock enumskyblock, int i, int j, int k, int l) {
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return;
        }
        if (j < 0) {
            return;
        }
        if (j >= 128) {
            return;
        }
        if (!this.chunkExists(i >> 4, k >> 4)) {
            return;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
        chunk.setLightValue(enumskyblock, i & 0xF, j, k & 0xF, l);
        int i1 = 0;
        while (i1 < this.worldAccesses.size()) {
            this.worldAccesses.get(i1).func_934_a(i, j, k);
            ++i1;
        }
    }

    @Override
    public float getBrightness(int i, int j, int k) {
        return field_1042_i[this.getBlockLightValue(i, j, k)];
    }

    public boolean func_624_b() {
        return this.skyLightSubtracted < 4;
    }

    public MovingObjectPosition rayTraceBlocks(Vec3D vec3d, Vec3D vec3d1) {
        return this.rayTraceBlocks_do(vec3d, vec3d1, false);
    }

    public MovingObjectPosition rayTraceBlocks_do(Vec3D vec3d, Vec3D vec3d1, boolean flag) {
        if (Double.isNaN(vec3d.xCoord) || Double.isNaN(vec3d.yCoord) || Double.isNaN(vec3d.zCoord)) {
            return null;
        }
        if (Double.isNaN(vec3d1.xCoord) || Double.isNaN(vec3d1.yCoord) || Double.isNaN(vec3d1.zCoord)) {
            return null;
        }
        int i = MathHelper.floor_double(vec3d1.xCoord);
        int j = MathHelper.floor_double(vec3d1.yCoord);
        int k = MathHelper.floor_double(vec3d1.zCoord);
        int l = MathHelper.floor_double(vec3d.xCoord);
        int i1 = MathHelper.floor_double(vec3d.yCoord);
        int j1 = MathHelper.floor_double(vec3d.zCoord);
        int k1 = 20;
        while (k1-- >= 0) {
            MovingObjectPosition movingobjectposition;
            if (Double.isNaN(vec3d.xCoord) || Double.isNaN(vec3d.yCoord) || Double.isNaN(vec3d.zCoord)) {
                return null;
            }
            if (l == i && i1 == j && j1 == k) {
                return null;
            }
            double d = 999.0;
            double d1 = 999.0;
            double d2 = 999.0;
            if (i > l) {
                d = (double)l + 1.0;
            }
            if (i < l) {
                d = (double)l + 0.0;
            }
            if (j > i1) {
                d1 = (double)i1 + 1.0;
            }
            if (j < i1) {
                d1 = (double)i1 + 0.0;
            }
            if (k > j1) {
                d2 = (double)j1 + 1.0;
            }
            if (k < j1) {
                d2 = (double)j1 + 0.0;
            }
            double d3 = 999.0;
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = vec3d1.xCoord - vec3d.xCoord;
            double d7 = vec3d1.yCoord - vec3d.yCoord;
            double d8 = vec3d1.zCoord - vec3d.zCoord;
            if (d != 999.0) {
                d3 = (d - vec3d.xCoord) / d6;
            }
            if (d1 != 999.0) {
                d4 = (d1 - vec3d.yCoord) / d7;
            }
            if (d2 != 999.0) {
                d5 = (d2 - vec3d.zCoord) / d8;
            }
            int byte0 = 0;
            if (d3 < d4 && d3 < d5) {
                byte0 = i > l ? 4 : 5;
                vec3d.xCoord = d;
                vec3d.yCoord += d7 * d3;
                vec3d.zCoord += d8 * d3;
            } else if (d4 < d5) {
                byte0 = j > i1 ? 0 : 1;
                vec3d.xCoord += d6 * d4;
                vec3d.yCoord = d1;
                vec3d.zCoord += d8 * d4;
            } else {
                byte0 = k > j1 ? 2 : 3;
                vec3d.xCoord += d6 * d5;
                vec3d.yCoord += d7 * d5;
                vec3d.zCoord = d2;
            }
            Vec3D vec3d2 = Vec3D.createVector(vec3d.xCoord, vec3d.yCoord, vec3d.zCoord);
            vec3d2.xCoord = MathHelper.floor_double(vec3d.xCoord);
            l = (int)vec3d2.xCoord;
            if (byte0 == 5) {
                --l;
                vec3d2.xCoord += 1.0;
            }
            vec3d2.yCoord = MathHelper.floor_double(vec3d.yCoord);
            i1 = (int)vec3d2.yCoord;
            if (byte0 == 1) {
                --i1;
                vec3d2.yCoord += 1.0;
            }
            vec3d2.zCoord = MathHelper.floor_double(vec3d.zCoord);
            j1 = (int)vec3d2.zCoord;
            if (byte0 == 3) {
                --j1;
                vec3d2.zCoord += 1.0;
            }
            int l1 = this.getBlockId(l, i1, j1);
            int i2 = this.getBlockMetadata(l, i1, j1);
            Block block = Block.allBlocks[l1];
            if (l1 <= 0 || !block.canCollideCheck(i2, flag) || (movingobjectposition = block.collisionRayTrace(this, l, i1, j1, vec3d, vec3d1)) == null) continue;
            return movingobjectposition;
        }
        return null;
    }

    public void playSoundAtEntity(Entity entity, String s, float f, float f1) {
        int i = 0;
        while (i < this.worldAccesses.size()) {
            this.worldAccesses.get(i).makeSound(s, entity.posX, entity.posY - (double)entity.yOffset, entity.posZ, f, f1);
            ++i;
        }
    }

    public void playSoundEffect(double d, double d1, double d2, String s, float f, float f1) {
        int i = 0;
        while (i < this.worldAccesses.size()) {
            this.worldAccesses.get(i).makeSound(s, d, d1, d2, f, f1);
            ++i;
        }
    }

    public void playAmbience(double posX, double posY, double posZ, String soundName, float volume, float pitch) {
        int i = 0;
        while (i < this.worldAccesses.size()) {
            this.worldAccesses.get(i).makeAmbience(soundName, posX, posY, posZ, volume, pitch);
            ++i;
        }
    }

    public void updateAmbience(double posX, double posY, double posZ, String soundName, float volume, float pitch) {
        int i = 0;
        while (i < this.worldAccesses.size()) {
            this.worldAccesses.get(i).updateAmbience(soundName, posX, posY, posZ, volume, pitch);
            ++i;
        }
    }

    public void pauseAmbience(double posX, double posY, double posZ, String soundName, float volume, float pitch) {
        int i = 0;
        while (i < this.worldAccesses.size()) {
            this.worldAccesses.get(i).pauseAmbience(soundName, posX, posY, posZ, volume, pitch);
            ++i;
        }
    }

    public boolean isAmbienceEnabled() {
        return this.worldAccesses.get(0).isAmbienceEnabled();
    }

    public IWorldAccess getWorldAccess(int i) {
        return this.worldAccesses.get(i);
    }

    public void playRecord(String s, int i, int j, int k) {
        int l = 0;
        while (l < this.worldAccesses.size()) {
            this.worldAccesses.get(l).playRecord(s, i, j, k);
            ++l;
        }
    }

    public void spawnParticle(String s, double d, double d1, double d2, double d3, double d4, double d5) {
        int i = 0;
        while (i < this.worldAccesses.size()) {
            try {
                this.worldAccesses.get(i).spawnParticle(s, d, d1, d2, d3, d4, d5);
            }
            catch (Exception ex) {
                System.out.println("Tried to render non-existant entity! Left server?");
            }
            ++i;
        }
    }

    public boolean addWeatherEffect(Entity entity) {
        this.weatherEffects.add(entity);
        new ThreadThunderSound(this.mc, entity.getDistanceToEntity(this.mc.thePlayer), 100.0f).start();
        return true;
    }

    public boolean entityJoinedWorld(Entity entity) {
        int i = MathHelper.floor_double(entity.posX / 16.0);
        int j = MathHelper.floor_double(entity.posZ / 16.0);
        boolean flag = false;
        if (entity instanceof EntityPlayer) {
            flag = true;
            if (!this.multiplayerWorld) {
                this.getBlockId(this.spawnX, this.spawnY, this.spawnZ);
                int cfr_ignored_0 = Block.bleedingObsidian.blockID;
            }
        }
        if (flag || this.chunkExists(i, j)) {
            if (entity instanceof EntityPlayer && !this.playerEntities.contains(entity)) {
                this.playerEntities.add((EntityPlayer)entity);
                System.out.println("Player count: " + this.playerEntities.size());
            }
            this.getChunkFromChunkCoords(i, j).addEntity(entity);
            this.loadedEntityList.add(entity);
            this.obtainEntitySkin(entity);
            return true;
        }
        return false;
    }

    public void obtainEntitySkin(Entity entity) {
        int i = 0;
        while (i < this.worldAccesses.size()) {
            this.worldAccesses.get(i).obtainEntitySkin(entity);
            ++i;
        }
    }

    public void releaseEntitySkin(Entity entity) {
        int i = 0;
        while (i < this.worldAccesses.size()) {
            this.worldAccesses.get(i).releaseEntitySkin(entity);
            ++i;
        }
    }

    public void setEntityDead(Entity entity) {
        entity.setEntityDead();
        if (entity instanceof EntityPlayer) {
            this.playerEntities.remove((EntityPlayer)entity);
            System.out.println("Player count: " + this.playerEntities.size());
        }
    }

    public void func_613_a(IWorldAccess iworldaccess) {
        this.worldAccesses.add(iworldaccess);
    }

    public void func_672_b(IWorldAccess iworldaccess) {
        this.worldAccesses.remove(iworldaccess);
    }

    public List<AxisAlignedBB> getCollidingBoundingBoxes(Entity entity, AxisAlignedBB axisalignedbb) {
        this.field_1015_J.clear();
        int i = MathHelper.floor_double(axisalignedbb.minX);
        int j = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k = MathHelper.floor_double(axisalignedbb.minY);
        int l = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        int j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        int k1 = i;
        while (k1 < j) {
            int l1 = i1;
            while (l1 < j1) {
                if (this.blockExists(k1, 64, l1)) {
                    int i2 = k - 1;
                    while (i2 < l) {
                        Block block = Block.allBlocks[this.getBlockId(k1, i2, l1)];
                        if (!(block == null || (entity instanceof EntityItem || entity instanceof EntityGiant) && block.blockID == Block.leaves.blockID || entity instanceof EntityGiant && block.blockID == Block.wood.blockID)) {
                            block.getCollidingBoundingBoxes(this, k1, i2, l1, axisalignedbb, this.field_1015_J);
                        }
                        ++i2;
                    }
                }
                ++l1;
            }
            ++k1;
        }
        double d = 0.25;
        List<Entity> list = this.getEntitiesWithinAABBExcludingEntity(entity, axisalignedbb.expand(d, d, d));
        int j2 = 0;
        while (j2 < list.size()) {
            AxisAlignedBB axisalignedbb1 = list.get(j2).func_372_f_();
            if (axisalignedbb1 != null && axisalignedbb1.intersectsWith(axisalignedbb)) {
                this.field_1015_J.add(axisalignedbb1);
            }
            if ((axisalignedbb1 = entity.getCollisionBox(list.get(j2))) != null && axisalignedbb1.intersectsWith(axisalignedbb)) {
                this.field_1015_J.add(axisalignedbb1);
            }
            ++j2;
        }
        return this.field_1015_J;
    }

    public int getTimeOfDayBrightness(float f) {
        float celestialAngle = this.calculateCelestialAngle(f);
        float lightNess = 1.0f - (MathHelper.cos(celestialAngle * 3.141593f * 2.0f) * 2.0f + 0.5f);
        if (lightNess < 0.0f) {
            lightNess = 0.0f;
        }
        if (lightNess > 1.0f) {
            lightNess = 1.0f;
        }
        return (int)(lightNess * 11.0f);
    }

    public Vec3D calculateSkyTopColor(float f) {
        float f1 = this.calculateCelestialAngle(f);
        float f2 = MathHelper.cos(f1 * 3.141593f * 2.0f) * 2.0f + 0.5f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        float f3 = (float)(this.skyTopColor >> 16 & 0xFFL) / 255.0f;
        float f4 = (float)(this.skyTopColor >> 8 & 0xFFL) / 255.0f;
        float f5 = (float)(this.skyTopColor & 0xFFL) / 255.0f;
        return Vec3D.createVector(f3 *= f2, f4 *= f2, f5 *= f2);
    }

    public float calculateCelestialAngle(float renderPartialTicks) {
        EnumSeason otherSeason;
        float tickWithinCycle = (float)((int)(this.worldTime % 24000L)) + renderPartialTicks;
        float currDayLength = 0.5f;
        float otherDayLength = 0.5f;
        EnumSeason currSeason = this.getCurrentSeason();
        EnumSeason enumSeason = otherSeason = this.seasonProgress <= 0.5f ? this.getLastSeason() : this.getNextSeason();
        if (currSeason != null) {
            currDayLength = currSeason.getDayLength();
            otherDayLength = otherSeason.getDayLength();
        }
        float blendFactor = Math.abs(this.seasonProgress - 0.5f);
        float dayLength = currDayLength + (otherDayLength - currDayLength) * blendFactor;
        float nightLength = 1.0f - dayLength;
        int dayLengthTicks = (int)(24000.0f * dayLength);
        int nightLengthTicks = (int)(24000.0f * nightLength);
        boolean isDay = tickWithinCycle < (float)dayLengthTicks;
        float partProgress = isDay ? tickWithinCycle / (float)dayLengthTicks : (tickWithinCycle - (float)dayLengthTicks) / (float)nightLengthTicks;
        float dayProgress = isDay ? partProgress / 2.0f : 0.5f + partProgress / 2.0f;
        if ((dayProgress -= 0.25f) < 0.0f) {
            dayProgress += 1.0f;
        }
        if (dayProgress > 1.0f) {
            dayProgress -= 1.0f;
        }
        float f2 = dayProgress;
        dayProgress = 1.0f - (float)((Math.cos((double)dayProgress * Math.PI) + 1.0) / 2.0);
        dayProgress = f2 + (dayProgress - f2) / 3.0f;
        return dayProgress;
    }

    public Vec3D calculateFogColor(float f) {
        float f1 = this.calculateCelestialAngle(f);
        float f2 = MathHelper.cos(f1 * 3.141593f * 2.0f) * 2.0f + 0.5f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        float f3 = (float)(this.fogColor >> 16 & 0xFFL) / 255.0f;
        float f4 = (float)(this.fogColor >> 8 & 0xFFL) / 255.0f;
        float f5 = (float)(this.fogColor & 0xFFL) / 255.0f;
        return Vec3D.createVector(f3 *= f2 * 0.9f + 0.1f, f4 *= f2 * 0.9f + 0.1f, f5 *= f2 * 0.85f + 0.15f);
    }

    public Vec3D calculateSkyEdgeColor(float f) {
        float f1 = this.calculateCelestialAngle(f);
        float f2 = MathHelper.cos(f1 * 3.141593f * 2.0f) * 2.0f + 0.5f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        float f3 = (float)(this.skyEdgeColor >> 16 & 0xFFL) / 255.0f;
        float f4 = (float)(this.skyEdgeColor >> 8 & 0xFFL) / 255.0f;
        float f5 = (float)(this.skyEdgeColor & 0xFFL) / 255.0f;
        return Vec3D.createVector(f3 *= f2 * 0.94f + 0.06f, f4 *= f2 * 0.94f + 0.06f, f5 *= f2 * 0.91f + 0.09f);
    }

    public int getTopSolidOrLiquidBlock(int i, int j) {
        Chunk chunk = this.getChunkFromBlockCoords(i, j);
        i &= 0xF;
        j &= 0xF;
        for (int k = 127; k > 0; --k) {
            int l = chunk.getBlockId(i, k, j);
            if (l == 0 || !Block.allBlocks[l].blockMaterial.blocksMovement() && !Block.allBlocks[l].blockMaterial.getIsGroundCover()) {
                continue;
            }
            return k + 1;
        }
        return -1;
    }

    public int findTopSolidBlock(int i, int j) {
        return this.getChunkFromBlockCoords(i, j).getHeightValue(i & 0xF, j & 0xF);
    }

    public ChunkCoordinates getSpawnPoint() {
        return new ChunkCoordinates(this.spawnX, this.spawnY, this.spawnZ);
    }

    public void setSpawnPoint(ChunkCoordinates chunkcoordinates) {
        this.spawnX = chunkcoordinates.x;
        this.spawnY = chunkcoordinates.y;
        this.spawnZ = chunkcoordinates.z;
    }

    public float func_679_f(float f) {
        float f1 = this.calculateCelestialAngle(f);
        float f2 = 1.0f - (MathHelper.cos(f1 * 3.141593f * 2.0f) * 2.0f + 0.75f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return f2 * f2 * 0.5f;
    }

    public void scheduleUpdateTick(int i, int j, int k, int l) {
        NextTickListEntry nextticklistentry = new NextTickListEntry(i, j, k, l);
        int byte0 = 8;
        if (this.checkChunksExist(i - byte0, j - byte0, k - byte0, i + byte0, j + byte0, k + byte0)) {
            if (l > 0) {
                nextticklistentry.func_900_a((long)Block.allBlocks[l].tickRate() + this.worldTime);
            }
            if (!this.field_1022_C.contains(nextticklistentry)) {
                this.field_1022_C.add(nextticklistentry);
                this.field_1023_B.add(nextticklistentry);
            }
        }
    }

    public void updateEntityList() {
        Entity entity;
        int i = 0;
        while (i < this.weatherEffects.size()) {
            entity = this.weatherEffects.get(i);
            entity.onUpdate();
            if (entity.isDead) {
                this.weatherEffects.remove(i--);
            }
            ++i;
        }
        this.loadedEntityList.removeAll(this.unloadedEntityList);
        i = 0;
        while (i < this.unloadedEntityList.size()) {
            entity = (Entity)this.unloadedEntityList.get(i);
            int i1 = entity.chunkCoordX;
            int k1 = entity.chunkCoordZ;
            if (entity.addedToChunk && this.chunkExists(i1, k1)) {
                this.getChunkFromChunkCoords(i1, k1).removeEntity(entity);
            }
            ++i;
        }
        int j = 0;
        while (j < this.unloadedEntityList.size()) {
            this.releaseEntitySkin((Entity)this.unloadedEntityList.get(j));
            ++j;
        }
        this.unloadedEntityList.clear();
        int k = 0;
        while (k < this.loadedEntityList.size()) {
            block14: {
                Entity entity1;
                block13: {
                    entity1 = this.loadedEntityList.get(k);
                    if (entity1.entityBeingRidden == null) break block13;
                    if (!entity1.entityBeingRidden.isDead && entity1.entityBeingRidden.riddenByEntity == entity1) break block14;
                    entity1.entityBeingRidden.riddenByEntity = null;
                    entity1.entityBeingRidden = null;
                }
                if (!entity1.isDead) {
                    this.updateEntityWithOptionalForce(entity1);
                }
                if (entity1.isDead) {
                    int j1 = entity1.chunkCoordX;
                    int l1 = entity1.chunkCoordZ;
                    if (entity1.addedToChunk && this.chunkExists(j1, l1)) {
                        this.getChunkFromChunkCoords(j1, l1).removeEntity(entity1);
                    }
                    this.loadedEntityList.remove(k--);
                    this.releaseEntitySkin(entity1);
                }
            }
            ++k;
        }
        int l = 0;
        while (l < this.field_1049_b.size()) {
            TileEntity tileentity = (TileEntity)this.field_1049_b.get(l);
            tileentity.func_475_b();
            ++l;
        }
    }

    protected void updateEntityWithOptionalForce(Entity entity) {
        int j;
        int byte0;
        int i = MathHelper.floor_double(entity.posX);
        if (!this.checkChunksExist(i - (byte0 = 16), 0, (j = MathHelper.floor_double(entity.posZ)) - byte0, i + byte0, 128, j + byte0)) {
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).tryToDespawn();
            }
            return;
        }
        entity.lastTickPosX = entity.posX;
        entity.lastTickPosY = entity.posY;
        entity.lastTickPosZ = entity.posZ;
        entity.prevRotationYaw = entity.rotationYaw;
        entity.prevRotationPitch = entity.rotationPitch;
        if (entity.entityBeingRidden != null) {
            entity.updateRidden();
        } else {
            entity.onUpdate();
        }
        int k = MathHelper.floor_double(entity.posX / 16.0);
        int l = MathHelper.floor_double(entity.posY / 16.0);
        int i1 = MathHelper.floor_double(entity.posZ / 16.0);
        if (!entity.addedToChunk || entity.chunkCoordX != k || entity.chunkCoordY != l || entity.chunkCoordZ != i1) {
            if (entity.addedToChunk && this.chunkExists(entity.chunkCoordX, entity.chunkCoordZ)) {
                this.getChunkFromChunkCoords(entity.chunkCoordX, entity.chunkCoordZ).removeEntityAtIndex(entity, entity.chunkCoordY);
            }
            if (this.chunkExists(k, i1)) {
                this.getChunkFromChunkCoords(k, i1).addEntity(entity);
            } else {
                entity.addedToChunk = false;
                System.out.println("Removing entity because it's not in a chunk!!");
                entity.setEntityDead();
            }
        }
        if (entity.riddenByEntity != null) {
            if (entity.riddenByEntity.isDead || entity.riddenByEntity.entityBeingRidden != entity) {
                entity.riddenByEntity.entityBeingRidden = null;
                entity.riddenByEntity = null;
            } else {
                this.updateEntityWithOptionalForce(entity.riddenByEntity);
            }
        }
        if (Double.isNaN(entity.posX) || Double.isInfinite(entity.posX)) {
            entity.posX = entity.lastTickPosX;
        }
        if (Double.isNaN(entity.posY) || Double.isInfinite(entity.posY)) {
            entity.posY = entity.lastTickPosY;
        }
        if (Double.isNaN(entity.posZ) || Double.isInfinite(entity.posZ)) {
            entity.posZ = entity.lastTickPosZ;
        }
        if (Double.isNaN(entity.rotationPitch) || Double.isInfinite(entity.rotationPitch)) {
            entity.rotationPitch = entity.prevRotationPitch;
        }
        if (Double.isNaN(entity.rotationYaw) || Double.isInfinite(entity.rotationYaw)) {
            entity.rotationYaw = entity.prevRotationYaw;
        }
    }

    public boolean func_604_a(AxisAlignedBB axisalignedbb) {
        List<Entity> list = this.getEntitiesWithinAABBExcludingEntity(null, axisalignedbb);
        int i = 0;
        while (i < list.size()) {
            Entity entity = list.get(i);
            if (!entity.isDead && entity.preventEntitySpawning) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean getIsAnyLiquid(AxisAlignedBB axisalignedbb) {
        int i = MathHelper.floor_double(axisalignedbb.minX);
        int j = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k = MathHelper.floor_double(axisalignedbb.minY);
        int l = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        int j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        if (axisalignedbb.minX < 0.0) {
            --i;
        }
        if (axisalignedbb.minY < 0.0) {
            --k;
        }
        if (axisalignedbb.minZ < 0.0) {
            --i1;
        }
        int k1 = i;
        while (k1 < j) {
            int l1 = k;
            while (l1 < l) {
                int i2 = i1;
                while (i2 < j1) {
                    Block block = Block.allBlocks[this.getBlockId(k1, l1, i2)];
                    if (block != null && block.blockMaterial.getIsGroundCover()) {
                        return true;
                    }
                    ++i2;
                }
                ++l1;
            }
            ++k1;
        }
        return false;
    }

    public boolean isBoundingBoxBurning(AxisAlignedBB axisalignedbb) {
        int i = MathHelper.floor_double(axisalignedbb.minX);
        int j = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k = MathHelper.floor_double(axisalignedbb.minY);
        int l = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        int j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        int k1 = i;
        while (k1 < j) {
            int l1 = k;
            while (l1 < l) {
                int i2 = i1;
                while (i2 < j1) {
                    int j2 = this.getBlockId(k1, l1, i2);
                    if (j2 == Block.fire.blockID || j2 == Block.lavaMoving.blockID || j2 == Block.lavaStill.blockID) {
                        return true;
                    }
                    ++i2;
                }
                ++l1;
            }
            ++k1;
        }
        return false;
    }

    public boolean handleMaterialAcceleration(AxisAlignedBB axisalignedbb, Material material, Entity entity) {
        int i = MathHelper.floor_double(axisalignedbb.minX);
        int j = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k = MathHelper.floor_double(axisalignedbb.minY);
        int l = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        int j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        boolean flag = false;
        Vec3D vec3d = Vec3D.createVector(0.0, 0.0, 0.0);
        int k1 = i;
        while (k1 < j) {
            int l1 = k;
            while (l1 < l) {
                int i2 = i1;
                while (i2 < j1) {
                    double d1;
                    Block block = Block.allBlocks[this.getBlockId(k1, l1, i2)];
                    if (block != null && block.blockMaterial == material && (double)l >= (d1 = (double)((float)(l1 + 1) - BlockFluids.getFluidLevel(this.getBlockMetadata(k1, l1, i2))))) {
                        flag = true;
                        block.velocityToAddToEntity(this, k1, l1, i2, entity, vec3d);
                    }
                    ++i2;
                }
                ++l1;
            }
            ++k1;
        }
        if (vec3d.lengthVector() > 0.0) {
            vec3d = vec3d.normalize();
            double d = 0.004;
            entity.motionX += vec3d.xCoord * d;
            entity.motionY += vec3d.yCoord * d;
            entity.motionZ += vec3d.zCoord * d;
        }
        return flag;
    }

    public boolean func_689_a(AxisAlignedBB axisalignedbb, Material material) {
        int i = MathHelper.floor_double(axisalignedbb.minX);
        int j = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k = MathHelper.floor_double(axisalignedbb.minY);
        int l = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        int j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        int k1 = i;
        while (k1 < j) {
            int l1 = k;
            while (l1 < l) {
                int i2 = i1;
                while (i2 < j1) {
                    Block block = Block.allBlocks[this.getBlockId(k1, l1, i2)];
                    if (block != null && block.blockMaterial == material) {
                        return true;
                    }
                    ++i2;
                }
                ++l1;
            }
            ++k1;
        }
        return false;
    }

    public boolean isAABBInMaterial(AxisAlignedBB axisalignedbb, Material material) {
        int i = MathHelper.floor_double(axisalignedbb.minX);
        int j = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k = MathHelper.floor_double(axisalignedbb.minY);
        int l = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        int j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        int k1 = i;
        while (k1 < j) {
            int l1 = k;
            while (l1 < l) {
                int i2 = i1;
                while (i2 < j1) {
                    Block block = Block.allBlocks[this.getBlockId(k1, l1, i2)];
                    if (block != null && block.blockMaterial == material) {
                        int j2 = this.getBlockMetadata(k1, l1, i2);
                        double d = l1 + 1;
                        if (j2 < 8) {
                            d = (double)(l1 + 1) - (double)j2 / 8.0;
                        }
                        if (d >= axisalignedbb.minY) {
                            return true;
                        }
                    }
                    ++i2;
                }
                ++l1;
            }
            ++k1;
        }
        return false;
    }

    public void createExplosion(Entity entity, double d, double d1, double d2, float f) {
        new Explosion().func_901_a(this, entity, d, d1, d2, f);
    }

    public float func_675_a(Vec3D vec3d, AxisAlignedBB axisalignedbb) {
        double d = 1.0 / ((axisalignedbb.maxX - axisalignedbb.minX) * 2.0 + 1.0);
        double d1 = 1.0 / ((axisalignedbb.maxY - axisalignedbb.minY) * 2.0 + 1.0);
        double d2 = 1.0 / ((axisalignedbb.maxZ - axisalignedbb.minZ) * 2.0 + 1.0);
        int i = 0;
        int j = 0;
        float f = 0.0f;
        while (f <= 1.0f) {
            float f1 = 0.0f;
            while (f1 <= 1.0f) {
                float f2 = 0.0f;
                while (f2 <= 1.0f) {
                    double d3 = axisalignedbb.minX + (axisalignedbb.maxX - axisalignedbb.minX) * (double)f;
                    double d4 = axisalignedbb.minY + (axisalignedbb.maxY - axisalignedbb.minY) * (double)f1;
                    double d5 = axisalignedbb.minZ + (axisalignedbb.maxZ - axisalignedbb.minZ) * (double)f2;
                    if (this.rayTraceBlocks(Vec3D.createVector(d3, d4, d5), vec3d) == null) {
                        ++i;
                    }
                    ++j;
                    f2 = (float)((double)f2 + d2);
                }
                f1 = (float)((double)f1 + d1);
            }
            f = (float)((double)f + d);
        }
        return (float)i / (float)j;
    }

    public void func_612_i(int i, int j, int k, int l) {
        if (l == 0) {
            --j;
        }
        if (l == 1) {
            ++j;
        }
        if (l == 2) {
            --k;
        }
        if (l == 3) {
            ++k;
        }
        if (l == 4) {
            --i;
        }
        if (l == 5) {
            ++i;
        }
        if (this.getBlockId(i, j, k) == Block.fire.blockID) {
            this.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, "random.fizz", 0.5f, 2.6f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.8f);
            this.setBlockWithNotify(i, j, k, 0);
        }
    }

    public Entity func_661_a(Class<?> class1) {
        return null;
    }

    public String loadedEntites() {
        return "All entities: " + this.loadedEntityList.size();
    }

    @Override
    public TileEntity getBlockTileEntity(int i, int j, int k) {
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
        if (chunk != null) {
            return chunk.getChunkBlockTileEntity(i & 0xF, j, k & 0xF);
        }
        return null;
    }

    public void func_654_a(int i, int j, int k, TileEntity tileentity) {
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
        if (chunk != null) {
            chunk.setChunkBlockTileEntity(i & 0xF, j, k & 0xF, tileentity);
        }
    }

    public void func_692_l(int i, int j, int k) {
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
        if (chunk != null) {
            chunk.removeChunkBlockTileEntity(i & 0xF, j, k & 0xF);
        }
    }

    @Override
    public boolean isBlockNormalCube(int i, int j, int k) {
        Block block = Block.allBlocks[this.getBlockId(i, j, k)];
        if (block == null) {
            return false;
        }
        return block.isOpaqueCube();
    }

    public boolean isWater(int i, int j, int k) {
        Block block = Block.allBlocks[this.getBlockId(i, j, k)];
        if (block == null) {
            return false;
        }
        return block.blockMaterial == Material.water;
    }

    public void saveWorldIndirectly(IProgressUpdate iprogressupdate) {
        this.saveAllChunks(true, iprogressupdate);
    }

    public boolean updatingLighting() {
        int i = 1000;
        while (this.lightingZones.size() > 0) {
            if (--i <= 0) {
                return true;
            }
            this.lightingZones.remove(this.lightingZones.size() - 1).calculateLightValues(this);
        }
        return false;
    }

    public void scheduleLightingUpdate(EnumSkyBlock enumskyblock, int i, int j, int k, int l, int i1, int j1) {
        this.doSomethingToTheLightingZones(enumskyblock, i, j, k, l, i1, j1, true);
    }

    public void doSomethingToTheLightingZones(EnumSkyBlock enumskyblock, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean flag) {
        int xRadius = (maxX + minX) / 2;
        int zRadius = (maxZ + minZ) / 2;
        if (!this.blockExists(xRadius, 64, zRadius)) {
            return;
        }
        int lightZonesCount = this.lightingZones.size();
        if (flag) {
            int j2 = 4;
            if (j2 > lightZonesCount) {
                j2 = lightZonesCount;
            }
            int k2 = 0;
            while (k2 < j2) {
                LightZone metadatachunkblock = this.lightingZones.get(this.lightingZones.size() - k2 - 1);
                if (metadatachunkblock.skyOrBlockLight == enumskyblock && metadatachunkblock.checkIfInBounds(minX, minY, minZ, maxX, maxY, maxZ)) {
                    return;
                }
                ++k2;
            }
        }
        this.lightingZones.add(new LightZone(enumskyblock, minX, minY, minZ, maxX, maxY, maxZ));
    }

    public void func_644_f() {
        int i = this.getTimeOfDayBrightness(1.0f);
        if (i != this.skyLightSubtracted) {
            this.skyLightSubtracted = i;
        }
    }

    public void setSaveInterval(int interval) {
        this.saveRate = interval * 20 + 40;
    }

    public void updateSeasonProgress() {
        this.seasonProgress = (float)(this.worldTime % (long)(this.daysInSeason * 24000)) / (float)(this.daysInSeason * 24000);
    }

    public void tick() {
        int j;
        this.chunkProvider.unload100OldestChunks();
        int timeOfDayBrightness = this.getTimeOfDayBrightness(1.0f);
        if (timeOfDayBrightness != this.skyLightSubtracted) {
            this.skyLightSubtracted = timeOfDayBrightness;
            j = 0;
            while (j < this.worldAccesses.size()) {
                this.worldAccesses.get(j).updateAllRenderers();
                ++j;
            }
        }
        if (this.getCurrentSeason() != this.lastSeason) {
            j = 0;
            while (j < this.worldAccesses.size()) {
                this.worldAccesses.get(j).updateAllRenderers();
                ++j;
            }
            this.seasonChanged = true;
        }
        this.lastSeason = this.getCurrentSeason();
        this.lastDay = this.getCurrentDay();
        ++this.worldTime;
        if (this.worldTime % (long)this.saveRate == 0L) {
            this.saveAllChunks(false, null);
        }
        this.tickUpdates(false);
        this.doWorldTick();
        this.updateSeasonProgress();
    }

    public void flash() {
        this.chunkProvider.unload100OldestChunks();
        int timeOfDayBrightness = 0;
        if (timeOfDayBrightness != this.skyLightSubtracted) {
            this.skyLightSubtracted = timeOfDayBrightness;
            int j = 0;
            while (j < this.worldAccesses.size()) {
                this.worldAccesses.get(j).updateAllRenderers();
                ++j;
            }
        }
    }

    protected void doWorldTick() {
        this.setOfTickableChunks.clear();
        int i = 0;
        while (i < this.playerEntities.size()) {
            EntityPlayer entityplayer = this.playerEntities.get(i);
            int playerPosX = MathHelper.floor_double(entityplayer.posX / 16.0);
            int playerPosZ = MathHelper.floor_double(entityplayer.posZ / 16.0);
            int chunkRadius = 9;
            int cX = -chunkRadius;
            while (cX <= chunkRadius) {
                int cZ = -chunkRadius;
                while (cZ <= chunkRadius) {
                    this.setOfTickableChunks.add(new ChunkCoordIntPair(cX + playerPosX, cZ + playerPosZ));
                    ++cZ;
                }
                ++cX;
            }
            ++i;
        }
        if (this.ambienceChance > 0) {
            --this.ambienceChance;
        }
        for (ChunkCoordIntPair chunkcoordintpair : this.setOfTickableChunks) {
            int topBlock;
            int chunkX = chunkcoordintpair.chunkX * 16;
            int chunkZ = chunkcoordintpair.chunkZ * 16;
            Chunk chunk = this.getChunkFromChunkCoords(chunkcoordintpair.chunkX, chunkcoordintpair.chunkZ);
            this.randomInt = this.randomInt * 3 + this.someOtherNumber;
            int baseVal = this.randomInt >> 2;
            int ranX = baseVal & 0xF;
            int ranY = baseVal >> 8 & 0xF;
            int ranZ = baseVal >> 16 & 0x7F;
            if (this.ambienceChance == 0) {
                EntityPlayer entityplayer1;
                int block = chunk.getBlockId(ranX, ranZ, ranY);
                int lranX = ranX + chunkX;
                int lranY = ranY + chunkZ;
                if (block == 0 && this.getBlockLightValue(lranX, ranZ, lranY) <= this.rand.nextInt(8) && this.getBlockLighting(EnumSkyBlock.Sky, lranX, ranZ, lranY) <= 0 && (entityplayer1 = this.getClosestPlayer((double)lranX + 0.5, (double)ranZ + 0.5, (double)lranY + 0.5, 8.0)) != null && entityplayer1.getDistanceSq((double)lranX + 0.5, (double)ranZ + 0.5, (double)lranY + 0.5) > 4.0) {
                    this.playSoundEffect((double)lranX + 0.5, (double)ranZ + 0.5, (double)lranY + 0.5, "ambient.cave.cave", 0.7f, 0.8f + this.rand.nextFloat() * 0.2f);
                    this.ambienceChance = this.rand.nextInt(12000) + 6000;
                }
            }
            if (this.getCurrentSeason() == EnumSeason.winter && this.rand.nextInt(4) == 0 && (topBlock = this.getTopSolidOrLiquidBlock(ranX + chunkX, ranY + chunkZ)) >= 0 && topBlock < 128 && chunk.getSavedLightValue(EnumSkyBlock.Block, ranX, topBlock, ranY) < 10) {
                int i5 = chunk.getBlockId(ranX, topBlock - 1, ranY);
                if (chunk.getBlockId(ranX, topBlock, ranY) == 0 && Block.snow.canPlace(this, ranX + chunkX, topBlock, ranY + chunkZ) && chunk.getWeatherLevel() >= 2) {
                    this.setBlockWithNotify(ranX + chunkX, topBlock, ranY + chunkZ, Block.snow.blockID);
                }
                if (i5 == Block.waterStill.blockID && chunk.getBlockMetadata(ranX, topBlock - 1, ranY) == 0 && Block.ice.canPlace(this, ranX + chunkX, topBlock, ranY + chunkZ)) {
                    this.setBlockWithNotify(ranX + chunkX, topBlock - 1, ranY + chunkZ, Block.ice.blockID);
                }
            }
            if (this.getCurrentSeason() != EnumSeason.winter && this.rand.nextInt(4) == 0 && (topBlock = this.getTopSolidOrLiquidBlock(ranX + chunkX, ranY + chunkZ)) >= 0 && topBlock < 128 && chunk.getSavedLightValue(EnumSkyBlock.Block, ranX, topBlock, ranY) < 10) {
                int block = chunk.getBlockId(ranX, topBlock - 1, ranY);
                if (chunk.getBlockId(ranX, topBlock, ranY) == Block.snow.blockID) {
                    this.setBlockWithNotify(ranX + chunkX, topBlock, ranY + chunkZ, 0);
                }
                if (block == Block.ice.blockID && chunk.getBlockMetadata(ranX, topBlock - 1, ranY) == 0) {
                    this.setBlockWithNotify(ranX + chunkX, topBlock - 1, ranY + chunkZ, Block.waterStill.blockID);
                }
            }
            int i2 = 0;
            while (i2 < this.mc.options.randomTickRate) {
                this.randomInt = this.randomInt * 3 + this.someOtherNumber;
                int baseVal2 = this.randomInt >> 2;
                int ranX2 = baseVal2 & 0xF;
                int ranY2 = baseVal2 >> 8 & 0xF;
                int ranZ2 = baseVal2 >> 16 & 0x7F;
                byte block = chunk.blocks[ranX2 << 11 | ranY2 << 7 | ranZ2];
                if (Block.tickOnLoad[block]) {
                    Block.allBlocks[block].updateTick(this, ranX2 + chunkX, ranZ2, ranY2 + chunkZ, this.rand);
                }
                ++i2;
            }
        }
    }

    public boolean tickUpdates(boolean flag) {
        int i = this.field_1023_B.size();
        if (i != this.field_1022_C.size()) {
            throw new IllegalStateException("TickNextTick list out of synch");
        }
        if (i > 1000) {
            i = 1000;
        }
        int j = 0;
        while (j < i) {
            int k;
            NextTickListEntry nextticklistentry = this.field_1023_B.first();
            if (!flag && nextticklistentry.field_1364_e > this.worldTime) break;
            this.field_1023_B.remove(nextticklistentry);
            this.field_1022_C.remove(nextticklistentry);
            int byte0 = 8;
            if (this.checkChunksExist(nextticklistentry.field_1361_a - byte0, nextticklistentry.field_1360_b - byte0, nextticklistentry.field_1366_c - byte0, nextticklistentry.field_1361_a + byte0, nextticklistentry.field_1360_b + byte0, nextticklistentry.field_1366_c + byte0) && (k = this.getBlockId(nextticklistentry.field_1361_a, nextticklistentry.field_1360_b, nextticklistentry.field_1366_c)) == nextticklistentry.field_1365_d && k > 0) {
                Block.allBlocks[k].updateTick(this, nextticklistentry.field_1361_a, nextticklistentry.field_1360_b, nextticklistentry.field_1366_c, this.rand);
            }
            ++j;
        }
        return this.field_1023_B.size() != 0;
    }

    public void randomDisplayUpdates(int i, int j, int k) {
        int byte0 = 16;
        Random random = new Random();
        int l = 0;
        while (l < 1000) {
            int k1;
            int j1;
            int i1 = i + this.rand.nextInt(byte0) - this.rand.nextInt(byte0);
            int l1 = this.getBlockId(i1, j1 = j + this.rand.nextInt(byte0) - this.rand.nextInt(byte0), k1 = k + this.rand.nextInt(byte0) - this.rand.nextInt(byte0));
            if (l1 > 0) {
                Block.allBlocks[l1].randomDisplayTick(this, i1, j1, k1, random);
            }
            ++l;
        }
    }

    public List<Entity> getEntitiesWithinAABBExcludingEntity(Entity entity, AxisAlignedBB axisalignedbb) {
        this.field_1012_M.clear();
        int i = MathHelper.floor_double((axisalignedbb.minX - 2.0) / 16.0);
        int j = MathHelper.floor_double((axisalignedbb.maxX + 2.0) / 16.0);
        int k = MathHelper.floor_double((axisalignedbb.minZ - 2.0) / 16.0);
        int l = MathHelper.floor_double((axisalignedbb.maxZ + 2.0) / 16.0);
        int i1 = i;
        while (i1 <= j) {
            int j1 = k;
            while (j1 <= l) {
                if (this.chunkExists(i1, j1)) {
                    this.getChunkFromChunkCoords(i1, j1).getEntitiesWithinAABBForEntity(entity, axisalignedbb, this.field_1012_M);
                }
                ++j1;
            }
            ++i1;
        }
        return this.field_1012_M;
    }

    public List<Entity> getEntitiesWithinAABB(Class<?> class1, AxisAlignedBB axisalignedbb) {
        int i = MathHelper.floor_double((axisalignedbb.minX - 2.0) / 16.0);
        int j = MathHelper.floor_double((axisalignedbb.maxX + 2.0) / 16.0);
        int k = MathHelper.floor_double((axisalignedbb.minZ - 2.0) / 16.0);
        int l = MathHelper.floor_double((axisalignedbb.maxZ + 2.0) / 16.0);
        ArrayList<Entity> arraylist = new ArrayList<Entity>();
        int i1 = i;
        while (i1 <= j) {
            int j1 = k;
            while (j1 <= l) {
                if (this.chunkExists(i1, j1)) {
                    this.getChunkFromChunkCoords(i1, j1).getEntitiesOfTypeWithinAAAB(class1, axisalignedbb, arraylist);
                }
                ++j1;
            }
            ++i1;
        }
        return arraylist;
    }

    public List<Entity> getLoadedEntityList() {
        return this.loadedEntityList;
    }

    public void cacheTileEntity(int i, int j, int k, TileEntity tileentity) {
        if (this.blockExists(i, j, k)) {
            this.getChunkFromBlockCoords(i, k).setChunkModified();
        }
        int l = 0;
        while (l < this.worldAccesses.size()) {
            this.worldAccesses.get(l).hashTileEntity(i, j, k, tileentity);
            ++l;
        }
    }

    public int getMatchingEntities(Class<?> class1) {
        int i = 0;
        int j = 0;
        while (j < this.loadedEntityList.size()) {
            Entity entity = this.loadedEntityList.get(j);
            if (class1.isAssignableFrom(entity.getClass())) {
                ++i;
            }
            ++j;
        }
        return i;
    }

    public void addLoadedEntities(List<Entity> list) {
        this.loadedEntityList.addAll(list);
        int i = 0;
        while (i < list.size()) {
            this.obtainEntitySkin(list.get(i));
            ++i;
        }
    }

    public void addUnloadedEntities(List<Entity> field_1528_m) {
        this.unloadedEntityList.addAll(field_1528_m);
    }

    public void func_656_j() {
        while (this.chunkProvider.unload100OldestChunks()) {
        }
    }

    public IChunkProvider getIChunkProvider() {
        return this.chunkProvider;
    }

    public boolean func_695_a(int i, int j, int k, int l, boolean flag) {
        int i1 = this.getBlockId(j, k, l);
        Block block = Block.allBlocks[i1];
        Block block1 = Block.allBlocks[i];
        AxisAlignedBB axisalignedbb = block1.getCollisionBoundingBoxFromPool(this, j, k, l);
        if (flag) {
            axisalignedbb = null;
        }
        if (axisalignedbb != null && !this.func_604_a(axisalignedbb)) {
            return false;
        }
        if (!(block != Block.waterMoving && block != Block.waterStill && block != Block.lavaMoving && block != Block.lavaStill && block != Block.fire && block != Block.snow || i == Block.ice.blockID && BlockBurntCloth.getSurroundHotBlock(this, j, k, l))) {
            return true;
        }
        return i > 0 && block == null && block1.canPlace(this, j, k, l);
    }

    public PathEntity getPathEntityToEntity(Entity entity, Entity entity1, float f) {
        int i = MathHelper.floor_double(entity.posX);
        int j = MathHelper.floor_double(entity.posY);
        int k = MathHelper.floor_double(entity.posZ);
        int l = (int)(f + 16.0f);
        int i1 = i - l;
        int j1 = j - l;
        int k1 = k - l;
        int l1 = i + l;
        int i2 = j + l;
        int j2 = k + l;
        ChunkCache chunkcache = new ChunkCache(this, i1, j1, k1, l1, i2, j2);
        return new Pathfinder(chunkcache).createEntityPathTo(entity, entity1, f);
    }

    public PathEntity func_637_a(Entity entity, int i, int j, int k, float f) {
        int l = MathHelper.floor_double(entity.posX);
        int i1 = MathHelper.floor_double(entity.posY);
        int j1 = MathHelper.floor_double(entity.posZ);
        int k1 = (int)(f + 8.0f);
        int l1 = l - k1;
        int i2 = i1 - k1;
        int j2 = j1 - k1;
        int k2 = l + k1;
        int l2 = i1 + k1;
        int i3 = j1 + k1;
        ChunkCache chunkcache = new ChunkCache(this, l1, i2, j2, k2, l2, i3);
        return new Pathfinder(chunkcache).createEntityPathTo(entity, i, j, k, f);
    }

    public boolean func_668_j(int i, int j, int k, int l) {
        int i1 = this.getBlockId(i, j, k);
        if (i1 == 0) {
            return false;
        }
        return Block.allBlocks[i1].isIndirectlyPoweringTo(this, i, j, k, l);
    }

    public boolean func_646_n(int i, int j, int k) {
        if (this.func_668_j(i, j - 1, k, 0)) {
            return true;
        }
        if (this.func_668_j(i, j + 1, k, 1)) {
            return true;
        }
        if (this.func_668_j(i, j, k - 1, 2)) {
            return true;
        }
        if (this.func_668_j(i, j, k + 1, 3)) {
            return true;
        }
        if (this.func_668_j(i - 1, j, k, 4)) {
            return true;
        }
        return this.func_668_j(i + 1, j, k, 5);
    }

    public boolean isBlockIndirectlyProvidingPowerTo(int i, int j, int k, int l) {
        if (this.getBlockId(i, j, k) == Block.motor.blockID) {
            return true;
        }
        if (this.isBlockNormalCube(i, j, k) && this.getBlockId(i, j, k) != Block.motor.blockID) {
            return this.func_646_n(i, j, k);
        }
        int i1 = this.getBlockId(i, j, k);
        if (i1 == 0) {
            return false;
        }
        return Block.allBlocks[i1].isPoweringTo(this, i, j, k, l);
    }

    public boolean isBlockIndirectlyGettingPowered(int i, int j, int k) {
        if (this.isBlockIndirectlyProvidingPowerTo(i, j - 1, k, 0)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(i, j + 1, k, 1)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(i, j, k - 1, 2)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(i, j, k + 1, 3)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(i - 1, j, k, 4)) {
            return true;
        }
        return this.isBlockIndirectlyProvidingPowerTo(i + 1, j, k, 5);
    }

    public EntityPlayer getClosestPlayerToEntity(Entity entity, double d) {
        return this.getClosestPlayer(entity.posX, entity.posY, entity.posZ, d);
    }

    public EntityPlayer getClosestPlayer(double d, double d1, double d2, double d3) {
        double d4 = -1.0;
        EntityPlayer entityplayer = null;
        int i = 0;
        while (i < this.playerEntities.size()) {
            EntityPlayer entityplayer1 = this.playerEntities.get(i);
            double d5 = entityplayer1.getDistanceSq(d, d1, d2);
            if ((d3 < 0.0 || d5 < d3 * d3) && (d4 == -1.0 || d5 < d4)) {
                d4 = d5;
                entityplayer = entityplayer1;
            }
            ++i;
        }
        return entityplayer;
    }

    public void setChunkData(int xPos, int yPos, int zPos, int xSize, int ySize, int zSize, byte[] chunk) {
        int chunkPosXMin = xPos >> 4;
        int chunkPosZMin = zPos >> 4;
        int chunkPosXMax = xPos + xSize - 1 >> 4;
        int chunkPosZMax = zPos + zSize - 1 >> 4;
        int k2 = 0;
        int chunkPosYMin = yPos;
        int chunkPosYMax = yPos + ySize;
        if (chunkPosYMin < 0) {
            chunkPosYMin = 0;
        }
        if (chunkPosYMax > 128) {
            chunkPosYMax = 128;
        }
        int xIndex = chunkPosXMin;
        while (xIndex <= chunkPosXMax) {
            int k3 = xPos - xIndex * 16;
            int l3 = xPos + xSize - xIndex * 16;
            if (k3 < 0) {
                k3 = 0;
            }
            if (l3 > 16) {
                l3 = 16;
            }
            int zIndex = chunkPosZMin;
            while (zIndex <= chunkPosZMax) {
                int j4 = zPos - zIndex * 16;
                int k4 = zPos + zSize - zIndex * 16;
                if (j4 < 0) {
                    j4 = 0;
                }
                if (k4 > 16) {
                    k4 = 16;
                }
                k2 = this.getChunkFromChunkCoords(xIndex, zIndex).getChunkData(chunk, k3, chunkPosYMin, j4, l3, chunkPosYMax, k4, k2);
                this.markBlocksDirty(xIndex * 16 + k3, chunkPosYMin, zIndex * 16 + j4, xIndex * 16 + l3, chunkPosYMax, zIndex * 16 + k4);
                ++zIndex;
            }
            ++xIndex;
        }
    }

    public void sendQuittingDisconnectingPacket() {
    }

    public void checkSessionLock() {
        try {
            File file = new File(this.worldFolder, "session.lock");
            DataInputStream datainputstream = new DataInputStream(new FileInputStream(file));
            try {
                if (datainputstream.readLong() != this.field_1018_G) {
                    throw new MinecraftException("The save is being accessed from another location, aborting");
                }
            }
            finally {
                datainputstream.close();
            }
        }
        catch (IOException ioexception) {
            throw new MinecraftException("Failed to check session lock, aborting");
        }
    }

    public void setWorldTime(long l) {
        this.worldTime = l;
    }

    public void joinEntityInSurroundings(Entity entity) {
        int i = MathHelper.floor_double(entity.posX / 16.0);
        int j = MathHelper.floor_double(entity.posZ / 16.0);
        int byte0 = 2;
        int k = i - byte0;
        while (k <= i + byte0) {
            int l = j - byte0;
            while (l <= j + byte0) {
                this.getChunkFromChunkCoords(k, l);
                ++l;
            }
            ++k;
        }
        if (!this.loadedEntityList.contains(entity)) {
            System.out.println("REINSERTING PLAYER!");
            this.loadedEntityList.add(entity);
            this.obtainEntitySkin(entity);
        }
    }

    public void func_28106_e(int i, int j, int k, int l, int i1) {
        this.func_28107_a(null, i, j, k, l, i1);
    }

    public void func_28107_a(EntityPlayer entityplayer, int i, int j, int k, int l, int i1) {
        int j1 = 0;
        while (j1 < this.worldAccesses.size()) {
            this.worldAccesses.get(j1).func_28136_a(entityplayer, i, j, k, l, i1);
            ++j1;
        }
    }

    @Override
    public EnumSeason getCurrentSeason() {
        if (this.season != EnumSeason.cycle) {
            return this.season;
        }
        int timeOfYear = (int)(this.worldTime % (long)(24000 * this.daysInSeason * 4) / (long)(24000 * this.daysInSeason));
        switch (timeOfYear) {
            case 0: {
                return EnumSeason.summer;
            }
            case 1: {
                return EnumSeason.fall;
            }
            case 2: {
                return EnumSeason.winter;
            }
            case 3: {
                return EnumSeason.spring;
            }
        }
        return EnumSeason.summer;
    }

    public EnumSeason getLastSeason() {
        switch (this.getCurrentSeason()) {
            case summer: {
                return EnumSeason.spring;
            }
            case fall: {
                return EnumSeason.summer;
            }
            case winter: {
                return EnumSeason.fall;
            }
            case spring: {
                return EnumSeason.winter;
            }
        }
        return EnumSeason.spring;
    }

    public EnumSeason getNextSeason() {
        switch (this.getCurrentSeason()) {
            case summer: {
                return EnumSeason.fall;
            }
            case fall: {
                return EnumSeason.winter;
            }
            case winter: {
                return EnumSeason.spring;
            }
            case spring: {
                return EnumSeason.summer;
            }
        }
        return EnumSeason.fall;
    }

    public long getCurrentDay() {
        return this.worldTime / 24000L;
    }

    @Override
    public float getSeasonProgress() {
        float prog = 0.0f;
        int timeOfSeason = (int)(this.worldTime % (long)(24000 * this.daysInSeason) / 24000L);
        prog = (float)timeOfSeason / (float)this.daysInSeason;
        return prog;
    }

    @Override
    public float getFoliageLevel(int x, int y, int z) {
        return (float)Math.abs(this.foliage.generateNoise((float)x / 8.0f, (float)y / 8.0f, (float)z / 8.0f)) * (3.0f * this.getSeasonProgress());
    }
}

