/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.level.chunk;

import com.mojang.minecraft.core.entity.tile.IBlockAccess;
import com.mojang.minecraft.core.entity.tile.TileEntity;
import com.mojang.minecraft.core.enums.EnumSeason;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.chunk.Chunk;
import com.mojang.minecraft.core.level.tile.Block;
import com.mojang.minecraft.core.level.tile.material.Material;

public class ChunkCache
implements IBlockAccess {
    private int field_1060_a;
    private int field_1059_b;
    private Chunk[][] field_1062_c;
    private World worldObj;

    public ChunkCache(World world, int i, int j, int k, int l, int i1, int j1) {
        this.worldObj = world;
        this.field_1060_a = i >> 4;
        this.field_1059_b = k >> 4;
        int k1 = l >> 4;
        int l1 = j1 >> 4;
        this.field_1062_c = new Chunk[k1 - this.field_1060_a + 1][l1 - this.field_1059_b + 1];
        int i2 = this.field_1060_a;
        while (i2 <= k1) {
            int j2 = this.field_1059_b;
            while (j2 <= l1) {
                this.field_1062_c[i2 - this.field_1060_a][j2 - this.field_1059_b] = world.getChunkFromChunkCoords(i2, j2);
                ++j2;
            }
            ++i2;
        }
    }

    public int getBlockId(int i, int j, int k) {
        if (j < 0) {
            return 0;
        }
        if (j >= 128) {
            return 0;
        }
        int l = (i >> 4) - this.field_1060_a;
        int i1 = (k >> 4) - this.field_1059_b;
        return this.field_1062_c[l][i1].getBlockId(i & 0xF, j, k & 0xF);
    }

    public boolean isTouchingAir(int x, int y, int z) {
        return this.getBlockId(x - 1, y, z) == 0 || this.getBlockId(x + 1, y, z) == 0 || this.getBlockId(x, y - 1, z) == 0 || this.getBlockId(x, y + 1, z) == 0 || this.getBlockId(x, y, z - 1) == 0 || this.getBlockId(x, y, z + 1) == 0;
    }

    public TileEntity getBlockTileEntity(int i, int j, int k) {
        int l = (i >> 4) - this.field_1060_a;
        int i1 = (k >> 4) - this.field_1059_b;
        return this.field_1062_c[l][i1].getChunkBlockTileEntity(i & 0xF, j, k & 0xF);
    }

    public float getBrightness(int i, int j, int k) {
        return World.field_1042_i[this.func_715_d(i, j, k)];
    }

    public int func_715_d(int i, int j, int k) {
        return this.func_716_a(i, j, k, true);
    }

    public int func_716_a(int i, int j, int k, boolean flag) {
        int l;
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return 15;
        }
        if (flag && ((l = this.getBlockId(i, j, k)) == Block.stepSingle.blockID || l == Block.tilledField.blockID)) {
            int k1 = this.func_716_a(i, j + 1, k, false);
            int i2 = this.func_716_a(i + 1, j, k, false);
            int j2 = this.func_716_a(i - 1, j, k, false);
            int k2 = this.func_716_a(i, j, k + 1, false);
            int l2 = this.func_716_a(i, j, k - 1, false);
            if (i2 > k1) {
                k1 = i2;
            }
            if (j2 > k1) {
                k1 = j2;
            }
            if (k2 > k1) {
                k1 = k2;
            }
            if (l2 > k1) {
                k1 = l2;
            }
            return k1;
        }
        if (j < 0) {
            return 0;
        }
        if (j >= 128) {
            int i1 = 15 - this.worldObj.skyLightSubtracted;
            if (i1 < 0) {
                i1 = 0;
            }
            return i1;
        }
        int j1 = (i >> 4) - this.field_1060_a;
        int l1 = (k >> 4) - this.field_1059_b;
        return this.field_1062_c[j1][l1].getBlockLightValue(i & 0xF, j, k & 0xF, this.worldObj.skyLightSubtracted);
    }

    public int getBlockMetadata(int x, int y, int z) {
        if (y < 0) {
            return 0;
        }
        if (y >= 128) {
            return 0;
        }
        int l = (x >> 4) - this.field_1060_a;
        int i1 = (z >> 4) - this.field_1059_b;
        return this.field_1062_c[l][i1].getBlockMetadata(x & 0xF, y, z & 0xF);
    }

    public Material getMaterialXYZ(int x, int y, int z) {
        int l = this.getBlockId(x, y, z);
        if (l == 0) {
            return Material.air;
        }
        return Block.allBlocks[l].blockMaterial;
    }

    public boolean isBlockNormalCube(int x, int y, int z) {
        Block block = Block.allBlocks[this.getBlockId(x, y, z)];
        if (block == null) {
            return false;
        }
        return block.isOpaqueCube();
    }

    public float getFoliageLevel(int i, int j, int k) {
        return this.worldObj.getFoliageLevel(i, j, k);
    }

    public EnumSeason getCurrentSeason() {
        return this.worldObj.getCurrentSeason();
    }

    public float getSeasonProgress() {
        return this.worldObj.getSeasonProgress();
    }
}

