/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.level.chunk;

import com.mojang.minecraft.core.enums.EnumSeason;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.chunk.ChunkProviderGenerate;
import com.mojang.minecraft.core.level.generate.IChunkProvider;
import com.mojang.minecraft.core.level.generate.WorldGenBigTree;
import com.mojang.minecraft.core.level.generate.WorldGenCactus;
import com.mojang.minecraft.core.level.generate.WorldGenClay;
import com.mojang.minecraft.core.level.generate.WorldGenDungeons;
import com.mojang.minecraft.core.level.generate.WorldGenFlowers;
import com.mojang.minecraft.core.level.generate.WorldGenLiquids;
import com.mojang.minecraft.core.level.generate.WorldGenMinable;
import com.mojang.minecraft.core.level.generate.WorldGenReed;
import com.mojang.minecraft.core.level.generate.WorldGenTrees;
import com.mojang.minecraft.core.level.generate.WorldGenWaterDungeons;
import com.mojang.minecraft.core.level.generate.WorldGenerator;
import com.mojang.minecraft.core.level.generate.noise.InfdevOldNoiseGeneratorOctaves;
import com.mojang.minecraft.core.level.tile.Block;
import com.mojang.minecraft.core.level.tile.BlockSand;
import com.mojang.minecraft.core.level.tile.material.Material;

public class ChunkProviderIndev
extends ChunkProviderGenerate {
    public ChunkProviderIndev(World world, long l) {
        super(world, l);
        world.cloudHeight = 108.0f;
        this.noiseGen1a = new InfdevOldNoiseGeneratorOctaves(this.genRandom, 16);
        this.noiseGen2a = new InfdevOldNoiseGeneratorOctaves(this.genRandom, 16);
        this.noiseGen3a = new InfdevOldNoiseGeneratorOctaves(this.genRandom, 8);
        this.noiseGen4a = new InfdevOldNoiseGeneratorOctaves(this.genRandom, 4);
        this.noiseGen5a = new InfdevOldNoiseGeneratorOctaves(this.genRandom, 4);
        this.noiseGen6a = new InfdevOldNoiseGeneratorOctaves(this.genRandom, 5);
        new InfdevOldNoiseGeneratorOctaves(this.genRandom, 3);
        new InfdevOldNoiseGeneratorOctaves(this.genRandom, 3);
        new InfdevOldNoiseGeneratorOctaves(this.genRandom, 3);
    }

    public void generateTerrain(int chunkX, int chunkZ, byte[] blockArray) {
        int blockX = chunkX << 4;
        int blockZ = chunkZ << 4;
        int j = 0;
        int genBlockX = blockX;
        while (genBlockX < blockX + 16) {
            int genBlockZ = blockZ;
            while (genBlockZ < blockZ + 16) {
                float heightValue = (float)(this.noiseGen1a.a((float)genBlockX / 0.03125f, 0.0, (float)genBlockZ / 0.03125f) - this.noiseGen2a.a((float)genBlockX / 0.015625f, 0.0, (float)genBlockZ / 0.015625f)) / 512.0f / 4.0f;
                float f2 = (float)this.noiseGen4a.func_806_a((float)genBlockX / 4.0f, (float)genBlockZ / 4.0f);
                float f3 = (float)this.noiseGen6a.func_806_a((float)genBlockX / 8.0f, (float)genBlockZ / 8.0f) / 8.0f;
                f2 = f2 <= 0.0f ? (float)(this.noiseGen5a.func_806_a((float)genBlockX * 0.2571428f, (float)genBlockZ * 0.2571428f) * (double)f3) : (float)(this.noiseGen3a.func_806_a((float)genBlockX * 0.2571428f * 2.0f, (float)genBlockZ * 0.2571428f * 2.0f) * (double)f3 / 4.0);
                heightValue = (int)(heightValue + 64.0f + f2);
                if ((float)this.noiseGen5a.func_806_a(genBlockX, genBlockZ) < 0.0f) {
                    heightValue = (int)heightValue / 2 << 1;
                    if ((float)this.noiseGen5a.func_806_a((double)genBlockX / 5.0, (double)genBlockZ / 5.0) < 0.0f) {
                        heightValue += 1.0f;
                    }
                }
                int genBlockY = 0;
                while (genBlockY < 128) {
                    int l1 = 0;
                    if ((genBlockX == 0 && chunkX == 0 || genBlockZ == 0 && chunkZ == 0) && (float)genBlockY <= heightValue) {
                        l1 = Block.stone.blockID;
                    }
                    if ((float)genBlockY == heightValue + 1.0f && heightValue >= 64.0f && Math.random() < 0.02) {
                        l1 = 0;
                    } else if ((float)genBlockY == heightValue && heightValue >= 64.0f) {
                        l1 = Block.stone.blockID;
                    } else if ((float)genBlockY <= heightValue - 2.0f) {
                        l1 = Block.stone.blockID;
                    } else if ((float)genBlockY <= heightValue) {
                        l1 = Block.stone.blockID;
                    } else if (genBlockY <= 64) {
                        l1 = Block.waterStill.blockID;
                        if ((this.worldObj.snowCovered || this.worldObj.getCurrentSeason() == EnumSeason.winter) && genBlockY == 64) {
                            l1 = Block.ice.blockID;
                        }
                    }
                    this.genRandom.setSeed(chunkX + chunkZ * 13871);
                    int i2 = (chunkX << 10) + 128 + this.genRandom.nextInt(512);
                    int j2 = (chunkZ << 10) + 128 + this.genRandom.nextInt(512);
                    i2 = genBlockX - i2;
                    j2 = genBlockZ - j2;
                    if (i2 < 0) {
                        i2 = -i2;
                    }
                    if (j2 < 0) {
                        j2 = -j2;
                    }
                    if (j2 > i2) {
                        i2 = j2;
                    }
                    if ((i2 = 127 - i2) == 255) {
                        i2 = 1;
                    }
                    if ((float)i2 < heightValue) {
                        i2 = (int)heightValue;
                    }
                    if (genBlockY <= i2 && (l1 == 0 || l1 == Block.waterStill.blockID || l1 == Block.lavaStill.blockID)) {
                        l1 = Block.brick.blockID;
                    }
                    if (l1 < 0) {
                        l1 = 0;
                    }
                    blockArray[j++] = (byte)l1;
                    ++genBlockY;
                }
                ++genBlockZ;
            }
            ++genBlockX;
        }
    }

    public void replaceBlocksForBiome(int i, int j, byte[] abyte0) {
        int seaLevel = 64;
        double d = 0.03125;
        this.sandBeachNoise = this.beachNoise.generateNoiseOctaves(this.sandBeachNoise, i * 16, j * 16, 0.0, 16, 16, 1, d, d, 1.0);
        this.gravelBeachNoise = this.beachNoise.generateNoiseOctaves(this.gravelBeachNoise, j * 16, 109.0134, i * 16, 16, 1, 16, d, 1.0, d);
        this.soilThicknessNoise = this.soilNoise.generateNoiseOctaves(this.soilThicknessNoise, i * 16, j * 16, 0.0, 16, 16, 1, d * 2.0, d * 2.0, d * 2.0);
        int k = 0;
        while (k < 16) {
            int l = 0;
            while (l < 16) {
                boolean flag = this.sandBeachNoise[k + l * 16] + this.genRandom.nextDouble() * 0.2 > 0.0;
                boolean flag1 = this.gravelBeachNoise[k + l * 16] + this.genRandom.nextDouble() * 0.2 > 3.0;
                int i1 = (int)(this.soilThicknessNoise[k + l * 16] / 3.0 + 3.0 + this.genRandom.nextDouble() * 0.25);
                int j1 = -1;
                byte byte1 = (byte)Block.grass.blockID;
                byte byte2 = (byte)Block.dirt.blockID;
                int k1 = 127;
                while (k1 >= 0) {
                    int l1 = (k * 16 + l) * 128 + k1;
                    if (k1 <= 0 + this.genRandom.nextInt(6) - 1) {
                        abyte0[l1] = (byte)Block.bedrock.blockID;
                    } else {
                        byte byte3 = abyte0[l1];
                        if (byte3 == 0) {
                            j1 = -1;
                        } else if (byte3 == Block.stone.blockID) {
                            if (j1 == -1) {
                                if (i1 <= 0) {
                                    byte1 = 0;
                                    byte2 = (byte)Block.stone.blockID;
                                } else if (k1 >= seaLevel - 4 && k1 <= seaLevel + 1) {
                                    if (flag1) {
                                        byte1 = 0;
                                    }
                                    if (flag1) {
                                        byte2 = (byte)Block.gravel.blockID;
                                    }
                                    if (flag) {
                                        byte1 = (byte)Block.sand.blockID;
                                    }
                                    if (flag) {
                                        byte2 = (byte)Block.sand.blockID;
                                    }
                                }
                                if (k1 < seaLevel && byte1 == 0) {
                                    byte1 = (byte)Block.waterStill.blockID;
                                }
                                j1 = i1;
                                abyte0[l1] = k1 >= seaLevel - 1 ? byte1 : byte2;
                            } else if (j1 > 0) {
                                --j1;
                                abyte0[l1] = byte2;
                            }
                        }
                    }
                    --k1;
                }
                ++l;
            }
            ++k;
        }
    }

    protected double[] initializeNoiseField(double[] ad, int i, int j, int k, int l, int i1, int j1) {
        return ad;
    }

    public boolean chunkExists(int i, int j) {
        return true;
    }

    public void generateStructures(IChunkProvider ichunkprovider, int i, int j) {
        int j16;
        int l13;
        int i9;
        int k12;
        int l7;
        int k5;
        int i11;
        int j6;
        int i4;
        BlockSand.fallInstantly = true;
        int k = i * 16;
        int l = j * 16;
        this.genRandom.setSeed(this.worldObj.randomSeed);
        long l1 = this.genRandom.nextLong() / 2L * 2L + 1L;
        long l2 = this.genRandom.nextLong() / 2L * 2L + 1L;
        this.genRandom.setSeed((long)i * l1 + (long)j * l2 ^ this.worldObj.randomSeed);
        double d = 0.25;
        int i1 = 0;
        while (i1 < 8) {
            i4 = k + this.genRandom.nextInt(16) + 8;
            j6 = this.genRandom.nextInt(128);
            i11 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenDungeons().generate(this.worldObj, this.genRandom, i4, j6, i11);
            ++i1;
        }
        if (!(k <= 1000 && k >= -1000 || l <= 1000 && l >= -1000 || this.genRandom.nextInt(4000) != 2)) {
            int y = 0;
            while (y < 128) {
                short inc = (short)(y - 128);
                int x = k + inc + 1;
                while (x < k - inc) {
                    int z = l + inc + 1;
                    while (z < l - inc) {
                        if (!this.worldObj.isBlockNormalCube(x, y, z) && Math.abs(x) > 999 && Math.abs(z) > 999) {
                            this.worldObj.setBlockWithNotify(x, y, z, Block.brick.blockID);
                        }
                        ++z;
                    }
                    ++x;
                }
                y = (short)(y + 1);
            }
        }
        i1 = 0;
        while (i1 < 8) {
            i4 = k + this.genRandom.nextInt(16) + 8;
            j6 = this.genRandom.nextInt(512);
            i11 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenWaterDungeons().generate(this.worldObj, this.genRandom, i4, j6, i11);
            ++i1;
        }
        int j1 = 0;
        while (j1 < 10) {
            int j4 = k + this.genRandom.nextInt(16);
            int k6 = this.genRandom.nextInt(64);
            int j11 = l + this.genRandom.nextInt(16);
            new WorldGenClay(8, new int[]{Block.grass.blockID, Block.dirt.blockID}).generate(this.worldObj, this.genRandom, j4, k6, j11);
            ++j1;
        }
        int k1 = 0;
        while (k1 < 20) {
            int k4 = k + this.genRandom.nextInt(16);
            int l6 = this.genRandom.nextInt(128);
            int k11 = l + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.dirt.blockID, 32).generate(this.worldObj, this.genRandom, k4, l6, k11);
            ++k1;
        }
        int i2 = 0;
        while (i2 < 10) {
            int l4 = k + this.genRandom.nextInt(16);
            int i7 = this.genRandom.nextInt(128);
            int l11 = l + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.gravel.blockID, 32).generate(this.worldObj, this.genRandom, l4, i7, l11);
            ++i2;
        }
        int j2 = 0;
        while (j2 < 20) {
            int i5 = k + this.genRandom.nextInt(16);
            int j7 = this.genRandom.nextInt(128);
            int i12 = l + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.oreCoal.blockID, 16).generate(this.worldObj, this.genRandom, i5, j7, i12);
            ++j2;
        }
        int k2 = 0;
        while (k2 < 20) {
            int j5 = k + this.genRandom.nextInt(16);
            int k7 = this.genRandom.nextInt(64);
            int j12 = l + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.oreIron.blockID, 8).generate(this.worldObj, this.genRandom, j5, k7, j12);
            ++k2;
        }
        int i3 = 0;
        while (i3 < 2) {
            k5 = k + this.genRandom.nextInt(16);
            l7 = this.genRandom.nextInt(32);
            k12 = l + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.oreGold.blockID, 8).generate(this.worldObj, this.genRandom, k5, l7, k12);
            ++i3;
        }
        i3 = 0;
        while (i3 < 6) {
            k5 = k + this.genRandom.nextInt(16);
            l7 = this.genRandom.nextInt(32);
            k12 = l + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.oreCopper.blockID, 8).generate(this.worldObj, this.genRandom, k5, l7, k12);
            ++i3;
        }
        int j3 = 0;
        while (j3 < 8) {
            int l5 = k + this.genRandom.nextInt(16);
            int i8 = this.genRandom.nextInt(16);
            int l12 = l + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.oreRed.blockID, 7).generate(this.worldObj, this.genRandom, l5, i8, l12);
            ++j3;
        }
        int k3 = 0;
        while (k3 < 1) {
            int i6 = k + this.genRandom.nextInt(16);
            int j8 = this.genRandom.nextInt(16);
            int i13 = l + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.oreDiamond.blockID, 7).generate(this.worldObj, this.genRandom, i6, j8, i13);
            ++k3;
        }
        d = 0.5;
        int l3 = (int)((this.treeNoise.getVal((double)k * d, (double)l * d) / 8.0 + this.genRandom.nextDouble() * 4.0 + 4.0) / 3.0);
        if (l3 < 0) {
            l3 = 0;
        }
        if (this.genRandom.nextInt(10) == 0) {
            ++l3;
        }
        WorldGenerator obj = new WorldGenTrees();
        if (this.genRandom.nextInt(10) == 0) {
            obj = new WorldGenBigTree();
        }
        int k8 = 0;
        while (k8 < l3) {
            int j13 = k + this.genRandom.nextInt(16) + 8;
            int l15 = l + this.genRandom.nextInt(16) + 8;
            ((WorldGenerator)obj).func_517_a(1.0, 1.0, 1.0);
            ((WorldGenerator)obj).generate(this.worldObj, this.genRandom, j13, this.worldObj.getHeightValue(j13, l15), l15);
            ++k8;
        }
        int l8 = 0;
        while (l8 < 2) {
            int k13 = k + this.genRandom.nextInt(16) + 8;
            int i16 = this.genRandom.nextInt(128);
            int j18 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenFlowers(Block.plantYellow.blockID).generate(this.worldObj, this.genRandom, k13, i16, j18);
            ++l8;
        }
        if (this.genRandom.nextInt(2) == 0) {
            i9 = k + this.genRandom.nextInt(16) + 8;
            l13 = this.genRandom.nextInt(128);
            j16 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenFlowers(Block.plantRed.blockID).generate(this.worldObj, this.genRandom, i9, l13, j16);
        }
        if (this.genRandom.nextInt(1) == 0) {
            i9 = k + this.genRandom.nextInt(16) + 8;
            l13 = this.genRandom.nextInt(128);
            j16 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenFlowers(Block.plantBlue.blockID).generate(this.worldObj, this.genRandom, i9, l13, j16);
        }
        if (this.genRandom.nextInt(4) == 0) {
            int j9 = k + this.genRandom.nextInt(16) + 8;
            int i14 = this.genRandom.nextInt(128);
            int k16 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomBrown.blockID).generate(this.worldObj, this.genRandom, j9, i14, k16);
        }
        if (this.genRandom.nextInt(8) == 0) {
            int k9 = k + this.genRandom.nextInt(16) + 8;
            int j14 = this.genRandom.nextInt(128);
            int l16 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomRed.blockID).generate(this.worldObj, this.genRandom, k9, j14, l16);
        }
        int l9 = 0;
        while (l9 < 10) {
            int k14 = k + this.genRandom.nextInt(16) + 8;
            int i17 = this.genRandom.nextInt(128);
            int k18 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenReed().generate(this.worldObj, this.genRandom, k14, i17, k18);
            ++l9;
        }
        int i10 = 0;
        while (i10 < 10) {
            int l14 = k + this.genRandom.nextInt(16) + 8;
            int j17 = this.genRandom.nextInt(128);
            int l18 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenCactus().generate(this.worldObj, this.genRandom, l14, j17, l18);
            ++i10;
        }
        int j10 = 0;
        while (j10 < 50) {
            int i15 = k + this.genRandom.nextInt(16) + 8;
            int k17 = this.genRandom.nextInt(this.genRandom.nextInt(120) + 8);
            int i19 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenLiquids(Block.waterMoving.blockID).generate(this.worldObj, this.genRandom, i15, k17, i19);
            ++j10;
        }
        int k10 = 0;
        while (k10 < 20) {
            int j15 = k + this.genRandom.nextInt(16) + 8;
            int l17 = this.genRandom.nextInt(this.genRandom.nextInt(this.genRandom.nextInt(112) + 8) + 8);
            int j19 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenLiquids(Block.lavaMoving.blockID).generate(this.worldObj, this.genRandom, j15, l17, j19);
            ++k10;
        }
        int l10 = k + 8 + 0;
        while (l10 < k + 8 + 16) {
            int k15 = l + 8 + 0;
            while (k15 < l + 8 + 16) {
                int i18 = this.worldObj.getTopSolidOrLiquidBlock(l10, k15);
                if ((this.worldObj.snowCovered || this.worldObj.getCurrentSeason() == EnumSeason.winter && this.worldObj.experiencedFirstSnow) && i18 > 0 && i18 < 128 && this.worldObj.getBlockId(l10, i18, k15) == 0 && this.worldObj.getMaterialXYZ(l10, i18 - 1, k15).blocksMovement() && this.worldObj.getMaterialXYZ(l10, i18 - 1, k15) != Material.ice) {
                    this.worldObj.setBlockWithNotify(l10, i18, k15, Block.snow.blockID);
                }
                ++k15;
            }
            ++l10;
        }
        BlockSand.fallInstantly = false;
    }
}

