/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.level.chunk;

import com.mojang.minecraft.core.enums.EnumSeason;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.chunk.Chunk;
import com.mojang.minecraft.core.level.chunk.ChunkProviderGenerate;
import com.mojang.minecraft.core.level.generate.IChunkProvider;
import com.mojang.minecraft.core.level.generate.MapGenCaves;
import com.mojang.minecraft.core.level.generate.WorldGenBigTree;
import com.mojang.minecraft.core.level.generate.WorldGenCactus;
import com.mojang.minecraft.core.level.generate.WorldGenClay;
import com.mojang.minecraft.core.level.generate.WorldGenClayRed;
import com.mojang.minecraft.core.level.generate.WorldGenDungeons;
import com.mojang.minecraft.core.level.generate.WorldGenFloatingDungeons;
import com.mojang.minecraft.core.level.generate.WorldGenFlowers;
import com.mojang.minecraft.core.level.generate.WorldGenLiquids;
import com.mojang.minecraft.core.level.generate.WorldGenMinable;
import com.mojang.minecraft.core.level.generate.WorldGenReed;
import com.mojang.minecraft.core.level.generate.WorldGenTrees;
import com.mojang.minecraft.core.level.generate.WorldGenerator;
import com.mojang.minecraft.core.level.generate.aaa2;
import com.mojang.minecraft.core.level.generate.noise.NoiseGeneratorOctaves;
import com.mojang.minecraft.core.level.tile.Block;
import com.mojang.minecraft.core.level.tile.BlockSand;
import com.mojang.minecraft.core.level.tile.material.Material;
import java.util.Random;

public class ChunkProviderSky
extends ChunkProviderGenerate {
    public ChunkProviderSky(World par1World, long par2) {
        super(par1World, par2);
        this.mapGenBase = new MapGenCaves();
        this.worldObj = par1World;
        this.genRandom = new Random(par2);
        this.noiseGen1 = new NoiseGeneratorOctaves(this.genRandom, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.genRandom, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.genRandom, 8);
        this.beachNoise = new NoiseGeneratorOctaves(this.genRandom, 10);
        this.soilNoise = new NoiseGeneratorOctaves(this.genRandom, 16);
        par1World.cloudHeight = 0.0f;
    }

    public void generateTerrain(int par1, int par2, byte[] par3ArrayOfByte) {
        int var5 = 2;
        int var6 = var5 + 1;
        int var7 = 33;
        int var8 = var5 + 1;
        this.densities = this.initializeNoiseField(this.densities, par1 * var5, 0, par2 * var5, var6, var7, var8);
        int var9 = 0;
        while (var9 < var5) {
            int var10 = 0;
            while (var10 < var5) {
                int var11 = 0;
                while (var11 < 32) {
                    double var12 = 0.25;
                    double var14 = this.densities[((var9 + 0) * var8 + var10 + 0) * var7 + var11 + 0];
                    double var16 = this.densities[((var9 + 0) * var8 + var10 + 1) * var7 + var11 + 0];
                    double var18 = this.densities[((var9 + 1) * var8 + var10 + 0) * var7 + var11 + 0];
                    double var20 = this.densities[((var9 + 1) * var8 + var10 + 1) * var7 + var11 + 0];
                    double var22 = (this.densities[((var9 + 0) * var8 + var10 + 0) * var7 + var11 + 1] - var14) * var12;
                    double var24 = (this.densities[((var9 + 0) * var8 + var10 + 1) * var7 + var11 + 1] - var16) * var12;
                    double var26 = (this.densities[((var9 + 1) * var8 + var10 + 0) * var7 + var11 + 1] - var18) * var12;
                    double var28 = (this.densities[((var9 + 1) * var8 + var10 + 1) * var7 + var11 + 1] - var20) * var12;
                    int var30 = 0;
                    while (var30 < 4) {
                        double var31 = 0.125;
                        double var33 = var14;
                        double var35 = var16;
                        double var37 = (var18 - var14) * var31;
                        double var39 = (var20 - var16) * var31;
                        int var41 = 0;
                        while (var41 < 8) {
                            int var42 = var41 + var9 * 8 << 11 | 0 + var10 * 8 << 7 | var11 * 4 + var30;
                            int var43 = 128;
                            double var44 = 0.125;
                            double var46 = var33;
                            double var48 = (var35 - var33) * var44;
                            int var50 = 0;
                            while (var50 < 8) {
                                int var51 = 0;
                                if (var46 > 0.0) {
                                    var51 = Block.stone.blockID;
                                }
                                par3ArrayOfByte[var42] = (byte)var51;
                                var42 += var43;
                                var46 += var48;
                                ++var50;
                            }
                            var33 += var37;
                            var35 += var39;
                            ++var41;
                        }
                        var14 += var22;
                        var16 += var24;
                        var18 += var26;
                        var20 += var28;
                        ++var30;
                    }
                    ++var11;
                }
                ++var10;
            }
            ++var9;
        }
    }

    public void replaceBlocksForBiome(int par1, int par2, byte[] abyte0) {
        int var5 = 0;
        while (var5 < 16) {
            int var6 = 0;
            while (var6 < 16) {
                int var7 = 1;
                int var8 = -1;
                byte var9 = (byte)Block.grass.blockID;
                byte var10 = (byte)Block.dirt.blockID;
                int var11 = 127;
                while (var11 >= 0) {
                    int var12 = (var6 * 16 + var5) * 128 + var11;
                    byte var13 = abyte0[var12];
                    if (var13 == 0) {
                        var8 = -1;
                    } else if (var13 == Block.stone.blockID) {
                        if (var8 == -1) {
                            if (var7 <= 0) {
                                var9 = 0;
                                var10 = (byte)Block.stone.blockID;
                            }
                            var8 = var7;
                            abyte0[var12] = var9;
                        } else if (var8 > 0) {
                            --var8;
                            abyte0[var12] = var10;
                        }
                    }
                    --var11;
                }
                ++var6;
            }
            ++var5;
        }
    }

    public Chunk provideChunk(int par1, int par2) {
        this.genRandom.setSeed((long)par1 * 341873128712L + (long)par2 * 132897987541L);
        byte[] var3 = new byte[32768];
        Chunk var4 = new Chunk(this.worldObj, var3, par1, par2);
        this.generateTerrain(par1, par2, var3);
        this.replaceBlocksForBiome(par1, par2, var3);
        this.mapGenBase.func_867_a(this, this.worldObj, par1, par2, var3);
        var4.func_1024_c();
        return var4;
    }

    protected double[] initializeNoiseField(double[] par1ArrayOfDouble, int par2, int par3, int par4, int par5, int par6, int par7) {
        if (par1ArrayOfDouble == null) {
            par1ArrayOfDouble = new double[par5 * par6 * par7];
        }
        float[] adFloat = new float[par1ArrayOfDouble.length];
        int i2 = 0;
        while (i2 < par1ArrayOfDouble.length) {
            adFloat[i2] = (float)par1ArrayOfDouble[i2];
            ++i2;
        }
        double var8 = 684.412;
        double var10 = 684.412;
        this.heightBias1 = this.beachNoise.generateNoiseOctaves(this.heightBias1, par2, par3, par4, par5, par6, par7, 1.121, 1.121, 0.5);
        this.heightBias2 = this.soilNoise.generateNoiseOctaves(this.heightBias2, par2, par3, par4, par5, par6, par7, 200.0, 200.0, 0.5);
        this.noiseData1 = this.noiseGen3.generateNoiseOctaves(this.noiseData1, par2, par3, par4, par5, par6, par7, (var8 *= 2.0) / 80.0, var10 / 160.0, var8 / 80.0);
        this.noiseData2 = this.noiseGen1.generateNoiseOctaves(this.noiseData2, par2, par3, par4, par5, par6, par7, var8, var10, var8);
        this.noiseData3 = this.noiseGen2.generateNoiseOctaves(this.noiseData3, par2, par3, par4, par5, par6, par7, var8, var10, var8);
        int k1 = 0;
        int l1 = 0;
        int i22 = 16 / par5;
        int j2 = 0;
        while (j2 < par5) {
            int k2 = j2 * i22 + i22 / 2;
            int l2 = 0;
            while (l2 < par7) {
                double d6;
                int i3 = l2 * i22 + i22 / 2;
                double d2 = k2 * 16 + i3;
                double d3 = (double)(k2 * 16 + i3) * d2;
                double d4 = 1.0 - d3;
                d4 *= d4;
                d4 *= d4;
                d4 = 1.0 - d4;
                double d5 = (this.heightBias1[l1] + 256.0) / 512.0;
                if ((d5 *= d4) > 1.0) {
                    d5 = 1.0;
                }
                if ((d6 = this.heightBias2[l1] / 8000.0) < 0.0) {
                    d6 = -d6 * 0.3;
                }
                if ((d6 = d6 * 3.0 - 2.0) > 1.0) {
                    d6 = 1.0;
                }
                d6 /= 8.0;
                d6 = 0.0;
                if (d5 < 0.0) {
                    d5 = 0.0;
                }
                d5 += 0.5;
                d6 = d6 * (double)par6 / 16.0;
                ++l1;
                double d7 = (double)par6 / 2.0;
                int j3 = 0;
                while (j3 < par6) {
                    double d8 = 0.0;
                    double d9 = ((double)j3 - d7) * 8.0 / d5;
                    if (d9 < 0.0) {
                        d9 *= -1.0;
                    }
                    double d10 = this.noiseData2[k1] / 512.0;
                    double d11 = this.noiseData3[k1] / 512.0;
                    double d12 = (this.noiseData1[k1] / 10.0 + 1.0) / 2.0;
                    d8 = d12 < 0.0 ? d10 : (d12 > 1.0 ? d11 : d10 + (d11 - d10) * d12);
                    d8 -= 8.0;
                    int k3 = 32;
                    if (j3 > par6 - k3) {
                        double d13 = (float)(j3 - (par6 - k3)) / ((float)k3 - 1.0f);
                        d8 = d8 * (1.0 - d13) + -30.0 * d13;
                    }
                    if (j3 < (k3 = 8)) {
                        double d14 = (float)(k3 - j3) / ((float)k3 - 1.0f);
                        d8 = d8 * (1.0 - d14) + -30.0 * d14;
                    }
                    par1ArrayOfDouble[k1] = d8;
                    ++k1;
                    ++j3;
                }
                ++l2;
            }
            ++j2;
        }
        return par1ArrayOfDouble;
    }

    public void generateStructures(IChunkProvider par1IChunkProvider, int par2, int par3) {
        int j16;
        int l13;
        int i9;
        int k12;
        int l7;
        int k5;
        int l11;
        int i7;
        int l4;
        int j11;
        int k6;
        int j4;
        int i11;
        int j6;
        int i4;
        BlockSand.fallInstantly = true;
        int k = par2 * 16;
        int l = par3 * 16;
        this.genRandom.setSeed(this.worldObj.randomSeed);
        long l1 = this.genRandom.nextLong() / 2L * 2L + 1L;
        long l2 = this.genRandom.nextLong() / 2L * 2L + 1L;
        this.genRandom.setSeed((long)par2 * l1 + (long)par3 * l2 ^ this.worldObj.randomSeed);
        double d = 0.25;
        int i1 = 0;
        while (i1 < 8) {
            i4 = k + this.genRandom.nextInt(16) + 8;
            j6 = this.genRandom.nextInt(128);
            i11 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenDungeons().generate(this.worldObj, this.genRandom, i4, j6, i11);
            ++i1;
        }
        if ((k > 3000 || k < -3000 || l > 3000 || l < -3000) && this.genRandom.nextInt(10000) == 2) {
            int i42 = k + this.genRandom.nextInt(16) + 8;
            int j62 = this.genRandom.nextInt(128);
            int i112 = l + this.genRandom.nextInt(16) + 8;
            new aaa2().generate(this.worldObj, this.genRandom, i42, j62, i112);
        }
        i1 = 0;
        while (i1 < 8) {
            i4 = k + this.genRandom.nextInt(16) + 8;
            j6 = this.genRandom.nextInt(65536);
            i11 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenFloatingDungeons().generate(this.worldObj, this.genRandom, i4, j6, i11);
            ++i1;
        }
        int j1 = 0;
        while (j1 < 10) {
            j4 = k + this.genRandom.nextInt(16);
            k6 = this.genRandom.nextInt(64);
            j11 = l + this.genRandom.nextInt(16);
            new WorldGenClay(8).generate(this.worldObj, this.genRandom, j4, k6, j11);
            ++j1;
        }
        j1 = 0;
        while (j1 < 10) {
            j4 = k + this.genRandom.nextInt(16);
            k6 = this.genRandom.nextInt(64);
            j11 = l + this.genRandom.nextInt(16);
            new WorldGenClayRed(4).generate(this.worldObj, this.genRandom, j4, k6, j11);
            ++j1;
        }
        int k1 = 0;
        while (k1 < 20) {
            int k4 = k + this.genRandom.nextInt(16);
            int l6 = this.genRandom.nextInt(128);
            int k11 = l + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.dirt.blockID, 32).generate(this.worldObj, this.genRandom, k4, l6, k11);
            ++k1;
        }
        int i2 = 0;
        while (i2 < 10) {
            l4 = k + this.genRandom.nextInt(16);
            i7 = this.genRandom.nextInt(128);
            l11 = l + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.sand.blockID, 32).generate(this.worldObj, this.genRandom, l4, i7, l11);
            ++i2;
        }
        i2 = 0;
        while (i2 < 10) {
            l4 = k + this.genRandom.nextInt(16);
            i7 = this.genRandom.nextInt(128);
            l11 = l + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.gravel.blockID, 32).generate(this.worldObj, this.genRandom, l4, i7, l11);
            ++i2;
        }
        int j2 = 0;
        while (j2 < 20) {
            int i5 = k + this.genRandom.nextInt(16);
            int j7 = this.genRandom.nextInt(128);
            int i12 = l + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.oreCoal.blockID, 16).generate(this.worldObj, this.genRandom, i5, j7, i12);
            ++j2;
        }
        int k2 = 0;
        while (k2 < 20) {
            int j5 = k + this.genRandom.nextInt(16);
            int k7 = this.genRandom.nextInt(64);
            int j12 = l + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.oreIron.blockID, 8).generate(this.worldObj, this.genRandom, j5, k7, j12);
            ++k2;
        }
        int i3 = 0;
        while (i3 < 2) {
            k5 = k + this.genRandom.nextInt(16);
            l7 = this.genRandom.nextInt(32);
            k12 = l + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.oreGold.blockID, 8).generate(this.worldObj, this.genRandom, k5, l7, k12);
            ++i3;
        }
        i3 = 0;
        while (i3 < 6) {
            k5 = k + this.genRandom.nextInt(16);
            l7 = this.genRandom.nextInt(32);
            k12 = l + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.oreCopper.blockID, 8).generate(this.worldObj, this.genRandom, k5, l7, k12);
            ++i3;
        }
        int j3 = 0;
        while (j3 < 8) {
            int l5 = k + this.genRandom.nextInt(16);
            int i8 = this.genRandom.nextInt(32);
            int l12 = l + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.oreRed.blockID, 7).generate(this.worldObj, this.genRandom, l5, i8, l12);
            ++j3;
        }
        int k3 = 0;
        while (k3 < 1) {
            int i6 = k + this.genRandom.nextInt(16);
            int j8 = this.genRandom.nextInt(32);
            int i13 = l + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.oreDiamond.blockID, 7).generate(this.worldObj, this.genRandom, i6, j8, i13);
            ++k3;
        }
        d = 0.5;
        int l3 = (int)((this.noiseGen3.getVal((double)k * d, (double)l * d) / 8.0 + this.genRandom.nextDouble() * 4.0 + 4.0) / 3.0);
        if (l3 < 0) {
            l3 = 0;
        }
        if (this.genRandom.nextInt(10) == 0) {
            ++l3;
        }
        WorldGenerator obj = new WorldGenTrees();
        if (this.genRandom.nextInt(10) == 0) {
            obj = new WorldGenBigTree();
        }
        int k8 = 0;
        while (k8 < l3) {
            int j13 = k + this.genRandom.nextInt(16) + 8;
            int l15 = l + this.genRandom.nextInt(16) + 8;
            ((WorldGenerator)obj).func_517_a(1.0, 1.0, 1.0);
            ((WorldGenerator)obj).generate(this.worldObj, this.genRandom, j13, this.worldObj.getHeightValue(j13, l15), l15);
            ++k8;
        }
        int l8 = 0;
        while (l8 < 2) {
            int k13 = k + this.genRandom.nextInt(16) + 8;
            int i16 = this.genRandom.nextInt(128);
            int j18 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenFlowers(Block.plantYellow.blockID).generate(this.worldObj, this.genRandom, k13, i16, j18);
            ++l8;
        }
        if (this.genRandom.nextInt(2) == 0) {
            i9 = k + this.genRandom.nextInt(16) + 8;
            l13 = this.genRandom.nextInt(128);
            j16 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenFlowers(Block.plantRed.blockID).generate(this.worldObj, this.genRandom, i9, l13, j16);
        }
        if (this.genRandom.nextInt(1) == 0) {
            i9 = k + this.genRandom.nextInt(16) + 8;
            l13 = this.genRandom.nextInt(128);
            j16 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenFlowers(Block.plantBlue.blockID).generate(this.worldObj, this.genRandom, i9, l13, j16);
        }
        if (this.genRandom.nextInt(4) == 0) {
            int j9 = k + this.genRandom.nextInt(16) + 8;
            int i14 = this.genRandom.nextInt(128);
            int k16 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomBrown.blockID).generate(this.worldObj, this.genRandom, j9, i14, k16);
        }
        if (this.genRandom.nextInt(8) == 0) {
            int k9 = k + this.genRandom.nextInt(16) + 8;
            int j14 = this.genRandom.nextInt(128);
            int l16 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomRed.blockID).generate(this.worldObj, this.genRandom, k9, j14, l16);
        }
        int l9 = 0;
        while (l9 < 10) {
            int k14 = k + this.genRandom.nextInt(16) + 8;
            int i17 = this.genRandom.nextInt(128);
            int k18 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenReed().generate(this.worldObj, this.genRandom, k14, i17, k18);
            ++l9;
        }
        int i10 = 0;
        while (i10 < 1) {
            int l14 = k + this.genRandom.nextInt(16) + 8;
            int j17 = this.genRandom.nextInt(128);
            int l18 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenCactus().generate(this.worldObj, this.genRandom, l14, j17, l18);
            ++i10;
        }
        int j10 = 0;
        while (j10 < 50) {
            int i15 = k + this.genRandom.nextInt(16) + 8;
            int k17 = this.genRandom.nextInt(this.genRandom.nextInt(120) + 8);
            int i19 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenLiquids(Block.waterMoving.blockID).generate(this.worldObj, this.genRandom, i15, k17, i19);
            ++j10;
        }
        int k10 = 0;
        while (k10 < 20) {
            int j15 = k + this.genRandom.nextInt(16) + 8;
            int l17 = this.genRandom.nextInt(this.genRandom.nextInt(this.genRandom.nextInt(112) + 8) + 8);
            int j19 = l + this.genRandom.nextInt(16) + 8;
            new WorldGenLiquids(Block.lavaMoving.blockID).generate(this.worldObj, this.genRandom, j15, l17, j19);
            ++k10;
        }
        int l10 = k + 8 + 0;
        while (l10 < k + 8 + 16) {
            int k15 = l + 8 + 0;
            while (k15 < l + 8 + 16) {
                int i18 = this.worldObj.getTopSolidOrLiquidBlock(l10, k15);
                if ((this.worldObj.snowCovered || this.worldObj.getCurrentSeason() == EnumSeason.winter && this.worldObj.experiencedFirstSnow) && i18 > 0 && i18 < 128 && this.worldObj.getBlockId(l10, i18, k15) == 0 && this.worldObj.getMaterialXYZ(l10, i18 - 1, k15).blocksMovement() && this.worldObj.getMaterialXYZ(l10, i18 - 1, k15) != Material.ice) {
                    this.worldObj.setBlockWithNotify(l10, i18, k15, Block.snow.blockID);
                }
                ++k15;
            }
            ++l10;
        }
        BlockSand.fallInstantly = false;
    }
}

