/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.level.chunk;

import com.mojang.minecraft.core.enums.EnumSkyBlock;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.tile.Block;

public class LightZone {
    public final EnumSkyBlock skyOrBlockLight;
    public int xMin;
    public int yMin;
    public int zMin;
    public int xMax;
    public int yMax;
    public int zMax;

    public LightZone(EnumSkyBlock enumskyblock, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.skyOrBlockLight = enumskyblock;
        this.xMin = minX;
        this.yMin = minY;
        this.zMin = minZ;
        this.xMax = maxX;
        this.yMax = maxY;
        this.zMax = maxZ;
    }

    public void calculateLightValues(World world) {
        int xSize = this.xMax - this.xMin;
        int ySize = this.yMax - this.yMin;
        int zSize = this.zMax - this.zMin;
        int totalSize = xSize * ySize * zSize;
        if (totalSize > 32768) {
            return;
        }
        int x = this.xMin;
        while (x <= this.xMax) {
            int z = this.zMin;
            while (z <= this.zMax) {
                if (world.blockExists(x, 0, z)) {
                    int y = this.yMin;
                    while (y <= this.yMax) {
                        if (y >= 0 && y < 128) {
                            int lightVal = world.getBlockLighting(this.skyOrBlockLight, x, y, z);
                            int lowestSurroundingVal = 0;
                            int blockid = world.getBlockId(x, y, z);
                            int blockOpacity = Block.lightOpacity[blockid];
                            if (blockOpacity == 0) {
                                blockOpacity = 1;
                            }
                            int blockLightVal = 0;
                            if (this.skyOrBlockLight == EnumSkyBlock.Sky) {
                                if (world.canBlockSeeTheSky(x, y, z)) {
                                    blockLightVal = 15;
                                }
                            } else if (this.skyOrBlockLight == EnumSkyBlock.Block) {
                                blockLightVal = Block.lightValue[blockid];
                            }
                            if (blockOpacity >= 15 && blockLightVal == 0) {
                                lowestSurroundingVal = 0;
                            } else {
                                int blockWest = world.getBlockLighting(this.skyOrBlockLight, x - 1, y, z);
                                int blockEast = world.getBlockLighting(this.skyOrBlockLight, x + 1, y, z);
                                int blockAbove = world.getBlockLighting(this.skyOrBlockLight, x, y - 1, z);
                                int blockBelow = world.getBlockLighting(this.skyOrBlockLight, x, y + 1, z);
                                int blockNorth = world.getBlockLighting(this.skyOrBlockLight, x, y, z - 1);
                                int blockSouth = world.getBlockLighting(this.skyOrBlockLight, x, y, z + 1);
                                lowestSurroundingVal = blockWest;
                                if (blockEast > lowestSurroundingVal) {
                                    lowestSurroundingVal = blockEast;
                                }
                                if (blockAbove > lowestSurroundingVal) {
                                    lowestSurroundingVal = blockAbove;
                                }
                                if (blockBelow > lowestSurroundingVal) {
                                    lowestSurroundingVal = blockBelow;
                                }
                                if (blockNorth > lowestSurroundingVal) {
                                    lowestSurroundingVal = blockNorth;
                                }
                                if (blockSouth > lowestSurroundingVal) {
                                    lowestSurroundingVal = blockSouth;
                                }
                                if ((lowestSurroundingVal -= blockOpacity) < 0) {
                                    lowestSurroundingVal = 0;
                                }
                                if (blockLightVal > lowestSurroundingVal) {
                                    lowestSurroundingVal = blockLightVal;
                                }
                            }
                            if (lightVal != lowestSurroundingVal) {
                                world.setBlockLightValue(this.skyOrBlockLight, x, y, z, lowestSurroundingVal);
                                int diffusedVal = lowestSurroundingVal - 1;
                                if (diffusedVal < 0) {
                                    diffusedVal = 0;
                                }
                                world.getLightValueAtBlock(this.skyOrBlockLight, x - 1, y, z, diffusedVal);
                                world.getLightValueAtBlock(this.skyOrBlockLight, x, y - 1, z, diffusedVal);
                                world.getLightValueAtBlock(this.skyOrBlockLight, x, y, z - 1, diffusedVal);
                                if (x + 1 >= this.xMax) {
                                    world.getLightValueAtBlock(this.skyOrBlockLight, x + 1, y, z, diffusedVal);
                                }
                                if (y + 1 >= this.yMax) {
                                    world.getLightValueAtBlock(this.skyOrBlockLight, x, y + 1, z, diffusedVal);
                                }
                                if (z + 1 >= this.zMax) {
                                    world.getLightValueAtBlock(this.skyOrBlockLight, x, y, z + 1, diffusedVal);
                                }
                            }
                        }
                        ++y;
                    }
                }
                ++z;
            }
            ++x;
        }
    }

    public boolean checkIfInBounds(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        if (minX >= this.xMin && minY >= this.yMin && minZ >= this.zMin && maxX <= this.xMax && maxY <= this.yMax && maxZ <= this.zMax) {
            return true;
        }
        int radius = 1;
        if (minX >= this.xMin - radius && minY >= this.yMin - radius && minZ >= this.zMin - radius && maxX <= this.xMax + radius && maxY <= this.yMax + radius && maxZ <= this.zMax + radius) {
            int size;
            int sizeZ_2;
            int sizeY_2;
            int sizeX_2;
            int size_2;
            int sizeX = this.xMax - this.xMin;
            int sizeY = this.yMax - this.yMin;
            int sizeZ = this.zMax - this.zMin;
            if (minX > this.xMin) {
                minX = this.xMin;
            }
            if (minY > this.yMin) {
                minY = this.yMin;
            }
            if (minZ > this.zMin) {
                minZ = this.zMin;
            }
            if (maxX < this.xMax) {
                maxX = this.xMax;
            }
            if (maxY < this.yMax) {
                maxY = this.yMax;
            }
            if (maxZ < this.zMax) {
                maxZ = this.zMax;
            }
            if ((size_2 = (sizeX_2 = maxX - minX) * (sizeY_2 = maxY - minY) * (sizeZ_2 = maxZ - minZ)) - (size = sizeX * sizeY * sizeZ) <= 2) {
                this.xMin = minX;
                this.yMin = minY;
                this.zMin = minZ;
                this.xMax = maxX;
                this.yMax = maxY;
                this.zMax = maxZ;
                return true;
            }
        }
        return false;
    }
}

