/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.level.generate;

import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.generate.WorldGenerator;
import com.mojang.minecraft.core.level.tile.Block;
import com.mojang.minecraft.core.level.tile.material.Material;
import com.mojang.minecraft.core.util.MathHelper;
import java.util.ArrayList;
import java.util.Random;

public class WorldGenClayRed
extends WorldGenerator {
    private ArrayList<Integer> blockIds;
    private int clayBlockId;
    private int numberOfBlocks;

    public WorldGenClayRed(int i) {
        this.clayBlockId = Block.blockClayRed.blockID;
        this.numberOfBlocks = i;
        this.blockIds = new ArrayList();
        this.blockIds.add(Block.dirt.blockID);
    }

    public WorldGenClayRed(int i, int[] b) {
        this.clayBlockId = Block.blockClayRed.blockID;
        this.numberOfBlocks = i;
        this.blockIds = new ArrayList();
        int x = 0;
        while (x < b.length) {
            this.blockIds.add(b[x]);
            ++x;
        }
    }

    public boolean generate(World world, Random random, int i, int j, int k) {
        if (world.getMaterialXYZ(i, j, k) != Material.ground) {
            return false;
        }
        float f = random.nextFloat() * 3.141593f;
        double d = (float)(i + 8) + MathHelper.sin(f) * (float)this.numberOfBlocks / 8.0f;
        double d1 = (float)(i + 8) - MathHelper.sin(f) * (float)this.numberOfBlocks / 8.0f;
        double d2 = (float)(k + 8) + MathHelper.cos(f) * (float)this.numberOfBlocks / 8.0f;
        double d3 = (float)(k + 8) - MathHelper.cos(f) * (float)this.numberOfBlocks / 8.0f;
        double d4 = j + random.nextInt(3) + 2;
        double d5 = j + random.nextInt(3) + 2;
        int l = 0;
        while (l <= this.numberOfBlocks) {
            double d6 = d + (d1 - d) * (double)l / (double)this.numberOfBlocks;
            double d7 = d4 + (d5 - d4) * (double)l / (double)this.numberOfBlocks;
            double d8 = d2 + (d3 - d2) * (double)l / (double)this.numberOfBlocks;
            double d9 = random.nextDouble() * (double)this.numberOfBlocks / 16.0;
            double d10 = (double)(MathHelper.sin((float)l * 3.141593f / (float)this.numberOfBlocks) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.sin((float)l * 3.141593f / (float)this.numberOfBlocks) + 1.0f) * d9 + 1.0;
            double i1 = d6 - d10 / 2.0;
            while (i1 <= d6 + d10 / 2.0) {
                double j1 = d7 - d11 / 2.0;
                while (j1 <= d7 + d11 / 2.0) {
                    double k1 = d8 - d10 / 2.0;
                    while (k1 <= d8 + d10 / 2.0) {
                        int l1;
                        double d14;
                        double d13;
                        double d12 = (Math.floor(i1) + 0.5 - d6) / (d10 / 2.0);
                        if (!(d12 * d12 + (d13 = (Math.floor(j1) + 0.5 - d7) / (d11 / 2.0)) * d13 + (d14 = (Math.floor(k1) + 0.5 - d8) / (d10 / 2.0)) * d14 >= 100.0) && this.blockIds.contains(l1 = world.getBlockId((int)Math.floor(i1), (int)Math.floor(j1), (int)Math.floor(k1)))) {
                            world.setBlock((int)Math.floor(i1), (int)Math.floor(j1), (int)Math.floor(k1), this.clayBlockId);
                        }
                        k1 += 1.0;
                    }
                    j1 += 1.0;
                }
                i1 += 1.0;
            }
            ++l;
        }
        return true;
    }
}

