/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.level.generate.noise;

import com.mojang.minecraft.core.level.generate.noise.NoiseGenerator;
import com.mojang.minecraft.core.level.generate.noise.NoiseGeneratorPerlin;
import java.util.Random;

public class NoiseGeneratorOctaves
extends NoiseGenerator {
    private NoiseGeneratorPerlin[] generatorCollection;
    private int octaves;

    public NoiseGeneratorOctaves(Random random, int octavesIn) {
        this.octaves = octavesIn;
        this.generatorCollection = new NoiseGeneratorPerlin[octavesIn];
        int j = 0;
        while (j < octavesIn) {
            this.generatorCollection[j] = new NoiseGeneratorPerlin(random);
            ++j;
        }
    }

    public double getVal(double d, double d1) {
        double d2 = 0.0;
        double d3 = 1.0;
        int i = 0;
        while (i < this.octaves) {
            d2 += this.generatorCollection[i].getVal(d * d3, d1 * d3) / d3;
            d3 /= 2.0;
            ++i;
        }
        return d2;
    }

    public double[] generateNoiseOctaves(double[] ad, double d, double d1, double d2, int i, int j, int k, double xScale, double yScale, double zScale) {
        if (ad == null) {
            ad = new double[i * j * k];
        } else {
            int l = 0;
            while (l < ad.length) {
                ad[l] = 0.0;
                ++l;
            }
        }
        double d6 = 1.0;
        int i1 = 0;
        while (i1 < this.octaves) {
            this.generatorCollection[i1].func_805_a(ad, d, d1, d2, i, j, k, xScale * d6, yScale * d6, zScale * d6, d6);
            d6 /= 2.0;
            ++i1;
        }
        return ad;
    }

    public double[] generateNoiseOctaves_2(double[] ad, double d, double d1, double d2, int i, int j, int k, double xScale, double yScale, double zScale) {
        if (ad == null) {
            ad = new double[i * j * k];
        } else {
            int l = 0;
            while (l < ad.length) {
                ad[l] = 0.0;
                ++l;
            }
        }
        double d6 = 1.0;
        int i1 = 0;
        while (i1 < this.octaves) {
            this.generatorCollection[i1].func_805_a_(ad, d, d1, d2, i, j, k, xScale * d6, yScale * d6, zScale * d6, d6);
            d6 /= 2.0;
            ++i1;
        }
        return ad;
    }
}

