/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.level.generate.noise;

import com.mojang.minecraft.core.level.generate.noise.NoiseGenerator;
import java.util.Random;

public class NoiseGeneratorPerlin
extends NoiseGenerator {
    private int[] perlinArray = new int[512];
    public double xCoord;
    public double yCoord;
    public double zCoord;

    public NoiseGeneratorPerlin() {
        this(new Random());
    }

    public NoiseGeneratorPerlin(Random random) {
        this.xCoord = random.nextDouble() * 256.0;
        this.yCoord = random.nextDouble() * 256.0;
        this.zCoord = random.nextDouble() * 256.0;
        int i = 0;
        while (i < 256) {
            this.perlinArray[i] = i;
            ++i;
        }
        int j = 0;
        while (j < 256) {
            int k = random.nextInt(256 - j) + j;
            int l = this.perlinArray[j];
            this.perlinArray[j] = this.perlinArray[k];
            this.perlinArray[k] = l;
            this.perlinArray[j + 256] = this.perlinArray[j];
            ++j;
        }
    }

    public double generateNoise(double d, double d1, double d2) {
        double d3 = d + this.xCoord;
        double d4 = d1 + this.yCoord;
        double d5 = d2 + this.zCoord;
        int i = (int)d3;
        int j = (int)d4;
        int k = (int)d5;
        if (d3 < (double)i) {
            --i;
        }
        if (d4 < (double)j) {
            --j;
        }
        if (d5 < (double)k) {
            --k;
        }
        int l = i & 0xFF;
        int i1 = j & 0xFF;
        int j1 = k & 0xFF;
        double d6 = (d3 -= (double)i) * d3 * d3 * (d3 * (d3 * 6.0 - 15.0) + 10.0);
        double d7 = (d4 -= (double)j) * d4 * d4 * (d4 * (d4 * 6.0 - 15.0) + 10.0);
        double d8 = (d5 -= (double)k) * d5 * d5 * (d5 * (d5 * 6.0 - 15.0) + 10.0);
        int k1 = this.perlinArray[l] + i1;
        int l1 = this.perlinArray[k1] + j1;
        int i2 = this.perlinArray[k1 + 1] + j1;
        int j2 = this.perlinArray[l + 1] + i1;
        int k2 = this.perlinArray[j2] + j1;
        int l2 = this.perlinArray[j2 + 1] + j1;
        return this.lerp(d8, this.lerp(d7, this.lerp(d6, this.func_803_a(this.perlinArray[l1], d3, d4, d5), this.func_803_a(this.perlinArray[k2], d3 - 1.0, d4, d5)), this.lerp(d6, this.func_803_a(this.perlinArray[i2], d3, d4 - 1.0, d5), this.func_803_a(this.perlinArray[l2], d3 - 1.0, d4 - 1.0, d5))), this.lerp(d7, this.lerp(d6, this.func_803_a(this.perlinArray[l1 + 1], d3, d4, d5 - 1.0), this.func_803_a(this.perlinArray[k2 + 1], d3 - 1.0, d4, d5 - 1.0)), this.lerp(d6, this.func_803_a(this.perlinArray[i2 + 1], d3, d4 - 1.0, d5 - 1.0), this.func_803_a(this.perlinArray[l2 + 1], d3 - 1.0, d4 - 1.0, d5 - 1.0))));
    }

    public double lerp(double d, double d1, double d2) {
        return d1 + d * (d2 - d1);
    }

    public double func_803_a(int i, double d, double d1, double d2) {
        double d3;
        int j = i & 0xF;
        double d4 = d3 = j >= 8 ? d1 : d;
        double d42 = j >= 4 ? (j != 12 && j != 14 ? d2 : d) : d1;
        return ((j & 1) != 0 ? -d3 : d3) + ((j & 2) != 0 ? -d42 : d42);
    }

    public final double func_4110_a(int i, double d, double d1) {
        int j = i & 0xF;
        double d2 = (double)(1 - ((j & 8) >> 3)) * d;
        double d3 = j >= 4 ? (j != 12 && j != 14 ? d1 : d) : 0.0;
        return ((j & 1) != 0 ? -d2 : d2) + ((j & 2) != 0 ? -d3 : d3);
    }

    public final double grad(int i, double d, double d1, double d2) {
        double d3;
        int j = i & 0xF;
        double d4 = d3 = j >= 8 ? d1 : d;
        double d42 = j >= 4 ? (j != 12 && j != 14 ? d2 : d) : d1;
        return ((j & 1) != 0 ? -d3 : d3) + ((j & 2) != 0 ? -d42 : d42);
    }

    public double getVal(double d, double d1) {
        return this.generateNoise(d, d1, 0.0);
    }

    public void func_805_a_(double[] ad, double d, double d1, double d2, int i, int j, int k, double d3, double d4, double d5, double d6) {
        if (j == 1) {
            boolean flag = false;
            boolean flag1 = false;
            boolean flag2 = false;
            boolean flag3 = false;
            double d8 = 0.0;
            double d10 = 0.0;
            int j3 = 0;
            double d12 = 1.0 / d6;
            int i4 = 0;
            while (i4 < i) {
                double d14 = (d + (double)i4) * d3 + this.xCoord;
                int j4 = (int)d14;
                if (d14 < (double)j4) {
                    --j4;
                }
                int k4 = j4 & 0xFF;
                double d17 = (d14 -= (double)j4) * d14 * d14 * (d14 * (d14 * 6.0 - 15.0) + 10.0);
                int l4 = 0;
                while (l4 < k) {
                    double d19 = (d2 + (double)l4) * d5 + this.zCoord;
                    int j5 = (int)d19;
                    if (d19 < (double)j5) {
                        --j5;
                    }
                    int l5 = j5 & 0xFF;
                    double d21 = (d19 -= (double)j5) * d19 * d19 * (d19 * (d19 * 6.0 - 15.0) + 10.0);
                    int l = this.perlinArray[k4] + 0;
                    int j1 = this.perlinArray[l] + l5;
                    int k1 = this.perlinArray[k4 + 1] + 0;
                    int l1 = this.perlinArray[k1] + l5;
                    double d9 = this.lerp(d17, this.func_4110_a(this.perlinArray[j1], d14, d19), this.grad(this.perlinArray[l1], d14 - 1.0, 0.0, d19));
                    double d11 = this.lerp(d17, this.grad(this.perlinArray[j1 + 1], d14, 0.0, d19 - 1.0), this.grad(this.perlinArray[l1 + 1], d14 - 1.0, 0.0, d19 - 1.0));
                    double d23 = this.lerp(d21, d9, d11);
                    int n = j3++;
                    ad[n] = ad[n] + d23 * d12;
                    ++l4;
                }
                ++i4;
            }
            return;
        }
        if (k == 1) {
            boolean flag = false;
            boolean flag1 = false;
            boolean flag2 = false;
            boolean flag3 = false;
            double d8 = 0.0;
            double d10 = 0.0;
            int j3 = 0;
            double d12 = 1.0 / d6;
            int i4 = 0;
            while (i4 < i) {
                double d14 = (d + (double)i4) * d3 + this.xCoord;
                int j4 = (int)d14;
                if (d14 < (double)j4) {
                    --j4;
                }
                int k4 = j4 & 0xFF;
                double d17 = (d14 -= (double)j4) * d14 * d14 * (d14 * (d14 * 6.0 - 15.0) + 10.0);
                int l4 = 0;
                while (l4 < j) {
                    double d19 = (d1 + (double)l4) * d4 + this.zCoord;
                    int j5 = (int)d19;
                    if (d19 < (double)j5) {
                        --j5;
                    }
                    int l5 = j5 & 0xFF;
                    double d21 = (d19 -= (double)j5) * d19 * d19 * (d19 * (d19 * 6.0 - 15.0) + 10.0);
                    int l = this.perlinArray[k4] + 0;
                    int j1 = this.perlinArray[l] + l5;
                    int k1 = this.perlinArray[k4 + 1] + 0;
                    int l1 = this.perlinArray[k1] + l5;
                    double d9 = this.lerp(d17, this.func_4110_a(this.perlinArray[j1], d14, d19), this.grad(this.perlinArray[l1], d14 - 1.0, 0.0, d19));
                    double d11 = this.lerp(d17, this.grad(this.perlinArray[j1 + 1], d14, 0.0, d19 - 1.0), this.grad(this.perlinArray[l1 + 1], d14 - 1.0, 0.0, d19 - 1.0));
                    double d23 = this.lerp(d21, d9, d11);
                    int n = j3++;
                    ad[n] = ad[n] + d23 * d12;
                    ++l4;
                }
                ++i4;
            }
            return;
        }
        int i1 = 0;
        double d7 = 1.0 / d6;
        int i2 = -1;
        boolean flag4 = false;
        boolean flag5 = false;
        boolean flag6 = false;
        boolean flag7 = false;
        boolean flag8 = false;
        boolean flag9 = false;
        double d13 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        double d18 = 0.0;
        int i5 = 0;
        while (i5 < i) {
            double d20 = (d + (double)i5) * d3 + this.xCoord;
            int k5 = (int)d20;
            if (d20 < (double)k5) {
                --k5;
            }
            int i6 = k5 & 0xFF;
            double d22 = (d20 -= (double)k5) * d20 * d20 * (d20 * (d20 * 6.0 - 15.0) + 10.0);
            int j6 = 0;
            while (j6 < k) {
                double d24 = (d2 + (double)j6) * d5 + this.zCoord;
                int k6 = (int)d24;
                if (d24 < (double)k6) {
                    --k6;
                }
                int l6 = k6 & 0xFF;
                double d25 = (d24 -= (double)k6) * d24 * d24 * (d24 * (d24 * 6.0 - 15.0) + 10.0);
                int i7 = 0;
                while (i7 < j) {
                    double d26 = (d1 + (double)i7) * d4 + this.yCoord;
                    int j7 = (int)d26;
                    if (d26 < (double)j7) {
                        --j7;
                    }
                    int k7 = j7 & 0xFF;
                    double d27 = (d26 -= (double)j7) * d26 * d26 * (d26 * (d26 * 6.0 - 15.0) + 10.0);
                    if (i7 == 0 || k7 != i2) {
                        i2 = k7;
                        int j2 = this.perlinArray[i6] + k7;
                        int k2 = this.perlinArray[j2] + l6;
                        int l2 = this.perlinArray[j2 + 1] + l6;
                        int i3 = this.perlinArray[i6 + 1] + k7;
                        int k3 = this.perlinArray[i3] + l6;
                        int l3 = this.perlinArray[i3 + 1] + l6;
                        d13 = this.lerp(d22, this.grad(this.perlinArray[k2], d20, d26, d24), this.grad(this.perlinArray[k3], d20 - 1.0, d26, d24));
                        d15 = this.lerp(d22, this.grad(this.perlinArray[l2], d20, d26 - 1.0, d24), this.grad(this.perlinArray[l3], d20 - 1.0, d26 - 1.0, d24));
                        d16 = this.lerp(d22, this.grad(this.perlinArray[k2 + 1], d20, d26, d24 - 1.0), this.grad(this.perlinArray[k3 + 1], d20 - 1.0, d26, d24 - 1.0));
                        d18 = this.lerp(d22, this.grad(this.perlinArray[l2 + 1], d20, d26 - 1.0, d24 - 1.0), this.grad(this.perlinArray[l3 + 1], d20 - 1.0, d26 - 1.0, d24 - 1.0));
                    }
                    double d28 = this.lerp(d27, d13, d15);
                    double d29 = this.lerp(d27, d16, d18);
                    double d30 = this.lerp(d25, d28, d29);
                    int n = i1++;
                    ad[n] = ad[n] + d30 * d7;
                    ++i7;
                }
                ++j6;
            }
            ++i5;
        }
    }

    public void func_805_a(double[] ad, double d, double d1, double d2, int i, int j, int k, double d3, double d4, double d5, double d6) {
        int l = 0;
        double d7 = 1.0 / d6;
        int i1 = -1;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        int l2 = 0;
        while (l2 < i) {
            double d12 = (d + (double)l2) * d3 + this.xCoord;
            int i3 = (int)d12;
            if (d12 < (double)i3) {
                --i3;
            }
            int j3 = i3 & 0xFF;
            double d13 = (d12 -= (double)i3) * d12 * d12 * (d12 * (d12 * 6.0 - 15.0) + 10.0);
            int k3 = 0;
            while (k3 < k) {
                double d14 = (d2 + (double)k3) * d5 + this.zCoord;
                int l3 = (int)d14;
                if (d14 < (double)l3) {
                    --l3;
                }
                int i4 = l3 & 0xFF;
                double d15 = (d14 -= (double)l3) * d14 * d14 * (d14 * (d14 * 6.0 - 15.0) + 10.0);
                int j4 = 0;
                while (j4 < j) {
                    double d16 = (d1 + (double)j4) * d4 + this.yCoord;
                    int k4 = (int)d16;
                    if (d16 < (double)k4) {
                        --k4;
                    }
                    int l4 = k4 & 0xFF;
                    double d17 = (d16 -= (double)k4) * d16 * d16 * (d16 * (d16 * 6.0 - 15.0) + 10.0);
                    if (j4 == 0 || l4 != i1) {
                        i1 = l4;
                        int j1 = this.perlinArray[j3] + l4;
                        int k1 = this.perlinArray[j1] + i4;
                        int l1 = this.perlinArray[j1 + 1] + i4;
                        int i2 = this.perlinArray[j3 + 1] + l4;
                        int j2 = this.perlinArray[i2] + i4;
                        int k2 = this.perlinArray[i2 + 1] + i4;
                        d8 = this.lerp(d13, this.func_803_a(this.perlinArray[k1], d12, d16, d14), this.func_803_a(this.perlinArray[j2], d12 - 1.0, d16, d14));
                        d9 = this.lerp(d13, this.func_803_a(this.perlinArray[l1], d12, d16 - 1.0, d14), this.func_803_a(this.perlinArray[k2], d12 - 1.0, d16 - 1.0, d14));
                        d10 = this.lerp(d13, this.func_803_a(this.perlinArray[k1 + 1], d12, d16, d14 - 1.0), this.func_803_a(this.perlinArray[j2 + 1], d12 - 1.0, d16, d14 - 1.0));
                        d11 = this.lerp(d13, this.func_803_a(this.perlinArray[l1 + 1], d12, d16 - 1.0, d14 - 1.0), this.func_803_a(this.perlinArray[k2 + 1], d12 - 1.0, d16 - 1.0, d14 - 1.0));
                    }
                    double d18 = this.lerp(d17, d8, d9);
                    double d19 = this.lerp(d17, d10, d11);
                    double d20 = this.lerp(d15, d18, d19);
                    int n = l++;
                    ad[n] = ad[n] + d20 * d7;
                    ++j4;
                }
                ++k3;
            }
            ++l2;
        }
    }
}

