/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.level.tile;

import com.mojang.minecraft.client.render.Vec3D;
import com.mojang.minecraft.core.entity.Entity;
import com.mojang.minecraft.core.entity.EntityItem;
import com.mojang.minecraft.core.entity.EntityLiving;
import com.mojang.minecraft.core.entity.EntityPlayer;
import com.mojang.minecraft.core.entity.MovingObjectPosition;
import com.mojang.minecraft.core.entity.item.Item;
import com.mojang.minecraft.core.entity.item.ItemBlock;
import com.mojang.minecraft.core.entity.item.ItemStack;
import com.mojang.minecraft.core.entity.tile.IBlockAccess;
import com.mojang.minecraft.core.entity.tile.TileEntitySign;
import com.mojang.minecraft.core.enums.EnumMobType;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.tile.BlockBleedingObsidian;
import com.mojang.minecraft.core.level.tile.BlockBookshelf;
import com.mojang.minecraft.core.level.tile.BlockBurntCloth;
import com.mojang.minecraft.core.level.tile.BlockButton;
import com.mojang.minecraft.core.level.tile.BlockCactus;
import com.mojang.minecraft.core.level.tile.BlockChest;
import com.mojang.minecraft.core.level.tile.BlockClay;
import com.mojang.minecraft.core.level.tile.BlockCrops;
import com.mojang.minecraft.core.level.tile.BlockDirt;
import com.mojang.minecraft.core.level.tile.BlockDoor;
import com.mojang.minecraft.core.level.tile.BlockFence;
import com.mojang.minecraft.core.level.tile.BlockFire;
import com.mojang.minecraft.core.level.tile.BlockFlower;
import com.mojang.minecraft.core.level.tile.BlockFlowing;
import com.mojang.minecraft.core.level.tile.BlockFurnace;
import com.mojang.minecraft.core.level.tile.BlockGear;
import com.mojang.minecraft.core.level.tile.BlockGlass;
import com.mojang.minecraft.core.level.tile.BlockGrass;
import com.mojang.minecraft.core.level.tile.BlockGravel;
import com.mojang.minecraft.core.level.tile.BlockIce;
import com.mojang.minecraft.core.level.tile.BlockJukeBox;
import com.mojang.minecraft.core.level.tile.BlockLadder;
import com.mojang.minecraft.core.level.tile.BlockLeaves;
import com.mojang.minecraft.core.level.tile.BlockLever;
import com.mojang.minecraft.core.level.tile.BlockLightBulb;
import com.mojang.minecraft.core.level.tile.BlockLog;
import com.mojang.minecraft.core.level.tile.BlockMinecartTrack;
import com.mojang.minecraft.core.level.tile.BlockMobSpawner;
import com.mojang.minecraft.core.level.tile.BlockMotor;
import com.mojang.minecraft.core.level.tile.BlockMushroom;
import com.mojang.minecraft.core.level.tile.BlockObsidian;
import com.mojang.minecraft.core.level.tile.BlockOre;
import com.mojang.minecraft.core.level.tile.BlockOreBlock;
import com.mojang.minecraft.core.level.tile.BlockPressurePlate;
import com.mojang.minecraft.core.level.tile.BlockPyramidion;
import com.mojang.minecraft.core.level.tile.BlockRedDustWire;
import com.mojang.minecraft.core.level.tile.BlockRedOre;
import com.mojang.minecraft.core.level.tile.BlockRedTorch;
import com.mojang.minecraft.core.level.tile.BlockReed;
import com.mojang.minecraft.core.level.tile.BlockSand;
import com.mojang.minecraft.core.level.tile.BlockSapling;
import com.mojang.minecraft.core.level.tile.BlockSign;
import com.mojang.minecraft.core.level.tile.BlockSnow;
import com.mojang.minecraft.core.level.tile.BlockSnowBlock;
import com.mojang.minecraft.core.level.tile.BlockSoil;
import com.mojang.minecraft.core.level.tile.BlockSponge;
import com.mojang.minecraft.core.level.tile.BlockSpongeInactive;
import com.mojang.minecraft.core.level.tile.BlockStairs;
import com.mojang.minecraft.core.level.tile.BlockStationary;
import com.mojang.minecraft.core.level.tile.BlockStep;
import com.mojang.minecraft.core.level.tile.BlockStone;
import com.mojang.minecraft.core.level.tile.BlockTNT;
import com.mojang.minecraft.core.level.tile.BlockTorch;
import com.mojang.minecraft.core.level.tile.BlockWeb;
import com.mojang.minecraft.core.level.tile.BlockWorkbench;
import com.mojang.minecraft.core.level.tile.StepSound;
import com.mojang.minecraft.core.level.tile.StepSoundSand;
import com.mojang.minecraft.core.level.tile.StepSoundStone;
import com.mojang.minecraft.core.level.tile.material.Material;
import com.mojang.minecraft.core.level.tile.phys.AxisAlignedBB;
import java.util.ArrayList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Block {
    public static final StepSound soundPowderFootstep;
    public static final StepSound soundWoodFootstep;
    public static final StepSound soundGravelFootstep;
    public static final StepSound soundGrassFootstep;
    public static final StepSound soundStoneFootstep;
    public static final StepSound soundMetalFootstep;
    public static final StepSound soundGlassFootstep;
    public static final StepSound soundClothFootstep;
    public static final StepSound soundSandFootstep;
    public static final StepSound soundNoFootstep;
    public static final Block[] allBlocks;
    public static final boolean[] tickOnLoad;
    public static final boolean[] opaqueCubeLookup;
    public static final boolean[] isBlockContainer;
    public static final int[] lightOpacity;
    public static final boolean[] field_340_s;
    public static final int[] lightValue;
    public static final Block stone;
    public static final BlockGrass grass;
    public static final Block dirt;
    public static final Block cobblestone;
    public static final Block planks;
    public static final Block sapling;
    public static final Block bedrock;
    public static final Block waterMoving;
    public static final Block waterStill;
    public static final Block lavaMoving;
    public static final Block lavaStill;
    public static final Block sand;
    public static final Block gravel;
    public static final Block oreGold;
    public static final Block oreIron;
    public static final Block oreCoal;
    public static final Block wood;
    public static final BlockLeaves leaves;
    public static final Block sponge;
    public static final Block glass;
    public static final Block cloth_red;
    public static final Block cloth_orange;
    public static final Block cloth_yellow;
    public static final Block cloth_lime;
    public static final Block cloth_green;
    public static final Block cloth_teal;
    public static final Block cloth_cyan;
    public static final Block cloth_blue;
    public static final Block cloth_indigo;
    public static final Block cloth_violet;
    public static final Block cloth_lilac;
    public static final Block cloth_pink;
    public static final Block cloth_magenta;
    public static final Block cloth_darkgray;
    public static final Block cloth;
    public static final Block cloth_lightgray;
    public static final BlockFlower plantYellow;
    public static final BlockFlower plantRed;
    public static final BlockFlower mushroomBrown;
    public static final BlockFlower mushroomRed;
    public static final Block blockGold;
    public static final Block blockSteel;
    public static final Block stepDouble;
    public static final Block stepSingle;
    public static final Block brick;
    public static final Block tnt;
    public static final Block bookShelf;
    public static final Block cobblestoneMossy;
    public static final Block obsidian;
    public static final Block torchWood;
    public static final BlockFire fire;
    public static final Block mobSpawner;
    public static final Block stairCompact_Wood;
    public static final Block crate;
    public static final Block redWire;
    public static final Block oreDiamond;
    public static final Block blockDiamond;
    public static final Block workbench;
    public static final Block crops;
    public static final Block tilledField;
    public static final Block stoneOvenIdle;
    public static final Block stoneOvenActive;
    public static final Block signPost;
    public static final Block doorWood;
    public static final Block ladder;
    public static final Block minecartTrack;
    public static final Block stairCompactStone;
    public static final Block pressurePlateWoodIdle;
    public static final Block lever;
    public static final Block pressurePlateStone;
    public static final Block doorSteel;
    public static final Block pressurePlateWood;
    public static final Block oreRed;
    public static final Block oreRedGlowing;
    public static final Block torchRedIdle;
    public static final Block torchRedActive;
    public static final Block button;
    public static final Block snow;
    public static final Block ice;
    public static final Block blockSnow;
    public static final Block cactus;
    public static final Block blockClay;
    public static final Block reed;
    public static final Block jukebox;
    public static final Block fence;
    public static final Block gear;
    public static final Block spongeInactive;
    public static final BlockFlower plantBlue;
    public static final Block oreCopper;
    public static final Block motor;
    public static final Block generator;
    public static final Block blockCopper;
    public static final Block brickMossy;
    public static final Block bleedingObsidian;
    public static final Block web;
    public static final Block pressurePlateSteel;
    public static final Block lightBulb;
    public static final Block lightBulbOn;
    public static final Block pyramidion;
    public static final Block stoneSand;
    public static final Block brickBlue;
    public static final Block brickFlint;
    public static final Block blockClayRed;
    public static final Block cloth_tekheles;
    public static final Block cloth_burnt;
    public static final Block cloth_burnt_hot;
    public int blockIndexInTexture;
    public final int blockID;
    protected float blockHardness;
    protected float blockResistance;
    public double minX;
    public double minY;
    public double minZ;
    public double maxX;
    public double maxY;
    public double maxZ;
    public StepSound stepSound = soundPowderFootstep;
    public float density = 1.0f;
    public final Material blockMaterial;
    public float slipperiness = 0.6f;
    public int blockGearPower = 0;
    public int primaryColor = 0xFFFFFF;
    public int secondaryColor = 0xFFFFFF;

    static {
        tickOnLoad = new boolean[256];
        opaqueCubeLookup = new boolean[256];
        isBlockContainer = new boolean[256];
        lightOpacity = new int[256];
        field_340_s = new boolean[256];
        lightValue = new int[256];
        soundPowderFootstep = new StepSound("stone", 1.0f, 1.0f);
        soundWoodFootstep = new StepSound("wood", 1.0f, 1.0f);
        soundGravelFootstep = new StepSound("gravel", 1.0f, 1.0f);
        soundGrassFootstep = new StepSound("grass", 1.0f, 1.0f);
        soundStoneFootstep = new StepSound("stone", 1.0f, 1.0f);
        soundMetalFootstep = new StepSound("stone", 1.0f, 1.5f);
        soundGlassFootstep = new StepSoundStone("stone", 1.0f, 1.0f);
        soundClothFootstep = new StepSound("cloth", 1.0f, 1.0f);
        soundSandFootstep = new StepSoundSand("sand", 1.0f, 1.0f);
        soundNoFootstep = new StepSound("stone", 0.0f, 0.0f);
        allBlocks = new Block[256];
        stone = new BlockStone(1, 1).setHardness(1.5f).setResistance(10.0f).setStepSound(soundStoneFootstep).setColor(0x747474);
        grass = (BlockGrass)new BlockGrass(2).setHardness(0.6f).setStepSound(soundGrassFootstep).setColor(7845709);
        dirt = new BlockDirt(3, 2).setHardness(0.5f).setStepSound(soundGravelFootstep).setColor(7951674);
        cobblestone = new BlockStone(4, 16).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setColor(0x606060);
        planks = new Block(5, 4, Material.wood).setHardness(2.0f).setResistance(5.0f).setStepSound(soundWoodFootstep).setColor(12359778);
        sapling = new BlockSapling(6, 15).setHardness(0.0f).setStepSound(soundGrassFootstep).setColor(25600);
        bedrock = new Block(7, 17, Material.rock).setHardness(-1.0f).setResistance(6000000.0f).setStepSound(soundStoneFootstep).setColor(0x333333);
        waterMoving = new BlockFlowing(8, Material.water).setHardness(100.0f).setLightOpacity(3).setStepSound(soundNoFootstep).setColor(1987581);
        waterStill = new BlockStationary(9, Material.water).setHardness(100.0f).setLightOpacity(3).setStepSound(soundNoFootstep).setColor(1987581);
        lavaMoving = new BlockFlowing(10, Material.lava).setHardness(0.0f).setLightValue(1.0f).setLightOpacity(255).setStepSound(soundNoFootstep).setColor(16537344);
        lavaStill = new BlockStationary(11, Material.lava).setHardness(100.0f).setLightValue(1.0f).setLightOpacity(255).setStepSound(soundNoFootstep).setColor(16537344);
        sand = new BlockSand(12, 18).setHardness(0.5f).setStepSound(soundSandFootstep).setColor(15129006);
        gravel = new BlockGravel(13, 19).setHardness(0.6f).setStepSound(soundGravelFootstep).setColor(10786456);
        oreGold = new BlockOre(14, 32).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setColor(0x747474, 0xFFF144);
        oreIron = new BlockOre(15, 33).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setColor(0x747474, 0xE9E9E9);
        oreCoal = new BlockOre(16, 34).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setColor(0x747474, 6938586);
        wood = new BlockLog(17).setHardness(2.0f).setStepSound(soundWoodFootstep).setColor(6705456);
        leaves = (BlockLeaves)new BlockLeaves(18, 52).setHardness(0.2f).setLightOpacity(1).setStepSound(soundGrassFootstep).setColor(4180006);
        sponge = new BlockSponge(19).setHardness(0.6f).setStepSound(soundGrassFootstep).setColor(13553222);
        glass = new BlockGlass(20, 49, Material.glass, false).setHardness(0.3f).setStepSound(soundGlassFootstep).setColor(0, 12645886);
        cloth_red = new Block(21, 144, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setColor(0xFF3A3A);
        cloth_orange = new Block(22, 145, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setColor(15043636);
        cloth_yellow = new Block(23, 146, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setColor(15855926);
        cloth_lime = new Block(24, 147, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setColor(9695542);
        cloth_green = new Block(25, 148, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setColor(3466548);
        cloth_teal = new Block(26, 149, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setColor(3600787);
        cloth_cyan = new Block(27, 150, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setColor(3533546);
        cloth_blue = new Block(28, 151, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setColor(6923744);
        cloth_indigo = new Block(29, 152, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setColor(7961056);
        cloth_violet = new Block(30, 153, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setColor(8335313);
        cloth_lilac = new Block(31, 154, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setColor(11816165);
        cloth_pink = new Block(32, 155, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setColor(15021285);
        cloth_magenta = new Block(33, 156, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setColor(15611538);
        cloth_darkgray = new Block(34, 157, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setColor(0x535353);
        cloth = new Block(35, 64, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setColor(0xE0E0E0);
        cloth_lightgray = new Block(36, 158, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep).setColor(0x9D9D9D);
        plantYellow = (BlockFlower)new BlockFlower(37, 13).setHardness(0.0f).setStepSound(soundGrassFootstep).setColor(13423362);
        plantRed = (BlockFlower)new BlockFlower(38, 12).setHardness(0.0f).setStepSound(soundGrassFootstep).setColor(13698569);
        mushroomBrown = (BlockFlower)new BlockMushroom(39, 29).setHardness(0.0f).setStepSound(soundGrassFootstep).setLightValue(0.125f).setColor(9530709);
        mushroomRed = (BlockFlower)new BlockMushroom(40, 28).setHardness(0.0f).setStepSound(soundGrassFootstep).setColor(0xE21212);
        blockGold = new BlockOreBlock(41, 39).setHardness(3.0f).setResistance(10.0f).setStepSound(soundMetalFootstep).setColor(0xFFF144);
        blockSteel = new BlockOreBlock(42, 38).setHardness(5.0f).setResistance(10.0f).setStepSound(soundMetalFootstep).setColor(0xE9E9E9);
        stepDouble = new BlockStep(43, true).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setColor(0xA3A3A3);
        stepSingle = new BlockStep(44, false).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setColor(0xA3A3A3);
        brick = new Block(45, 7, Material.rock).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setColor(8010795, 0xB4B4B4);
        tnt = new BlockTNT(46, 8).setHardness(0.0f).setStepSound(soundGrassFootstep).setColor(14369818, 0);
        bookShelf = new BlockBookshelf(47, 35).setHardness(1.5f).setStepSound(soundWoodFootstep).setColor(7704081, 12359778);
        cobblestoneMossy = new Block(48, 36, Material.rock).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setColor(0x606060, 0x1C411C);
        obsidian = new BlockObsidian(49, 37).setHardness(10.0f).setResistance(2000.0f).setStepSound(soundStoneFootstep).setColor(1511716);
        torchWood = new BlockTorch(50, 80).setHardness(0.0f).setLightValue(0.9375f).setStepSound(soundWoodFootstep).setColor(167739216);
        fire = (BlockFire)new BlockFire(51, 31).setHardness(0.0f).setLightValue(1.0f).setStepSound(soundWoodFootstep).setColor(0xFF8F00);
        mobSpawner = new BlockMobSpawner(52, 65).setHardness(5.0f).setStepSound(soundMetalFootstep).setColor(0, 1791100);
        stairCompact_Wood = new BlockStairs(53, planks).setColor(12359778);
        crate = new BlockChest(54).setHardness(2.5f).setStepSound(soundWoodFootstep).setColor(10972703);
        redWire = new BlockRedDustWire(55, 84).setHardness(0.0f).setStepSound(soundPowderFootstep).setColor(0x480000, 0xFD0000);
        oreDiamond = new BlockOre(56, 50).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setColor(0x747474, 6938586);
        blockDiamond = new BlockOreBlock(57, 40).setHardness(5.0f).setResistance(10.0f).setStepSound(soundMetalFootstep).setColor(6938586);
        workbench = new BlockWorkbench(58).setHardness(2.5f).setStepSound(soundWoodFootstep).setColor(11234882);
        crops = new BlockCrops(59, 88).setHardness(0.0f).setStepSound(soundGrassFootstep).setColor(0x199311);
        tilledField = new BlockSoil(60).setHardness(0.6f).setStepSound(soundGravelFootstep).setColor(4532501);
        stoneOvenIdle = new BlockFurnace(61, false).setHardness(3.5f).setStepSound(soundStoneFootstep).setColor(0x6F6F6F);
        stoneOvenActive = new BlockFurnace(62, true).setHardness(3.5f).setStepSound(soundStoneFootstep).setLightValue(0.875f).setColor(0x6F6F6F);
        signPost = new BlockSign(63, TileEntitySign.class, true).setHardness(1.0f).setStepSound(soundWoodFootstep).setColor(12359778);
        doorWood = new BlockDoor(64, Material.wood).setHardness(3.0f).setStepSound(soundWoodFootstep).setColor(9005106);
        ladder = new BlockLadder(65, 83).setHardness(0.4f).setStepSound(soundWoodFootstep).setColor(0, 11307090);
        minecartTrack = new BlockMinecartTrack(66, 128).setHardness(0.7f).setStepSound(soundMetalFootstep).setColor(0, 0xA4A4A4);
        stairCompactStone = new BlockStairs(67, cobblestone).setColor(0x606060);
        pressurePlateWoodIdle = new BlockSign(68, TileEntitySign.class, false).setHardness(1.0f).setStepSound(soundWoodFootstep).setColor(12359778);
        lever = new BlockLever(69, 96).setHardness(0.5f).setStepSound(soundWoodFootstep).setColor(0x727272);
        pressurePlateStone = new BlockPressurePlate(70, Block.stone.blockIndexInTexture, EnumMobType.mobs).setHardness(0.5f).setStepSound(soundStoneFootstep).setColor(0x747474);
        doorSteel = new BlockDoor(71, Material.iron).setHardness(5.0f).setStepSound(soundMetalFootstep).setColor(0xE9E9E9);
        pressurePlateWood = new BlockPressurePlate(72, Block.planks.blockIndexInTexture, EnumMobType.everything).setHardness(0.5f).setStepSound(soundWoodFootstep).setColor(12359778);
        oreRed = new BlockRedOre(73, 51, false).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setColor(0x747474, 9372419);
        oreRedGlowing = new BlockRedOre(74, 51, true).setLightValue(0.625f).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setColor(0x747474, 0xFF0000);
        torchRedIdle = new BlockRedTorch(75, 115, false).setHardness(0.0f).setStepSound(soundWoodFootstep).setColor(0x480000);
        torchRedActive = new BlockRedTorch(76, 99, true).setHardness(0.0f).setLightValue(0.5f).setStepSound(soundWoodFootstep).setColor(0xFD0000);
        button = new BlockButton(77, Block.stone.blockIndexInTexture).setHardness(0.5f).setStepSound(soundStoneFootstep).setColor(0x747474);
        snow = new BlockSnow(78, 66).setHardness(0.1f).setStepSound(soundClothFootstep).setColor(0xE3F3F3);
        ice = new BlockIce(79, 67).setHardness(0.5f).setLightOpacity(3).setStepSound(soundGlassFootstep).setColor(7710717);
        blockSnow = new BlockSnowBlock(80, 66).setHardness(0.2f).setStepSound(soundClothFootstep).setColor(0xE3F3F3);
        cactus = new BlockCactus(81, 70).setHardness(0.4f).setStepSound(soundClothFootstep).setColor(1147679);
        blockClay = new BlockClay(82, 72).setHardness(0.6f).setStepSound(soundGravelFootstep).setColor(10527925);
        reed = new BlockReed(83, 73).setHardness(0.0f).setStepSound(soundGrassFootstep).setColor(11197300);
        jukebox = new BlockJukeBox(84, 74).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setColor(9525312, 4663837);
        fence = new BlockFence(85, 4).setHardness(2.0f).setResistance(5.0f).setStepSound(soundWoodFootstep).setColor(12359778);
        gear = new BlockGear(86, 62).setHardness(0.5f).setResistance(5.0f).setStepSound(soundPowderFootstep);
        spongeInactive = new BlockSpongeInactive(87).setHardness(0.6f).setStepSound(soundGrassFootstep).setColor(13553222);
        plantBlue = (BlockFlower)new BlockFlower(88, 14).setHardness(0.0f).setStepSound(soundGrassFootstep).setColor(3973835);
        oreCopper = new BlockOre(89, 76).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setColor(0x747474, 10538147);
        motor = new BlockMotor(90, 113, Material.iron, true, 30).setHardness(3.5f).setStepSound(soundMetalFootstep).setLightValue(0.875f);
        generator = new BlockMotor(91, 114, Material.iron, false, -1).setHardness(3.5f).setStepSound(soundMetalFootstep).setLightValue(0.875f);
        blockCopper = new BlockOreBlock(92, 176).setHardness(5.0f).setResistance(10.0f).setStepSound(soundMetalFootstep).setColor(15373137);
        brickMossy = new Block(93, 77, Material.rock).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setColor(8010795, 7845709);
        bleedingObsidian = new BlockBleedingObsidian(94, 116).setHardness(10.0f).setResistance(2000.0f).setStepSound(soundStoneFootstep).setColor(3809868, 737702);
        web = new BlockWeb(95, 11).setHardness(2.0f).setStepSound(soundClothFootstep).setColor(0, 0xFFFFFF);
        pressurePlateSteel = new BlockPressurePlate(96, Block.blockSteel.blockIndexInTexture, EnumMobType.players).setHardness(0.5f).setStepSound(soundMetalFootstep).setColor(0xE9E9E9);
        lightBulb = new BlockLightBulb(97).setHardness(0.5f).setStepSound(soundGlassFootstep).setColor(15066338, 16051672);
        lightBulbOn = new BlockLightBulb(98).setHardness(0.5f).setStepSound(soundGlassFootstep).setLightValue(1.0f).setColor(0xFFFAA4, 16051672);
        pyramidion = new BlockPyramidion(99, 104).setHardness(0.5f).setStepSound(soundMetalFootstep).setLightValue(1.0f).setColor(8010795, 0xFFF144);
        stoneSand = new Block(100, 118, Material.rock).setHardness(0.75f).setStepSound(soundStoneFootstep);
        brickBlue = new Block(101, 117, Material.rock).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep);
        brickFlint = new Block(102, 119, Material.rock).setHardness(3.0f).setResistance(20.0f).setStepSound(soundStoneFootstep);
        blockClayRed = new BlockClay(103, 120).setHardness(0.6f).setStepSound(soundGravelFootstep);
        cloth_tekheles = new Block(104, 159, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep);
        cloth_burnt = new BlockBurntCloth(105).setHardness(0.8f).setStepSound(soundGrassFootstep);
        cloth_burnt_hot = new BlockBurntCloth(106).setHardness(0.8f).setStepSound(soundGrassFootstep).setLightValue(0.25f);
        int i = 0;
        while (i < 256) {
            if (allBlocks[i] != null) {
                Item.itemsList[i] = new ItemBlock(i - 256);
            }
            ++i;
        }
    }

    protected Block(int i, Material material1) {
        if (allBlocks[i] != null) {
            throw new IllegalArgumentException("Slot " + i + " is already occupied by " + allBlocks[i] + " when adding " + this);
        }
        this.blockMaterial = material1;
        Block.allBlocks[i] = this;
        this.blockID = i;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        Block.opaqueCubeLookup[i] = this.isOpaqueCube();
        Block.lightOpacity[i] = this.isOpaqueCube() ? 255 : 0;
        Block.field_340_s[i] = this.func_212_i();
        Block.isBlockContainer[i] = false;
    }

    protected Block(int i, int j, Material material1) {
        this(i, material1);
        this.blockIndexInTexture = j;
    }

    protected Block setColor(int color) {
        this.primaryColor = color;
        return this;
    }

    protected Block setColor(int color, int color2) {
        this.primaryColor = color;
        this.secondaryColor = color2;
        return this;
    }

    protected Block setStepSound(StepSound stepsound) {
        this.stepSound = stepsound;
        return this;
    }

    protected Block setLightOpacity(int i) {
        Block.lightOpacity[this.blockID] = i;
        return this;
    }

    protected Block setLightValue(float f) {
        Block.lightValue[this.blockID] = (int)(15.0f * f);
        return this;
    }

    protected Block setResistance(float f) {
        this.blockResistance = f * 3.0f;
        return this;
    }

    private boolean func_212_i() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return true;
    }

    public int getRenderType() {
        return 0;
    }

    protected Block setHardness(float f) {
        this.blockHardness = f;
        if (this.blockResistance < f * 5.0f) {
            this.blockResistance = f * 5.0f;
        }
        return this;
    }

    protected void setTickOnLoad(boolean flag) {
        Block.tickOnLoad[this.blockID] = flag;
    }

    public void setBlockBounds(float f, float f1, float f2, float f3, float f4, float f5) {
        this.minX = f;
        this.minY = f1;
        this.minZ = f2;
        this.maxX = f3;
        this.maxY = f4;
        this.maxZ = f5;
    }

    public float getBlockBrightness(IBlockAccess iblockaccess, int i, int j, int k) {
        return iblockaccess.getBrightness(i, j, k);
    }

    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int x, int y, int z, int face) {
        if (face == 1 && iblockaccess.getBlockId(x, y, z) == Block.snow.blockID) {
            return false;
        }
        if (face == 0 && this.minY > 0.0) {
            return true;
        }
        if (face == 1 && this.maxY < 1.0) {
            return true;
        }
        if (face == 2 && this.minZ > 0.0) {
            return true;
        }
        if (face == 3 && this.maxZ < 1.0) {
            return true;
        }
        if (face == 4 && this.minX > 0.0) {
            return true;
        }
        if (face == 5 && this.maxX < 1.0) {
            return true;
        }
        return !iblockaccess.isBlockNormalCube(x, y, z);
    }

    public int getTextureIndex(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return this.getBlockTextureFromSideAndMetadata(l, iblockaccess.getBlockMetadata(i, j, k));
    }

    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        return this.getTextureIndex(i);
    }

    public int getTextureIndex(int i) {
        return this.blockIndexInTexture;
    }

    public AxisAlignedBB getSelectedCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.getBoundingBoxFromPool((double)i + this.minX, (double)j + this.minY, (double)k + this.minZ, (double)i + this.maxX, (double)j + this.maxY, (double)k + this.maxZ);
    }

    public void getCollidingBoundingBoxes(World world, int i, int j, int k, AxisAlignedBB axisalignedbb, ArrayList<AxisAlignedBB> arraylist) {
        AxisAlignedBB axisalignedbb1 = this.getCollisionBoundingBoxFromPool(world, i, j, k);
        if (axisalignedbb1 != null && axisalignedbb.intersectsWith(axisalignedbb1)) {
            arraylist.add(axisalignedbb1);
        }
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.getBoundingBoxFromPool((double)i + this.minX, (double)j + this.minY, (double)k + this.minZ, (double)i + this.maxX, (double)j + this.maxY, (double)k + this.maxZ);
    }

    public boolean isOpaqueCube() {
        return true;
    }

    public boolean canCollideCheck(int i, boolean flag) {
        return this.isCollidable();
    }

    public boolean isCollidable() {
        return true;
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
    }

    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
    }

    public void onBlockDestroyedByPlayer(World world, int i, int j, int k, int l) {
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
    }

    public int tickRate() {
        return 10;
    }

    public void onBlockAdded(World world, int i, int j, int k) {
    }

    public void onBlockRemoval(World world, int i, int j, int k) {
    }

    public int quantityDropped(Random random) {
        return 1;
    }

    public int idDropped(int i, Random random) {
        return this.blockID;
    }

    public float blockStrength(EntityPlayer entityplayer) {
        if (this.blockHardness < 0.0f) {
            return 0.0f;
        }
        if (!entityplayer.checkBreakBlock(this)) {
            return 1.0f / this.blockHardness / 100.0f;
        }
        return entityplayer.getMiningInhibitors(this) / this.blockHardness / 30.0f;
    }

    public void dropBlockAsItem(World world, int i, int j, int k, int l) {
        this.dropBlockAsItemWithChance(world, i, j, k, l, 1.0f);
    }

    public void dropBlockAsItemWithChance(World world, int i, int j, int k, int l, float f) {
        if (world.multiplayerWorld) {
            return;
        }
        int i1 = this.quantityDropped(world.rand);
        int j1 = 0;
        while (j1 < i1) {
            int k1;
            if (!(world.rand.nextFloat() > f) && (k1 = this.idDropped(l, world.rand)) > 0) {
                this.dropBlockAsItem_do(world, i, j, k, new ItemStack(k1, 1, this.damageDropped(l)));
            }
            ++j1;
        }
    }

    public void dropBlockGoldTouch(World world, int x, int y, int z, int damage, float f) {
        if (world.multiplayerWorld) {
            return;
        }
        int i1 = 1;
        int j1 = 0;
        while (j1 < i1) {
            if (!(world.rand.nextFloat() > f)) {
                int id = this.blockID;
                if (id > 0 && id != Block.crops.blockID && id != Block.signPost.blockID && id != Block.pressurePlateWoodIdle.blockID && id != Block.doorWood.blockID && id != Block.doorSteel.blockID && id != Block.lightBulbOn.blockID && id != Block.pyramidion.blockID && id != Block.tnt.blockID) {
                    this.dropBlockAsItem_do(world, x, y, z, new ItemStack(id, 1, this.damageDropped(damage)));
                } else if (id == Block.crops.blockID || id == Block.signPost.blockID || id == Block.pressurePlateWoodIdle.blockID || id == Block.doorWood.blockID || id == Block.doorSteel.blockID || id == Block.lightBulbOn.blockID) {
                    this.dropBlockAsItem(world, x, y, z, damage);
                }
            }
            ++j1;
        }
    }

    protected void dropBlockAsItem_do(World world, int i, int j, int k, ItemStack itemstack) {
        if (world.multiplayerWorld) {
            return;
        }
        float f = 0.7f;
        double d = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d1 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d2 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        EntityItem entityitem = new EntityItem(world, (double)i + d, (double)j + d1, (double)k + d2, itemstack);
        entityitem.delayBeforeCanPickup = 10;
        world.entityJoinedWorld(entityitem);
    }

    protected int damageDropped(int i) {
        return 0;
    }

    public float getExplosionResistance(Entity entity) {
        return this.blockResistance / 5.0f;
    }

    public MovingObjectPosition collisionRayTrace(World world, int x, int y, int z, Vec3D vec3d, Vec3D vec3d1) {
        this.setBlockBoundsBasedOnState(world, x, y, z);
        vec3d = vec3d.addVector(-x, -y, -z);
        vec3d1 = vec3d1.addVector(-x, -y, -z);
        Vec3D vec3d2 = vec3d.getIntermediateWithXValue(vec3d1, this.minX);
        Vec3D vec3d3 = vec3d.getIntermediateWithXValue(vec3d1, this.maxX);
        Vec3D vec3d4 = vec3d.getIntermediateWithYValue(vec3d1, this.minY);
        Vec3D vec3d5 = vec3d.getIntermediateWithYValue(vec3d1, this.maxY);
        Vec3D vec3d6 = vec3d.getIntermediateWithZValue(vec3d1, this.minZ);
        Vec3D vec3d7 = vec3d.getIntermediateWithZValue(vec3d1, this.maxZ);
        if (!this.isVecInsideYZBounds(vec3d2)) {
            vec3d2 = null;
        }
        if (!this.isVecInsideYZBounds(vec3d3)) {
            vec3d3 = null;
        }
        if (!this.isVecInsideXZBounds(vec3d4)) {
            vec3d4 = null;
        }
        if (!this.isVecInsideXZBounds(vec3d5)) {
            vec3d5 = null;
        }
        if (!this.isVecInsideXYBounds(vec3d6)) {
            vec3d6 = null;
        }
        if (!this.isVecInsideXYBounds(vec3d7)) {
            vec3d7 = null;
        }
        Vec3D vec3d8 = null;
        if (vec3d2 != null && (vec3d8 == null || vec3d.distanceTo(vec3d2) < vec3d.distanceTo(vec3d8))) {
            vec3d8 = vec3d2;
        }
        if (vec3d3 != null && (vec3d8 == null || vec3d.distanceTo(vec3d3) < vec3d.distanceTo(vec3d8))) {
            vec3d8 = vec3d3;
        }
        if (vec3d4 != null && (vec3d8 == null || vec3d.distanceTo(vec3d4) < vec3d.distanceTo(vec3d8))) {
            vec3d8 = vec3d4;
        }
        if (vec3d5 != null && (vec3d8 == null || vec3d.distanceTo(vec3d5) < vec3d.distanceTo(vec3d8))) {
            vec3d8 = vec3d5;
        }
        if (vec3d6 != null && (vec3d8 == null || vec3d.distanceTo(vec3d6) < vec3d.distanceTo(vec3d8))) {
            vec3d8 = vec3d6;
        }
        if (vec3d7 != null && (vec3d8 == null || vec3d.distanceTo(vec3d7) < vec3d.distanceTo(vec3d8))) {
            vec3d8 = vec3d7;
        }
        if (vec3d8 == null) {
            return null;
        }
        int byte0 = -1;
        if (vec3d8 == vec3d2) {
            byte0 = 4;
        }
        if (vec3d8 == vec3d3) {
            byte0 = 5;
        }
        if (vec3d8 == vec3d4) {
            byte0 = 0;
        }
        if (vec3d8 == vec3d5) {
            byte0 = 1;
        }
        if (vec3d8 == vec3d6) {
            byte0 = 2;
        }
        if (vec3d8 == vec3d7) {
            byte0 = 3;
        }
        return new MovingObjectPosition(x, y, z, byte0, vec3d8.addVector(x, y, z));
    }

    private boolean isVecInsideYZBounds(Vec3D vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.yCoord >= this.minY && vec3d.yCoord <= this.maxY && vec3d.zCoord >= this.minZ && vec3d.zCoord <= this.maxZ;
    }

    private boolean isVecInsideXZBounds(Vec3D vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.xCoord >= this.minX && vec3d.xCoord <= this.maxX && vec3d.zCoord >= this.minZ && vec3d.zCoord <= this.maxZ;
    }

    private boolean isVecInsideXYBounds(Vec3D vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.xCoord >= this.minX && vec3d.xCoord <= this.maxX && vec3d.yCoord >= this.minY && vec3d.yCoord <= this.maxY;
    }

    public void onBlockDestroyedByExplosion(World world, int i, int j, int k) {
    }

    public int getRenderBlockPass() {
        return 0;
    }

    public boolean canPlace(World world, int i, int j, int k) {
        int l = world.getBlockId(i, j, k);
        return l == 0 || Block.allBlocks[l].blockMaterial.getIsGroundCover();
    }

    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        return false;
    }

    public void onEntityWalking(World world, int i, int j, int k, Entity entity) {
    }

    public void onBlockPlaced(World world, int i, int j, int k, int l) {
    }

    public void onBlockClicked(World world, int i, int j, int k, EntityPlayer entityplayer) {
    }

    public void velocityToAddToEntity(World world, int i, int j, int k, Entity entity, Vec3D vec3d) {
    }

    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int i, int j, int k) {
    }

    public int colorMultiplier(IBlockAccess iblockaccess, int i, int j, int k) {
        return 0xFFFFFF;
    }

    public int colorAdditive(IBlockAccess iblockaccess, int i, int j, int k) {
        return 0;
    }

    public int colorMultiplierFlat(IBlockAccess iblockaccess, int i, int j, int k) {
        return this.primaryColor;
    }

    public int colorMultiplierSecondary(IBlockAccess iblockaccess, int i, int j, int k) {
        return this.secondaryColor;
    }

    public boolean isPoweringTo(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return false;
    }

    public boolean canProvidePower() {
        return false;
    }

    public void onEntityCollidedWithBlock(World world, int i, int j, int k, Entity entity) {
    }

    public boolean isIndirectlyPoweringTo(World world, int i, int j, int k, int l) {
        return false;
    }

    public void setBlockBoundsForItemRender() {
    }

    public void harvestBlock(World world, int i, int j, int k, int l) {
        this.dropBlockAsItem(world, i, j, k, l);
    }

    public boolean canBlockStay(World world, int i, int j, int k) {
        return true;
    }

    public void applyGearPower() {
    }

    public void removeGearPower() {
    }

    public boolean isGearPowered() {
        return false;
    }

    public int getConnectedGearsCount(World world, int i, int j, int k) {
        return 0;
    }

    public ArrayList<Vec3D> getConnectedGears(World world, int i, int j, int k) {
        ArrayList<Vec3D> blocklist = new ArrayList<Vec3D>();
        if (world.getBlockId(i - 1, j, k) == Block.gear.blockID) {
            blocklist.add(Vec3D.createVectorHelper(i - 1, j, k));
        }
        if (world.getBlockId(i + 1, j, k) == Block.gear.blockID) {
            blocklist.add(Vec3D.createVectorHelper(i + 1, j, k));
        }
        if (world.getBlockId(i, j, k - 1) == Block.gear.blockID) {
            blocklist.add(Vec3D.createVectorHelper(i, j, k - 1));
        }
        if (world.getBlockId(i, j, k + 1) == Block.gear.blockID) {
            blocklist.add(Vec3D.createVectorHelper(i, j, k + 1));
        }
        return blocklist;
    }

    public ArrayList<Vec3D> getConnectedBlocks(World world, int i, int j, int k) {
        return new ArrayList<Vec3D>();
    }

    static Class<?> _mthclass$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException classnotfoundexception) {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
    }

    public void onBlockPlacedBy(World world, int i, int j, int k, EntityLiving entityliving) {
    }

    public void goldTouch() {
    }

    public void notGoldTouch() {
    }

    public int getTextureIndex(int n, int n2, int n3) {
        return this.getTextureIndex(0);
    }

    public double getFallyness(World world, int i, int j, int k) {
        return 0.0;
    }

    public boolean canPlaceSnowy(World worldObj, int i, int j4, int j) {
        return false;
    }
}

