/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.level.tile;

import com.mojang.minecraft.core.entity.EntityItem;
import com.mojang.minecraft.core.entity.item.Item;
import com.mojang.minecraft.core.entity.item.ItemStack;
import com.mojang.minecraft.core.enums.EnumSeason;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.tile.Block;
import com.mojang.minecraft.core.level.tile.BlockFlower;
import java.util.Random;

public class BlockCrops
extends BlockFlower {
    protected BlockCrops(int i, int j) {
        super(i, j);
        this.blockIndexInTexture = j;
        this.density = 0.25f;
        this.setTickOnLoad(true);
        float f = 0.5f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 0.25f, 0.5f + f);
    }

    protected boolean canThisPlantGrowOnThisBlockID(int i) {
        return i == Block.tilledField.blockID;
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
        float f;
        int l;
        super.updateTick(world, i, j, k, random);
        if (world.getBlockLightValue(i, j + 1, k) >= 9 && (l = world.getBlockMetadata(i, j, k)) < 7 && random.nextInt((int)(100.0f / (f = this.getGrowthRate(world, i, j, k)))) == 0) {
            world.setBlockMetadataWithNotify(i, j, k, ++l);
        }
    }

    public void fertilize(World world, int i, int j, int k) {
        world.setBlockMetadataWithNotify(i, j, k, 7);
    }

    private float getGrowthRate(World world, int i, int j, int k) {
        float f = 1.0f;
        int l = world.getBlockId(i, j, k - 1);
        int i1 = world.getBlockId(i, j, k + 1);
        int j1 = world.getBlockId(i - 1, j, k);
        int k1 = world.getBlockId(i + 1, j, k);
        int l1 = world.getBlockId(i - 1, j, k - 1);
        int i2 = world.getBlockId(i + 1, j, k - 1);
        int j2 = world.getBlockId(i + 1, j, k + 1);
        int k2 = world.getBlockId(i - 1, j, k + 1);
        boolean flag = j1 == this.blockID || k1 == this.blockID;
        boolean flag1 = l == this.blockID || i1 == this.blockID;
        boolean flag2 = l1 == this.blockID || i2 == this.blockID || j2 == this.blockID || k2 == this.blockID;
        int l2 = i - 1;
        while (l2 <= i + 1) {
            int i3 = k - 1;
            while (i3 <= k + 1) {
                int j3 = world.getBlockId(l2, j - 1, i3);
                float f1 = 0.0f;
                if (j3 == Block.tilledField.blockID) {
                    f1 = 1.0f;
                    if (world.getBlockMetadata(l2, j - 1, i3) > 0) {
                        f1 = 3.0f;
                    }
                }
                if (l2 != i || i3 != k) {
                    f1 /= 4.0f;
                }
                f += f1;
                ++i3;
            }
            ++l2;
        }
        if (flag2 || flag && flag1) {
            f /= 2.0f;
        }
        if (world.season == EnumSeason.cycle) {
            if (world.getCurrentSeason() == EnumSeason.fall) {
                f /= 3.0f;
            }
            if (world.getCurrentSeason() == EnumSeason.winter) {
                f /= 10.0f;
            }
            if (world.getCurrentSeason() == EnumSeason.spring) {
                f *= 3.0f;
            }
        }
        return f;
    }

    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        if (j < 0) {
            j = 7;
        }
        return this.blockIndexInTexture + j;
    }

    public int getRenderType() {
        return 6;
    }

    public void onBlockDestroyedByPlayer(World world, int i, int j, int k, int l) {
        super.onBlockDestroyedByPlayer(world, i, j, k, l);
        if (world.multiplayerWorld) {
            return;
        }
        int i1 = 0;
        while (i1 < 3) {
            if (world.rand.nextInt(15) <= l) {
                float f = 0.7f;
                float f1 = world.rand.nextFloat() * f + (1.0f - f) * 0.5f;
                float f2 = world.rand.nextFloat() * f + (1.0f - f) * 0.5f;
                float f3 = world.rand.nextFloat() * f + (1.0f - f) * 0.5f;
                EntityItem entityitem = new EntityItem(world, (float)i + f1, (float)j + f2, (float)k + f3, new ItemStack(Item.seeds));
                entityitem.delayBeforeCanPickup = 10;
                world.entityJoinedWorld(entityitem);
            }
            ++i1;
        }
    }

    public void dropBlockAsItemWithChance(World world, int i, int j, int k, int l, float f) {
        super.dropBlockAsItemWithChance(world, i, j, k, l, f);
        if (world.multiplayerWorld) {
            return;
        }
        float f1 = 0.7f;
        float f2 = world.rand.nextFloat() * f1 + (1.0f - f1) * 0.5f;
        float f3 = world.rand.nextFloat() * f1 + (1.0f - f1) * 0.5f;
        float f4 = world.rand.nextFloat() * f1 + (1.0f - f1) * 0.5f;
        EntityItem entityitem = new EntityItem(world, (float)i + f2, (float)j + f3, (float)k + f4, new ItemStack(Item.seeds));
        entityitem.delayBeforeCanPickup = 10;
        world.entityJoinedWorld(entityitem);
    }

    public int idDropped(int i, Random random) {
        System.out.println("Get resource: " + i);
        if (i == 7) {
            return Item.wheat.shiftedIndex;
        }
        return -1;
    }

    public int quantityDropped(Random random) {
        return 1;
    }
}

