/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.level.tile;

import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.tile.Block;
import com.mojang.minecraft.core.level.tile.BlockFluids;
import com.mojang.minecraft.core.level.tile.BlockSponge;
import com.mojang.minecraft.core.level.tile.material.Material;
import java.util.Random;

public class BlockFlowing
extends BlockFluids {
    int surroundingSourceBlocks = 0;
    boolean[] flowPermits = new boolean[4];
    int[] flowCosts = new int[4];

    protected BlockFlowing(int id, Material material) {
        super(id, material);
    }

    private void setStill(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        world.setBlockAndMetadata(x, y, z, this.blockID + 1, meta);
        world.markBlocksDirty(x, y, z, x, y, z);
        world.markBlockNeedsUpdate(x, y, z);
    }

    public int getTextureIndex(int i) {
        return this.blockIndexInTexture + 1;
    }

    public void updateTick(World world, int x, int y, int z, Random random) {
        int localHeight = this.getSameFluidHeight(world, x, y, z);
        boolean flowComplete = true;
        if (localHeight > 0) {
            int neighborCount = -100;
            this.surroundingSourceBlocks = 0;
            neighborCount = this.checkNeighborlyFluids(world, x - 1, y, z, neighborCount);
            neighborCount = this.checkNeighborlyFluids(world, x + 1, y, z, neighborCount);
            neighborCount = this.checkNeighborlyFluids(world, x, y, z - 1, neighborCount);
            int heightsAround = (neighborCount = this.checkNeighborlyFluids(world, x, y, z + 1, neighborCount)) + this.fluidType;
            if (heightsAround >= 8 || neighborCount < 0) {
                heightsAround = -1;
            }
            if (this.getSameFluidHeight(world, x, y + 1, z) >= 0) {
                int heightAbove = this.getSameFluidHeight(world, x, y + 1, z);
                heightsAround = heightAbove >= 8 ? heightAbove : heightAbove + 8;
            }
            if (this.surroundingSourceBlocks >= 2 && this.blockMaterial == Material.water) {
                if (world.isBlockNormalCube(x, y - 1, z) || world.isWater(x, y - 1, z)) {
                    heightsAround = 0;
                } else if (world.getMaterialXYZ(x, y - 1, z) == this.blockMaterial && world.getBlockMetadata(x, y, z) == 0 && !BlockSponge.getSurroundSponge(world, x, y, z)) {
                    heightsAround = 0;
                }
            }
            if (this.blockMaterial == Material.lava && localHeight < 8 && heightsAround < 8 && heightsAround > localHeight && random.nextInt(4) != 0) {
                heightsAround = localHeight;
                flowComplete = false;
            }
            if (heightsAround != localHeight) {
                localHeight = heightsAround;
                if (localHeight < 0) {
                    world.setBlockWithNotify(x, y, z, 0);
                } else {
                    world.setBlockMetadataWithNotify(x, y, z, localHeight);
                    world.scheduleUpdateTick(x, y, z, this.blockID);
                    world.notifyBlocksOfNeighborChange(x, y, z, this.blockID);
                }
            } else if (flowComplete) {
                this.setStill(world, x, y, z);
            }
        } else {
            this.setStill(world, x, y, z);
        }
        if (this.liquidCanDisplaceBlock(world, x, y - 1, z)) {
            if (localHeight >= 8) {
                world.setBlockAndMetadataWithNotify(x, y - 1, z, this.blockID, localHeight);
            } else {
                world.setBlockAndMetadataWithNotify(x, y - 1, z, this.blockID, localHeight + 8);
            }
        } else if (localHeight >= 0 && (localHeight == 0 || this.canFlowInto(world, x, y - 1, z))) {
            boolean[] costs = this.calcFlowCosts(world, x, y, z);
            int totalHeight = localHeight + this.fluidType;
            if (localHeight >= 8) {
                totalHeight = 1;
            }
            if (totalHeight >= 8) {
                return;
            }
            if (costs[0]) {
                this.flowIntoBlock(world, x - 1, y, z, totalHeight);
            }
            if (costs[1]) {
                this.flowIntoBlock(world, x + 1, y, z, totalHeight);
            }
            if (costs[2]) {
                this.flowIntoBlock(world, x, y, z - 1, totalHeight);
            }
            if (costs[3]) {
                this.flowIntoBlock(world, x, y, z + 1, totalHeight);
            }
        }
    }

    private void flowIntoBlock(World world, int i, int j, int k, int l) {
        if (this.liquidCanDisplaceBlock(world, i, j, k)) {
            int i1 = world.getBlockId(i, j, k);
            if (i1 > 0) {
                if (this.blockMaterial == Material.lava) {
                    this.triggerLavaMixEffects(world, i, j, k);
                } else {
                    Block.allBlocks[i1].dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
                }
            }
            world.setBlockAndMetadataWithNotify(i, j, k, this.blockID, l);
        }
    }

    private int calculateFlowCost(World world, int x, int y, int z, int dist, int direction) {
        int cost = 1000;
        int dir = 0;
        while (dir < 4) {
            if (!(dir == 0 && direction == 1 || dir == 1 && direction == 0 || dir == 2 && direction == 3 || dir == 3 && direction == 2)) {
                int xCheck = x;
                int yCheck = y;
                int zCheck = z;
                if (dir == 0) {
                    --xCheck;
                }
                if (dir == 1) {
                    ++xCheck;
                }
                if (dir == 2) {
                    --zCheck;
                }
                if (dir == 3) {
                    ++zCheck;
                }
                if (!(this.canFlowInto(world, xCheck, yCheck, zCheck) || world.getMaterialXYZ(xCheck, yCheck, zCheck) == this.blockMaterial && world.getBlockMetadata(xCheck, yCheck, zCheck) == 0)) {
                    int nextCost;
                    if (!this.canFlowInto(world, xCheck, yCheck - 1, zCheck)) {
                        return dist;
                    }
                    if (dist < 4 && (nextCost = this.calculateFlowCost(world, xCheck, yCheck, zCheck, dist + 1, dir)) < cost) {
                        cost = nextCost;
                    }
                }
            }
            ++dir;
        }
        return cost;
    }

    private boolean[] calcFlowCosts(World world, int x, int y, int z) {
        int dir = 0;
        while (dir < 4) {
            this.flowCosts[dir] = 1000;
            int xCheck = x;
            int yCheck = y;
            int zCheck = z;
            if (dir == 0) {
                --xCheck;
            }
            if (dir == 1) {
                ++xCheck;
            }
            if (dir == 2) {
                --zCheck;
            }
            if (dir == 3) {
                ++zCheck;
            }
            if (!(this.canFlowInto(world, xCheck, yCheck, zCheck) || world.getMaterialXYZ(xCheck, yCheck, zCheck) == this.blockMaterial && world.getBlockMetadata(xCheck, yCheck, zCheck) == 0)) {
                this.flowCosts[dir] = !this.canFlowInto(world, xCheck, yCheck - 1, zCheck) ? 0 : this.calculateFlowCost(world, xCheck, yCheck, zCheck, 1, dir);
            }
            ++dir;
        }
        int minCost = this.flowCosts[0];
        int dir2 = 1;
        while (dir2 < 4) {
            if (this.flowCosts[dir2] < minCost) {
                minCost = this.flowCosts[dir2];
            }
            ++dir2;
        }
        dir2 = 0;
        while (dir2 < 4) {
            this.flowPermits[dir2] = this.flowCosts[dir2] == minCost;
            ++dir2;
        }
        return this.flowPermits;
    }

    private boolean canFlowInto(World world, int x, int y, int z) {
        int l = world.getBlockId(x, y, z);
        if (l == Block.doorWood.blockID || BlockSponge.getSurroundSponge(world, x, y, z) || l == Block.doorSteel.blockID || l == Block.signPost.blockID || l == Block.ladder.blockID || l == Block.reed.blockID) {
            return true;
        }
        if (l == 0) {
            return false;
        }
        Material material = Block.allBlocks[l].blockMaterial;
        return material.isSolidMaterial();
    }

    protected int checkNeighborlyFluids(World world, int x, int y, int z, int count) {
        int fluidHeight = this.getSameFluidHeight(world, x, y, z);
        if (fluidHeight < 0) {
            return count;
        }
        if (fluidHeight == 0) {
            ++this.surroundingSourceBlocks;
        }
        if (fluidHeight >= 8) {
            fluidHeight = 0;
        }
        return count >= 0 && fluidHeight >= count ? count : fluidHeight;
    }

    private boolean liquidCanDisplaceBlock(World world, int i, int j, int k) {
        Material material = world.getMaterialXYZ(i, j, k);
        if (material == this.blockMaterial) {
            return false;
        }
        if (material == Material.lava) {
            return false;
        }
        return !this.canFlowInto(world, i, j, k);
    }

    public void onBlockAdded(World world, int i, int j, int k) {
        super.onBlockAdded(world, i, j, k);
        if (world.getBlockId(i, j, k) == this.blockID) {
            world.scheduleUpdateTick(i, j, k, this.blockID);
        }
    }
}

