/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.level.tile;

import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.tile.Block;
import com.mojang.minecraft.core.level.tile.material.Material;
import com.mojang.minecraft.core.level.tile.phys.AxisAlignedBB;
import java.util.Random;

public class BlockLadder
extends Block {
    protected BlockLadder(int i, int j) {
        super(i, j, Material.circuits);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        int l = world.getBlockMetadata(i, j, k);
        float f = 0.125f;
        if (l == 2) {
            this.setBlockBounds(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f);
        }
        if (l == 3) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f);
        }
        if (l == 4) {
            this.setBlockBounds(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        if (l == 5) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f);
        }
        return super.getCollisionBoundingBoxFromPool(world, i, j, k);
    }

    public AxisAlignedBB getSelectedCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        int l = world.getBlockMetadata(i, j, k);
        float f = 0.125f;
        if (l == 2) {
            this.setBlockBounds(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f);
        }
        if (l == 3) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f);
        }
        if (l == 4) {
            this.setBlockBounds(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        if (l == 5) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f);
        }
        return super.getSelectedCollisionBoundingBoxFromPool(world, i, j, k);
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return 8;
    }

    public boolean canPlace(World world, int i, int j, int k) {
        if (world.isBlockNormalCube(i - 1, j, k)) {
            return true;
        }
        if (world.isBlockNormalCube(i + 1, j, k)) {
            return true;
        }
        if (world.isBlockNormalCube(i, j, k - 1)) {
            return true;
        }
        return world.isBlockNormalCube(i, j, k + 1);
    }

    public void onBlockPlaced(World world, int i, int j, int k, int l) {
        int i1 = world.getBlockMetadata(i, j, k);
        if ((i1 == 0 || l == 2) && world.isBlockNormalCube(i, j, k + 1)) {
            i1 = 2;
        }
        if ((i1 == 0 || l == 3) && world.isBlockNormalCube(i, j, k - 1)) {
            i1 = 3;
        }
        if ((i1 == 0 || l == 4) && world.isBlockNormalCube(i + 1, j, k)) {
            i1 = 4;
        }
        if ((i1 == 0 || l == 5) && world.isBlockNormalCube(i - 1, j, k)) {
            i1 = 5;
        }
        world.setBlockMetadataWithNotify(i, j, k, i1);
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        int i1 = world.getBlockMetadata(i, j, k);
        boolean flag = false;
        if (i1 == 2 && world.isBlockNormalCube(i, j, k + 1)) {
            flag = true;
        }
        if (i1 == 3 && world.isBlockNormalCube(i, j, k - 1)) {
            flag = true;
        }
        if (i1 == 4 && world.isBlockNormalCube(i + 1, j, k)) {
            flag = true;
        }
        if (i1 == 5 && world.isBlockNormalCube(i - 1, j, k)) {
            flag = true;
        }
        if (!flag) {
            this.dropBlockAsItem(world, i, j, k, i1);
            world.setBlockWithNotify(i, j, k, 0);
        }
        super.onNeighborBlockChange(world, i, j, k, l);
    }

    public int quantityDropped(Random random) {
        return 1;
    }
}

