/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.level.tile;

import com.mojang.minecraft.core.entity.EntityItem;
import com.mojang.minecraft.core.entity.item.Item;
import com.mojang.minecraft.core.entity.item.ItemStack;
import com.mojang.minecraft.core.entity.tile.IBlockAccess;
import com.mojang.minecraft.core.enums.EnumSeason;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.tile.Block;
import com.mojang.minecraft.core.level.tile.BlockLeavesBase;
import com.mojang.minecraft.core.level.tile.material.Material;
import com.mojang.minecraft.core.util.MathHelper;
import java.util.Random;

public class BlockLeaves
extends BlockLeavesBase {
    public static final int radius = 4;
    private int indexOfTheTextor;
    private int oldInd;

    protected BlockLeaves(int i, int j) {
        super(i, j, Material.leaves, 0);
        this.density = 0.5f;
        this.indexOfTheTextor = 105;
        this.oldInd = j;
        this.setTickOnLoad(true);
    }

    public int getTextureIndex(IBlockAccess iblockaccess, int x, int y, int z, int meta) {
        this.indexOfTheTextor = 105;
        return this.blockIndexInTexture;
    }

    public int colorMultiplier(IBlockAccess iblockaccess, int x, int y, int z) {
        if (iblockaccess.getCurrentSeason() == EnumSeason.fall) {
            int foliage = (int)(iblockaccess.getFoliageLevel(x, y, z) * 256.0f);
            int r = this.colorCheck(512 - MathHelper.sqrt(foliage * 720) + 64);
            int g = this.colorCheck(256 - MathHelper.sqrt(foliage * 256) + 64);
            int b = this.colorCheck(64 - MathHelper.sqrt(foliage * 1024) + 64);
            return (r << 16) + (g << 8) + b;
        }
        return 0xFFFFFF;
    }

    public int colorAdditive(IBlockAccess iblockaccess, int x, int y, int z) {
        return 0;
    }

    private int colorCheck(int color) {
        if (color > 255) {
            return 255;
        }
        if (color < 0) {
            return 0;
        }
        return color & 0xFF;
    }

    public boolean getConnectLog(World world, int x, int y, int z) {
        int x1 = x - 4;
        while (x1 <= x + 4) {
            int z1 = z - 4;
            while (z1 <= z + 4) {
                int y1 = y - 4;
                while (y1 <= y + 4) {
                    if (world.getBlockId(x1, y1, z1) == Block.wood.blockID || world.getBlockId(x1, y1, z1) == Block.brickMossy.blockID) {
                        return true;
                    }
                    ++y1;
                }
                ++z1;
            }
            ++x1;
        }
        return false;
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
        if (world.multiplayerWorld) {
            return;
        }
        if (!this.getConnectLog(world, i, j, k)) {
            EntityItem entityitem;
            world.setBlockWithNotify(i, j, k, 0);
            if (random.nextInt(this.dropChance(world, 0)) == 0) {
                if (world.multiplayerWorld) {
                    return;
                }
                entityitem = new EntityItem(world, i, j, k, new ItemStack(Block.sapling));
                entityitem.delayBeforeCanPickup = 10;
                world.entityJoinedWorld(entityitem);
            }
            if (random.nextInt(this.dropChance(world, 1)) == 0) {
                if (world.multiplayerWorld) {
                    return;
                }
                entityitem = new EntityItem(world, i, j, k, new ItemStack(Item.appleRed));
                entityitem.delayBeforeCanPickup = 10;
                world.entityJoinedWorld(entityitem);
            }
            if (random.nextInt(this.dropChance(world, 2)) == 0) {
                if (world.multiplayerWorld) {
                    return;
                }
                entityitem = new EntityItem(world, i, j, k, new ItemStack(Item.appleGold));
                entityitem.delayBeforeCanPickup = 10;
                world.entityJoinedWorld(entityitem);
            }
        }
    }

    public int idDropped(int i, Random random) {
        return 0;
    }

    public void onBlockDestroyedByPlayer(World world, int i, int j, int k, int l) {
        EntityItem entityitem;
        super.onBlockDestroyedByPlayer(world, i, j, k, l);
        if (world.multiplayerWorld) {
            return;
        }
        Random random = new Random();
        if (random.nextInt(this.dropChance(world, 0)) == 0) {
            entityitem = new EntityItem(world, i, j, k, new ItemStack(Block.sapling));
            entityitem.delayBeforeCanPickup = 10;
            world.entityJoinedWorld(entityitem);
        }
        if (random.nextInt(this.dropChance(world, 1)) == 0) {
            entityitem = new EntityItem(world, i, j, k, new ItemStack(Item.appleRed));
            entityitem.delayBeforeCanPickup = 10;
            world.entityJoinedWorld(entityitem);
        }
        if (random.nextInt(this.dropChance(world, 2)) == 0) {
            entityitem = new EntityItem(world, i, j, k, new ItemStack(Item.appleGold));
            entityitem.delayBeforeCanPickup = 10;
            world.entityJoinedWorld(entityitem);
        }
    }

    private int dropChance(World world, int item) {
        int chance = 0;
        if (item == 0) {
            chance = 40;
        }
        if (item == 1) {
            chance = 128;
        }
        if (item == 2) {
            chance = 10000;
        }
        if (world.season == EnumSeason.cycle) {
            if (world.getCurrentSeason() == EnumSeason.summer) {
                if (item == 0) {
                    chance = 40;
                }
                if (item == 1) {
                    chance = 256;
                }
                if (item == 2) {
                    chance = 20000;
                }
            }
            if (world.getCurrentSeason() == EnumSeason.fall) {
                if (item == 0) {
                    chance = 60;
                }
                if (item == 1) {
                    chance = 128;
                }
                if (item == 2) {
                    chance = 10000;
                }
            }
            if (world.getCurrentSeason() == EnumSeason.winter) {
                if (item == 0) {
                    chance = 100;
                }
                if (item == 1) {
                    chance = 512;
                }
                if (item == 2) {
                    chance = 10000;
                }
            }
            if (world.getCurrentSeason() == EnumSeason.spring) {
                if (item == 0) {
                    chance = 30;
                }
                if (item == 1) {
                    chance = 512;
                }
                if (item == 2) {
                    chance = 10000;
                }
            }
        }
        return chance;
    }

    public void setFastOrFancy(int level) {
        this.graphicsLevel = level;
        this.blockIndexInTexture = this.indexOfTheTextor + (level == 0 ? 1 : 0);
    }
}

