/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.level.tile;

import com.mojang.minecraft.client.render.Vec3D;
import com.mojang.minecraft.core.entity.MovingObjectPosition;
import com.mojang.minecraft.core.entity.tile.IBlockAccess;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.tile.Block;
import com.mojang.minecraft.core.level.tile.MinecartTrackLogic;
import com.mojang.minecraft.core.level.tile.material.Material;
import com.mojang.minecraft.core.level.tile.phys.AxisAlignedBB;
import java.util.Random;

public class BlockMinecartTrack
extends Block {
    protected BlockMinecartTrack(int i, int j) {
        super(i, j, Material.circuits);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return null;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public MovingObjectPosition collisionRayTrace(World world, int i, int j, int k, Vec3D vec3d, Vec3D vec3d1) {
        this.setBlockBoundsBasedOnState(world, i, j, k);
        return super.collisionRayTrace(world, i, j, k, vec3d, vec3d1);
    }

    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int i, int j, int k) {
        int l = iblockaccess.getBlockMetadata(i, j, k);
        if (l >= 2 && l <= 5) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.625f, 1.0f);
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        }
    }

    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        if (j >= 6) {
            return this.blockIndexInTexture - 16;
        }
        return this.blockIndexInTexture;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return 9;
    }

    public int quantityDropped(Random random) {
        return 1;
    }

    public boolean canPlace(World world, int i, int j, int k) {
        return world.isBlockNormalCube(i, j - 1, k);
    }

    public void onBlockAdded(World world, int i, int j, int k) {
        if (!world.multiplayerWorld) {
            world.setBlockMetadataWithNotify(i, j, k, 15);
            this.func_304_h(world, i, j, k);
        }
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (world.multiplayerWorld) {
            return;
        }
        int i1 = world.getBlockMetadata(i, j, k);
        boolean flag = false;
        if (!world.isBlockNormalCube(i, j - 1, k)) {
            flag = true;
        }
        if (i1 == 2 && !world.isBlockNormalCube(i + 1, j, k)) {
            flag = true;
        }
        if (i1 == 3 && !world.isBlockNormalCube(i - 1, j, k)) {
            flag = true;
        }
        if (i1 == 4 && !world.isBlockNormalCube(i, j, k - 1)) {
            flag = true;
        }
        if (i1 == 5 && !world.isBlockNormalCube(i, j, k + 1)) {
            flag = true;
        }
        if (flag) {
            this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
            world.setBlockWithNotify(i, j, k, 0);
        } else if (l > 0 && Block.allBlocks[l].canProvidePower() && MinecartTrackLogic.func_791_a(new MinecartTrackLogic(this, world, i, j, k)) == 3) {
            this.func_304_h(world, i, j, k);
        }
    }

    private void func_304_h(World world, int i, int j, int k) {
        if (world.multiplayerWorld) {
            return;
        }
        new MinecartTrackLogic(this, world, i, j, k).func_792_a(world.isBlockIndirectlyGettingPowered(i, j, k));
    }
}

