/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.level.tile;

import com.mojang.minecraft.core.entity.Entity;
import com.mojang.minecraft.core.entity.EntityLiving;
import com.mojang.minecraft.core.entity.EntityPlayer;
import com.mojang.minecraft.core.entity.tile.IBlockAccess;
import com.mojang.minecraft.core.enums.EnumMobType;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.tile.Block;
import com.mojang.minecraft.core.level.tile.material.Material;
import com.mojang.minecraft.core.level.tile.phys.AxisAlignedBB;
import java.util.List;
import java.util.Random;

public class BlockPressurePlate
extends Block {
    private EnumMobType field_467_a;

    protected BlockPressurePlate(int i, int j, EnumMobType enummobtype) {
        super(i, j, Material.rock);
        this.field_467_a = enummobtype;
        this.setTickOnLoad(true);
        float f = 0.0625f;
        this.setBlockBounds(f, 0.0f, f, 1.0f - f, 0.03125f, 1.0f - f);
    }

    public int tickRate() {
        return 20;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return null;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return true;
    }

    public boolean canPlace(World world, int i, int j, int k) {
        if (world.getBlockId(i, j - 1, k) == Block.fence.blockID) {
            return true;
        }
        return world.isBlockNormalCube(i, j - 1, k);
    }

    public void onBlockAdded(World world, int i, int j, int k) {
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        boolean flag = false;
        if (!world.isBlockNormalCube(i, j - 1, k) && world.getBlockId(i, j - 1, k) != Block.fence.blockID) {
            flag = true;
        }
        if (flag) {
            this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
            world.setBlockWithNotify(i, j, k, 0);
        }
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
        if (world.multiplayerWorld) {
            return;
        }
        if (world.getBlockMetadata(i, j, k) == 0) {
            return;
        }
        this.func_318_h(world, i, j, k);
    }

    public void onEntityCollidedWithBlock(World world, int i, int j, int k, Entity entity) {
        if (world.multiplayerWorld) {
            return;
        }
        if (world.getBlockMetadata(i, j, k) == 1) {
            return;
        }
        this.func_318_h(world, i, j, k);
    }

    private void func_318_h(World world, int i, int j, int k) {
        boolean flag = world.getBlockMetadata(i, j, k) == 1;
        boolean flag1 = false;
        float f = 0.125f;
        List<Entity> list = null;
        if (this.field_467_a == EnumMobType.everything) {
            list = world.getEntitiesWithinAABBExcludingEntity(null, AxisAlignedBB.getBoundingBoxFromPool((float)i + f, j, (float)k + f, (float)(i + 1) - f, (double)j + 0.25, (float)(k + 1) - f));
        }
        if (this.field_467_a == EnumMobType.mobs) {
            list = world.getEntitiesWithinAABB(EntityLiving.class, AxisAlignedBB.getBoundingBoxFromPool((float)i + f, j, (float)k + f, (float)(i + 1) - f, (double)j + 0.25, (float)(k + 1) - f));
        }
        if (this.field_467_a == EnumMobType.players) {
            list = world.getEntitiesWithinAABB(EntityPlayer.class, AxisAlignedBB.getBoundingBoxFromPool((float)i + f, j, (float)k + f, (float)(i + 1) - f, (double)j + 0.25, (float)(k + 1) - f));
        }
        if (list.size() > 0) {
            flag1 = true;
        }
        if (flag1 && !flag) {
            world.setBlockMetadataWithNotify(i, j, k, 1);
            world.notifyBlocksOfNeighborChange(i, j, k, this.blockID);
            world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
            world.markBlocksDirty(i, j, k, i, j, k);
            world.playSoundEffect((double)i + 0.5, (double)j + 0.1, (double)k + 0.5, "random.click", 0.3f, 0.6f);
        }
        if (!flag1 && flag) {
            world.setBlockMetadataWithNotify(i, j, k, 0);
            world.notifyBlocksOfNeighborChange(i, j, k, this.blockID);
            world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
            world.markBlocksDirty(i, j, k, i, j, k);
            world.playSoundEffect((double)i + 0.5, (double)j + 0.1, (double)k + 0.5, "random.click", 0.3f, 0.5f);
        }
        if (flag1) {
            world.scheduleUpdateTick(i, j, k, this.blockID);
        }
    }

    public void onBlockRemoval(World world, int i, int j, int k) {
        int l = world.getBlockMetadata(i, j, k);
        if (l > 0) {
            world.notifyBlocksOfNeighborChange(i, j, k, this.blockID);
            world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
        }
        super.onBlockRemoval(world, i, j, k);
    }

    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int i, int j, int k) {
        boolean flag = iblockaccess.getBlockMetadata(i, j, k) == 1;
        float f = 0.0625f;
        if (flag) {
            this.setBlockBounds(f, 0.0f, f, 1.0f - f, 0.03125f, 1.0f - f);
        } else {
            this.setBlockBounds(f, 0.0f, f, 1.0f - f, 0.0625f, 1.0f - f);
        }
    }

    public boolean isPoweringTo(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return iblockaccess.getBlockMetadata(i, j, k) > 0;
    }

    public boolean isIndirectlyPoweringTo(World world, int i, int j, int k, int l) {
        if (world.getBlockMetadata(i, j, k) == 0) {
            return false;
        }
        return l == 1;
    }

    public boolean canProvidePower() {
        return true;
    }

    public void setBlockBoundsForItemRender() {
        float f = 0.5f;
        float f1 = 0.125f;
        float f2 = 0.5f;
        this.setBlockBounds(0.5f - f, 0.5f - f1, 0.5f - f2, 0.5f + f, 0.5f + f1, 0.5f + f2);
    }
}

