/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.level.tile;

import com.mojang.minecraft.core.entity.item.Item;
import com.mojang.minecraft.core.entity.tile.IBlockAccess;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.tile.Block;
import com.mojang.minecraft.core.level.tile.material.Material;
import com.mojang.minecraft.core.level.tile.phys.AxisAlignedBB;
import java.util.Random;

public class BlockRedDustWire
extends Block {
    private boolean wiresProvidePower = true;

    public BlockRedDustWire(int i, int j) {
        super(i, j, Material.circuits);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
    }

    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        return this.blockIndexInTexture + (j <= 0 ? 0 : 16);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return null;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return 5;
    }

    public boolean canPlace(World world, int i, int j, int k) {
        return world.isBlockNormalCube(i, j - 1, k);
    }

    private void func_280_h(World world, int i, int j, int k) {
        int l = world.getBlockMetadata(i, j, k);
        int i1 = 0;
        this.wiresProvidePower = false;
        boolean flag = world.isBlockIndirectlyGettingPowered(i, j, k);
        this.wiresProvidePower = true;
        if (flag) {
            i1 = 15;
        } else {
            int j1 = 0;
            while (j1 < 4) {
                int l1 = i;
                int j2 = k;
                if (j1 == 0) {
                    --l1;
                }
                if (j1 == 1) {
                    ++l1;
                }
                if (j1 == 2) {
                    --j2;
                }
                if (j1 == 3) {
                    ++j2;
                }
                i1 = this.getMaxCurrentStrength(world, l1, j, j2, i1);
                if (world.isBlockNormalCube(l1, j, j2) && !world.isBlockNormalCube(i, j + 1, k)) {
                    i1 = this.getMaxCurrentStrength(world, l1, j + 1, j2, i1);
                } else if (!world.isBlockNormalCube(l1, j, j2)) {
                    i1 = this.getMaxCurrentStrength(world, l1, j - 1, j2, i1);
                }
                ++j1;
            }
            i1 = i1 > 0 ? --i1 : 0;
        }
        if (l != i1) {
            world.setBlockMetadataWithNotify(i, j, k, i1);
            world.markBlocksDirty(i, j, k, i, j, k);
            if (i1 > 0) {
                --i1;
            }
            int k1 = 0;
            while (k1 < 4) {
                int i3;
                int i2 = i;
                int k2 = k;
                int l2 = j - 1;
                if (k1 == 0) {
                    --i2;
                }
                if (k1 == 1) {
                    ++i2;
                }
                if (k1 == 2) {
                    --k2;
                }
                if (k1 == 3) {
                    ++k2;
                }
                if (world.isBlockNormalCube(i2, j, k2)) {
                    l2 += 2;
                }
                if ((i3 = this.getMaxCurrentStrength(world, i2, j, k2, -1)) >= 0 && i3 != i1) {
                    this.func_280_h(world, i2, j, k2);
                }
                if ((i3 = this.getMaxCurrentStrength(world, i2, l2, k2, -1)) >= 0 && i3 != i1) {
                    this.func_280_h(world, i2, l2, k2);
                }
                ++k1;
            }
            if (l == 0 || i1 == 0) {
                world.notifyBlocksOfNeighborChange(i, j, k, this.blockID);
                world.notifyBlocksOfNeighborChange(i - 1, j, k, this.blockID);
                world.notifyBlocksOfNeighborChange(i + 1, j, k, this.blockID);
                world.notifyBlocksOfNeighborChange(i, j, k - 1, this.blockID);
                world.notifyBlocksOfNeighborChange(i, j, k + 1, this.blockID);
                world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
                world.notifyBlocksOfNeighborChange(i, j + 1, k, this.blockID);
            }
        }
    }

    private void notifyWireNeighborsOfNeighborChange(World world, int i, int j, int k) {
        if (world.getBlockId(i, j, k) != this.blockID) {
            return;
        }
        world.notifyBlocksOfNeighborChange(i, j, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i - 1, j, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i + 1, j, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j, k - 1, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j, k + 1, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j + 1, k, this.blockID);
    }

    public void onBlockAdded(World world, int i, int j, int k) {
        super.onBlockAdded(world, i, j, k);
        if (world.multiplayerWorld) {
            return;
        }
        this.func_280_h(world, i, j, k);
        world.notifyBlocksOfNeighborChange(i, j + 1, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
        this.notifyWireNeighborsOfNeighborChange(world, i - 1, j, k);
        this.notifyWireNeighborsOfNeighborChange(world, i + 1, j, k);
        this.notifyWireNeighborsOfNeighborChange(world, i, j, k - 1);
        this.notifyWireNeighborsOfNeighborChange(world, i, j, k + 1);
        if (world.isBlockNormalCube(i - 1, j, k)) {
            this.notifyWireNeighborsOfNeighborChange(world, i - 1, j + 1, k);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i - 1, j - 1, k);
        }
        if (world.isBlockNormalCube(i + 1, j, k)) {
            this.notifyWireNeighborsOfNeighborChange(world, i + 1, j + 1, k);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i + 1, j - 1, k);
        }
        if (world.isBlockNormalCube(i, j, k - 1)) {
            this.notifyWireNeighborsOfNeighborChange(world, i, j + 1, k - 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i, j - 1, k - 1);
        }
        if (world.isBlockNormalCube(i, j, k + 1)) {
            this.notifyWireNeighborsOfNeighborChange(world, i, j + 1, k + 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i, j - 1, k + 1);
        }
    }

    public void onBlockRemoval(World world, int i, int j, int k) {
        super.onBlockRemoval(world, i, j, k);
        if (world.multiplayerWorld) {
            return;
        }
        world.notifyBlocksOfNeighborChange(i, j + 1, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
        this.func_280_h(world, i, j, k);
        this.notifyWireNeighborsOfNeighborChange(world, i - 1, j, k);
        this.notifyWireNeighborsOfNeighborChange(world, i + 1, j, k);
        this.notifyWireNeighborsOfNeighborChange(world, i, j, k - 1);
        this.notifyWireNeighborsOfNeighborChange(world, i, j, k + 1);
        if (world.isBlockNormalCube(i - 1, j, k)) {
            this.notifyWireNeighborsOfNeighborChange(world, i - 1, j + 1, k);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i - 1, j - 1, k);
        }
        if (world.isBlockNormalCube(i + 1, j, k)) {
            this.notifyWireNeighborsOfNeighborChange(world, i + 1, j + 1, k);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i + 1, j - 1, k);
        }
        if (world.isBlockNormalCube(i, j, k - 1)) {
            this.notifyWireNeighborsOfNeighborChange(world, i, j + 1, k - 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i, j - 1, k - 1);
        }
        if (world.isBlockNormalCube(i, j, k + 1)) {
            this.notifyWireNeighborsOfNeighborChange(world, i, j + 1, k + 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i, j - 1, k + 1);
        }
    }

    private int getMaxCurrentStrength(World world, int i, int j, int k, int l) {
        if (world.getBlockId(i, j, k) != this.blockID) {
            return l;
        }
        int i1 = world.getBlockMetadata(i, j, k);
        if (i1 > l) {
            return i1;
        }
        return l;
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (world.multiplayerWorld) {
            return;
        }
        int i1 = world.getBlockMetadata(i, j, k);
        boolean flag = this.canPlace(world, i, j, k);
        if (!flag) {
            this.dropBlockAsItem(world, i, j, k, i1);
            world.setBlockWithNotify(i, j, k, 0);
        } else {
            this.func_280_h(world, i, j, k);
        }
        super.onNeighborBlockChange(world, i, j, k, l);
    }

    public int idDropped(int i, Random random) {
        return Item.red_dust.shiftedIndex;
    }

    public boolean isIndirectlyPoweringTo(World world, int i, int j, int k, int l) {
        if (!this.wiresProvidePower) {
            return false;
        }
        return this.isPoweringTo(world, i, j, k, l);
    }

    public boolean isPoweringTo(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        boolean flag3;
        if (!this.wiresProvidePower) {
            return false;
        }
        if (iblockaccess.getBlockMetadata(i, j, k) == 0) {
            return false;
        }
        if (l == 1) {
            return true;
        }
        boolean flag = BlockRedDustWire.isPowerProviderOrWire(iblockaccess, i - 1, j, k) || !iblockaccess.isBlockNormalCube(i - 1, j, k) && BlockRedDustWire.isPowerProviderOrWire(iblockaccess, i - 1, j - 1, k);
        boolean flag1 = BlockRedDustWire.isPowerProviderOrWire(iblockaccess, i + 1, j, k) || !iblockaccess.isBlockNormalCube(i + 1, j, k) && BlockRedDustWire.isPowerProviderOrWire(iblockaccess, i + 1, j - 1, k);
        boolean flag2 = BlockRedDustWire.isPowerProviderOrWire(iblockaccess, i, j, k - 1) || !iblockaccess.isBlockNormalCube(i, j, k - 1) && BlockRedDustWire.isPowerProviderOrWire(iblockaccess, i, j - 1, k - 1);
        boolean bl = flag3 = BlockRedDustWire.isPowerProviderOrWire(iblockaccess, i, j, k + 1) || !iblockaccess.isBlockNormalCube(i, j, k + 1) && BlockRedDustWire.isPowerProviderOrWire(iblockaccess, i, j - 1, k + 1);
        if (!iblockaccess.isBlockNormalCube(i, j + 1, k)) {
            if (iblockaccess.isBlockNormalCube(i - 1, j, k) && BlockRedDustWire.isPowerProviderOrWire(iblockaccess, i - 1, j + 1, k)) {
                flag = true;
            }
            if (iblockaccess.isBlockNormalCube(i + 1, j, k) && BlockRedDustWire.isPowerProviderOrWire(iblockaccess, i + 1, j + 1, k)) {
                flag1 = true;
            }
            if (iblockaccess.isBlockNormalCube(i, j, k - 1) && BlockRedDustWire.isPowerProviderOrWire(iblockaccess, i, j + 1, k - 1)) {
                flag2 = true;
            }
            if (iblockaccess.isBlockNormalCube(i, j, k + 1) && BlockRedDustWire.isPowerProviderOrWire(iblockaccess, i, j + 1, k + 1)) {
                flag3 = true;
            }
        }
        if (!(flag2 || flag1 || flag || flag3 || l < 2 || l > 5)) {
            return true;
        }
        if (l == 2 && flag2 && !flag && !flag1) {
            return true;
        }
        if (l == 3 && flag3 && !flag && !flag1) {
            return true;
        }
        if (l == 4 && flag && !flag2 && !flag3) {
            return true;
        }
        return l == 5 && flag1 && !flag2 && !flag3;
    }

    public boolean canProvidePower() {
        return this.wiresProvidePower;
    }

    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        if (world.getBlockMetadata(i, j, k) > 0) {
            double d = (double)i + 0.5 + ((double)random.nextFloat() - 0.5) * 0.2;
            double d1 = (float)j + 0.0625f;
            double d2 = (double)k + 0.5 + ((double)random.nextFloat() - 0.5) * 0.2;
            world.spawnParticle("reddust", d, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public static boolean isPowerProviderOrWire(IBlockAccess iblockaccess, int i, int j, int k) {
        int l = iblockaccess.getBlockId(i, j, k);
        if (l == Block.redWire.blockID) {
            return true;
        }
        if (l == 0) {
            return false;
        }
        return Block.allBlocks[l].canProvidePower();
    }
}

