/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.level.tile;

import com.mojang.minecraft.core.entity.Entity;
import com.mojang.minecraft.core.entity.EntityPlayer;
import com.mojang.minecraft.core.entity.item.Item;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.tile.Block;
import com.mojang.minecraft.core.level.tile.material.Material;
import java.util.Random;

public class BlockRedOre
extends Block {
    private boolean field_468_a;

    public BlockRedOre(int i, int j, boolean flag) {
        super(i, j, Material.rock);
        if (flag) {
            this.setTickOnLoad(true);
        }
        this.field_468_a = flag;
    }

    public int tickRate() {
        return 30;
    }

    public void onBlockClicked(World world, int i, int j, int k, EntityPlayer entityplayer) {
        this.func_320_h(world, i, j, k);
        super.onBlockClicked(world, i, j, k, entityplayer);
    }

    public void onEntityWalking(World world, int i, int j, int k, Entity entity) {
        this.func_320_h(world, i, j, k);
        super.onEntityWalking(world, i, j, k, entity);
    }

    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        this.func_320_h(world, i, j, k);
        return super.blockActivated(world, i, j, k, entityplayer);
    }

    private void func_320_h(World world, int i, int j, int k) {
        this.func_319_i(world, i, j, k);
        if (this.blockID == Block.oreRed.blockID) {
            world.setBlockWithNotify(i, j, k, Block.oreRedGlowing.blockID);
        }
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
        if (this.blockID == Block.oreRedGlowing.blockID) {
            world.setBlockWithNotify(i, j, k, Block.oreRed.blockID);
        }
    }

    public int idDropped(int i, Random random) {
        return Item.red_dust.shiftedIndex;
    }

    public int quantityDropped(Random random) {
        return 4 + random.nextInt(2);
    }

    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        if (this.field_468_a) {
            this.func_319_i(world, i, j, k);
        }
    }

    private void func_319_i(World world, int i, int j, int k) {
        Random random = world.rand;
        double d = 0.0625;
        int l = 0;
        while (l < 6) {
            double d1 = (float)i + random.nextFloat();
            double d2 = (float)j + random.nextFloat();
            double d3 = (float)k + random.nextFloat();
            if (l == 0 && !world.isBlockNormalCube(i, j + 1, k)) {
                d2 = (double)(j + 1) + d;
            }
            if (l == 1 && !world.isBlockNormalCube(i, j - 1, k)) {
                d2 = (double)(j + 0) - d;
            }
            if (l == 2 && !world.isBlockNormalCube(i, j, k + 1)) {
                d3 = (double)(k + 1) + d;
            }
            if (l == 3 && !world.isBlockNormalCube(i, j, k - 1)) {
                d3 = (double)(k + 0) - d;
            }
            if (l == 4 && !world.isBlockNormalCube(i + 1, j, k)) {
                d1 = (double)(i + 1) + d;
            }
            if (l == 5 && !world.isBlockNormalCube(i - 1, j, k)) {
                d1 = (double)(i + 0) - d;
            }
            if (d1 < (double)i || d1 > (double)(i + 1) || d2 < 0.0 || d2 > (double)(j + 1) || d3 < (double)k || d3 > (double)(k + 1)) {
                world.spawnParticle("reddust", d1, d2, d3, 0.0, 0.0, 0.0);
            }
            ++l;
        }
    }
}

