/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.level.tile;

import com.mojang.minecraft.core.entity.tile.IBlockAccess;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.tile.Block;
import com.mojang.minecraft.core.level.tile.BlockTorch;
import com.mojang.minecraft.core.level.tile.RedPowerUpdateInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class BlockRedTorch
extends BlockTorch {
    private boolean torchActive = false;
    private static List<RedPowerUpdateInfo> torchUpdates = new ArrayList<RedPowerUpdateInfo>();

    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        if (i == 1) {
            return Block.redWire.getBlockTextureFromSideAndMetadata(i, j);
        }
        return super.getBlockTextureFromSideAndMetadata(i, j);
    }

    private boolean checkForBurnout(World world, int i, int j, int k, boolean flag) {
        if (flag) {
            torchUpdates.add(new RedPowerUpdateInfo(i, j, k, world.worldTime));
        }
        int l = 0;
        int i1 = 0;
        while (i1 < torchUpdates.size()) {
            RedPowerUpdateInfo redstoneupdateinfo = torchUpdates.get(i1);
            if (redstoneupdateinfo.x == i && redstoneupdateinfo.y == j && redstoneupdateinfo.z == k && ++l >= 8) {
                return true;
            }
            ++i1;
        }
        return false;
    }

    protected BlockRedTorch(int i, int j, boolean flag) {
        super(i, j);
        this.torchActive = flag;
        this.setTickOnLoad(true);
    }

    public int tickRate() {
        return 2;
    }

    public void onBlockAdded(World world, int i, int j, int k) {
        if (world.getBlockMetadata(i, j, k) == 0) {
            super.onBlockAdded(world, i, j, k);
        }
        if (this.torchActive) {
            world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
            world.notifyBlocksOfNeighborChange(i, j + 1, k, this.blockID);
            world.notifyBlocksOfNeighborChange(i - 1, j, k, this.blockID);
            world.notifyBlocksOfNeighborChange(i + 1, j, k, this.blockID);
            world.notifyBlocksOfNeighborChange(i, j, k - 1, this.blockID);
            world.notifyBlocksOfNeighborChange(i, j, k + 1, this.blockID);
        }
    }

    public void onBlockRemoval(World world, int i, int j, int k) {
        if (this.torchActive) {
            world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
            world.notifyBlocksOfNeighborChange(i, j + 1, k, this.blockID);
            world.notifyBlocksOfNeighborChange(i - 1, j, k, this.blockID);
            world.notifyBlocksOfNeighborChange(i + 1, j, k, this.blockID);
            world.notifyBlocksOfNeighborChange(i, j, k - 1, this.blockID);
            world.notifyBlocksOfNeighborChange(i, j, k + 1, this.blockID);
        }
    }

    public boolean isPoweringTo(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        if (!this.torchActive) {
            return false;
        }
        int i1 = iblockaccess.getBlockMetadata(i, j, k);
        if (i1 == 5 && l == 1) {
            return false;
        }
        if (i1 == 3 && l == 3) {
            return false;
        }
        if (i1 == 4 && l == 2) {
            return false;
        }
        if (i1 == 1 && l == 5) {
            return false;
        }
        return i1 != 2 || l != 4;
    }

    private boolean func_272_h(World world, int i, int j, int k) {
        int l = world.getBlockMetadata(i, j, k);
        if (l == 5 && world.isBlockIndirectlyProvidingPowerTo(i, j - 1, k, 0)) {
            return true;
        }
        if (l == 3 && world.isBlockIndirectlyProvidingPowerTo(i, j, k - 1, 2)) {
            return true;
        }
        if (l == 4 && world.isBlockIndirectlyProvidingPowerTo(i, j, k + 1, 3)) {
            return true;
        }
        if (l == 1 && world.isBlockIndirectlyProvidingPowerTo(i - 1, j, k, 4)) {
            return true;
        }
        return l == 2 && world.isBlockIndirectlyProvidingPowerTo(i + 1, j, k, 5);
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
        boolean flag = this.func_272_h(world, i, j, k);
        while (torchUpdates.size() > 0 && world.worldTime - BlockRedTorch.torchUpdates.get((int)0).field_1010_d > 100L) {
            torchUpdates.remove(0);
        }
        if (this.torchActive) {
            if (flag) {
                world.setBlockAndMetadataWithNotify(i, j, k, Block.torchRedIdle.blockID, world.getBlockMetadata(i, j, k));
                if (this.checkForBurnout(world, i, j, k, true)) {
                    world.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
                    int l = 0;
                    while (l < 5) {
                        double d = (double)i + random.nextDouble() * 0.6 + 0.2;
                        double d1 = (double)j + random.nextDouble() * 0.6 + 0.2;
                        double d2 = (double)k + random.nextDouble() * 0.6 + 0.2;
                        world.spawnParticle("smoke", d, d1, d2, 0.0, 0.0, 0.0);
                        ++l;
                    }
                }
            }
        } else if (!flag && !this.checkForBurnout(world, i, j, k, false)) {
            world.setBlockAndMetadataWithNotify(i, j, k, Block.torchRedActive.blockID, world.getBlockMetadata(i, j, k));
        }
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        super.onNeighborBlockChange(world, i, j, k, l);
        world.scheduleUpdateTick(i, j, k, this.blockID);
    }

    public boolean isIndirectlyPoweringTo(World world, int i, int j, int k, int l) {
        if (l == 0) {
            return this.isPoweringTo(world, i, j, k, l);
        }
        return false;
    }

    public int idDropped(int i, Random random) {
        return Block.torchRedActive.blockID;
    }

    public boolean canProvidePower() {
        return true;
    }

    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        if (!this.torchActive) {
            return;
        }
        int l = world.getBlockMetadata(i, j, k);
        double d = (double)((float)i + 0.5f) + (double)(random.nextFloat() - 0.5f) * 0.2;
        double d1 = (double)((float)j + 0.7f) + (double)(random.nextFloat() - 0.5f) * 0.2;
        double d2 = (double)((float)k + 0.5f) + (double)(random.nextFloat() - 0.5f) * 0.2;
        double d3 = 0.22f;
        double d4 = 0.27f;
        if (l == 1) {
            world.spawnParticle("reddust", d - d4, d1 + d3, d2, 0.0, 0.0, 0.0);
        } else if (l == 2) {
            world.spawnParticle("reddust", d + d4, d1 + d3, d2, 0.0, 0.0, 0.0);
        } else if (l == 3) {
            world.spawnParticle("reddust", d, d1 + d3, d2 - d4, 0.0, 0.0, 0.0);
        } else if (l == 4) {
            world.spawnParticle("reddust", d, d1 + d3, d2 + d4, 0.0, 0.0, 0.0);
        } else {
            world.spawnParticle("reddust", d, d1, d2, 0.0, 0.0, 0.0);
        }
    }
}

