/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.level.tile;

import com.mojang.minecraft.core.entity.item.Item;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.tile.Block;
import com.mojang.minecraft.core.level.tile.material.Material;
import com.mojang.minecraft.core.level.tile.phys.AxisAlignedBB;
import java.util.Random;

public class BlockReed
extends Block {
    protected BlockReed(int i, int j) {
        super(i, Material.plants);
        this.blockIndexInTexture = j;
        float f = 0.375f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 1.0f, 0.5f + f);
        this.setTickOnLoad(true);
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
        if (world.getBlockId(i, j + 1, k) == 0) {
            int l = 1;
            while (world.getBlockId(i, j - l, k) == this.blockID) {
                ++l;
            }
            if (l < 3) {
                int i1 = world.getBlockMetadata(i, j, k);
                if (i1 == 15) {
                    world.setBlockWithNotify(i, j + 1, k, this.blockID);
                    world.setBlockMetadataWithNotify(i, j, k, 0);
                } else {
                    world.setBlockMetadataWithNotify(i, j, k, i1 + 1);
                }
            }
        }
    }

    public boolean canPlace(World world, int i, int j, int k) {
        int l = world.getBlockId(i, j - 1, k);
        if (l == this.blockID) {
            return true;
        }
        if (l != Block.grass.blockID && l != Block.dirt.blockID) {
            return false;
        }
        Material reedCheckPos1 = world.getMaterialXYZ(i - 1, j - 1, k);
        Material reedCheckPos2 = world.getMaterialXYZ(i + 1, j - 1, k);
        Material reedCheckPos3 = world.getMaterialXYZ(i, j - 1, k - 1);
        Material reedCheckPos4 = world.getMaterialXYZ(i, j - 1, k + 1);
        if (reedCheckPos1 == Material.water || reedCheckPos1 == Material.ice) {
            return true;
        }
        if (reedCheckPos2 == Material.water || reedCheckPos2 == Material.ice) {
            return true;
        }
        if (reedCheckPos3 == Material.water || reedCheckPos3 == Material.ice) {
            return true;
        }
        return reedCheckPos4 == Material.water || reedCheckPos4 == Material.ice;
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        this.func_303_h(world, i, j, k);
    }

    protected final void func_303_h(World world, int i, int j, int k) {
        if (!this.canBlockStay(world, i, j, k)) {
            this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
            world.setBlockWithNotify(i, j, k, 0);
        }
    }

    public boolean canBlockStay(World world, int i, int j, int k) {
        return this.canPlace(world, i, j, k);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return null;
    }

    public int idDropped(int i, Random random) {
        return Item.reed.shiftedIndex;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return 1;
    }
}

