/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.level.tile;

import com.mojang.minecraft.core.entity.item.Item;
import com.mojang.minecraft.core.entity.tile.IBlockAccess;
import com.mojang.minecraft.core.entity.tile.TileEntity;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.tile.BlockContainer;
import com.mojang.minecraft.core.level.tile.material.Material;
import com.mojang.minecraft.core.level.tile.phys.AxisAlignedBB;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockSign
extends BlockContainer {
    private Class<?> field_455_a;
    private boolean field_454_b;

    protected BlockSign(int i, Class<?> class1, boolean flag) {
        super(i, Material.wood);
        this.field_454_b = flag;
        this.blockIndexInTexture = 4;
        this.field_455_a = class1;
        float f = 0.25f;
        float f1 = 1.0f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f1, 0.5f + f);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return null;
    }

    @Override
    public AxisAlignedBB getSelectedCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        this.setBlockBoundsBasedOnState(world, i, j, k);
        return super.getSelectedCollisionBoundingBoxFromPool(world, i, j, k);
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int i, int j, int k) {
        if (this.field_454_b) {
            return;
        }
        int l = iblockaccess.getBlockMetadata(i, j, k);
        float f = 0.28125f;
        float f1 = 0.78125f;
        float f2 = 0.0f;
        float f3 = 1.0f;
        float f4 = 0.125f;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        if (l == 2) {
            this.setBlockBounds(f2, f, 1.0f - f4, f3, f1, 1.0f);
        }
        if (l == 3) {
            this.setBlockBounds(f2, f, 0.0f, f3, f1, f4);
        }
        if (l == 4) {
            this.setBlockBounds(1.0f - f4, f, f2, 1.0f, f1, f3);
        }
        if (l == 5) {
            this.setBlockBounds(0.0f, f, f2, f4, f1, f3);
        }
    }

    @Override
    public int getRenderType() {
        return -1;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    protected TileEntity getBlockEntity() {
        try {
            return (TileEntity)this.field_455_a.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public int idDropped(int i, Random random) {
        return Item.sign.shiftedIndex;
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        boolean flag = false;
        if (this.field_454_b) {
            if (!world.getMaterialXYZ(i, j - 1, k).isSolidMaterial()) {
                flag = true;
            }
        } else {
            int i1 = world.getBlockMetadata(i, j, k);
            flag = true;
            if (i1 == 2 && world.getMaterialXYZ(i, j, k + 1).isSolidMaterial()) {
                flag = false;
            }
            if (i1 == 3 && world.getMaterialXYZ(i, j, k - 1).isSolidMaterial()) {
                flag = false;
            }
            if (i1 == 4 && world.getMaterialXYZ(i + 1, j, k).isSolidMaterial()) {
                flag = false;
            }
            if (i1 == 5 && world.getMaterialXYZ(i - 1, j, k).isSolidMaterial()) {
                flag = false;
            }
        }
        if (flag) {
            this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
            world.setBlockWithNotify(i, j, k, 0);
        }
        super.onNeighborBlockChange(world, i, j, k, l);
    }
}

