/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.level.tile;

import com.mojang.minecraft.core.entity.tile.IBlockAccess;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.tile.Block;
import com.mojang.minecraft.core.level.tile.material.Material;
import com.mojang.minecraft.core.level.tile.phys.AxisAlignedBB;
import java.util.Random;

public class BlockStep
extends Block {
    private boolean isDouble;

    public BlockStep(int i, boolean flag) {
        super(i, 6, Material.rock);
        this.isDouble = flag;
        if (!flag) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        }
        this.setLightOpacity(255);
    }

    public int getTextureIndex(int i) {
        return i > 1 ? 5 : 6;
    }

    public boolean isOpaqueCube() {
        return this.isDouble;
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (this != Block.stepSingle) {
            return;
        }
    }

    public void setBlockBoundsForItemRender() {
        if (this.isDouble) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        }
    }

    public void setBlockBoundsBasedOnState(IBlockAccess iblock, int i, int j, int k) {
        if (this.isDouble) {
            return;
        }
        int orientation = iblock.getBlockMetadata(i, j, k);
        switch (orientation) {
            case 0: {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
                break;
            }
            case 1: {
                this.setBlockBounds(0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 2: {
                this.setBlockBounds(0.0f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 3: {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f);
                break;
            }
            case 4: {
                this.setBlockBounds(0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 5: {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f);
                break;
            }
            default: {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public AxisAlignedBB getSelectedCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        this.setBlockBoundsBasedOnState(world, i, j, k);
        return super.getSelectedCollisionBoundingBoxFromPool(world, i, j, k);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        this.setBlockBoundsBasedOnState(world, i, j, k);
        return super.getCollisionBoundingBoxFromPool(world, i, j, k);
    }

    public void onBlockPlaced(World world, int i, int j, int k, int face) {
        int orientation = world.getBlockMetadata(i, j, k);
        orientation = face;
        if (face == 1) {
            orientation = 0;
        } else if (face == 0) {
            orientation = 1;
        }
        if (world.mc.thePlayer.getIsSneaking()) {
            orientation = 0;
        }
        if (world.mc.thePlayer.isRunning()) {
            orientation = 1;
        }
        world.setBlockMetadataWithNotify(i, j, k, orientation);
    }

    public void onBlockAdded(World world, int i, int j, int k) {
        if (this != Block.stepSingle) {
            super.onBlockAdded(world, i, j, k);
        }
        int l = world.getBlockId(i, j - 1, k);
        int orientation = world.getBlockMetadata(i, j, k);
        int orientationBelow = world.getBlockMetadata(i, j - 1, k);
    }

    public int idDropped(int i, Random random) {
        return Block.stepSingle.blockID;
    }

    public int quantityDropped(Random random) {
        if (!this.isDouble) {
            return 1;
        }
        return 2;
    }

    public boolean renderAsNormalBlock() {
        return this.isDouble;
    }

    public boolean shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int face) {
        boolean checkFromSlab;
        int orientation = world.getBlockMetadata(x, y, z);
        int orientationFrom = 0;
        boolean bl = checkFromSlab = world.getBlockId(x, y, z) == Block.stepSingle.blockID;
        if (this != Block.stepSingle) {
            return super.shouldSideBeRendered(world, x, y, z, face);
        }
        if (checkFromSlab) {
            if (face == 0) {
                orientationFrom = world.getBlockMetadata(x, y + 1, z);
                if (orientationFrom != 0) {
                    return orientation != orientationFrom;
                }
            } else if (face == 1) {
                orientationFrom = world.getBlockMetadata(x, y - 1, z);
                if (orientationFrom != 0) {
                    return orientation != orientationFrom;
                }
            } else if (face == 2) {
                orientationFrom = world.getBlockMetadata(x, y, z - 1);
                if (orientationFrom == 4 || orientationFrom == 5) {
                    return orientation != orientationFrom;
                }
            } else if (face == 3) {
                orientationFrom = world.getBlockMetadata(x, y, z + 1);
                if (orientationFrom == 4 || orientationFrom == 5) {
                    return orientation != orientationFrom;
                }
            } else if (face == 4) {
                orientationFrom = world.getBlockMetadata(x - 1, y, z);
                if (orientationFrom == 2 || orientationFrom == 3) {
                    return orientation != orientationFrom;
                }
            } else if (face == 5 && ((orientationFrom = world.getBlockMetadata(x + 1, y, z)) == 2 || orientationFrom == 3)) {
                return orientation != orientationFrom;
            }
        }
        return super.shouldSideBeRendered(world, x, y, z, face);
    }
}

