/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.level.tile;

import com.mojang.minecraft.client.render.Vec3D;
import com.mojang.minecraft.core.entity.MovingObjectPosition;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.tile.Block;
import com.mojang.minecraft.core.level.tile.material.Material;
import com.mojang.minecraft.core.level.tile.phys.AxisAlignedBB;
import java.util.Random;

public class BlockTorch
extends Block {
    protected BlockTorch(int i, int j) {
        super(i, j, Material.circuits);
        this.setTickOnLoad(true);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return null;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return 2;
    }

    public boolean canPlace(World world, int x, int y, int z) {
        if (world.getBlockId(x, y - 1, z) == Block.fence.blockID || world.getBlockId(x, y - 1, z) == Block.glass.blockID) {
            return true;
        }
        if (world.isBlockNormalCube(x - 1, y, z) || world.getBlockId(x - 1, y, z) == Block.stepSingle.blockID && world.getBlockMetadata(x - 1, y, z) == 4) {
            return true;
        }
        if (world.isBlockNormalCube(x + 1, y, z) || world.getBlockId(x + 1, y, z) == Block.stepSingle.blockID && world.getBlockMetadata(x + 1, y, z) == 5) {
            return true;
        }
        if (world.isBlockNormalCube(x, y, z - 1) || world.getBlockId(x, y, z - 1) == Block.stepSingle.blockID && world.getBlockMetadata(x, y, z - 1) == 2) {
            return true;
        }
        if (world.isBlockNormalCube(x, y, z + 1) || world.getBlockId(x, y, z + 1) == Block.stepSingle.blockID && world.getBlockMetadata(x, y, z + 1) == 3) {
            return true;
        }
        return world.isBlockNormalCube(x, y - 1, z) || world.getBlockId(x, y - 1, z) == Block.stepSingle.blockID && world.getBlockMetadata(x, y - 1, z) == 1;
    }

    public void onBlockPlaced(World world, int x, int y, int z, int face) {
        int orientation = world.getBlockMetadata(x, y, z);
        if (face == 1 && (world.isBlockNormalCube(x, y - 1, z) || world.getBlockId(x, y - 1, z) == Block.fence.blockID || world.getBlockId(x, y - 1, z) == Block.stepSingle.blockID && world.getBlockMetadata(x, y - 1, z) == 1)) {
            orientation = 5;
        }
        if (face == 2 && world.isBlockNormalCube(x, y, z + 1) || world.getBlockId(x, y, z + 1) == Block.stepSingle.blockID && world.getBlockMetadata(x, y, z + 1) == 3) {
            orientation = 4;
        }
        if (face == 3 && world.isBlockNormalCube(x, y, z - 1) || world.getBlockId(x, y, z - 1) == Block.stepSingle.blockID && world.getBlockMetadata(x, y, z - 1) == 2) {
            orientation = 3;
        }
        if (face == 4 && world.isBlockNormalCube(x + 1, y, z) || world.getBlockId(x + 1, y, z) == Block.stepSingle.blockID && world.getBlockMetadata(x + 1, y, z) == 5) {
            orientation = 2;
        }
        if (face == 5 && world.isBlockNormalCube(x - 1, y, z) || world.getBlockId(x - 1, y, z) == Block.stepSingle.blockID && world.getBlockMetadata(x - 1, y, z) == 4) {
            orientation = 1;
        }
        world.setBlockMetadataWithNotify(x, y, z, orientation);
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
        super.updateTick(world, i, j, k, random);
        if (world.getBlockMetadata(i, j, k) == 0) {
            this.onBlockAdded(world, i, j, k);
        }
    }

    public void onBlockAdded(World world, int i, int j, int k) {
        if (world.isBlockNormalCube(i - 1, j, k)) {
            world.setBlockMetadataWithNotify(i, j, k, 1);
        } else if (world.isBlockNormalCube(i + 1, j, k)) {
            world.setBlockMetadataWithNotify(i, j, k, 2);
        } else if (world.isBlockNormalCube(i, j, k - 1)) {
            world.setBlockMetadataWithNotify(i, j, k, 3);
        } else if (world.isBlockNormalCube(i, j, k + 1)) {
            world.setBlockMetadataWithNotify(i, j, k, 4);
        } else if (world.isBlockNormalCube(i, j - 1, k)) {
            world.setBlockMetadataWithNotify(i, j, k, 5);
        }
        this.isInLegalPosition(world, i, j, k);
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, int l) {
        if (this.isInLegalPosition(world, x, y, z)) {
            int i1 = world.getBlockMetadata(x, y, z);
            boolean flag = false;
            if (!(world.isBlockNormalCube(x - 1, y, z) || world.getBlockId(x - 1, y, z) == Block.stepSingle.blockID && world.getBlockMetadata(x - 1, y, z) == 4 || i1 != 1)) {
                flag = true;
            }
            if (!(world.isBlockNormalCube(x + 1, y, z) || world.getBlockId(x + 1, y, z) == Block.stepSingle.blockID && world.getBlockMetadata(x + 1, y, z) == 5 || i1 != 2)) {
                flag = true;
            }
            if (!(world.isBlockNormalCube(x, y, z - 1) || world.getBlockId(x, y, z - 1) == Block.stepSingle.blockID && world.getBlockMetadata(x, y, z - 1) == 2 || i1 != 3)) {
                flag = true;
            }
            if (!(world.isBlockNormalCube(x, y, z + 1) || world.getBlockId(x, y, z + 1) == Block.stepSingle.blockID && world.getBlockMetadata(x, y, z + 1) == 3 || i1 != 4)) {
                flag = true;
            }
            if (!(world.isBlockNormalCube(x, y - 1, z) || world.getBlockId(x, y - 1, z) == Block.stepSingle.blockID && world.getBlockMetadata(x, y - 1, z) == 1 || i1 != 5 || world.getBlockId(x, y - 1, z) == Block.fence.blockID)) {
                flag = true;
            }
            if (flag) {
                this.dropBlockAsItem(world, x, y, z, world.getBlockMetadata(x, y, z));
                world.setBlockWithNotify(x, y, z, 0);
            }
        }
    }

    private boolean isInLegalPosition(World world, int i, int j, int k) {
        if (!this.canPlace(world, i, j, k)) {
            this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
            world.setBlockWithNotify(i, j, k, 0);
            return false;
        }
        return true;
    }

    public MovingObjectPosition collisionRayTrace(World world, int i, int j, int k, Vec3D vec3d, Vec3D vec3d1) {
        int l = world.getBlockMetadata(i, j, k) & 7;
        float f = 0.15f;
        if (l == 1) {
            this.setBlockBounds(0.0f, 0.2f, 0.5f - f, f * 2.0f, 0.8f, 0.5f + f);
        } else if (l == 2) {
            this.setBlockBounds(1.0f - f * 2.0f, 0.2f, 0.5f - f, 1.0f, 0.8f, 0.5f + f);
        } else if (l == 3) {
            this.setBlockBounds(0.5f - f, 0.2f, 0.0f, 0.5f + f, 0.8f, f * 2.0f);
        } else if (l == 4) {
            this.setBlockBounds(0.5f - f, 0.2f, 1.0f - f * 2.0f, 0.5f + f, 0.8f, 1.0f);
        } else {
            float f1 = 0.1f;
            this.setBlockBounds(0.5f - f1, 0.0f, 0.5f - f1, 0.5f + f1, 0.6f, 0.5f + f1);
        }
        return super.collisionRayTrace(world, i, j, k, vec3d, vec3d1);
    }

    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        int l = world.getBlockMetadata(i, j, k);
        double d = (float)i + 0.5f;
        double d1 = (float)j + 0.7f;
        double d2 = (float)k + 0.5f;
        double d3 = 0.22f;
        double d4 = 0.27f;
        if (l == 1) {
            world.spawnParticle("smoke", d - d4, d1 + d3, d2, 0.0, 0.0, 0.0);
            world.spawnParticle("flame", d - d4, d1 + d3, d2, 0.0, 0.0, 0.0);
        } else if (l == 2) {
            world.spawnParticle("smoke", d + d4, d1 + d3, d2, 0.0, 0.0, 0.0);
            world.spawnParticle("flame", d + d4, d1 + d3, d2, 0.0, 0.0, 0.0);
        } else if (l == 3) {
            world.spawnParticle("smoke", d, d1 + d3, d2 - d4, 0.0, 0.0, 0.0);
            world.spawnParticle("flame", d, d1 + d3, d2 - d4, 0.0, 0.0, 0.0);
        } else if (l == 4) {
            world.spawnParticle("smoke", d, d1 + d3, d2 + d4, 0.0, 0.0, 0.0);
            world.spawnParticle("flame", d, d1 + d3, d2 + d4, 0.0, 0.0, 0.0);
        } else {
            world.spawnParticle("smoke", d, d1, d2, 0.0, 0.0, 0.0);
            world.spawnParticle("flame", d, d1, d2, 0.0, 0.0, 0.0);
        }
    }
}

