/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.nbt;

import com.mojang.minecraft.core.nbt.NBTBase;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class NBTTagList
extends NBTBase {
    private List<NBTBase> tagList = new ArrayList<NBTBase>();
    private byte tagType;

    void writeTagContents(DataOutput dataoutput) throws IOException {
        this.tagType = this.tagList.size() > 0 ? this.tagList.get(0).getType() : (byte)1;
        dataoutput.writeByte(this.tagType);
        dataoutput.writeInt(this.tagList.size());
        int i = 0;
        while (i < this.tagList.size()) {
            this.tagList.get(i).writeTagContents(dataoutput);
            ++i;
        }
    }

    void readTagContents(DataInput datainput) throws IOException {
        this.tagType = datainput.readByte();
        int i = datainput.readInt();
        this.tagList = new ArrayList<NBTBase>();
        int j = 0;
        while (j < i) {
            NBTBase nbtbase = NBTBase.createTagOfType(this.tagType);
            nbtbase.readTagContents(datainput);
            this.tagList.add(nbtbase);
            ++j;
        }
    }

    public byte getType() {
        return 9;
    }

    public String toString() {
        return "" + this.tagList.size() + " entries of type " + NBTBase.getTagName(this.tagType);
    }

    public void setTag(NBTBase nbtbase) {
        this.tagType = nbtbase.getType();
        this.tagList.add(nbtbase);
    }

    public NBTBase tagAt(int i) {
        return this.tagList.get(i);
    }

    public int tagCount() {
        return this.tagList.size();
    }
}

