/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.player.inventory;

import com.mojang.minecraft.core.crafting.CraftingManager;
import com.mojang.minecraft.core.entity.EntityPlayer;
import com.mojang.minecraft.core.entity.item.IInventory;
import com.mojang.minecraft.core.entity.item.ItemStack;
import com.mojang.minecraft.core.player.inventory.Container;
import com.mojang.minecraft.core.player.inventory.InventoryCraftResult;
import com.mojang.minecraft.core.player.inventory.InventoryCrafting;
import com.mojang.minecraft.core.player.inventory.InventoryPlayer;
import com.mojang.minecraft.core.player.inventory.Slot;
import com.mojang.minecraft.core.player.inventory.SlotArmor;
import com.mojang.minecraft.core.player.inventory.SlotCrafting;

public class ContainerPlayer
extends Container {
    public InventoryCrafting craftMatrix = new InventoryCrafting(this, 2, 2);
    public IInventory craftResult = new InventoryCraftResult();
    public boolean isSinglePlayer = false;

    public ContainerPlayer(InventoryPlayer inventoryplayer) {
        this(inventoryplayer, true);
    }

    public ContainerPlayer(InventoryPlayer inventoryplayer, boolean flag) {
        this.isSinglePlayer = flag;
        this.addSlot(new SlotCrafting(inventoryplayer.player, this.craftMatrix, this.craftResult, 0, 144, 36));
        int y = 0;
        while (y < 2) {
            int x = 0;
            while (x < 2) {
                this.addSlot(new Slot(this.craftMatrix, x + y * 2, 88 + x * 18, 26 + y * 18));
                ++x;
            }
            ++y;
        }
        int armorIndex = 0;
        while (armorIndex < 4) {
            int article = armorIndex;
            if (!this.isSinglePlayer || !inventoryplayer.player.worldObj.justLoaded) {
                this.addSlot(new SlotArmor(this, inventoryplayer, inventoryplayer.getSizeInventory() - 1 - armorIndex, 8, 8 + armorIndex * 18, article));
            } else {
                this.addSlot(new SlotArmor(this, inventoryplayer, inventoryplayer.getSizeInventory() - 2 - armorIndex, 8, 8 + armorIndex * 18, article));
            }
            ++armorIndex;
        }
        int inventoryRow = 0;
        while (inventoryRow < 3) {
            int inventorySlot = 0;
            while (inventorySlot < 9) {
                this.addSlot(new Slot(inventoryplayer, inventorySlot + (inventoryRow + 1) * 9, 8 + inventorySlot * 18, 84 + inventoryRow * 18));
                ++inventorySlot;
            }
            ++inventoryRow;
        }
        int hotbarSlot = 0;
        while (hotbarSlot < 9) {
            this.addSlot(new Slot(inventoryplayer, hotbarSlot, 8 + hotbarSlot * 18, 142));
            ++hotbarSlot;
        }
        this.onCraftMatrixChanged(this.craftMatrix);
    }

    public void onCraftMatrixChanged(IInventory iinventory) {
        this.craftResult.setInventorySlotContents(0, CraftingManager.getInstance().findMatchingRecipe(this.craftMatrix));
    }

    public void onCraftGuiClosed(EntityPlayer entityplayer) {
        super.onCraftGuiClosed(entityplayer);
    }

    public boolean isUsableByPlayer(EntityPlayer entityplayer) {
        return true;
    }

    public ItemStack getStackInSlot(int i) {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.slots.get(i);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemstack1 = slot.getStack();
            itemstack = itemstack1.copy();
            if (i == 0) {
                this.func_28125_a(itemstack1, 9, 45, true);
            } else if (i >= 9 && i < 36) {
                this.func_28125_a(itemstack1, 36, 45, false);
            } else if (i >= 36 && i < 45) {
                this.func_28125_a(itemstack1, 9, 36, false);
            } else {
                this.func_28125_a(itemstack1, 9, 45, false);
            }
            if (itemstack1.stackSize == 0) {
                slot.putStack(null);
            } else {
                slot.onSlotChanged();
            }
            if (itemstack1.stackSize != itemstack.stackSize) {
                slot.onPickupFromSlot(itemstack1);
            } else {
                return null;
            }
        }
        return itemstack;
    }
}

