/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.util;

import com.mojang.minecraft.client.Minecraft;
import java.util.ArrayList;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;

public class ThreadDisplayMode
extends Thread {
    ArrayList<DisplayMode> Resolutions = new ArrayList();
    ArrayList<String> threadModes;
    final Minecraft mc;
    final boolean force;

    public ThreadDisplayMode(Minecraft minecraft, boolean shouldForce) {
        this.mc = minecraft;
        this.force = shouldForce;
        this.threadModes = this.mc.options.Modes;
        this.setName("Display mode thread");
        this.setDaemon(true);
        this.start();
    }

    public void run() {
        if (this.threadModes != null && this.threadModes.size() > this.mc.options.displayMode && !this.force) {
            return;
        }
        this.Resolutions = new ArrayList();
        this.threadModes = new ArrayList();
        this.threadModes.add("Display: DEFAULT");
        try {
            System.out.println("Getting Available Display Modes");
            DisplayMode[] modes = Display.getAvailableDisplayModes();
            int i = 0;
            while (i < modes.length) {
                DisplayMode current = modes[i];
                this.Resolutions.add(current);
                ++i;
            }
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
        int i = 0;
        for (DisplayMode mode : this.Resolutions) {
            this.threadModes.add("Display: " + mode.getWidth() + "x" + mode.getHeight() + "x" + mode.getBitsPerPixel() + " " + mode.getFrequency() + "Hz");
            ++i;
        }
        this.mc.options.setDisplayModes(this.threadModes);
        System.out.println("Display Modes Loaded");
    }
}

