/*
 * Decompiled with CFR 0.152.
 */
package paulscode2.sound.codecs;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import java.nio.ByteOrder;
import javax.sound.sampled.AudioFormat;
import paulscode.sound.ICodec;
import paulscode.sound.SoundBuffer;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemLogger;

public class CodecJOrbis
implements ICodec {
    private static final boolean GET = false;
    private static final boolean SET = true;
    private static final boolean XXX = false;
    protected URL url;
    protected URLConnection urlConnection = null;
    private InputStream inputStream;
    private AudioFormat audioFormat;
    private boolean endOfStream = false;
    private boolean initialized = false;
    private byte[] buffer = null;
    private int bufferSize;
    private int count = 0;
    private int index = 0;
    private int convertedBufferSize;
    private float[][][] pcmInfo;
    private int[] pcmIndex;
    private Packet joggPacket = new Packet();
    private Page joggPage = new Page();
    private StreamState joggStreamState = new StreamState();
    private SyncState joggSyncState = new SyncState();
    private DspState jorbisDspState = new DspState();
    private Block jorbisBlock = new Block(this.jorbisDspState);
    private Comment jorbisComment = new Comment();
    private Info jorbisInfo = new Info();
    private SoundSystemLogger logger = SoundSystemConfig.getLogger();
    private static final boolean LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;

    public void reverseByteOrder(boolean b) {
    }

    public boolean initialize(URL url) {
        this.initialized(true, false);
        if (this.joggStreamState != null) {
            this.joggStreamState.clear();
        }
        if (this.jorbisBlock != null) {
            this.jorbisBlock.clear();
        }
        if (this.jorbisDspState != null) {
            this.jorbisDspState.clear();
        }
        if (this.jorbisInfo != null) {
            this.jorbisInfo.clear();
        }
        if (this.joggSyncState != null) {
            this.joggSyncState.clear();
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.url = url;
        this.bufferSize = SoundSystemConfig.getStreamingBufferSize() / 2;
        this.buffer = null;
        this.count = 0;
        this.index = 0;
        this.joggStreamState = new StreamState();
        this.jorbisBlock = new Block(this.jorbisDspState);
        this.jorbisDspState = new DspState();
        this.jorbisInfo = new Info();
        this.joggSyncState = new SyncState();
        try {
            this.urlConnection = url.openConnection();
        }
        catch (UnknownServiceException ex) {
            this.errorMessage("Unable to create a UrlConnection in method 'initialize'.");
            this.printStackTrace(ex);
            this.cleanup();
            return false;
        }
        catch (IOException ex2) {
            this.errorMessage("Unable to create a UrlConnection in method 'initialize'.");
            this.printStackTrace(ex2);
            this.cleanup();
            return false;
        }
        if (this.urlConnection != null) {
            try {
                this.inputStream = this.openInputStream();
            }
            catch (IOException ex3) {
                this.errorMessage("Unable to acquire inputstream in method 'initialize'.");
                this.printStackTrace(ex3);
                this.cleanup();
                return false;
            }
        }
        this.endOfStream(true, false);
        this.joggSyncState.init();
        this.joggSyncState.buffer(this.bufferSize);
        this.buffer = this.joggSyncState.data;
        try {
            if (!this.readHeader()) {
                this.errorMessage("Error reading the header");
                return false;
            }
        }
        catch (IOException ex5) {
            this.errorMessage("Error reading the header");
            return false;
        }
        this.convertedBufferSize = this.bufferSize * 2;
        this.jorbisDspState.synthesis_init(this.jorbisInfo);
        this.jorbisBlock.init(this.jorbisDspState);
        this.audioFormat = new AudioFormat(this.jorbisInfo.rate, 16, this.jorbisInfo.channels, true, false);
        this.pcmInfo = new float[1][][];
        this.pcmIndex = new int[this.jorbisInfo.channels];
        this.initialized(true, true);
        return true;
    }

    protected InputStream openInputStream() throws IOException {
        return this.urlConnection.getInputStream();
    }

    public boolean initialized() {
        return this.initialized(false, false);
    }

    public SoundBuffer read() {
        byte[] bytes = this.readBytes();
        if (bytes == null) {
            return null;
        }
        return new SoundBuffer(bytes, this.audioFormat);
    }

    public SoundBuffer readAll() {
        byte[] array = this.readBytes();
        while (!this.endOfStream(false, false)) {
            if ((array = CodecJOrbis.appendByteArrays(array, this.readBytes())) != null && array.length >= SoundSystemConfig.getMaxFileSize()) break;
        }
        return new SoundBuffer(array, this.audioFormat);
    }

    public boolean endOfStream() {
        return this.endOfStream(false, false);
    }

    public void cleanup() {
        this.joggStreamState.clear();
        this.jorbisBlock.clear();
        this.jorbisDspState.clear();
        this.jorbisInfo.clear();
        this.joggSyncState.clear();
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.joggStreamState = null;
        this.jorbisBlock = null;
        this.jorbisDspState = null;
        this.jorbisInfo = null;
        this.joggSyncState = null;
        this.inputStream = null;
    }

    public AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    /*
     * Unable to fully structure code
     */
    private boolean readHeader() throws IOException {
        block13: {
            this.index = this.joggSyncState.buffer(this.bufferSize);
            read = this.inputStream.read(this.joggSyncState.data, this.index, this.bufferSize);
            if (read < 0) {
                read = 0;
            }
            this.joggSyncState.wrote(read);
            if (this.joggSyncState.pageout(this.joggPage) != 1) {
                if (read < this.bufferSize) {
                    return true;
                }
                this.errorMessage("Ogg header not recognized in method 'readHeader'.");
                return false;
            }
            this.joggStreamState.init(this.joggPage.serialno());
            this.jorbisInfo.init();
            this.jorbisComment.init();
            if (this.joggStreamState.pagein(this.joggPage) < 0) {
                this.errorMessage("Problem with first Ogg header page in method 'readHeader'.");
                return false;
            }
            if (this.joggStreamState.packetout(this.joggPacket) != 1) {
                this.errorMessage("Problem with first Ogg header packet in method 'readHeader'.");
                return false;
            }
            if (this.jorbisInfo.synthesis_headerin(this.jorbisComment, this.joggPacket) < 0) {
                this.errorMessage("File does not contain Vorbis header in method 'readHeader'.");
                return false;
            }
            i = 0;
            break block13;
            while ((pageout = this.joggSyncState.pageout(this.joggPage)) != 0) {
                if (pageout == 1) {
                    this.joggStreamState.pagein(this.joggPage);
                    while (i < 2) {
                        packetout = this.joggStreamState.packetout(this.joggPacket);
                        if (packetout == 0) break;
                        if (packetout == -1) {
                            this.errorMessage("Secondary Ogg header corrupt in method 'readHeader'.");
                            return false;
                        }
                        this.jorbisInfo.synthesis_headerin(this.jorbisComment, this.joggPacket);
                        ++i;
                    }
                }
lbl40:
                // 5 sources

                ** while (i >= 2)
lbl41:
                // 1 sources

            }
lbl42:
            // 2 sources

            this.index = this.joggSyncState.buffer(this.bufferSize);
            read2 = this.inputStream.read(this.joggSyncState.data, this.index, this.bufferSize);
            if (read2 < 0) {
                read2 = 0;
            }
            if (read2 == 0 && i < 2) {
                this.errorMessage("End of file reached before finished readingOgg header in method 'readHeader'");
                return false;
            }
            this.joggSyncState.wrote(read2);
        }
        if (i < 2) ** GOTO lbl40
        this.index = this.joggSyncState.buffer(this.bufferSize);
        this.buffer = this.joggSyncState.data;
        return true;
    }

    private byte[] readBytes() {
        if (!this.initialized(false, false)) {
            return null;
        }
        if (this.endOfStream(false, false)) {
            return null;
        }
        byte[] appendByteArrays = null;
        switch (this.joggSyncState.pageout(this.joggPage)) {
            case -1: 
            case 0: {
                this.endOfStream(true, true);
                break;
            }
            case 1: {
                this.joggStreamState.pagein(this.joggPage);
                if (this.joggPage.granulepos() == 0L) {
                    this.endOfStream(true, true);
                    break;
                }
                block10: while (true) {
                    switch (this.joggStreamState.packetout(this.joggPacket)) {
                        case -1: 
                        case 0: {
                            break block10;
                        }
                        case 1: {
                            appendByteArrays = CodecJOrbis.appendByteArrays(appendByteArrays, this.decodeCurrentPacket());
                        }
                        default: {
                            continue block10;
                        }
                    }
                    break;
                }
                if (this.joggPage.eos() == 0) break;
                this.endOfStream(true, true);
            }
        }
        if (!this.endOfStream(false, false)) {
            this.index = this.joggSyncState.buffer(this.bufferSize);
            if (this.index == -1) {
                this.endOfStream(true, true);
            } else {
                this.buffer = this.joggSyncState.data;
                try {
                    this.count = this.inputStream.read(this.buffer, this.index, this.bufferSize);
                }
                catch (Exception ex) {
                    this.printStackTrace(ex);
                    return appendByteArrays;
                }
                this.joggSyncState.wrote(this.count);
                if (this.count == 0) {
                    this.endOfStream(true, true);
                }
            }
        }
        return appendByteArrays;
    }

    private byte[] decodeCurrentPacket() {
        int synthesis_pcmout;
        byte[] array = new byte[this.convertedBufferSize];
        if (this.jorbisBlock.synthesis(this.joggPacket) == 0) {
            this.jorbisDspState.synthesis_blockin(this.jorbisBlock);
        }
        int n = this.convertedBufferSize / (this.jorbisInfo.channels * 2);
        int n2 = 0;
        while (n2 < this.convertedBufferSize && (synthesis_pcmout = this.jorbisDspState.synthesis_pcmout(this.pcmInfo, this.pcmIndex)) > 0) {
            int n3 = synthesis_pcmout < n ? synthesis_pcmout : n;
            int i = 0;
            while (i < this.jorbisInfo.channels) {
                int n4 = i * 2;
                int j = 0;
                while (j < n3) {
                    int n5 = (int)(this.pcmInfo[0][i][this.pcmIndex[i] + j] * 32767.0f);
                    if (n5 > Short.MAX_VALUE) {
                        n5 = Short.MAX_VALUE;
                    }
                    if (n5 < Short.MIN_VALUE) {
                        n5 = Short.MIN_VALUE;
                    }
                    if (n5 < 0) {
                        n5 |= 0x8000;
                    }
                    if (LITTLE_ENDIAN) {
                        array[n2 + n4] = (byte)n5;
                        array[n2 + n4 + 1] = (byte)(n5 >>> 8);
                    } else {
                        array[n2 + n4 + 1] = (byte)n5;
                        array[n2 + n4] = (byte)(n5 >>> 8);
                    }
                    n4 += 2 * this.jorbisInfo.channels;
                    ++j;
                }
                ++i;
            }
            n2 += n3 * this.jorbisInfo.channels * 2;
            this.jorbisDspState.synthesis_read(n3);
        }
        return CodecJOrbis.trimArray(array, n2);
    }

    private synchronized boolean initialized(boolean b, boolean initialized) {
        if (b) {
            this.initialized = initialized;
        }
        return this.initialized;
    }

    private synchronized boolean endOfStream(boolean b, boolean endOfStream) {
        if (b) {
            this.endOfStream = endOfStream;
        }
        return this.endOfStream;
    }

    private static byte[] trimArray(byte[] array, int n) {
        byte[] o = null;
        if (array != null && array.length > n) {
            o = new byte[n];
            System.arraycopy(array, 0, o, 0, n);
        }
        return o;
    }

    private static byte[] appendByteArrays(byte[] array, byte[] array2) {
        byte[] array3;
        if (array == null && array2 == null) {
            return null;
        }
        if (array == null) {
            array3 = new byte[array2.length];
            System.arraycopy(array2, 0, array3, 0, array2.length);
        } else if (array2 == null) {
            array3 = new byte[array.length];
            System.arraycopy(array, 0, array3, 0, array.length);
        } else {
            array3 = new byte[array.length + array2.length];
            System.arraycopy(array, 0, array3, 0, array.length);
            System.arraycopy(array2, 0, array3, array.length, array2.length);
        }
        return array3;
    }

    private void errorMessage(String s) {
        this.logger.errorMessage("CodecJOrbis", s, 0);
    }

    private void printStackTrace(Exception ex) {
        this.logger.printStackTrace(ex, 1);
    }
}

