/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityLightningBolt;
import com.mojang.minecraft.entity.EntityList;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockFluid;
import com.mojang.minecraft.level.tile.StepSound;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.nbt.NBTTagDouble;
import com.mojang.minecraft.nbt.NBTTagFloat;
import com.mojang.minecraft.nbt.NBTTagInt;
import com.mojang.minecraft.nbt.NBTTagList;
import com.mojang.minecraft.network.DataWatcher;
import com.mojang.minecraft.render.Vec3D;
import com.mojang.minecraft.util.MathHelper;
import java.util.List;
import java.util.Random;

public abstract class Entity {
    private static int nextEntityID = 0;
    public int entityId;
    public double renderDistanceWeight = 1.0;
    public boolean preventEntitySpawning = false;
    public Entity riddenByEntity;
    public Entity ridingEntity;
    public World worldObj;
    public double prevPosX;
    public double prevPosY;
    public double prevPosZ;
    public double posX;
    public double posY;
    public double posZ;
    public double motionX;
    public double motionY;
    public double motionZ;
    public float rotationYaw;
    public float rotationPitch;
    public float prevRotationYaw;
    public float prevRotationPitch;
    public final AxisAlignedBB boundingBox = AxisAlignedBB.getBoundingBox(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public boolean onGround = false;
    public boolean isCollidedHorizontally;
    public boolean isCollidedVertically;
    public boolean isCollided = false;
    public boolean beenAttacked = false;
    public boolean isInWeb;
    public boolean field_9077_F = true;
    public boolean isDead = false;
    public float yOffset = 0.0f;
    public float width = 0.6f;
    public float height = 1.8f;
    public float prevDistanceWalkedModified = 0.0f;
    public float distanceWalkedModified = 0.0f;
    protected boolean field_640_aG = true;
    protected float fallDistance = 0.0f;
    private int nextStepDistance = 1;
    public double lastTickPosX;
    public double lastTickPosY;
    public double lastTickPosZ;
    public float ySize = 0.0f;
    public float stepHeight = 0.0f;
    public boolean noClip = false;
    public float entityCollisionReduction = 0.0f;
    protected Random rand;
    public int ticksExisted = 0;
    public int fireResistance = 1;
    public int fire = 0;
    protected int maxAir = 300;
    protected boolean inWater = false;
    public int field_9083_ac = 0;
    public int air = 300;
    private boolean firstUpdate = true;
    protected boolean isImmuneToFire = false;
    protected DataWatcher dataWatcher;
    public float field_31001_bF = 0.0f;
    private double entityRiderPitchDelta;
    private double entityRiderYawDelta;
    public boolean addedToChunk = false;
    public int chunkCoordX;
    public int chunkCoordY;
    public int chunkCoordZ;
    public boolean field_28008_bI;
    int leatherArmor;
    public int steelArmor;
    public int diamondArmor;
    public int chainArmor;
    public int goldArmor;

    public Entity(World world) {
        this.entityId = nextEntityID++;
        this.rand = new Random();
        this.dataWatcher = new DataWatcher();
        this.worldObj = world;
        this.setPosition(0.0, 0.0, 0.0);
        this.dataWatcher.addObject(0, (byte)0);
        this.leatherArmor = 0;
        this.entityInit();
    }

    protected abstract void entityInit();

    public DataWatcher getDataWatcher() {
        return this.dataWatcher;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Entity) {
            return ((Entity)obj).entityId == this.entityId;
        }
        return false;
    }

    public int hashCode() {
        return this.entityId;
    }

    public void setEntityDead() {
        this.isDead = true;
    }

    protected void setSize(float f, float f1) {
        this.width = f;
        this.height = f1;
    }

    protected void setRotation(float f, float f1) {
        this.rotationYaw = f % 360.0f;
        this.rotationPitch = f1 % 360.0f;
    }

    public void setPosition(double d, double d1, double d2) {
        this.posX = d;
        this.posY = d1;
        this.posZ = d2;
        float f = this.width / 2.0f;
        float f1 = this.height;
        this.boundingBox.setBounds(d - (double)f, d1 - (double)this.yOffset + (double)this.ySize, d2 - (double)f, d + (double)f, d1 - (double)this.yOffset + (double)this.ySize + (double)f1, d2 + (double)f);
    }

    public void onUpdate() {
        this.onEntityUpdate();
    }

    public void onEntityUpdate() {
        if (this.ridingEntity != null && this.ridingEntity.isDead) {
            this.ridingEntity = null;
        }
        ++this.ticksExisted;
        this.prevDistanceWalkedModified = this.distanceWalkedModified;
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.prevRotationPitch = this.rotationPitch;
        this.prevRotationYaw = this.rotationYaw;
        if (this.handleWaterMovement()) {
            if (!this.inWater && !this.firstUpdate) {
                float f = MathHelper.sqrt_double(this.motionX * this.motionX * (double)0.2f + this.motionY * this.motionY + this.motionZ * this.motionZ * (double)0.2f) * 0.2f;
                if (f > 1.0f) {
                    f = 1.0f;
                }
                this.worldObj.playSoundAtEntity(this, "random.splash", f, 1.0f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.4f);
                float f1 = MathHelper.floor_double(this.boundingBox.minY);
                int i = 0;
                while ((float)i < 1.0f + this.width * 20.0f) {
                    float f2 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    float f4 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    this.worldObj.spawnParticle("bubble", this.posX + (double)f2, f1 + 1.0f, this.posZ + (double)f4, this.motionX, this.motionY - (double)(this.rand.nextFloat() * 0.2f), this.motionZ);
                    ++i;
                }
                int j = 0;
                while ((float)j < 1.0f + this.width * 20.0f) {
                    float f3 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    float f5 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    this.worldObj.spawnParticle("splash", this.posX + (double)f3, f1 + 1.0f, this.posZ + (double)f5, this.motionX, this.motionY, this.motionZ);
                    ++j;
                }
            }
            this.fallDistance = 0.0f;
            this.inWater = true;
            this.fire = 0;
        } else {
            this.inWater = false;
        }
        if (this.worldObj.singleplayerWorld) {
            this.fire = 0;
        } else if (this.fire > 0) {
            if (this.leatherArmor == 0) {
                if (this.fire % 20 == 0) {
                    this.attackEntityFrom(null, 1);
                }
            } else if (this.leatherArmor == 1) {
                if (this.fire % 30 == 0) {
                    this.attackEntityFrom(null, 1);
                }
            } else if (this.leatherArmor == 2) {
                if (this.fire % 40 == 0) {
                    this.attackEntityFrom(null, 1);
                }
            } else if (this.leatherArmor == 3) {
                if (this.fire % 50 == 0) {
                    this.attackEntityFrom(null, 1);
                }
            } else if (this.leatherArmor == 4 && this.fire % 60 == 0) {
                this.attackEntityFrom(null, 1);
            }
            --this.fire;
        }
        if (this.handleLavaMovement()) {
            this.setOnFireFromLava();
        }
        if (this.posY < -64.0) {
            this.kill();
        }
        if (!this.worldObj.singleplayerWorld) {
            this.setFlag(0, this.fire > 0);
            this.setFlag(2, this.ridingEntity != null);
        }
        this.firstUpdate = false;
    }

    protected void setOnFireFromLava() {
        if (!this.isImmuneToFire) {
            this.attackEntityFrom(null, 10 - this.leatherArmor * 2);
            this.fire = 600;
        }
    }

    protected void kill() {
        this.setEntityDead();
    }

    public boolean isOffsetPositionInLiquid(double d, double d1, double d2) {
        AxisAlignedBB axisalignedbb = this.boundingBox.getOffsetBoundingBox(d, d1, d2);
        List list = this.worldObj.getCollidingBoundingBoxes(this, axisalignedbb);
        if (list.size() > 0) {
            return false;
        }
        return !this.worldObj.getIsAnyLiquid(axisalignedbb);
    }

    public void moveEntity(double d, double d1, double d2) {
        int i4;
        int l3;
        int k3;
        int i2;
        int k1;
        int i1;
        boolean flag;
        if (this.noClip) {
            this.boundingBox.offset(d, d1, d2);
            this.posX = (this.boundingBox.minX + this.boundingBox.maxX) / 2.0;
            this.posY = this.boundingBox.minY + (double)this.yOffset - (double)this.ySize;
            this.posZ = (this.boundingBox.minZ + this.boundingBox.maxZ) / 2.0;
            return;
        }
        this.ySize *= 0.4f;
        double d3 = this.posX;
        double d4 = this.posZ;
        if (this.isInWeb) {
            this.isInWeb = false;
            d *= 0.25;
            d1 *= (double)0.05f;
            d2 *= 0.25;
            this.motionX = 0.0;
            this.motionY = 0.0;
            this.motionZ = 0.0;
        }
        double d5 = d;
        double d6 = d1;
        double d7 = d2;
        AxisAlignedBB axisalignedbb = this.boundingBox.copy();
        boolean bl = flag = this.onGround && this.isSneaking();
        if (flag) {
            double d8 = 0.05;
            while (d != 0.0 && this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox.getOffsetBoundingBox(d, -1.0, 0.0)).size() == 0) {
                d = d < d8 && d >= -d8 ? 0.0 : (d > 0.0 ? (d -= d8) : (d += d8));
                d5 = d;
            }
            while (d2 != 0.0 && this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox.getOffsetBoundingBox(0.0, -1.0, d2)).size() == 0) {
                d2 = d2 < d8 && d2 >= -d8 ? 0.0 : (d2 > 0.0 ? (d2 -= d8) : (d2 += d8));
                d7 = d2;
            }
        }
        List list = this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox.addCoord(d, d1, d2));
        int i = 0;
        while (i < list.size()) {
            d1 = ((AxisAlignedBB)list.get(i)).calculateYOffset(this.boundingBox, d1);
            ++i;
        }
        this.boundingBox.offset(0.0, d1, 0.0);
        if (!this.field_9077_F && d6 != d1) {
            d2 = 0.0;
            d1 = 0.0;
            d = 0.0;
        }
        boolean flag1 = this.onGround || d6 != d1 && d6 < 0.0;
        int j = 0;
        while (j < list.size()) {
            d = ((AxisAlignedBB)list.get(j)).calculateXOffset(this.boundingBox, d);
            ++j;
        }
        this.boundingBox.offset(d, 0.0, 0.0);
        if (!this.field_9077_F && d5 != d) {
            d2 = 0.0;
            d1 = 0.0;
            d = 0.0;
        }
        int k = 0;
        while (k < list.size()) {
            d2 = ((AxisAlignedBB)list.get(k)).calculateZOffset(this.boundingBox, d2);
            ++k;
        }
        this.boundingBox.offset(0.0, 0.0, d2);
        if (!this.field_9077_F && d7 != d2) {
            d2 = 0.0;
            d1 = 0.0;
            d = 0.0;
        }
        if (this.stepHeight > 0.0f && flag1 && (flag || this.ySize < 0.05f) && (d5 != d || d7 != d2)) {
            double d9 = d;
            double d11 = d1;
            double d13 = d2;
            d = d5;
            d1 = this.stepHeight;
            d2 = d7;
            AxisAlignedBB axisalignedbb1 = this.boundingBox.copy();
            this.boundingBox.setBB(axisalignedbb);
            List list1 = this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox.addCoord(d, d1, d2));
            int j2 = 0;
            while (j2 < list1.size()) {
                d1 = ((AxisAlignedBB)list1.get(j2)).calculateYOffset(this.boundingBox, d1);
                ++j2;
            }
            this.boundingBox.offset(0.0, d1, 0.0);
            if (!this.field_9077_F && d6 != d1) {
                d2 = 0.0;
                d1 = 0.0;
                d = 0.0;
            }
            int k2 = 0;
            while (k2 < list1.size()) {
                d = ((AxisAlignedBB)list1.get(k2)).calculateXOffset(this.boundingBox, d);
                ++k2;
            }
            this.boundingBox.offset(d, 0.0, 0.0);
            if (!this.field_9077_F && d5 != d) {
                d2 = 0.0;
                d1 = 0.0;
                d = 0.0;
            }
            int l2 = 0;
            while (l2 < list1.size()) {
                d2 = ((AxisAlignedBB)list1.get(l2)).calculateZOffset(this.boundingBox, d2);
                ++l2;
            }
            this.boundingBox.offset(0.0, 0.0, d2);
            if (!this.field_9077_F && d7 != d2) {
                d2 = 0.0;
                d1 = 0.0;
                d = 0.0;
            }
            if (!this.field_9077_F && d6 != d1) {
                d2 = 0.0;
                d1 = 0.0;
                d = 0.0;
            } else {
                d1 = -this.stepHeight;
                int i3 = 0;
                while (i3 < list1.size()) {
                    d1 = ((AxisAlignedBB)list1.get(i3)).calculateYOffset(this.boundingBox, d1);
                    ++i3;
                }
                this.boundingBox.offset(0.0, d1, 0.0);
            }
            if (d9 * d9 + d13 * d13 >= d * d + d2 * d2) {
                d = d9;
                d1 = d11;
                d2 = d13;
                this.boundingBox.setBB(axisalignedbb1);
            } else {
                double d14 = this.boundingBox.minY - (double)((int)this.boundingBox.minY);
                if (d14 > 0.0) {
                    this.ySize = (float)((double)this.ySize + (d14 + 0.01));
                }
            }
        }
        this.posX = (this.boundingBox.minX + this.boundingBox.maxX) / 2.0;
        this.posY = this.boundingBox.minY + (double)this.yOffset - (double)this.ySize;
        this.posZ = (this.boundingBox.minZ + this.boundingBox.maxZ) / 2.0;
        this.isCollidedHorizontally = d5 != d || d7 != d2;
        this.isCollidedVertically = d6 != d1;
        this.onGround = d6 != d1 && d6 < 0.0;
        this.isCollided = this.isCollidedHorizontally || this.isCollidedVertically;
        this.updateFallState(d1, this.onGround);
        if (d5 != d) {
            this.motionX = 0.0;
        }
        if (d6 != d1) {
            this.motionY = 0.0;
        }
        if (d7 != d2) {
            this.motionZ = 0.0;
        }
        double d10 = this.posX - d3;
        double d12 = this.posZ - d4;
        if (this.func_25017_l() && !flag && this.ridingEntity == null) {
            this.distanceWalkedModified = (float)((double)this.distanceWalkedModified + (double)MathHelper.sqrt_double(d10 * d10 + d12 * d12) * 0.6);
            int l = MathHelper.floor_double(this.posX);
            int j1 = MathHelper.floor_double(this.posY - (double)0.2f - (double)this.yOffset);
            int l1 = MathHelper.floor_double(this.posZ);
            int j3 = this.worldObj.getBlockId(l, j1, l1);
            if (this.worldObj.getBlockId(l, j1 - 1, l1) == Block.fence.blockID) {
                j3 = this.worldObj.getBlockId(l, j1 - 1, l1);
            }
            if (this.distanceWalkedModified > (float)this.nextStepDistance && j3 > 0) {
                ++this.nextStepDistance;
                StepSound stepsound = Block.allBlocks[j3].stepSound;
                if (this.worldObj.getBlockId(l, j1 + 1, l1) == Block.snow.blockID) {
                    stepsound = Block.snow.stepSound;
                    this.worldObj.playSoundAtEntity(this, stepsound.stepSoundDir(), stepsound.getVolume() * 0.15f, stepsound.getPitch());
                } else if (!Block.allBlocks[j3].blockMaterial.getIsLiquid()) {
                    this.worldObj.playSoundAtEntity(this, stepsound.stepSoundDir(), stepsound.getVolume() * 0.15f, stepsound.getPitch());
                }
                Block.allBlocks[j3].onEntityWalking(this.worldObj, l, j1, l1, this);
            }
        }
        if (this.worldObj.checkChunksExist(i1 = MathHelper.floor_double(this.boundingBox.minX + 0.001), k1 = MathHelper.floor_double(this.boundingBox.minY + 0.001), i2 = MathHelper.floor_double(this.boundingBox.minZ + 0.001), k3 = MathHelper.floor_double(this.boundingBox.maxX - 0.001), l3 = MathHelper.floor_double(this.boundingBox.maxY - 0.001), i4 = MathHelper.floor_double(this.boundingBox.maxZ - 0.001))) {
            int j4 = i1;
            while (j4 <= k3) {
                int k4 = k1;
                while (k4 <= l3) {
                    int l4 = i2;
                    while (l4 <= i4) {
                        int i5 = this.worldObj.getBlockId(j4, k4, l4);
                        if (i5 > 0) {
                            Block.allBlocks[i5].onEntityCollidedWithBlock(this.worldObj, j4, k4, l4, this);
                        }
                        ++l4;
                    }
                    ++k4;
                }
                ++j4;
            }
        }
        boolean flag2 = this.func_27008_Y();
        if (this.worldObj.isBoundingBoxBurning(this.boundingBox.getInsetBoundingBox(0.001, 0.001, 0.001))) {
            this.dealFireDamage(1);
            if (!flag2) {
                ++this.fire;
                if (this.fire == 0) {
                    this.fire = 300;
                }
            }
        } else if (this.fire <= 0) {
            this.fire = -this.fireResistance;
        }
        if (flag2 && this.fire > 0) {
            this.worldObj.playSoundAtEntity(this, "random.fizz", 0.7f, 1.6f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.4f);
            this.fire = -this.fireResistance;
        }
    }

    protected boolean func_25017_l() {
        return true;
    }

    protected void updateFallState(double d, boolean flag) {
        if (flag) {
            if (this.fallDistance > 0.0f) {
                this.fall(this.fallDistance);
                this.fallDistance = 0.0f;
            }
        } else if (d < 0.0) {
            this.fallDistance = (float)((double)this.fallDistance - d);
        }
    }

    public AxisAlignedBB getBoundingBox() {
        return null;
    }

    protected void dealFireDamage(int i) {
        if (!this.isImmuneToFire) {
            this.attackEntityFrom(null, i + this.steelArmor + this.diamondArmor * 2);
        }
    }

    protected void fall(float f) {
        if (this.riddenByEntity != null) {
            this.riddenByEntity.fall(f);
        }
    }

    public boolean func_27008_Y() {
        return this.inWater || this.worldObj.canLightningStrikeAt(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ));
    }

    public boolean isInWater() {
        return this.inWater;
    }

    public boolean handleWaterMovement() {
        return this.worldObj.handleMaterialAcceleration(this.boundingBox.expand(0.0, -0.4f, 0.0).getInsetBoundingBox(0.001, 0.001, 0.001), Material.water, this);
    }

    public boolean isInsideOfMaterial(Material material) {
        int k;
        int j;
        double d = this.posY + (double)this.getEyeHeight();
        int i = MathHelper.floor_double(this.posX);
        int l = this.worldObj.getBlockId(i, j = MathHelper.floor_float(MathHelper.floor_double(d)), k = MathHelper.floor_double(this.posZ));
        if (l != 0 && Block.allBlocks[l].blockMaterial == material) {
            float f = BlockFluid.setFluidHeight(this.worldObj.getBlockMetadata(i, j, k)) - 0.1111111f;
            float f1 = (float)(j + 1) - f;
            return d < (double)f1;
        }
        return false;
    }

    public float getEyeHeight() {
        return 0.0f;
    }

    public boolean handleLavaMovement() {
        return this.worldObj.isMaterialInBB(this.boundingBox.expand(0.0, -0.4f, 0.0), Material.lava);
    }

    public void moveFlying(float f, float f1, float f2) {
        float f3 = MathHelper.sqrt_float(f * f + f1 * f1);
        if (f3 < 0.01f) {
            return;
        }
        if (f3 < 1.0f) {
            f3 = 1.0f;
        }
        f3 = f2 / f3;
        float f4 = MathHelper.sin(this.rotationYaw * 3.141593f / 180.0f);
        float f5 = MathHelper.cos(this.rotationYaw * 3.141593f / 180.0f);
        this.motionX += (double)((f *= f3) * f5 - (f1 *= f3) * f4);
        this.motionZ += (double)(f1 * f5 + f * f4);
    }

    public float getEntityBrightness(float f) {
        int i = MathHelper.floor_double(this.posX);
        double d = (this.boundingBox.maxY - this.boundingBox.minY) * 0.66;
        int j = MathHelper.floor_double(this.posY - (double)this.yOffset + d);
        int k = MathHelper.floor_double(this.posZ);
        if (this.worldObj.checkChunksExist(MathHelper.floor_double(this.boundingBox.minX), MathHelper.floor_double(this.boundingBox.minY), MathHelper.floor_double(this.boundingBox.minZ), MathHelper.floor_double(this.boundingBox.maxX), MathHelper.floor_double(this.boundingBox.maxY), MathHelper.floor_double(this.boundingBox.maxZ))) {
            float f1 = this.worldObj.getLightBrightness(i, j, k);
            if (f1 < this.field_31001_bF) {
                f1 = this.field_31001_bF;
            }
            return f1;
        }
        return this.field_31001_bF;
    }

    public void setWorldHandler(World world) {
        this.worldObj = world;
    }

    public void setPositionAndRotation(double d, double d1, double d2, float f, float f1) {
        this.prevPosX = this.posX = d;
        this.prevPosY = this.posY = d1;
        this.prevPosZ = this.posZ = d2;
        this.prevRotationYaw = this.rotationYaw = f;
        this.prevRotationPitch = this.rotationPitch = f1;
        this.ySize = 0.0f;
        double d3 = this.prevRotationYaw - f;
        if (d3 < -180.0) {
            this.prevRotationYaw += 360.0f;
        }
        if (d3 >= 180.0) {
            this.prevRotationYaw -= 360.0f;
        }
        this.setPosition(this.posX, this.posY, this.posZ);
        this.setRotation(f, f1);
    }

    public void setLocationAndAngles(double d, double d1, double d2, float f, float f1) {
        this.prevPosX = this.posX = d;
        this.lastTickPosX = this.posX;
        this.prevPosY = this.posY = d1 + (double)this.yOffset;
        this.lastTickPosY = this.posY;
        this.prevPosZ = this.posZ = d2;
        this.lastTickPosZ = this.posZ;
        this.rotationYaw = f;
        this.rotationPitch = f1;
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    public float getDistanceToEntity(Entity entity) {
        float f = (float)(this.posX - entity.posX);
        float f1 = (float)(this.posY - entity.posY);
        float f2 = (float)(this.posZ - entity.posZ);
        return MathHelper.sqrt_float(f * f + f1 * f1 + f2 * f2);
    }

    public double getDistanceSq(double d, double d1, double d2) {
        double d3 = this.posX - d;
        double d4 = this.posY - d1;
        double d5 = this.posZ - d2;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public double getDistance(double d, double d1, double d2) {
        double d3 = this.posX - d;
        double d4 = this.posY - d1;
        double d5 = this.posZ - d2;
        return MathHelper.sqrt_double(d3 * d3 + d4 * d4 + d5 * d5);
    }

    public double getDistanceSqToEntity(Entity entity) {
        double d = this.posX - entity.posX;
        double d1 = this.posY - entity.posY;
        double d2 = this.posZ - entity.posZ;
        return d * d + d1 * d1 + d2 * d2;
    }

    public void onCollideWithPlayer(EntityPlayer entityplayer) {
    }

    public void applyEntityCollision(Entity entity) {
        if (entity.riddenByEntity == this || entity.ridingEntity == this) {
            return;
        }
        double d = entity.posX - this.posX;
        double d1 = entity.posZ - this.posZ;
        double d2 = MathHelper.abs_max(d, d1);
        if (d2 >= (double)0.01f) {
            d2 = MathHelper.sqrt_double(d2);
            d /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d *= d3;
            d1 *= d3;
            d *= (double)0.05f;
            d1 *= (double)0.05f;
            this.addVelocity(-(d *= (double)(1.0f - this.entityCollisionReduction)), 0.0, -(d1 *= (double)(1.0f - this.entityCollisionReduction)));
            entity.addVelocity(d, 0.0, d1);
        }
    }

    public void addVelocity(double d, double d1, double d2) {
        this.motionX += d;
        this.motionY += d1;
        this.motionZ += d2;
    }

    protected void setBeenAttacked() {
        this.beenAttacked = true;
    }

    public boolean attackEntityFrom(Entity entity, int i) {
        this.setBeenAttacked();
        return false;
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean canBePushed() {
        return false;
    }

    public void addToPlayerScore(Entity entity, int i) {
    }

    public boolean addEntityID(NBTTagCompound nbttagcompound) {
        String s = this.getEntityString();
        if (this.isDead || s == null) {
            return false;
        }
        nbttagcompound.setString("id", s);
        this.writeToNBT(nbttagcompound);
        return true;
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setTag("Pos", this.newDoubleNBTList(new double[]{this.posX, this.posY + (double)this.ySize, this.posZ}));
        nbttagcompound.setTag("Motion", this.newDoubleNBTList(new double[]{this.motionX, this.motionY, this.motionZ}));
        nbttagcompound.setTag("Rotation", this.newFloatNBTList(new float[]{this.rotationYaw, this.rotationPitch}));
        nbttagcompound.setFloat("FallDistance", this.fallDistance);
        nbttagcompound.setShort("Fire", (short)this.fire);
        nbttagcompound.setShort("Air", (short)this.air);
        nbttagcompound.setBoolean("OnGround", this.onGround);
        this.writeEntityToNBT(nbttagcompound);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = nbttagcompound.getTagList("Pos");
        NBTTagList nbttaglist1 = nbttagcompound.getTagList("Motion");
        NBTTagList nbttaglist2 = nbttagcompound.getTagList("Rotation");
        this.motionX = ((NBTTagDouble)nbttaglist1.tagAt((int)0)).doubleValue;
        this.motionY = ((NBTTagDouble)nbttaglist1.tagAt((int)1)).doubleValue;
        this.motionZ = ((NBTTagDouble)nbttaglist1.tagAt((int)2)).doubleValue;
        if (Math.abs(this.motionX) > 10.0) {
            this.motionX = 0.0;
        }
        if (Math.abs(this.motionY) > 10.0) {
            this.motionY = 0.0;
        }
        if (Math.abs(this.motionZ) > 10.0) {
            this.motionZ = 0.0;
        }
        this.lastTickPosX = this.posX = ((NBTTagDouble)nbttaglist.tagAt((int)0)).doubleValue;
        this.prevPosX = this.posX;
        this.lastTickPosY = this.posY = ((NBTTagDouble)nbttaglist.tagAt((int)1)).doubleValue;
        this.prevPosY = this.posY;
        this.lastTickPosZ = this.posZ = ((NBTTagDouble)nbttaglist.tagAt((int)2)).doubleValue;
        this.prevPosZ = this.posZ;
        this.prevRotationYaw = this.rotationYaw = ((NBTTagFloat)nbttaglist2.tagAt((int)0)).floatValue;
        this.prevRotationPitch = this.rotationPitch = ((NBTTagFloat)nbttaglist2.tagAt((int)1)).floatValue;
        this.fallDistance = nbttagcompound.getFloat("FallDistance");
        this.fire = nbttagcompound.getShort("Fire");
        this.air = nbttagcompound.getShort("Air");
        this.onGround = nbttagcompound.getBoolean("OnGround");
        this.setPosition(this.posX, this.posY, this.posZ);
        this.setRotation(this.rotationYaw, this.rotationPitch);
        this.readEntityFromNBT(nbttagcompound);
    }

    protected final String getEntityString() {
        return EntityList.getEntityString(this);
    }

    protected abstract void readEntityFromNBT(NBTTagCompound var1);

    protected abstract void writeEntityToNBT(NBTTagCompound var1);

    protected NBTTagList newDoubleNBTList(double[] ad) {
        NBTTagList nbttaglist = new NBTTagList();
        double[] ad1 = ad;
        int i = ad1.length;
        int j = 0;
        while (j < i) {
            double d = ad1[j];
            nbttaglist.setTag(new NBTTagDouble(d));
            ++j;
        }
        return nbttaglist;
    }

    protected NBTTagList newFloatNBTList(float[] af) {
        NBTTagList nbttaglist = new NBTTagList();
        float[] af1 = af;
        int i = af1.length;
        int j = 0;
        while (j < i) {
            float f = af1[j];
            nbttaglist.setTag(new NBTTagFloat(f));
            ++j;
        }
        return nbttaglist;
    }

    protected NBTTagList newIntNBTList(int[] af) {
        NBTTagList nbttaglist = new NBTTagList();
        int[] af1 = af;
        int i = af1.length;
        int j = 0;
        while (j < i) {
            int f = af1[j];
            nbttaglist.setTag(new NBTTagInt(f));
            ++j;
        }
        return nbttaglist;
    }

    public EntityItem dropItem(int i, int j) {
        return this.dropItemWithOffset(i, j, 0.0f);
    }

    public EntityItem dropItemWithOffset(int i, int j, float f) {
        return this.entityDropItem(new ItemStack(i, j, 0), f);
    }

    public EntityItem entityDropItem(ItemStack itemstack, float f) {
        EntityItem entityitem = new EntityItem(this.worldObj, this.posX, this.posY + (double)f, this.posZ, itemstack);
        entityitem.delayBeforeCanPickup = 10;
        this.worldObj.entityJoinedWorld(entityitem);
        return entityitem;
    }

    public boolean isEntityAlive() {
        return !this.isDead;
    }

    public boolean isEntityInsideOpaqueBlock() {
        int i = 0;
        while (i < 8) {
            int l;
            int k;
            float f = ((float)((i >> 0) % 2) - 0.5f) * this.width * 0.9f;
            float f1 = ((float)((i >> 1) % 2) - 0.5f) * 0.1f;
            float f2 = ((float)((i >> 2) % 2) - 0.5f) * this.width * 0.9f;
            int j = MathHelper.floor_double(this.posX + (double)f);
            if (this.worldObj.isBlockNormalCube(j, k = MathHelper.floor_double(this.posY + (double)this.getEyeHeight() + (double)f1), l = MathHelper.floor_double(this.posZ + (double)f2))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean interact(EntityPlayer entityplayer) {
        return false;
    }

    public AxisAlignedBB func_89_d(Entity entity) {
        return null;
    }

    public void updateRidden() {
        if (this.ridingEntity.isDead) {
            this.ridingEntity = null;
            return;
        }
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.onUpdate();
        if (this.ridingEntity == null) {
            return;
        }
        this.ridingEntity.updateRiderPosition();
        this.entityRiderYawDelta += (double)(this.ridingEntity.rotationYaw - this.ridingEntity.prevRotationYaw);
        this.entityRiderPitchDelta += (double)(this.ridingEntity.rotationPitch - this.ridingEntity.prevRotationPitch);
        while (this.entityRiderYawDelta >= 180.0) {
            this.entityRiderYawDelta -= 360.0;
        }
        while (this.entityRiderYawDelta < -180.0) {
            this.entityRiderYawDelta += 360.0;
        }
        while (this.entityRiderPitchDelta >= 180.0) {
            this.entityRiderPitchDelta -= 360.0;
        }
        while (this.entityRiderPitchDelta < -180.0) {
            this.entityRiderPitchDelta += 360.0;
        }
        double d = this.entityRiderYawDelta * 0.5;
        double d1 = this.entityRiderPitchDelta * 0.5;
        float f = 10.0f;
        if (d > (double)f) {
            d = f;
        }
        if (d < (double)(-f)) {
            d = -f;
        }
        if (d1 > (double)f) {
            d1 = f;
        }
        if (d1 < (double)(-f)) {
            d1 = -f;
        }
        this.entityRiderYawDelta -= d;
        this.entityRiderPitchDelta -= d1;
        this.rotationYaw = (float)((double)this.rotationYaw + d);
        this.rotationPitch = (float)((double)this.rotationPitch + d1);
    }

    public void updateRiderPosition() {
        this.riddenByEntity.setPosition(this.posX, this.posY + this.getMountedYOffset() + this.riddenByEntity.getYOffset(), this.posZ);
    }

    public double getYOffset() {
        return this.yOffset;
    }

    public double getMountedYOffset() {
        return (double)this.height * 0.75;
    }

    public void mountEntity(Entity entity) {
        this.entityRiderPitchDelta = 0.0;
        this.entityRiderYawDelta = 0.0;
        if (entity == null) {
            if (this.ridingEntity != null) {
                this.setLocationAndAngles(this.ridingEntity.posX, this.ridingEntity.boundingBox.minY + (double)this.ridingEntity.height, this.ridingEntity.posZ, this.rotationYaw, this.rotationPitch);
                this.ridingEntity.riddenByEntity = null;
            }
            this.ridingEntity = null;
            return;
        }
        if (this.ridingEntity == entity) {
            this.ridingEntity.riddenByEntity = null;
            this.ridingEntity = null;
            this.setLocationAndAngles(entity.posX, entity.boundingBox.minY + (double)entity.height, entity.posZ, this.rotationYaw, this.rotationPitch);
            return;
        }
        if (this.ridingEntity != null) {
            this.ridingEntity.riddenByEntity = null;
        }
        if (entity.riddenByEntity != null) {
            entity.riddenByEntity.ridingEntity = null;
        }
        this.ridingEntity = entity;
        entity.riddenByEntity = this;
    }

    public Vec3D getLookVec() {
        return null;
    }

    public double getRealMoveSpeed() {
        return 0.5;
    }

    public void setInPortal() {
    }

    public ItemStack[] getInventory() {
        return null;
    }

    public boolean isSneaking() {
        return this.getFlag(1);
    }

    public void setSneaking(boolean flag) {
        this.setFlag(1, flag);
    }

    public boolean isRunning() {
        return this.getFlag(5);
    }

    public void setRunning(boolean flag) {
        this.setFlag(5, flag);
    }

    protected boolean getFlag(int i) {
        return (this.dataWatcher.getWatchableObjectByte(0) & 1 << i) != 0;
    }

    protected void setFlag(int i, boolean flag) {
        byte byte0 = this.dataWatcher.getWatchableObjectByte(0);
        if (flag) {
            this.dataWatcher.updateObject(0, (byte)(byte0 | 1 << i));
        } else {
            this.dataWatcher.updateObject(0, (byte)(byte0 & ~(1 << i)));
        }
    }

    public boolean getUsing() {
        return this.getFlag(4);
    }

    public void setUsing(boolean flag) {
        this.setFlag(4, flag);
    }

    public void onStruckByLightning(EntityLightningBolt entitylightningbolt) {
        this.dealFireDamage(5);
        ++this.fire;
        if (this.fire == 0) {
            this.fire = 300;
        }
    }

    public void func_27010_a(EntityLiving entityliving) {
    }

    protected boolean func_28005_g(double d, double d1, double d2) {
        int i = MathHelper.floor_double(d);
        int j = MathHelper.floor_double(d1);
        int k = MathHelper.floor_double(d2);
        double d3 = d - (double)i;
        double d4 = d1 - (double)j;
        double d5 = d2 - (double)k;
        if (this.worldObj.isBlockNormalCube(i, j, k)) {
            boolean flag = !this.worldObj.isBlockNormalCube(i - 1, j, k);
            boolean flag1 = !this.worldObj.isBlockNormalCube(i + 1, j, k);
            boolean flag2 = !this.worldObj.isBlockNormalCube(i, j - 1, k);
            boolean flag3 = !this.worldObj.isBlockNormalCube(i, j + 1, k);
            boolean flag4 = !this.worldObj.isBlockNormalCube(i, j, k - 1);
            boolean flag5 = !this.worldObj.isBlockNormalCube(i, j, k + 1);
            int byte0 = -1;
            double d6 = 9999.0;
            if (flag && d3 < d6) {
                d6 = d3;
                byte0 = 0;
            }
            if (flag1 && 1.0 - d3 < d6) {
                d6 = 1.0 - d3;
                byte0 = 1;
            }
            if (flag2 && d4 < d6) {
                d6 = d4;
                byte0 = 2;
            }
            if (flag3 && 1.0 - d4 < d6) {
                d6 = 1.0 - d4;
                byte0 = 3;
            }
            if (flag4 && d5 < d6) {
                d6 = d5;
                byte0 = 4;
            }
            if (flag5 && 1.0 - d5 < d6) {
                double d7 = 1.0 - d5;
                byte0 = 5;
            }
            float f = this.rand.nextFloat() * 0.2f + 0.1f;
            if (byte0 == 0) {
                this.motionX = -f;
            }
            if (byte0 == 1) {
                this.motionX = f;
            }
            if (byte0 == 2) {
                this.motionY = -f;
            }
            if (byte0 == 3) {
                this.motionY = f;
            }
            if (byte0 == 4) {
                this.motionZ = -f;
            }
            if (byte0 == 5) {
                this.motionZ = f;
            }
        }
        return false;
    }
}

