/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.path.PathEntity;
import com.mojang.minecraft.entity.path.PathEntityIndev;
import com.mojang.minecraft.entity.path.PathFinderIndev;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.render.Vec3D;
import com.mojang.minecraft.util.MathHelper;

public class EntityCreature
extends EntityLiving {
    private PathEntity pathToEntity;
    private PathEntityIndev indevPathToEntity;
    protected Entity entityToAttack;
    protected boolean hasAttacked = false;
    public boolean indevai;
    public static PathFinderIndev pathFinderIndev;

    public EntityCreature(World world) {
        super(world);
        if (this.worldObj != null && (pathFinderIndev == null || EntityCreature.pathFinderIndev.worldObj != world)) {
            pathFinderIndev = new PathFinderIndev(this.worldObj);
        }
    }

    protected boolean func_25026_u() {
        return false;
    }

    protected void updateEntityActionStateIndev() {
        this.hasAttacked = false;
        PathFinderIndev pathFinder = pathFinderIndev;
        if (this.entityToAttack == null) {
            this.entityToAttack = this.findPlayerToAttack();
            if (this.entityToAttack != null) {
                this.indevPathToEntity = pathFinder.a(this, this.entityToAttack, 16.0f);
            }
        } else if (!this.entityToAttack.isEntityAlive()) {
            this.entityToAttack = null;
        } else {
            float var1 = this.entityToAttack.getDistanceToEntity(this);
            if (this.worldObj.rayTraceBlocks(Vec3D.createVector(this.posX, this.posY + (double)this.getEyeHeight(), this.posZ), Vec3D.createVector(this.posX, this.posY + (double)this.getEyeHeight(), this.posZ)) == null) {
                this.attackEntity(this.entityToAttack, var1);
            }
        }
        if (this.hasAttacked) {
            this.moveStrafing = 0.0f;
            this.moveForward = 0.0f;
            this.isJumping = false;
        } else {
            float var4;
            if (this.entityToAttack != null && (this.indevPathToEntity == null || this.rand.nextInt(20) == 0)) {
                this.indevPathToEntity = pathFinder.a(this, this.entityToAttack, 16.0f);
            } else if (this.indevPathToEntity == null || this.rand.nextInt(100) == 0) {
                int var10 = -1;
                int var2 = -1;
                int var3 = -1;
                var4 = -99999.0f;
                int var14 = 0;
                while (var14 < 200) {
                    float f;
                    int var16 = (int)(this.posX + (double)this.rand.nextInt(21) - 10.0);
                    int var17 = (int)(this.posY + (double)this.rand.nextInt(9) - 4.0);
                    int var18 = (int)(this.posZ + (double)this.rand.nextInt(21) - 10.0);
                    float var9 = this.getBlockPathWeight(var16, var17, var18);
                    if (f > var4) {
                        var4 = var9;
                        var10 = var16;
                        var2 = var17;
                        var3 = var18;
                    }
                    ++var14;
                }
                if (var10 > 0) {
                    this.indevPathToEntity = pathFinder.a((Entity)this, var10, var2, var3, 16.0f);
                }
            }
            boolean var11 = this.handleWaterMovement();
            boolean var12 = this.handleLavaMovement();
            if (this.indevPathToEntity != null && this.rand.nextInt(100) != 0) {
                double var6;
                double var7;
                Vec3D var13 = this.indevPathToEntity.a(this);
                var4 = this.width * 2.0f;
                while (var13 != null) {
                    double var8 = this.posZ;
                    var7 = this.posY;
                    var6 = this.posX;
                    double var16 = var8 - var13.zCoord;
                    if ((var6 -= var13.xCoord) * var6 + (var7 -= var13.yCoord) * var7 + var16 * var16 >= (double)(var4 * var4) || var13.yCoord > this.posY) break;
                    this.indevPathToEntity.a();
                    if (this.indevPathToEntity.b()) {
                        var13 = null;
                        this.indevPathToEntity = null;
                        continue;
                    }
                    var13 = this.indevPathToEntity.a(this);
                }
                this.isJumping = false;
                if (var13 != null) {
                    double var16 = var13.xCoord - this.posX;
                    var6 = var13.zCoord - this.posZ;
                    var7 = var13.yCoord - this.posY;
                    this.rotationYaw = (float)(Math.atan2(var6, var16) * 180.0 / Math.PI) - 90.0f;
                    this.moveForward = (float)this.getRealMoveSpeed();
                    if (var7 > 0.0) {
                        this.isJumping = true;
                    }
                }
                if (this.rand.nextFloat() < 0.8f && (var11 || var12)) {
                    this.isJumping = true;
                }
            } else {
                super.updateEntityActionStateIndev();
                this.indevPathToEntity = null;
            }
        }
    }

    protected void updateEntityActionState() {
        this.hasAttacked = this.func_25026_u();
        float f = 16.0f;
        if (this.entityToAttack == null) {
            this.entityToAttack = this.findPlayerToAttack();
            if (this.entityToAttack != null) {
                this.pathToEntity = this.worldObj.getPathToEntity(this, this.entityToAttack, f);
            }
        } else if (!this.entityToAttack.isEntityAlive()) {
            this.entityToAttack = null;
        } else {
            float f1 = this.entityToAttack.getDistanceToEntity(this);
            if (this.canEntityBeSeen(this.entityToAttack)) {
                this.attackEntity(this.entityToAttack, f1);
            } else {
                this.func_28013_b(this.entityToAttack, f1);
            }
        }
        if (!(this.hasAttacked || this.entityToAttack == null || this.pathToEntity != null && this.rand.nextInt(20) != 0)) {
            this.pathToEntity = this.worldObj.getPathToEntity(this, this.entityToAttack, f);
        } else if (!this.hasAttacked && (this.pathToEntity == null && this.rand.nextInt(80) == 0 || this.rand.nextInt(80) == 0)) {
            this.func_31021_B();
        }
        int i = MathHelper.floor_double(this.boundingBox.minY + 0.5);
        boolean flag = this.isInWater();
        boolean flag1 = this.handleLavaMovement();
        this.rotationPitch = 0.0f;
        if (this.pathToEntity == null || this.rand.nextInt(100) == 0) {
            super.updateEntityActionState();
            this.pathToEntity = null;
            return;
        }
        Vec3D vec3d = this.pathToEntity.getPosition(this);
        double d = this.width * 2.0f;
        while (vec3d != null && vec3d.squareDistanceTo(this.posX, vec3d.yCoord, this.posZ) < d * d) {
            this.pathToEntity.incrementPathIndex();
            if (this.pathToEntity.isFinished()) {
                vec3d = null;
                this.pathToEntity = null;
                continue;
            }
            vec3d = this.pathToEntity.getPosition(this);
        }
        this.isJumping = false;
        if (vec3d != null) {
            double d1 = vec3d.xCoord - this.posX;
            double d2 = vec3d.zCoord - this.posZ;
            double d3 = vec3d.yCoord - (double)i;
            float f2 = (float)(Math.atan2(d2, d1) * 180.0 / 3.1415927410125732) - 90.0f;
            float f3 = f2 - this.rotationYaw;
            this.moveForward = this.move_Speed;
            while (f3 < -180.0f) {
                f3 += 360.0f;
            }
            while (f3 >= 180.0f) {
                f3 -= 360.0f;
            }
            if (f3 > 30.0f) {
                f3 = 30.0f;
            }
            if (f3 < -30.0f) {
                f3 = -30.0f;
            }
            this.rotationYaw += f3;
            if (this.hasAttacked && this.entityToAttack != null) {
                double d4 = this.entityToAttack.posX - this.posX;
                double d5 = this.entityToAttack.posZ - this.posZ;
                float f5 = this.rotationYaw;
                this.rotationYaw = (float)(Math.atan2(d5, d4) * 180.0 / 3.1415927410125732) - 90.0f;
                float f4 = (f5 - this.rotationYaw + 90.0f) * 3.141593f / 180.0f;
                this.moveStrafing = -MathHelper.sin(f4) * this.moveForward * 1.0f;
                this.moveForward = MathHelper.cos(f4) * this.moveForward * 1.0f;
            }
            if (d3 > 0.0) {
                this.isJumping = true;
            }
        }
        if (this.entityToAttack != null) {
            this.faceEntity(this.entityToAttack, 30.0f, 30.0f);
        }
        if (this.isCollidedHorizontally && !this.getGotPath()) {
            this.isJumping = true;
        }
        if (this.rand.nextFloat() < 0.8f && (flag || flag1)) {
            this.isJumping = true;
        }
    }

    protected void func_31021_B() {
        boolean flag = false;
        int i = -1;
        int j = -1;
        int k = -1;
        float f = -99999.0f;
        int l = 0;
        while (l < 10) {
            int k1;
            int j1;
            int i1 = MathHelper.floor_double(this.posX + (double)this.rand.nextInt(13) - 6.0);
            float f1 = this.getBlockPathWeight(i1, j1 = MathHelper.floor_double(this.posY + (double)this.rand.nextInt(7) - 3.0), k1 = MathHelper.floor_double(this.posZ + (double)this.rand.nextInt(13) - 6.0));
            if (f1 > f) {
                f = f1;
                i = i1;
                j = j1;
                k = k1;
                flag = true;
            }
            ++l;
        }
        if (flag) {
            this.pathToEntity = this.worldObj.getEntityPathToXYZ(this, i, j, k, 10.0f);
        }
    }

    protected void attackEntity(Entity entity, float f) {
    }

    protected void func_28013_b(Entity entity, float f) {
    }

    protected float getBlockPathWeight(int i, int j, int k) {
        return 0.0f;
    }

    protected Entity findPlayerToAttack() {
        return null;
    }

    public boolean shouldSpawnOnTile() {
        int i = MathHelper.floor_double(this.posX);
        int j = MathHelper.floor_double(this.boundingBox.minY);
        int k = MathHelper.floor_double(this.posZ);
        return super.shouldSpawnOnTile() && this.getBlockPathWeight(i, j, k) >= 0.0f;
    }

    public boolean getGotPath() {
        return this.pathToEntity != null;
    }

    public void setPathToEntity(PathEntity pathentity) {
        this.pathToEntity = pathentity;
    }

    public Entity getEntityToAttack() {
        return this.entityToAttack;
    }

    public void setEntityToAttack(Entity entity) {
        this.entityToAttack = entity;
    }
}

