/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityLightningBolt;
import com.mojang.minecraft.entity.EntityMob;
import com.mojang.minecraft.entity.EntitySkeleton;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.nbt.NBTTagCompound;

public class EntityCreeper
extends EntityMob {
    int timeSinceIgnited;
    int lastActiveTime;

    public EntityCreeper(World world) {
        super(world);
        this.scoreValue = 50;
        this.texture = "/mob/creeper.png";
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (byte)-1);
        this.dataWatcher.addObject(17, (byte)0);
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        if (this.dataWatcher.getWatchableObjectByte(17) == 1) {
            nbttagcompound.setBoolean("powered", true);
        }
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        this.dataWatcher.updateObject(17, (byte)(nbttagcompound.getBoolean("powered") ? 1 : 0));
    }

    protected void func_28013_b(Entity entity, float f) {
        if (this.worldObj.singleplayerWorld) {
            return;
        }
        if (this.timeSinceIgnited > 0) {
            this.setCreeperState(-1);
            --this.timeSinceIgnited;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
        }
    }

    public void onUpdate() {
        this.lastActiveTime = this.timeSinceIgnited;
        if (this.worldObj.singleplayerWorld) {
            int i = this.getCreeperState();
            if (i > 0 && this.timeSinceIgnited == 0) {
                this.worldObj.playSoundAtEntity(this, "random.fuse", 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= 30) {
                this.timeSinceIgnited = 30;
            }
        }
        super.onUpdate();
        if (this.entityToAttack == null && this.timeSinceIgnited > 0) {
            this.setCreeperState(-1);
            --this.timeSinceIgnited;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
        }
    }

    protected String getHurtSound() {
        return "mob.creeper";
    }

    protected String getDeathSound() {
        return "mob.creeperdeath";
    }

    public void onDeath(Entity entity) {
        super.onDeath(entity);
        if (entity instanceof EntitySkeleton) {
            this.dropItem(Item.record13.shiftedIndex + this.rand.nextInt(13), 1);
        }
    }

    protected void attackEntity(Entity entity, float f) {
        if (this.worldObj.singleplayerWorld) {
            return;
        }
        int i = this.getCreeperState();
        if (i <= 0 && f < 3.0f || i > 0 && f < 7.0f) {
            if (this.timeSinceIgnited == 0) {
                this.worldObj.playSoundAtEntity(this, "random.fuse", 1.0f, 0.5f);
            }
            this.setCreeperState(1);
            ++this.timeSinceIgnited;
            if (this.timeSinceIgnited >= 30) {
                if (this.getPowered()) {
                    this.worldObj.createExplosion(this, this.posX, this.posY, this.posZ, 6.0f);
                } else {
                    this.worldObj.createExplosion(this, this.posX, this.posY, this.posZ, 3.0f);
                }
                this.setEntityDead();
            }
            this.hasAttacked = true;
        } else {
            this.setCreeperState(-1);
            --this.timeSinceIgnited;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
        }
    }

    public boolean getPowered() {
        return this.dataWatcher.getWatchableObjectByte(17) == 1;
    }

    protected int getDropItemId() {
        return Item.gunpowder.shiftedIndex;
    }

    private int getCreeperState() {
        return this.dataWatcher.getWatchableObjectByte(16);
    }

    private void setCreeperState(int i) {
        this.dataWatcher.updateObject(16, (byte)i);
    }

    public void onStruckByLightning(EntityLightningBolt entitylightningbolt) {
        super.onStruckByLightning(entitylightningbolt);
        this.dataWatcher.updateObject(17, (byte)1);
    }
}

