/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.BlockSand;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.util.MathHelper;

public class EntityFallingSand
extends Entity {
    public int blockID;
    public int fallTime = 0;

    public EntityFallingSand(World world) {
        super(world);
    }

    public EntityFallingSand(World world, double d, double d1, double d2, int i) {
        super(world);
        this.blockID = i;
        this.preventEntitySpawning = true;
        this.setSize(0.98f, 0.98f);
        this.yOffset = this.height / 2.0f;
        this.setPosition(d, d1, d2);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = d;
        this.prevPosY = d1;
        this.prevPosZ = d2;
    }

    protected boolean func_25017_l() {
        return false;
    }

    protected void entityInit() {
    }

    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    public void onUpdate() {
        if (this.blockID == 0) {
            this.setEntityDead();
            return;
        }
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        ++this.fallTime;
        this.motionY -= (double)0.04f;
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        this.motionX *= (double)0.98f;
        this.motionY *= (double)0.98f;
        this.motionZ *= (double)0.98f;
        int i = MathHelper.floor_double(this.posX);
        int j = MathHelper.floor_double(this.posY);
        int k = MathHelper.floor_double(this.posZ);
        if (this.worldObj.getBlockId(i, j, k) == this.blockID) {
            this.worldObj.setBlockWithNotify(i, j, k, 0);
        }
        if (this.onGround) {
            this.motionX *= (double)0.7f;
            this.motionZ *= (double)0.7f;
            this.motionY *= -0.5;
            this.setEntityDead();
            if (!(this.worldObj.canBlockBePlacedAt(this.blockID, i, j, k, true, 1) && !BlockSand.canFallBelow(this.worldObj, i, j - 1, k) && this.worldObj.setBlockWithNotify(i, j, k, this.blockID) || this.worldObj.singleplayerWorld)) {
                this.dropItem(this.blockID, 1);
            }
        } else if (this.fallTime > 100 && !this.worldObj.singleplayerWorld) {
            this.dropItem(this.blockID, 1);
            this.setEntityDead();
        }
    }

    protected void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setByte("Tile", (byte)this.blockID);
    }

    protected void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        this.blockID = nbttagcompound.getByte("Tile") & 0xFF;
    }
}

