/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.util.MathHelper;

public class EntityItem
extends Entity {
    public ItemStack item;
    public int age = 0;
    public int delayBeforeCanPickup;
    private int health = 5;
    public float field_432_ae = (float)(Math.random() * Math.PI * 2.0);

    public EntityItem(World world, double d, double d1, double d2, ItemStack itemstack) {
        super(world);
        this.setSize(0.25f, 0.25f);
        this.yOffset = this.height / 2.0f;
        this.setPosition(d, d1, d2);
        this.item = itemstack;
        this.rotationYaw = (float)(Math.random() * 360.0);
        this.motionX = (float)(Math.random() * (double)0.2f - (double)0.1f);
        this.motionY = 0.2f;
        this.motionZ = (float)(Math.random() * (double)0.2f - (double)0.1f);
        this.field_640_aG = false;
    }

    protected boolean func_25017_l() {
        return false;
    }

    public EntityItem(World world) {
        super(world);
        this.setSize(0.25f, 0.25f);
        this.yOffset = this.height / 2.0f;
    }

    protected void entityInit() {
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.delayBeforeCanPickup > 0) {
            --this.delayBeforeCanPickup;
        }
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.motionY -= (double)0.04f;
        if (this.worldObj.getMaterialXYZ(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ)) == Material.lava) {
            this.motionY = 0.2f;
            this.motionX = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f;
            this.motionZ = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f;
            this.worldObj.playSoundAtEntity(this, "random.fizz", 0.4f, 2.0f + this.rand.nextFloat() * 0.4f);
        }
        this.func_466_g(this.posX, this.posY, this.posZ);
        this.handleWaterMovement();
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        float f = 0.98f;
        if (this.onGround) {
            f = 0.5880001f;
            int i = this.worldObj.getBlockId(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.boundingBox.minY) - 1, MathHelper.floor_double(this.posZ));
            if (i > 0) {
                f = Block.allBlocks[i].slipperiness * 0.98f;
            }
        }
        this.motionX *= (double)f;
        this.motionY *= (double)0.98f;
        this.motionZ *= (double)f;
        if (this.onGround) {
            this.motionY *= -0.5;
        }
        ++this.age;
        if (this.age >= 6000) {
            this.setEntityDead();
        }
    }

    protected boolean func_28005_g(double posX, double d, double posZ) {
        return false;
    }

    public boolean handleWaterMovement() {
        return this.worldObj.handleMaterialAcceleration(this.boundingBox, Material.water, this);
    }

    protected void dealFireDamage(int i) {
        this.attackEntityFrom(null, i);
    }

    public boolean attackEntityFrom(Entity entity, int i) {
        this.setBeenAttacked();
        this.health -= i;
        if (this.health <= 0) {
            this.setEntityDead();
        }
        return false;
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setShort("Health", (byte)this.health);
        nbttagcompound.setShort("Age", (short)this.age);
        nbttagcompound.setCompoundTag("Item", this.item.writeToNBT(new NBTTagCompound()));
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        this.health = nbttagcompound.getShort("Health") & 0xFF;
        this.age = nbttagcompound.getShort("Age");
        NBTTagCompound nbttagcompound1 = nbttagcompound.getCompoundTag("Item");
        this.item = new ItemStack(nbttagcompound1);
    }

    public void onCollideWithPlayer(EntityPlayer entityplayer) {
        if (this.worldObj.singleplayerWorld) {
            return;
        }
        int i = this.item.stackSize;
        if (this.delayBeforeCanPickup == 0 && entityplayer.inventory.addItemStackToInventory(this.item)) {
            int cfr_ignored_0 = this.item.itemID;
            int cfr_ignored_1 = Block.wood.blockID;
            int cfr_ignored_2 = this.item.itemID;
            int cfr_ignored_3 = Item.leather.shiftedIndex;
            this.worldObj.playSoundAtEntity(this, "random.pop", 0.2f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            entityplayer.onItemPickup(this, i);
            if (this.item.stackSize <= 0) {
                this.setEntityDead();
            }
        }
    }

    private boolean func_466_g(double d, double d1, double d2) {
        int i = MathHelper.floor_double(d);
        int j = MathHelper.floor_double(d1);
        int k = MathHelper.floor_double(d2);
        double d3 = d - (double)i;
        double d4 = d1 - (double)j;
        double d5 = d2 - (double)k;
        if (Block.opaqueCubeLookup[this.worldObj.getBlockId(i, j, k)]) {
            boolean flag = !Block.opaqueCubeLookup[this.worldObj.getBlockId(i - 1, j, k)];
            boolean flag1 = !Block.opaqueCubeLookup[this.worldObj.getBlockId(i + 1, j, k)];
            boolean flag2 = !Block.opaqueCubeLookup[this.worldObj.getBlockId(i, j - 1, k)];
            boolean flag3 = !Block.opaqueCubeLookup[this.worldObj.getBlockId(i, j + 1, k)];
            boolean flag4 = !Block.opaqueCubeLookup[this.worldObj.getBlockId(i, j, k - 1)];
            boolean flag5 = !Block.opaqueCubeLookup[this.worldObj.getBlockId(i, j, k + 1)];
            int byte0 = -1;
            double d6 = 9999.0;
            if (flag && d3 < d6) {
                d6 = d3;
                byte0 = 0;
            }
            if (flag1 && 1.0 - d3 < d6) {
                d6 = 1.0 - d3;
                byte0 = 1;
            }
            if (flag2 && d4 < d6) {
                d6 = d4;
                byte0 = 2;
            }
            if (flag3 && 1.0 - d4 < d6) {
                d6 = 1.0 - d4;
                byte0 = 3;
            }
            if (flag4 && d5 < d6) {
                d6 = d5;
                byte0 = 4;
            }
            if (flag5 && 1.0 - d5 < d6) {
                byte0 = 5;
            }
            float f = this.rand.nextFloat() * 0.2f + 0.1f;
            if (byte0 == 0) {
                this.motionX = -f;
            }
            if (byte0 == 1) {
                this.motionX = f;
            }
            if (byte0 == 2) {
                this.motionY = -f;
            }
            if (byte0 == 3) {
                this.motionY = f;
            }
            if (byte0 == 4) {
                this.motionZ = -f;
            }
            if (byte0 == 5) {
                this.motionZ = f;
            }
        }
        return false;
    }
}

