/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.StepSound;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.render.Vec3D;
import com.mojang.minecraft.util.MathHelper;
import java.util.List;

public abstract class EntityLiving
extends Entity {
    int spongeArmor;
    int airQuart;
    public int maxHealth;
    public float field_9098_aw;
    public float field_9096_ay;
    public float renderYawOffset;
    public float prevRenderYawOffset;
    protected float field_9124_aB;
    protected float field_9123_aC;
    protected float field_9122_aD;
    protected float field_9121_aE;
    protected boolean field_9120_aF;
    protected String texture;
    protected boolean field_9118_aH;
    protected float field_9117_aI;
    protected String entityType;
    protected float field_9115_aK;
    protected int scoreValue;
    protected float field_9113_aM;
    public boolean isMultiplayerEntity;
    public float prevSwingProgress;
    public float swingProgress;
    public int health;
    public int prevHealth;
    private int livingSoundTime;
    public int hurtTime;
    public int maxHurtTime;
    public float attackedAtYaw;
    public int deathTime;
    public int attackTime;
    public float field_9102_aX;
    public float field_9101_aY;
    protected boolean unused_flag;
    public int field_9144_ba;
    public float field_9143_bb;
    public float field_9142_bc;
    public float field_9141_bd;
    public float field_386_ba;
    protected int field_9140_bf;
    protected double field_9139_bg;
    protected double field_9138_bh;
    protected double field_9137_bi;
    protected double field_9136_bj;
    protected double field_9135_bk;
    float field_9134_bl;
    protected int field_9133_bm;
    protected int lifeTimer;
    protected float moveStrafing;
    protected float moveForward;
    protected float randomYawVelocity;
    protected boolean isJumping;
    protected float defaultPitch;
    protected float move_Speed;
    private Entity currentTarget;
    protected int numTicksToChaseTarget;
    public boolean isSpecial;
    public int measureBlockX;
    public int measureBlockY;
    public int measureBlockZ;

    public EntityLiving(World world) {
        super(world);
        this.airQuart = this.spongeArmor;
        this.maxHealth = 20;
        this.renderYawOffset = 0.0f;
        this.prevRenderYawOffset = 0.0f;
        this.field_9120_aF = true;
        this.texture = "/mob/char.png";
        this.field_9118_aH = true;
        this.field_9117_aI = 0.0f;
        this.entityType = null;
        this.field_9115_aK = 1.0f;
        this.scoreValue = 0;
        this.field_9113_aM = 0.0f;
        this.isMultiplayerEntity = false;
        this.attackedAtYaw = 0.0f;
        this.deathTime = 0;
        this.attackTime = 0;
        this.unused_flag = false;
        this.field_9144_ba = -1;
        this.field_9143_bb = (float)(Math.random() * (double)0.9f + (double)0.1f);
        this.field_9134_bl = 0.0f;
        this.field_9133_bm = 0;
        this.lifeTimer = 0;
        this.isJumping = false;
        this.defaultPitch = 0.0f;
        this.move_Speed = 0.7f;
        this.numTicksToChaseTarget = 0;
        this.health = 10;
        this.preventEntitySpawning = true;
        this.field_9096_ay = (float)(Math.random() + 1.0) * 0.01f;
        this.setPosition(this.posX, this.posY, this.posZ);
        this.field_9098_aw = (float)Math.random() * 12398.0f;
        this.rotationYaw = (float)(Math.random() * 3.1415927410125732 * 2.0);
        this.stepHeight = 0.5f;
        this.leatherArmor = 0;
        this.goldArmor = 0;
        this.chainArmor = 0;
        this.steelArmor = 0;
        this.diamondArmor = 0;
        this.isSpecial = false;
    }

    protected void entityInit() {
    }

    public boolean canEntityBeSeen(Entity entity) {
        return this.worldObj.rayTraceBlocks(Vec3D.createVector(this.posX, this.posY + (double)this.getEyeHeight(), this.posZ), Vec3D.createVector(entity.posX, entity.posY + (double)entity.getEyeHeight(), entity.posZ)) == null;
    }

    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    public boolean canBePushed() {
        return !this.isDead;
    }

    public float getEyeHeight() {
        return this.height * 0.85f;
    }

    public int getTalkInterval() {
        return 80;
    }

    public void playLivingSound() {
        String s = this.getLivingSound();
        if (s != null) {
            this.worldObj.playSoundAtEntity(this, s, this.getSoundVolume(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
        }
    }

    public void onEntityUpdate() {
        this.prevSwingProgress = this.swingProgress;
        super.onEntityUpdate();
        if (this.rand.nextInt(1000) < this.livingSoundTime++) {
            this.livingSoundTime = -this.getTalkInterval();
            this.playLivingSound();
        }
        if (this.isEntityAlive() && this.isEntityInsideOpaqueBlock()) {
            this.attackEntityFrom(null, 1);
        }
        if (this.isImmuneToFire || this.worldObj.singleplayerWorld) {
            this.fire = 0;
        }
        if (this.isEntityAlive() && this.isInsideOfMaterial(Material.water) && !this.canBreatheUnderwater()) {
            if (this.spongeArmor > 0 && this.airQuart > 0) {
                --this.airQuart;
            } else if (this.spongeArmor == 0 || this.airQuart == 0) {
                --this.air;
                this.airQuart = this.spongeArmor;
            }
            if (this.air == -20) {
                this.air = 0;
                int i = 0;
                while (i < 8) {
                    float f = this.rand.nextFloat() - this.rand.nextFloat();
                    float f1 = this.rand.nextFloat() - this.rand.nextFloat();
                    float f2 = this.rand.nextFloat() - this.rand.nextFloat();
                    this.worldObj.spawnParticle("bubble", this.posX + (double)f, this.posY + (double)f1, this.posZ + (double)f2, this.motionX, this.motionY, this.motionZ);
                    ++i;
                }
                this.attackEntityFrom(null, 2);
            }
            this.fire = 0;
        } else {
            this.air = this.maxAir;
        }
        this.field_9102_aX = this.field_9101_aY;
        if (this.attackTime > 0) {
            --this.attackTime;
        }
        if (this.hurtTime > 0) {
            --this.hurtTime;
        }
        if (this.field_9083_ac > 0) {
            --this.field_9083_ac;
        }
        if (this.health <= 0) {
            ++this.deathTime;
            if (this.deathTime > 20) {
                this.func_6101_K();
                this.setEntityDead();
                int j = 0;
                while (j < 20) {
                    double d = this.rand.nextGaussian() * 0.02;
                    double d1 = this.rand.nextGaussian() * 0.02;
                    double d2 = this.rand.nextGaussian() * 0.02;
                    this.worldObj.spawnParticle("explode", this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, d, d1, d2);
                    ++j;
                }
            }
        }
        this.field_9121_aE = this.field_9122_aD;
        this.prevRenderYawOffset = this.renderYawOffset;
        this.prevRotationYaw = this.rotationYaw;
        this.prevRotationPitch = this.rotationPitch;
    }

    public void spawnExplosionParticle() {
        int i = 0;
        while (i < 20) {
            double d = this.rand.nextGaussian() * 0.02;
            double d1 = this.rand.nextGaussian() * 0.02;
            double d2 = this.rand.nextGaussian() * 0.02;
            double d3 = 10.0;
            this.worldObj.spawnParticle("explode", this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width - d * d3, this.posY + (double)(this.rand.nextFloat() * this.height) - d1 * d3, this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width - d2 * d3, d, d1, d2);
            ++i;
        }
    }

    public void updateRidden() {
        super.updateRidden();
        this.field_9124_aB = this.field_9123_aC;
        this.field_9123_aC = 0.0f;
    }

    public void onUpdate() {
        boolean flag;
        super.onUpdate();
        this.onLivingUpdate();
        double d = this.posX - this.prevPosX;
        double d1 = this.posZ - this.prevPosZ;
        float f = MathHelper.sqrt_double(d * d + d1 * d1);
        float f1 = this.renderYawOffset;
        float f2 = 0.0f;
        this.field_9124_aB = this.field_9123_aC;
        float f3 = 0.0f;
        if (f > 0.05f) {
            f3 = 1.0f;
            f2 = f * 3.0f;
            f1 = (float)Math.atan2(d1, d) * 180.0f / 3.141593f - 90.0f;
        }
        if (this.swingProgress > 0.0f) {
            f1 = this.rotationYaw;
        }
        if (!this.onGround) {
            f3 = 0.0f;
        }
        this.field_9123_aC += (f3 - this.field_9123_aC) * 0.3f;
        float f4 = f1 - this.renderYawOffset;
        while (f4 < -180.0f) {
            f4 += 360.0f;
        }
        while (f4 >= 180.0f) {
            f4 -= 360.0f;
        }
        this.renderYawOffset += f4 * 0.3f;
        float f5 = this.rotationYaw - this.renderYawOffset;
        while (f5 < -180.0f) {
            f5 += 360.0f;
        }
        while (f5 >= 180.0f) {
            f5 -= 360.0f;
        }
        boolean bl = flag = f5 < -90.0f || f5 >= 90.0f;
        if (f5 < -75.0f) {
            f5 = -75.0f;
        }
        if (f5 >= 75.0f) {
            f5 = 75.0f;
        }
        this.renderYawOffset = this.rotationYaw - f5;
        if (f5 * f5 > 2500.0f) {
            this.renderYawOffset += f5 * 0.2f;
        }
        if (flag) {
            f2 *= -1.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        while (this.renderYawOffset - this.prevRenderYawOffset < -180.0f) {
            this.prevRenderYawOffset -= 360.0f;
        }
        while (this.renderYawOffset - this.prevRenderYawOffset >= 180.0f) {
            this.prevRenderYawOffset += 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        this.field_9122_aD += f2;
    }

    protected void setSize(float f, float f1) {
        super.setSize(f, f1);
    }

    public void heal(int i) {
        if (this.health <= 0) {
            return;
        }
        this.health += i;
        if (this.health > 20) {
            this.health = 20;
        }
        this.field_9083_ac = this.maxHealth / 2;
    }

    public boolean attackEntityFrom(Entity entity, int i) {
        if (this.worldObj.singleplayerWorld) {
            return false;
        }
        this.lifeTimer = 0;
        if (this.health <= 0) {
            return false;
        }
        this.field_9141_bd = 1.5f;
        boolean flag = true;
        if ((float)this.field_9083_ac > (float)this.maxHealth / 2.0f) {
            if (i <= this.field_9133_bm) {
                return false;
            }
            this.damageEntity(i - this.field_9133_bm);
            this.field_9133_bm = i;
            flag = false;
        } else {
            this.field_9133_bm = i;
            this.prevHealth = this.health;
            this.field_9083_ac = this.maxHealth;
            this.damageEntity(i);
            this.maxHurtTime = 10;
            this.hurtTime = 10;
        }
        this.attackedAtYaw = 0.0f;
        if (flag) {
            this.worldObj.sendTrackedEntityStatusUpdatePacket(this, (byte)2);
            this.setBeenAttacked();
            if (entity != null) {
                double d = entity.posX - this.posX;
                double d1 = entity.posZ - this.posZ;
                while (d * d + d1 * d1 < 1.0E-4) {
                    d = (Math.random() - Math.random()) * 0.01;
                    d1 = (Math.random() - Math.random()) * 0.01;
                }
                this.attackedAtYaw = (float)(Math.atan2(d1, d) * 180.0 / 3.1415927410125732) - this.rotationYaw;
                this.applyKnockBack(entity, i, d, d1);
            } else {
                this.attackedAtYaw = (int)(Math.random() * 2.0) * 180;
            }
        }
        if (this.health <= 0) {
            if (flag) {
                this.worldObj.playSoundAtEntity(this, this.getDeathSound(), this.getSoundVolume(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            }
            this.onDeath(entity);
        } else if (flag) {
            this.worldObj.playSoundAtEntity(this, this.getHurtSound(), this.getSoundVolume(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
        }
        return true;
    }

    protected void damageEntity(int i) {
        this.health -= i;
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    protected String getLivingSound() {
        return null;
    }

    protected String getHurtSound() {
        return "random.hurt";
    }

    protected String getDeathSound() {
        return "random.hurt";
    }

    public void applyKnockBack(Entity entity, int i, double d, double d1) {
        float f = MathHelper.sqrt_double(d * d + d1 * d1);
        float f1 = 0.4f;
        this.motionX /= 2.0;
        this.motionY /= 2.0;
        this.motionZ /= 2.0;
        this.motionX -= d / (double)f * (double)f1;
        this.motionY += (double)0.4f;
        this.motionZ -= d1 / (double)f * (double)f1;
        if (this.motionY > (double)0.4f) {
            this.motionY = 0.4f;
        }
    }

    public void onDeath(Entity entity) {
        if (this.scoreValue >= 0 && entity != null) {
            entity.addToPlayerScore(this, this.scoreValue);
        }
        if (entity != null) {
            entity.func_27010_a(this);
        }
        this.unused_flag = true;
        if (!this.worldObj.singleplayerWorld) {
            this.dropFewItems();
        }
        this.worldObj.sendTrackedEntityStatusUpdatePacket(this, (byte)3);
    }

    protected void dropFewItems() {
        int i = this.getDropItemId();
        if (i > 0) {
            int j = this.rand.nextInt(3);
            int k = 0;
            while (k < j) {
                this.dropItem(i, 1);
                ++k;
            }
        }
    }

    protected int getDropItemId() {
        return 0;
    }

    protected void fall(float fallDist) {
        super.fall(fallDist);
        int damage = (int)Math.ceil(fallDist - 3.0f) - this.goldArmor * 2;
        if (damage > 0) {
            this.attackEntityFrom(null, damage);
            int j = this.worldObj.getBlockId(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY - (double)0.2f - (double)this.yOffset), MathHelper.floor_double(this.posZ));
            if (j > 0) {
                StepSound stepsound = Block.allBlocks[j].stepSound;
                this.worldObj.playSoundAtEntity(this, stepsound.stepSoundDir(), stepsound.getVolume() * 0.5f, stepsound.getPitch() * 0.75f);
            }
        }
    }

    public void moveEntityWithHeading(float f, float f1) {
        if (this.isInWater()) {
            double d = this.posY;
            this.moveFlying(f, f1, 0.02f);
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            this.motionX *= (double)0.8f;
            this.motionY *= (double)0.8f;
            this.motionZ *= (double)0.8f;
            this.motionY -= 0.02;
            this.motionX += this.motionX * ((double)(this.spongeArmor / 4) * 0.15);
            this.motionZ += this.motionZ * ((double)(this.spongeArmor / 4) * 0.15);
            if (this.isCollidedHorizontally && this.isOffsetPositionInLiquid(this.motionX, this.motionY + (double)0.6f - this.posY + d, this.motionZ)) {
                this.motionY = 0.3f;
            }
        } else if (this.handleLavaMovement()) {
            double d1 = this.posY;
            this.moveFlying(f, f1, 0.02f);
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            this.motionX *= 0.5;
            this.motionY *= 0.5;
            this.motionZ *= 0.5;
            this.motionY -= 0.02;
            if (this.isCollidedHorizontally && this.isOffsetPositionInLiquid(this.motionX, this.motionY + (double)0.6f - this.posY + d1, this.motionZ)) {
                this.motionY = 0.3f;
            }
        } else {
            float f2 = 0.91f;
            if (this.onGround) {
                f2 = 0.5460001f;
                int i = this.worldObj.getBlockId(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.boundingBox.minY) - 1, MathHelper.floor_double(this.posZ));
                if (i > 0) {
                    f2 = Block.allBlocks[i].slipperiness * 0.91f;
                }
            }
            float f3 = 0.1627714f / (f2 * f2 * f2);
            this.moveFlying(f, f1, this.onGround ? 0.1f * f3 : 0.02f);
            f2 = 0.91f;
            if (this.onGround) {
                f2 = 0.5460001f;
                int j = this.worldObj.getBlockId(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.boundingBox.minY) - 1, MathHelper.floor_double(this.posZ));
                if (j > 0) {
                    f2 = Block.allBlocks[j].slipperiness * 0.91f;
                }
            }
            if (this.isOnLadder()) {
                float f4 = 0.15f;
                if (this.motionX < (double)(-f4)) {
                    this.motionX = -f4;
                }
                if (this.motionX > (double)f4) {
                    this.motionX = f4;
                }
                if (this.motionZ < (double)(-f4)) {
                    this.motionZ = -f4;
                }
                if (this.motionZ > (double)f4) {
                    this.motionZ = f4;
                }
                this.fallDistance = 0.0f;
                if (this.motionY < -0.15) {
                    this.motionY = -0.15;
                }
                if (this.isSneaking() && this.motionY < 0.0) {
                    this.motionY = 0.0;
                }
            }
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            if (this.isCollidedHorizontally && this.isOnLadder()) {
                this.motionY = 0.2;
            }
            this.motionY -= 0.08;
            this.motionY *= (double)0.98f;
            this.motionX *= (double)f2;
            this.motionZ *= (double)f2;
        }
        this.field_9142_bc = this.field_9141_bd;
        double d2 = this.posX - this.prevPosX;
        double d3 = this.posZ - this.prevPosZ;
        float f5 = MathHelper.sqrt_double(d2 * d2 + d3 * d3) * 4.0f;
        if (f5 > 1.0f) {
            f5 = 1.0f;
        }
        this.field_9141_bd += (f5 - this.field_9141_bd) * 0.4f;
        this.field_386_ba += this.field_9141_bd;
    }

    public boolean isOnLadder() {
        int k;
        int j;
        int i = MathHelper.floor_double(this.posX);
        return this.worldObj.getBlockId(i, j = MathHelper.floor_double(this.boundingBox.minY), k = MathHelper.floor_double(this.posZ)) == Block.ladder.blockID;
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setShort("Health", (short)this.health);
        nbttagcompound.setShort("HurtTime", (short)this.hurtTime);
        nbttagcompound.setShort("DeathTime", (short)this.deathTime);
        nbttagcompound.setShort("AttackTime", (short)this.attackTime);
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        this.health = nbttagcompound.getShort("Health");
        if (!nbttagcompound.hasKey("Health")) {
            this.health = 10;
        }
        this.hurtTime = nbttagcompound.getShort("HurtTime");
        this.deathTime = nbttagcompound.getShort("DeathTime");
        this.attackTime = nbttagcompound.getShort("AttackTime");
    }

    public boolean isEntityAlive() {
        return !this.isDead && this.health > 0;
    }

    public boolean canBreatheUnderwater() {
        return false;
    }

    public void onLivingUpdate() {
        if (this.field_9140_bf > 0) {
            double d = this.posX + (this.field_9139_bg - this.posX) / (double)this.field_9140_bf;
            double d1 = this.posY + (this.field_9138_bh - this.posY) / (double)this.field_9140_bf;
            double d2 = this.posZ + (this.field_9137_bi - this.posZ) / (double)this.field_9140_bf;
            double d3 = this.field_9136_bj - (double)this.rotationYaw;
            while (d3 < -180.0) {
                d3 += 360.0;
            }
            while (d3 >= 180.0) {
                d3 -= 360.0;
            }
            this.rotationYaw = (float)((double)this.rotationYaw + d3 / (double)this.field_9140_bf);
            this.rotationPitch = (float)((double)this.rotationPitch + (this.field_9135_bk - (double)this.rotationPitch) / (double)this.field_9140_bf);
            --this.field_9140_bf;
            this.setPosition(d, d1, d2);
            this.setRotation(this.rotationYaw, this.rotationPitch);
            List list1 = this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox.getInsetBoundingBox(0.03125, 0.0, 0.03125));
            if (list1.size() > 0) {
                double d4 = 0.0;
                int j = 0;
                while (j < list1.size()) {
                    AxisAlignedBB axisalignedbb = (AxisAlignedBB)list1.get(j);
                    if (axisalignedbb.maxY > d4) {
                        d4 = axisalignedbb.maxY;
                    }
                    ++j;
                }
                this.setPosition(d, d1 += d4 - this.boundingBox.minY, d2);
            }
        }
        if (this.isMovementBlocked()) {
            this.isJumping = false;
            this.moveStrafing = 0.0f;
            this.moveForward = 0.0f;
            this.randomYawVelocity = 0.0f;
        } else if (!this.isMultiplayerEntity) {
            this.updateEntityActionState();
        }
        boolean flag = this.isInWater();
        boolean flag1 = this.handleLavaMovement();
        if (this.isJumping) {
            if (flag) {
                this.motionY += (double)0.04f;
            } else if (flag1) {
                this.motionY += (double)0.04f;
            } else if (this.onGround) {
                this.jump();
            }
        }
        this.moveStrafing *= 0.98f;
        this.moveForward *= 0.98f;
        this.randomYawVelocity *= 0.9f;
        this.moveEntityWithHeading(this.moveStrafing, this.moveForward);
        List list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.expand(0.2f, 0.0, 0.2f));
        if (list != null && list.size() > 0) {
            int i = 0;
            while (i < list.size()) {
                Entity entity = (Entity)list.get(i);
                if (entity.canBePushed()) {
                    entity.applyEntityCollision(this);
                }
                ++i;
            }
        }
    }

    protected boolean isMovementBlocked() {
        return this.health <= 0;
    }

    protected void jump() {
        this.motionY = 0.42f;
    }

    protected boolean func_25020_s() {
        return true;
    }

    protected void func_27013_Q() {
        EntityPlayer entityplayer = this.worldObj.getClosestPlayerToEntity(this, -1.0);
        if (this.func_25020_s() && entityplayer != null) {
            double d = entityplayer.posX - this.posX;
            double d1 = entityplayer.posY - this.posY;
            double d2 = entityplayer.posZ - this.posZ;
            double d3 = d * d + d1 * d1 + d2 * d2;
            if (d3 > 16384.0 && !this.isSpecial) {
                this.setEntityDead();
            }
            if (this.lifeTimer > 600 && this.rand.nextInt(800) == 0 && !this.isSpecial) {
                if (d3 < 1024.0) {
                    this.lifeTimer = 0;
                } else {
                    this.setEntityDead();
                }
            }
        }
    }

    protected void updateEntityActionState() {
        ++this.lifeTimer;
        EntityPlayer entityplayer = this.worldObj.getClosestPlayerToEntity(this, -1.0);
        this.func_27013_Q();
        this.moveStrafing = 0.0f;
        this.moveForward = 0.0f;
        float f = 8.0f;
        if (this.rand.nextFloat() < 0.02f) {
            EntityPlayer entityplayer1 = this.worldObj.getClosestPlayerToEntity(this, f);
            if (entityplayer1 != null) {
                this.currentTarget = entityplayer1;
                this.numTicksToChaseTarget = 10 + this.rand.nextInt(20);
            } else {
                this.randomYawVelocity = (this.rand.nextFloat() - 0.5f) * 20.0f;
            }
        }
        if (this.currentTarget != null) {
            this.faceEntity(this.currentTarget, 10.0f, this.func_25018_n_());
            if (this.numTicksToChaseTarget-- <= 0 || this.currentTarget.isDead || this.currentTarget.getDistanceSqToEntity(this) > (double)(f * f)) {
                this.currentTarget = null;
            }
        } else {
            if (this.rand.nextFloat() < 0.05f) {
                this.randomYawVelocity = (this.rand.nextFloat() - 0.5f) * 20.0f;
            }
            this.rotationYaw += this.randomYawVelocity;
            this.rotationPitch = this.defaultPitch;
        }
        boolean flag = this.isInWater();
        boolean flag1 = this.handleLavaMovement();
        if (flag || flag1) {
            this.isJumping = this.rand.nextFloat() < 0.8f;
        }
    }

    protected int func_25018_n_() {
        return 40;
    }

    public void faceEntity(Entity entity, float f, float f1) {
        double d1;
        double d = entity.posX - this.posX;
        double d2 = entity.posZ - this.posZ;
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            d1 = this.posY + (double)this.getEyeHeight() - (entityliving.posY + (double)entityliving.getEyeHeight());
        } else {
            d1 = (entity.boundingBox.minY + entity.boundingBox.maxY) / 2.0 - (this.posY + (double)this.getEyeHeight());
        }
        double d3 = MathHelper.sqrt_double(d * d + d2 * d2);
        float f2 = (float)(Math.atan2(d2, d) * 180.0 / 3.1415927410125732) - 90.0f;
        float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / 3.1415927410125732));
        this.rotationPitch = this.updateRotation(this.rotationPitch, f3, f1);
        this.rotationYaw = this.updateRotation(this.rotationYaw, f2, f);
    }

    public boolean func_25021_O() {
        return this.currentTarget != null;
    }

    public Entity getCurrentTarget() {
        return this.currentTarget;
    }

    private float updateRotation(float f, float f1, float f2) {
        float f3 = f1 - f;
        while (f3 < -180.0f) {
            f3 += 360.0f;
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        if (f3 > f2) {
            f3 = f2;
        }
        if (f3 < -f2) {
            f3 = -f2;
        }
        return f + f3;
    }

    public void func_6101_K() {
    }

    public boolean shouldSpawnOnTile() {
        return this.worldObj.checkIfAABBIsClear(this.boundingBox) && this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox).size() == 0 && !this.worldObj.getIsAnyLiquid(this.boundingBox);
    }

    protected void kill() {
        this.attackEntityFrom(null, 4);
    }

    public Vec3D getLookVec() {
        return this.getLook(1.0f);
    }

    public Vec3D getLook(float f) {
        if (f == 1.0f) {
            float f1 = MathHelper.cos(-this.rotationYaw * 0.01745329f - 3.141593f);
            float f3 = MathHelper.sin(-this.rotationYaw * 0.01745329f - 3.141593f);
            float f5 = -MathHelper.cos(-this.rotationPitch * 0.01745329f);
            float f7 = MathHelper.sin(-this.rotationPitch * 0.01745329f);
            return Vec3D.createVector(f3 * f5, f7, f1 * f5);
        }
        float f2 = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * f;
        float f4 = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * f;
        float f6 = MathHelper.cos(-f4 * 0.01745329f - 3.141593f);
        float f8 = MathHelper.sin(-f4 * 0.01745329f - 3.141593f);
        float f9 = -MathHelper.cos(-f2 * 0.01745329f);
        float f10 = MathHelper.sin(-f2 * 0.01745329f);
        return Vec3D.createVector(f8 * f9, f10, f6 * f9);
    }

    public int getMaxSpawnedInChunk() {
        return 4;
    }

    public boolean func_22057_E() {
        return false;
    }

    public void tryToDespawn() {
        EntityPlayer entityplayer = this.worldObj.getClosestPlayerToEntity(this, -1.0);
        if (entityplayer != null) {
            double playerX = entityplayer.posX - this.posX;
            double playerY = entityplayer.posY - this.posY;
            double playerZ = entityplayer.posZ - this.posZ;
            double dist_squared = playerX * playerX + playerY * playerY + playerZ * playerZ;
            if (dist_squared > 16384.0 && !this.isSpecial) {
                this.setEntityDead();
            }
            if (this.lifeTimer > 600 && this.rand.nextInt(800) == 0 && !this.isSpecial) {
                if (dist_squared < 1024.0) {
                    this.lifeTimer = 0;
                } else {
                    this.setEntityDead();
                }
            }
        }
    }

    protected void updateEntityActionStateIndev() {
    }
}

