/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityCreature;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.EntityZombie;
import com.mojang.minecraft.entity.IMob;
import com.mojang.minecraft.enums.EnumSkyBlock;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.util.MathHelper;

public class EntityMob
extends EntityCreature
implements IMob {
    protected int attackStrength = 2;
    public double currentSpeed;

    public EntityMob(World world) {
        super(world);
        this.health = 20;
    }

    public void onLivingUpdate() {
        float f = this.getEntityBrightness(1.0f);
        if (f > 0.5f) {
            this.lifeTimer += 2;
        }
        super.onLivingUpdate();
    }

    public void onUpdate() {
        super.onUpdate();
        if (!this.worldObj.singleplayerWorld && this.worldObj.difficultySetting == 0) {
            this.setEntityDead();
        }
    }

    protected Entity findPlayerToAttack() {
        EntityPlayer entityplayer = this.worldObj.getClosestPlayerToEntity(this, 16.0);
        if (entityplayer != null && this.canEntityBeSeen(entityplayer)) {
            return entityplayer;
        }
        return null;
    }

    public boolean attackEntityFrom(Entity entity, int i) {
        if (super.attackEntityFrom(entity, i)) {
            if (this.riddenByEntity == entity || this.ridingEntity == entity) {
                return true;
            }
            if (entity != this) {
                this.entityToAttack = entity;
            }
            return true;
        }
        return false;
    }

    protected void attackEntity(Entity entity, float f) {
        if (this.attackTime <= 0 && f < 2.0f && entity.boundingBox.maxY > this.boundingBox.minY && entity.boundingBox.minY < this.boundingBox.maxY) {
            this.attackTime = 20;
            if (this.fire > 0 && this instanceof EntityZombie) {
                entity.fire = 100;
            }
            entity.attackEntityFrom(this, this.attackStrength - (entity.chainArmor + entity.diamondArmor) / 2);
        }
    }

    protected float getBlockPathWeight(int i, int j, int k) {
        return 0.5f - this.worldObj.getLightBrightness(i, j, k);
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
    }

    public boolean shouldSpawnOnTile() {
        int k;
        int j;
        int i = MathHelper.floor_double(this.posX);
        if (this.worldObj.getSavedLightValue(EnumSkyBlock.Sky, i, j = MathHelper.floor_double(this.boundingBox.minY), k = MathHelper.floor_double(this.posZ)) > this.rand.nextInt(32)) {
            return false;
        }
        int l = this.worldObj.getBlockLightValue(i, j, k);
        if (this.worldObj.func_27067_u()) {
            int i1 = this.worldObj.skylightSubtracted;
            this.worldObj.skylightSubtracted = 10;
            l = this.worldObj.getBlockLightValue(i, j, k);
            this.worldObj.skylightSubtracted = i1;
        }
        return l <= this.rand.nextInt(8) && super.shouldSpawnOnTile();
    }
}

