/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.EntityAnimal;
import com.mojang.minecraft.entity.EntityLightningBolt;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.nbt.NBTTagCompound;

public class EntityPig
extends EntityAnimal {
    public EntityPig(World world) {
        super(world);
        this.scoreValue = 10;
        this.texture = "/mob/pig.png";
        this.setSize(0.9f, 0.9f);
        this.setReal(true);
    }

    protected void entityInit() {
        this.dataWatcher.addObject(16, (byte)0);
        this.dataWatcher.addObject(15, (byte)0);
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        nbttagcompound.setBoolean("Saddle", this.getSaddled());
        nbttagcompound.setBoolean("Real", this.getReal());
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        this.setSaddled(nbttagcompound.getBoolean("Saddle"));
        this.setReal(nbttagcompound.getBoolean("Real"));
    }

    protected String getLivingSound() {
        return "mob.pig";
    }

    protected String getHurtSound() {
        return "mob.pig";
    }

    protected String getDeathSound() {
        return "mob.pigdeath";
    }

    public boolean interact(EntityPlayer entityplayer) {
        if (this.getSaddled() && !this.worldObj.singleplayerWorld && (this.riddenByEntity == null || this.riddenByEntity == entityplayer)) {
            entityplayer.mountEntity(this);
            return true;
        }
        return false;
    }

    protected int getDropItemId() {
        if (this.worldObj.singleplayerWorld || !this.getReal()) {
            return 0;
        }
        if (!this.getSaddled()) {
            if (this.fire > 0) {
                return Item.porkCooked.shiftedIndex;
            }
            return Item.porkRaw.shiftedIndex;
        }
        this.dropItem(Item.saddle.shiftedIndex, 1);
        if (this.fire > 0) {
            return Item.porkCooked.shiftedIndex;
        }
        return Item.porkRaw.shiftedIndex;
    }

    public boolean getReal() {
        return (this.dataWatcher.getWatchableObjectByte(15) & 1) == 0;
    }

    public void setReal(boolean isReal) {
        if (isReal) {
            this.dataWatcher.updateObject(15, (byte)0);
        } else {
            this.dataWatcher.updateObject(15, (byte)1);
        }
    }

    public boolean getSaddled() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 1) != 0;
    }

    public void setSaddled(boolean flag) {
        if (flag) {
            if (!this.getReal()) {
                this.worldObj.createExplosion(this, this.posX, this.posY, this.posZ, 2.0f);
                this.damageEntity(100);
            }
            this.dataWatcher.updateObject(16, (byte)1);
            this.isSpecial = true;
        } else {
            this.dataWatcher.updateObject(16, (byte)0);
            this.isSpecial = true;
        }
    }

    public void onStruckByLightning(EntityLightningBolt entitylightningbolt) {
    }

    protected void fall(float f) {
        super.fall(f);
        if (f > 5.0f) {
            boolean cfr_ignored_0 = this.riddenByEntity instanceof EntityPlayer;
        }
    }
}

