/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityArrow;
import com.mojang.minecraft.entity.EntityBoat;
import com.mojang.minecraft.entity.EntityCreeper;
import com.mojang.minecraft.entity.EntityFish;
import com.mojang.minecraft.entity.EntityGhast;
import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityMinecart;
import com.mojang.minecraft.entity.EntityMob;
import com.mojang.minecraft.entity.EntityPig;
import com.mojang.minecraft.entity.EntitySkeleton;
import com.mojang.minecraft.entity.EntitySpider;
import com.mojang.minecraft.entity.EntityWolf;
import com.mojang.minecraft.entity.EntityZombie;
import com.mojang.minecraft.entity.item.IInventory;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.TileEntityDispenser;
import com.mojang.minecraft.entity.tile.TileEntityFurnace;
import com.mojang.minecraft.entity.tile.TileEntitySign;
import com.mojang.minecraft.enums.EnumStatus;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.ChunkCoordinates;
import com.mojang.minecraft.level.generate.IChunkProvider;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockBleedingObsidian;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.nbt.NBTTagInt;
import com.mojang.minecraft.nbt.NBTTagList;
import com.mojang.minecraft.player.inventory.Container;
import com.mojang.minecraft.player.inventory.ContainerPlayer;
import com.mojang.minecraft.player.inventory.InventoryPlayer;
import com.mojang.minecraft.util.MathHelper;
import java.util.List;

public abstract class EntityPlayer
extends EntityLiving {
    public InventoryPlayer inventory = new InventoryPlayer(this);
    public Container personalCraftingInventory;
    public Container currentCraftingInventory;
    public byte field_9152_am = 0;
    public int score = 0;
    public float field_9150_ao;
    public float field_9149_ap;
    public boolean isSwinging = false;
    public int swingProgressInt = 0;
    public String username;
    public int dimension;
    public double field_20047_ay;
    public double field_20046_az;
    public double field_20051_aA;
    public double field_20050_aB;
    public double field_20049_aC;
    public double field_20048_aD;
    protected boolean sleeping;
    public ChunkCoordinates playerLocation;
    private int sleepTimer;
    public float field_22066_z;
    public float field_22067_A;
    private ChunkCoordinates spawnChunk;
    private ChunkCoordinates field_27995_d;
    public int timeUntilPortal = 20;
    protected boolean inPortal = false;
    public float timeInPortal;
    private int damageRemainder = 0;
    public EntityFish fishEntity = null;
    private ItemStack itemBeingUsed;
    public int itemUseTime;

    public EntityPlayer(World world) {
        super(world);
        this.currentCraftingInventory = this.personalCraftingInventory = new ContainerPlayer(this.inventory, !world.singleplayerWorld);
        this.yOffset = 1.62f;
        ChunkCoordinates chunkcoordinates = world.getSpawnPoint();
        this.setLocationAndAngles((double)chunkcoordinates.posX + 0.5, chunkcoordinates.posY + 1, (double)chunkcoordinates.posZ + 0.5, 0.0f, 0.0f);
        this.health = 20;
        this.entityType = "humanoid";
        this.field_9117_aI = 180.0f;
        this.fireResistance = 20;
        this.texture = "/mob/char.png";
        this.spongeArmor = 0;
        this.leatherArmor = 0;
        this.goldArmor = 0;
        this.chainArmor = 0;
        this.steelArmor = 0;
        this.diamondArmor = 0;
        this.measureBlockX = 0;
        this.measureBlockY = 0;
        this.measureBlockZ = 0;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (byte)0);
    }

    public void onUpdate() {
        if (this.func_22057_E()) {
            ++this.sleepTimer;
            if (this.sleepTimer > 100) {
                this.sleepTimer = 100;
            }
            if (!this.worldObj.singleplayerWorld) {
                if (!this.isInBed()) {
                    this.wakeUpPlayer(true, true, false);
                } else if (this.worldObj.isDaytime()) {
                    this.wakeUpPlayer(false, true, true);
                }
            }
        } else if (this.sleepTimer > 0) {
            ++this.sleepTimer;
            if (this.sleepTimer >= 110) {
                this.sleepTimer = 0;
            }
        }
        super.onUpdate();
        if (this.itemBeingUsed != null) {
            ItemStack itemstack = this.inventory.getCurrentItem();
            if (this.itemUseTime <= 25) {
                int cfr_ignored_0 = this.itemUseTime % 4;
            }
            if (--this.itemUseTime == 0) {
                boolean cfr_ignored_1 = this.worldObj.singleplayerWorld;
            }
        }
        if (!this.worldObj.singleplayerWorld && this.currentCraftingInventory != null && !this.currentCraftingInventory.canInteractWith(this)) {
            this.usePersonalCraftingInventory();
            this.currentCraftingInventory = this.personalCraftingInventory;
        }
        this.field_20047_ay = this.field_20050_aB;
        this.field_20046_az = this.field_20049_aC;
        this.field_20051_aA = this.field_20048_aD;
        double d = this.posX - this.field_20050_aB;
        double d1 = this.posY - this.field_20049_aC;
        double d2 = this.posZ - this.field_20048_aD;
        double d3 = 10.0;
        if (d > d3) {
            this.field_20047_ay = this.field_20050_aB = this.posX;
        }
        if (d2 > d3) {
            this.field_20051_aA = this.field_20048_aD = this.posZ;
        }
        if (d1 > d3) {
            this.field_20046_az = this.field_20049_aC = this.posY;
        }
        if (d < -d3) {
            this.field_20047_ay = this.field_20050_aB = this.posX;
        }
        if (d2 < -d3) {
            this.field_20051_aA = this.field_20048_aD = this.posZ;
        }
        if (d1 < -d3) {
            this.field_20046_az = this.field_20049_aC = this.posY;
        }
        this.field_20050_aB += d * 0.25;
        this.field_20048_aD += d2 * 0.25;
        this.field_20049_aC += d1 * 0.25;
        if (this.ridingEntity == null) {
            this.field_27995_d = null;
        }
    }

    protected boolean isMovementBlocked() {
        return this.health <= 0 || this.func_22057_E();
    }

    protected void usePersonalCraftingInventory() {
        this.currentCraftingInventory = this.personalCraftingInventory;
    }

    public void updateRidden() {
        double d = this.posX;
        double d1 = this.posY;
        double d2 = this.posZ;
        super.updateRidden();
        this.field_9150_ao = this.field_9149_ap;
        this.field_9149_ap = 0.0f;
        this.func_27015_h(this.posX - d, this.posY - d1, this.posZ - d2);
    }

    protected void updateEntityActionState() {
        if (this.isSwinging) {
            ++this.swingProgressInt;
            if (this.swingProgressInt >= 8) {
                this.swingProgressInt = 0;
                this.isSwinging = false;
            }
        } else {
            this.swingProgressInt = 0;
        }
        this.swingProgress = (float)this.swingProgressInt / 8.0f;
    }

    public void onLivingUpdate() {
        List list;
        if (this.worldObj.difficultySetting == 0 && this.health < 20 && this.ticksExisted % 20 * 12 == 0) {
            this.heal(1);
        }
        int spongeCount = this.inventory.getSpongeCount();
        this.spongeArmor = this.inventory.getArmorCount("sponge");
        this.leatherArmor = this.inventory.getArmorCount("leather");
        this.goldArmor = this.inventory.getArmorCount("gold");
        this.chainArmor = this.inventory.getArmorCount("chain");
        this.steelArmor = this.inventory.getArmorCount("steel");
        this.diamondArmor = this.inventory.getArmorCount("diamond");
        this.inventory.decrementAnimations();
        this.field_9150_ao = this.field_9149_ap;
        super.onLivingUpdate();
        float f = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionZ * this.motionZ);
        float f1 = (float)Math.atan(-this.motionY * (double)0.2f) * 15.0f;
        if (f > 0.1f) {
            f = 0.1f;
        }
        if (!this.onGround || this.health <= 0) {
            f = 0.0f;
        }
        if (this.onGround || this.health <= 0) {
            f1 = 0.0f;
        }
        this.field_9149_ap += (f - this.field_9149_ap) * 0.4f;
        this.field_9101_aY += (f1 - this.field_9101_aY) * 0.8f;
        if (this.health > 0 && (list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.expand(1.0, 0.0, 1.0))) != null) {
            int i = 0;
            while (i < list.size()) {
                Entity entity = (Entity)list.get(i);
                if (!entity.isDead) {
                    this.func_171_h(entity);
                }
                ++i;
            }
        }
    }

    private void func_171_h(Entity entity) {
        entity.onCollideWithPlayer(this);
    }

    public void onDeath(Entity entity) {
        super.onDeath(entity);
        this.setSize(0.2f, 0.2f);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.motionY = 0.1f;
        if (this.username.equals("Noptch")) {
            this.dropPlayerItemWithRandomChoice(new ItemStack(Item.appleRed, 1), true);
        }
        this.inventory.dropAllItems();
        if (entity != null) {
            this.motionX = -MathHelper.cos((this.attackedAtYaw + this.rotationYaw) * 3.141593f / 180.0f) * 0.1f;
            this.motionZ = -MathHelper.sin((this.attackedAtYaw + this.rotationYaw) * 3.141593f / 180.0f) * 0.1f;
        } else {
            this.motionZ = 0.0;
            this.motionX = 0.0;
        }
        this.yOffset = 0.1f;
    }

    public void addToPlayerScore(Entity entity, int i) {
        this.score += i;
        boolean cfr_ignored_0 = entity instanceof EntityPlayer;
    }

    public void dropCurrentItem() {
        this.dropPlayerItemWithRandomChoice(this.inventory.decrStackSize(this.inventory.currentItem, 1), false);
    }

    public void dropPlayerItem(ItemStack itemstack) {
        this.dropPlayerItemWithRandomChoice(itemstack, false);
    }

    public void dropPlayerItemWithRandomChoice(ItemStack itemstack, boolean flag) {
        if (itemstack == null) {
            return;
        }
        EntityItem entityitem = new EntityItem(this.worldObj, this.posX, this.posY - (double)0.3f + (double)this.getEyeHeight(), this.posZ, itemstack);
        entityitem.delayBeforeCanPickup = 40;
        float f = 0.1f;
        if (flag) {
            float f2 = this.rand.nextFloat() * 0.5f;
            float f4 = this.rand.nextFloat() * 3.141593f * 2.0f;
            entityitem.motionX = -MathHelper.sin(f4) * f2;
            entityitem.motionZ = MathHelper.cos(f4) * f2;
            entityitem.motionY = 0.2f;
        } else {
            float f1 = 0.3f;
            entityitem.motionX = -MathHelper.sin(this.rotationYaw / 180.0f * 3.141593f) * MathHelper.cos(this.rotationPitch / 180.0f * 3.141593f) * f1;
            entityitem.motionZ = MathHelper.cos(this.rotationYaw / 180.0f * 3.141593f) * MathHelper.cos(this.rotationPitch / 180.0f * 3.141593f) * f1;
            entityitem.motionY = -MathHelper.sin(this.rotationPitch / 180.0f * 3.141593f) * f1 + 0.1f;
            f1 = 0.02f;
            float f3 = this.rand.nextFloat() * 3.141593f * 2.0f;
            entityitem.motionX += Math.cos(f3) * (double)(f1 *= this.rand.nextFloat());
            entityitem.motionY += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f);
            entityitem.motionZ += Math.sin(f3) * (double)f1;
        }
        this.joinEntityItemWithWorld(entityitem);
    }

    protected void joinEntityItemWithWorld(EntityItem entityitem) {
        this.worldObj.entityJoinedWorld(entityitem);
    }

    public float getCurrentPlayerStrVsBlock(Block block) {
        float f = this.inventory.getStrVsBlock(block);
        if (this.isInsideOfMaterial(Material.water)) {
            f = this.spongeArmor > 0 ? (f /= (float)(5 - this.spongeArmor)) : (f /= 5.0f);
        }
        if (!this.onGround) {
            f /= 5.0f;
        }
        return f;
    }

    public boolean canHarvestBlock(Block block) {
        return this.inventory.canHarvestBlock(block);
    }

    public boolean checkGoldTouch(Block block) {
        return this.inventory.canHarvestBlockGoldTouch(block);
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.getTagList("Inventory");
        this.inventory.readFromNBT(nbttaglist);
        this.dimension = nbttagcompound.getInteger("Dimension");
        this.sleeping = nbttagcompound.getBoolean("Sleeping");
        this.sleepTimer = nbttagcompound.getShort("SleepTimer");
        if (this.sleeping) {
            this.playerLocation = new ChunkCoordinates(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ));
            this.wakeUpPlayer(true, true, false);
        }
        if (nbttagcompound.hasKey("SpawnX") && nbttagcompound.hasKey("SpawnY") && nbttagcompound.hasKey("SpawnZ")) {
            this.spawnChunk = new ChunkCoordinates(nbttagcompound.getInteger("SpawnX"), nbttagcompound.getInteger("SpawnY"), nbttagcompound.getInteger("SpawnZ"));
        }
        try {
            NBTTagList measure = nbttagcompound.getTagList("MeasuringFrom");
            this.measureBlockX = ((NBTTagInt)measure.tagAt((int)0)).intValue;
            this.measureBlockY = ((NBTTagInt)measure.tagAt((int)1)).intValue;
            this.measureBlockZ = ((NBTTagInt)measure.tagAt((int)2)).intValue;
        }
        catch (Exception ex) {
            System.out.println("Old save data was missing a doohickey and/or gizmo!");
        }
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        nbttagcompound.setTag("Inventory", this.inventory.writeToNBT(new NBTTagList()));
        nbttagcompound.setInteger("Dimension", this.dimension);
        nbttagcompound.setBoolean("Sleeping", this.sleeping);
        nbttagcompound.setShort("SleepTimer", (short)this.sleepTimer);
        if (this.spawnChunk != null) {
            nbttagcompound.setInteger("SpawnX", this.spawnChunk.posX);
            nbttagcompound.setInteger("SpawnY", this.spawnChunk.posY);
            nbttagcompound.setInteger("SpawnZ", this.spawnChunk.posZ);
        }
        nbttagcompound.setTag("MeasuringFrom", this.newIntNBTList(new int[]{this.measureBlockX, this.measureBlockY, this.measureBlockZ}));
    }

    public void displayGUIChest(IInventory iinventory) {
    }

    public void displayWorkbenchGUI(int i, int j, int k) {
    }

    public void onItemPickup(Entity entity, int i) {
    }

    public float getEyeHeight() {
        return 0.12f;
    }

    protected void resetHeight() {
        this.yOffset = 1.62f;
    }

    public boolean attackEntityFrom(Entity entity, int i) {
        this.lifeTimer = 0;
        if (this.health <= 0) {
            return false;
        }
        if (this.func_22057_E() && !this.worldObj.singleplayerWorld) {
            this.wakeUpPlayer(true, true, false);
        }
        if (entity instanceof EntityMob || entity instanceof EntityArrow) {
            if (this.worldObj.difficultySetting == 0) {
                i = 0;
            }
            if (this.worldObj.difficultySetting == 1) {
                i = i / 3 + 1;
            }
            if (this.worldObj.difficultySetting == 3) {
                i = i * 3 / 2;
            }
        }
        if (!(i != 0 || entity instanceof EntityArrow || entity instanceof EntitySpider || entity instanceof EntityZombie || entity instanceof EntitySkeleton)) {
            return false;
        }
        Entity obj = entity;
        if (obj instanceof EntityArrow && ((EntityArrow)obj).owner != null) {
            obj = ((EntityArrow)obj).owner;
        }
        if (obj instanceof EntityLiving) {
            this.func_25047_a((EntityLiving)obj, false);
        }
        return super.attackEntityFrom(entity, i);
    }

    protected boolean isPVPEnabled() {
        return false;
    }

    protected void func_25047_a(EntityLiving entityliving, boolean flag) {
        EntityWolf entitywolf;
        if (entityliving instanceof EntityCreeper || entityliving instanceof EntityGhast) {
            return;
        }
        if (entityliving instanceof EntityWolf && (entitywolf = (EntityWolf)entityliving).func_25030_y() && this.username.equals(entitywolf.getOwner())) {
            return;
        }
        if (entityliving instanceof EntityPlayer && !this.isPVPEnabled()) {
            return;
        }
        List list = this.worldObj.getEntitiesWithinAABB(EntityWolf.class, AxisAlignedBB.getBoundingBoxFromPool(this.posX, this.posY, this.posZ, this.posX + 1.0, this.posY + 1.0, this.posZ + 1.0).expand(16.0, 4.0, 16.0));
        for (Entity entity : list) {
            EntityWolf entitywolf1 = (EntityWolf)entity;
            if (!entitywolf1.func_25030_y() || entitywolf1.getEntityToAttack() != null || !this.username.equals(entitywolf1.getOwner()) || flag && entitywolf1.getIsSitting()) continue;
            entitywolf1.setIsSitting(false);
            entitywolf1.setEntityToAttack(entityliving);
        }
    }

    protected void damageEntity(int i) {
        int j = 25 - this.inventory.getTotalArmorValue();
        int k = i * j + this.damageRemainder;
        this.inventory.damageArmor(i);
        i = k / 25;
        this.damageRemainder = k % 25;
        super.damageEntity(i);
    }

    public void displayGUIFurnace(TileEntityFurnace tileentityfurnace) {
    }

    public void displayGUIDispenser(TileEntityDispenser tileentitydispenser) {
    }

    public void displayGUIEditSign(TileEntitySign tileentitysign) {
    }

    public void useCurrentItemOnEntity(Entity entity) {
        if (entity.interact(this)) {
            return;
        }
        ItemStack itemstack = this.getCurrentEquippedItem();
        if (itemstack != null && entity instanceof EntityLiving) {
            itemstack.useItemOnEntity((EntityLiving)entity);
            if (itemstack.stackSize <= 0) {
                itemstack.func_577_a(this);
                this.destroyCurrentEquippedItem();
            }
        }
    }

    public ItemStack getCurrentEquippedItem() {
        return this.inventory.getCurrentItem();
    }

    public void destroyCurrentEquippedItem() {
        this.inventory.setInventorySlotContents(this.inventory.currentItem, null);
    }

    public double getYOffset() {
        return this.yOffset - 0.5f;
    }

    public void swingItem() {
        this.swingProgressInt = -1;
        this.isSwinging = true;
    }

    public void attackTargetEntityWithCurrentItem(Entity entity) {
        int i = this.inventory.getDamageVsEntity(entity);
        if (i > 0) {
            if (this.motionY < 0.0) {
                ++i;
            }
            entity.attackEntityFrom(this, i);
            ItemStack itemstack = this.getCurrentEquippedItem();
            if (itemstack != null && entity instanceof EntityLiving) {
                itemstack.hitEntity((EntityLiving)entity, this);
                if (itemstack.stackSize <= 0) {
                    itemstack.func_577_a(this);
                    this.destroyCurrentEquippedItem();
                }
            }
            if (entity instanceof EntityLiving && entity.isEntityAlive()) {
                this.func_25047_a((EntityLiving)entity, true);
            }
        }
    }

    public void onItemStackChanged(ItemStack itemstack) {
    }

    public void setEntityDead() {
        super.setEntityDead();
        this.personalCraftingInventory.onCraftGuiClosed(this);
        if (this.currentCraftingInventory != null) {
            this.currentCraftingInventory.onCraftGuiClosed(this);
        }
    }

    public boolean isEntityInsideOpaqueBlock() {
        return !this.sleeping && super.isEntityInsideOpaqueBlock();
    }

    public EnumStatus goToSleep(int i, int j, int k) {
        if (!this.worldObj.singleplayerWorld) {
            if (this.func_22057_E() || !this.isEntityAlive()) {
                return EnumStatus.OTHER_PROBLEM;
            }
            if (this.worldObj.worldProvider.field_6167_c) {
                return EnumStatus.NOT_POSSIBLE_HERE;
            }
            if (this.worldObj.isDaytime()) {
                return EnumStatus.NOT_POSSIBLE_NOW;
            }
            if (Math.abs(this.posX - (double)i) > 3.0 || Math.abs(this.posY - (double)j) > 2.0 || Math.abs(this.posZ - (double)k) > 3.0) {
                return EnumStatus.TOO_FAR_AWAY;
            }
        }
        this.setSize(0.2f, 0.2f);
        this.yOffset = 0.2f;
        if (this.worldObj.blockExists(i, j, k)) {
            int l = this.worldObj.getBlockMetadata(i, j, k);
            float f = 0.5f;
            float f1 = 0.5f;
            this.setPosition((float)i + f, (float)j + 0.9375f, (float)k + f1);
        } else {
            this.setPosition((float)i + 0.5f, (float)j + 0.9375f, (float)k + 0.5f);
        }
        this.sleeping = true;
        this.sleepTimer = 0;
        this.playerLocation = new ChunkCoordinates(i, j, k);
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.motionX = 0.0;
        if (!this.worldObj.singleplayerWorld) {
            this.worldObj.updateAllPlayersSleepingFlag();
        }
        return EnumStatus.OK;
    }

    private void func_22059_e(int i) {
        this.field_22066_z = 0.0f;
        this.field_22067_A = 0.0f;
        switch (i) {
            case 0: {
                this.field_22067_A = -1.8f;
                break;
            }
            case 2: {
                this.field_22067_A = 1.8f;
                break;
            }
            case 1: {
                this.field_22066_z = 1.8f;
                break;
            }
            case 3: {
                this.field_22066_z = -1.8f;
            }
        }
    }

    public void wakeUpPlayer(boolean flag, boolean flag1, boolean flag2) {
    }

    private boolean isInBed() {
        return false;
    }

    public static ChunkCoordinates func_25051_a(World world, ChunkCoordinates chunkcoordinates) {
        IChunkProvider ichunkprovider = world.getChunkProvider();
        ichunkprovider.loadChunk(chunkcoordinates.posX - 3 >> 4, chunkcoordinates.posZ - 3 >> 4);
        ichunkprovider.loadChunk(chunkcoordinates.posX + 3 >> 4, chunkcoordinates.posZ - 3 >> 4);
        ichunkprovider.loadChunk(chunkcoordinates.posX - 3 >> 4, chunkcoordinates.posZ + 3 >> 4);
        ichunkprovider.loadChunk(chunkcoordinates.posX + 3 >> 4, chunkcoordinates.posZ + 3 >> 4);
        ChunkCoordinates chunkcoordinates1 = BlockBleedingObsidian.func_22021_g(world, chunkcoordinates.posX, chunkcoordinates.posY, chunkcoordinates.posZ, 0);
        return chunkcoordinates1;
    }

    public boolean func_22057_E() {
        return this.sleeping;
    }

    public boolean isPlayerFullyAsleep() {
        return this.sleeping && this.sleepTimer >= 100;
    }

    public void addChatMessage(String s) {
    }

    public ChunkCoordinates getSpawnChunk() {
        return this.spawnChunk;
    }

    public void setSpawnChunk(ChunkCoordinates chunkcoordinates) {
        this.spawnChunk = chunkcoordinates != null ? new ChunkCoordinates(chunkcoordinates) : null;
    }

    protected void jump() {
        super.jump();
    }

    public void moveEntityWithHeading(float f, float f1) {
        double d = this.posX;
        double d1 = this.posY;
        double d2 = this.posZ;
        super.moveEntityWithHeading(f, f1);
        this.func_25045_g(this.posX - d, this.posY - d1, this.posZ - d2);
    }

    private void func_25045_g(double d, double d1, double d2) {
        if (this.ridingEntity != null) {
            return;
        }
        if (this.isInsideOfMaterial(Material.water)) {
            int n = Math.round(MathHelper.sqrt_double(d * d + d1 * d1 + d2 * d2) * 100.0f);
        } else if (this.isInWater()) {
            int n = Math.round(MathHelper.sqrt_double(d * d + d2 * d2) * 100.0f);
        } else if (!this.isOnLadder()) {
            if (this.onGround) {
                int n = Math.round(MathHelper.sqrt_double(d * d + d2 * d2) * 100.0f);
            } else {
                int n = Math.round(MathHelper.sqrt_double(d * d + d2 * d2) * 100.0f);
            }
        }
    }

    private void func_27015_h(double d, double d1, double d2) {
        int i;
        if (this.ridingEntity != null && (i = Math.round(MathHelper.sqrt_double(d * d + d1 * d1 + d2 * d2) * 100.0f)) > 0) {
            if (this.ridingEntity instanceof EntityMinecart) {
                if (this.field_27995_d == null) {
                    this.field_27995_d = new ChunkCoordinates(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ));
                } else {
                    this.field_27995_d.getSqDistanceTo(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ));
                }
            } else if (!(this.ridingEntity instanceof EntityBoat)) {
                boolean cfr_ignored_0 = this.ridingEntity instanceof EntityPig;
            }
        }
    }

    protected void fall(float f) {
        super.fall(f);
    }

    public void func_27010_a(EntityLiving entityliving) {
        boolean cfr_ignored_0 = entityliving instanceof EntityMob;
    }

    public void setInPortal() {
        if (this.timeUntilPortal > 0) {
            this.timeUntilPortal = 10;
            return;
        }
        this.inPortal = true;
    }

    public int[] getMeasuredBlock() {
        int[] list = new int[]{this.measureBlockX, this.measureBlockY, this.measureBlockZ};
        return list;
    }

    public boolean isMeasuringBlock() {
        return this.measureBlockX != 0 || this.measureBlockY != 0 || this.measureBlockZ != 0;
    }

    public void setMeasuredBlock(int x, int y, int z) {
        this.measureBlockX = x;
        this.measureBlockY = y;
        this.measureBlockZ = z;
    }

    public void startUsing(ItemStack itemstack, int i) {
        if (itemstack != null && this.itemBeingUsed != null && itemstack.itemID == this.itemBeingUsed.itemID) {
            return;
        }
        this.itemBeingUsed = itemstack;
        this.itemUseTime = i;
        if (!this.worldObj.singleplayerWorld) {
            this.setUsing(true);
        }
    }

    public void onPlayerStoppedUsing() {
        if (this.itemBeingUsed != null) {
            this.itemBeingUsed.onPlayerStoppedUsing(this.worldObj, this, this.itemUseTime);
        }
        this.stopUsing();
    }

    public void stopUsing() {
        this.itemBeingUsed = null;
        this.itemUseTime = 0;
        if (!this.worldObj.singleplayerWorld) {
            this.setUsing(false);
        }
    }
}

