/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityArrow;
import com.mojang.minecraft.entity.EntityCreeper;
import com.mojang.minecraft.entity.EntityGiant;
import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityPig;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.EntitySlime;
import com.mojang.minecraft.entity.EntitySpider;
import com.mojang.minecraft.entity.EntityTracker;
import com.mojang.minecraft.entity.EntityZombie;
import com.mojang.minecraft.entity.item.ICrafting;
import com.mojang.minecraft.entity.item.IInventory;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemInWorldManager;
import com.mojang.minecraft.entity.item.ItemMapBase;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.entity.tile.TileEntityDispenser;
import com.mojang.minecraft.entity.tile.TileEntityFurnace;
import com.mojang.minecraft.enums.EnumStatus;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.ChunkCoordIntPair;
import com.mojang.minecraft.level.chunk.ChunkCoordinates;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.network.NetServerHandler;
import com.mojang.minecraft.network.packet.Packet;
import com.mojang.minecraft.network.packet.Packet100OpenWindow;
import com.mojang.minecraft.network.packet.Packet101CloseWindow;
import com.mojang.minecraft.network.packet.Packet103SetSlot;
import com.mojang.minecraft.network.packet.Packet104WindowItems;
import com.mojang.minecraft.network.packet.Packet105UpdateProgressbar;
import com.mojang.minecraft.network.packet.Packet17Sleep;
import com.mojang.minecraft.network.packet.Packet18Animation;
import com.mojang.minecraft.network.packet.Packet22Collect;
import com.mojang.minecraft.network.packet.Packet39AttachEntity;
import com.mojang.minecraft.network.packet.Packet3Chat;
import com.mojang.minecraft.network.packet.Packet51MapChunk;
import com.mojang.minecraft.network.packet.Packet5PlayerInventory;
import com.mojang.minecraft.network.packet.Packet62CompassPosition;
import com.mojang.minecraft.network.packet.Packet8UpdateHealth;
import com.mojang.minecraft.player.inventory.Container;
import com.mojang.minecraft.player.inventory.ContainerChest;
import com.mojang.minecraft.player.inventory.ContainerFurnace;
import com.mojang.minecraft.player.inventory.ContainerWorkbench;
import com.mojang.minecraft.player.inventory.SlotCrafting;
import com.mojang.minecraft.server.MinecraftServer;
import com.mojang.minecraft.server.WorldServer;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class EntityPlayerMP
extends EntityPlayer
implements ICrafting {
    public NetServerHandler playerNetServerHandler;
    public MinecraftServer mcServer;
    public ItemInWorldManager itemInWorldManager;
    public double field_9155_d;
    public double field_9154_e;
    public List loadedChunks;
    public Set field_420_ah;
    private int lastHealth = -99999999;
    private int ticksOfInvuln = 60;
    boolean deathMessageSent = false;
    private ItemStack[] playerInventory = new ItemStack[5];
    private int currentWindowId = 0;
    public boolean isChangingQuantityOnly;

    public EntityPlayerMP(MinecraftServer minecraftserver, World world, String s, ItemInWorldManager iteminworldmanager) {
        super(world);
        this.loadedChunks = new LinkedList();
        this.field_420_ah = new HashSet();
        iteminworldmanager.thisPlayer = this;
        this.itemInWorldManager = iteminworldmanager;
        ChunkCoordinates chunkcoordinates = world.getSpawnPoint();
        int i = chunkcoordinates.posX;
        int j = chunkcoordinates.posZ;
        int k = chunkcoordinates.posY;
        if (!world.worldProvider.field_4306_c) {
            k = world.findTopSolidBlock(i += this.rand.nextInt(20) - 10, j);
            j += this.rand.nextInt(20) - 10;
        }
        this.setLocationAndAngles((double)i + 0.5, k, (double)j + 0.5, 0.0f, 0.0f);
        this.mcServer = minecraftserver;
        this.stepHeight = 0.0f;
        this.username = s;
        this.yOffset = 0.0f;
    }

    public void setWorldHandler(World world) {
        super.setWorldHandler(world);
        this.itemInWorldManager = new ItemInWorldManager((WorldServer)world);
        this.itemInWorldManager.thisPlayer = this;
    }

    public void func_20057_k() {
        this.currentCraftingInventory.onCraftGuiOpened(this);
    }

    public ItemStack[] getInventory() {
        return this.playerInventory;
    }

    protected void resetHeight() {
        this.yOffset = 0.0f;
    }

    public float getEyeHeight() {
        return 1.62f;
    }

    public void onUpdate() {
        this.itemInWorldManager.func_328_a();
        --this.ticksOfInvuln;
        this.currentCraftingInventory.updateCraftingMatrix();
        int i = 0;
        while (i < 5) {
            ItemStack itemstack = this.getEquipmentInSlot(i);
            if (itemstack != this.playerInventory[i]) {
                this.mcServer.getEntityTracker(this.dimension).sendPacketToTrackedPlayers(this, new Packet5PlayerInventory(this.entityId, i, itemstack));
                this.playerInventory[i] = itemstack;
            }
            ++i;
        }
    }

    public ItemStack getEquipmentInSlot(int i) {
        if (i == 0) {
            return this.inventory.getCurrentItem();
        }
        return this.inventory.armorInventory[i - 1];
    }

    protected void fall(float f) {
        super.fall(f);
        if (this.health <= 0 && !this.deathMessageSent) {
            this.playerNetServerHandler.mcServer.configManager.sendPacketToAllPlayers(new Packet3Chat("The ground hit " + this.username + " too hard"));
            this.deathMessageSent = true;
        }
    }

    public void addToPlayerScore(Entity entity, int i) {
        super.addToPlayerScore(entity, i);
        this.playerNetServerHandler.mcServer.updatePlayerScore(this.username, this.score);
    }

    public void onDeath(Entity entity) {
        System.out.println("PLAYER KILLED BY " + entity);
        this.inventory.dropAllItems();
        this.deathMessageSent = false;
        if (entity != null) {
            if (entity instanceof EntityCreeper && !this.deathMessageSent) {
                this.playerNetServerHandler.mcServer.configManager.sendPacketToAllPlayers(new Packet3Chat(String.valueOf(this.username) + " was blown to smitheroons by a Creeper"));
                this.deathMessageSent = true;
            }
            if (entity instanceof EntityZombie && !this.deathMessageSent) {
                this.playerNetServerHandler.mcServer.configManager.sendPacketToAllPlayers(new Packet3Chat(String.valueOf(this.username) + " was killed by a Zombie"));
                this.deathMessageSent = true;
            }
            if (entity instanceof EntityCreeper && !this.deathMessageSent) {
                this.playerNetServerHandler.mcServer.configManager.sendPacketToAllPlayers(new Packet3Chat(String.valueOf(this.username) + " was shot by a Skeleton"));
                this.deathMessageSent = true;
            }
            if (entity instanceof EntitySpider && !this.deathMessageSent) {
                this.playerNetServerHandler.mcServer.configManager.sendPacketToAllPlayers(new Packet3Chat(String.valueOf(this.username) + " was bit by a Spider"));
                this.deathMessageSent = true;
            }
            if (entity instanceof EntitySlime && !this.deathMessageSent) {
                this.playerNetServerHandler.mcServer.configManager.sendPacketToAllPlayers(new Packet3Chat(String.valueOf(this.username) + " was absorbed by a Slime"));
                this.deathMessageSent = true;
            }
            if (entity instanceof EntityGiant && !this.deathMessageSent) {
                this.playerNetServerHandler.mcServer.configManager.sendPacketToAllPlayers(new Packet3Chat(String.valueOf(this.username) + " was smushed by a Giant"));
                this.deathMessageSent = true;
            }
            if (entity instanceof EntityPig && !this.deathMessageSent) {
                this.playerNetServerHandler.mcServer.configManager.sendPacketToAllPlayers(new Packet3Chat(String.valueOf(this.username) + " was killed by a Pig... somehow?"));
                this.deathMessageSent = true;
            }
            if (entity instanceof EntityPlayer && !this.deathMessageSent) {
                if (((EntityPlayer)entity).getCurrentEquippedItem() == null) {
                    this.playerNetServerHandler.mcServer.configManager.sendPacketToAllPlayers(new Packet3Chat(String.valueOf(((EntityPlayer)entity).username) + " murdered " + this.username + " with their bare hands"));
                } else {
                    this.playerNetServerHandler.mcServer.configManager.sendPacketToAllPlayers(new Packet3Chat(String.valueOf(this.username) + " was murdered by " + ((EntityPlayer)entity).username));
                }
                this.deathMessageSent = true;
            }
        } else {
            if (this.air <= 0 && !this.deathMessageSent) {
                this.playerNetServerHandler.mcServer.configManager.sendPacketToAllPlayers(new Packet3Chat(String.valueOf(this.username) + " took a long walk off a short pier"));
                this.deathMessageSent = true;
            }
            if (this.fire >= 0 && !this.deathMessageSent) {
                this.playerNetServerHandler.mcServer.configManager.sendPacketToAllPlayers(new Packet3Chat(String.valueOf(this.username) + " didn't stop, drop, and roll"));
                this.deathMessageSent = true;
            }
        }
        if (!this.deathMessageSent) {
            this.playerNetServerHandler.mcServer.configManager.sendPacketToAllPlayers(new Packet3Chat(String.valueOf(this.username) + " died"));
            this.deathMessageSent = true;
        }
        this.playerNetServerHandler.mcServer.updatePlayerScore(this.username, 0);
    }

    public boolean attackEntityFrom(Entity entity, int i) {
        if (this.ticksOfInvuln > 0) {
            return false;
        }
        if (!this.mcServer.pvpOn) {
            if (entity instanceof EntityPlayer) {
                return false;
            }
            if (entity instanceof EntityArrow) {
                EntityArrow entityarrow = (EntityArrow)entity;
                if (entityarrow.owner instanceof EntityPlayer) {
                    return false;
                }
            }
        }
        return super.attackEntityFrom(entity, i);
    }

    protected boolean isPVPEnabled() {
        return this.mcServer.pvpOn;
    }

    public void heal(int i) {
        super.heal(i);
    }

    public void onUpdateEntity(boolean flag) {
        ChunkCoordIntPair chunkcoordintpair;
        super.onUpdate();
        int i = 0;
        while (i < this.inventory.getSizeInventory()) {
            Packet packet;
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack != null && Item.itemsList[itemstack.itemID].func_28019_b() && this.playerNetServerHandler.getNumChunkDataPackets() <= 2 && (packet = ((ItemMapBase)Item.itemsList[itemstack.itemID]).func_28022_b(itemstack, this.worldObj, this)) != null) {
                this.playerNetServerHandler.sendPacket(packet);
            }
            ++i;
        }
        if (flag && !this.loadedChunks.isEmpty() && (chunkcoordintpair = (ChunkCoordIntPair)this.loadedChunks.get(0)) != null) {
            boolean flag1 = false;
            if (this.playerNetServerHandler.getNumChunkDataPackets() < 4) {
                flag1 = true;
            }
            if (flag1) {
                WorldServer worldserver = this.mcServer.getWorldManager(this.dimension);
                this.loadedChunks.remove(chunkcoordintpair);
                this.playerNetServerHandler.sendPacket(new Packet51MapChunk(chunkcoordintpair.chunkXPos * 16, 0, chunkcoordintpair.chunkZPos * 16, 16, 128, 16, worldserver));
                List list = worldserver.getTileEntityList(chunkcoordintpair.chunkXPos * 16, 0, chunkcoordintpair.chunkZPos * 16, chunkcoordintpair.chunkXPos * 16 + 16, 128, chunkcoordintpair.chunkZPos * 16 + 16);
                int j = 0;
                while (j < list.size()) {
                    this.getTileEntityInfo((TileEntity)list.get(j));
                    ++j;
                }
            }
        }
        if (this.inPortal) {
            if (this.mcServer.propertyManagerObj.getBooleanProperty("allow-nether", false)) {
                if (this.currentCraftingInventory != this.personalCraftingInventory) {
                    this.usePersonalCraftingInventory();
                }
                if (this.ridingEntity != null) {
                    this.mountEntity(this.ridingEntity);
                } else {
                    this.timeInPortal += 0.0125f;
                    if (this.timeInPortal >= 1.0f) {
                        this.timeInPortal = 1.0f;
                        this.timeUntilPortal = 10;
                        this.mcServer.configManager.sendPlayerToOtherDimension(this);
                    }
                }
                this.inPortal = false;
            }
        } else {
            if (this.timeInPortal > 0.0f) {
                this.timeInPortal -= 0.05f;
            }
            if (this.timeInPortal < 0.0f) {
                this.timeInPortal = 0.0f;
            }
        }
        if (this.timeUntilPortal > 0) {
            --this.timeUntilPortal;
        }
        if (this.health != this.lastHealth) {
            this.playerNetServerHandler.sendPacket(new Packet8UpdateHealth(this.health));
            this.lastHealth = this.health;
        }
    }

    private void getTileEntityInfo(TileEntity tileentity) {
        Packet packet;
        if (tileentity != null && (packet = tileentity.getDescriptionPacket()) != null) {
            this.playerNetServerHandler.sendPacket(packet);
        }
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
    }

    public void onItemPickup(Entity entity, int i) {
        if (!entity.isDead) {
            EntityTracker entitytracker = this.mcServer.getEntityTracker(this.dimension);
            if (entity instanceof EntityItem) {
                entitytracker.sendPacketToTrackedPlayers(entity, new Packet22Collect(entity.entityId, this.entityId));
            }
            if (entity instanceof EntityArrow) {
                entitytracker.sendPacketToTrackedPlayers(entity, new Packet22Collect(entity.entityId, this.entityId));
            }
        }
        super.onItemPickup(entity, i);
        this.currentCraftingInventory.updateCraftingMatrix();
    }

    public void swingItem() {
        if (!this.isSwinging) {
            this.swingProgressInt = -1;
            this.isSwinging = true;
            EntityTracker entitytracker = this.mcServer.getEntityTracker(this.dimension);
            entitytracker.sendPacketToTrackedPlayers(this, new Packet18Animation(this, 1));
        }
    }

    public void func_22068_s() {
    }

    public EnumStatus goToSleep(int i, int j, int k) {
        EnumStatus enumstatus = super.goToSleep(i, j, k);
        if (enumstatus == EnumStatus.OK) {
            EntityTracker entitytracker = this.mcServer.getEntityTracker(this.dimension);
            Packet17Sleep packet17sleep = new Packet17Sleep(this, 0, i, j, k);
            entitytracker.sendPacketToTrackedPlayers(this, packet17sleep);
            this.playerNetServerHandler.teleportTo(this.posX, this.posY, this.posZ, this.rotationYaw, this.rotationPitch);
            this.playerNetServerHandler.sendPacket(packet17sleep);
        }
        return enumstatus;
    }

    public void wakeUpPlayer(boolean flag, boolean flag1, boolean flag2) {
        if (this.func_22057_E()) {
            EntityTracker entitytracker = this.mcServer.getEntityTracker(this.dimension);
            entitytracker.sendPacketToTrackedPlayersAndTrackedEntity(this, new Packet18Animation(this, 3));
        }
        super.wakeUpPlayer(flag, flag1, flag2);
        if (this.playerNetServerHandler != null) {
            this.playerNetServerHandler.teleportTo(this.posX, this.posY, this.posZ, this.rotationYaw, this.rotationPitch);
        }
    }

    public void mountEntity(Entity entity) {
        super.mountEntity(entity);
        this.playerNetServerHandler.mcServer.configManager.sendPacketToAllPlayers(new Packet39AttachEntity(this, this.ridingEntity));
        this.playerNetServerHandler.teleportTo(this.posX, this.posY, this.posZ, this.rotationYaw, this.rotationPitch);
    }

    protected void updateFallState(double d, boolean flag) {
    }

    public void handleFalling(double d, boolean flag) {
        super.updateFallState(d, flag);
    }

    private void getNextWidowId() {
        this.currentWindowId = this.currentWindowId % 100 + 1;
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        nbttagcompound.setInteger("Score", this.score);
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        this.score = nbttagcompound.getInteger("Score");
    }

    public void displayWorkbenchGUI(int i, int j, int k) {
        this.getNextWidowId();
        this.playerNetServerHandler.sendPacket(new Packet100OpenWindow(this.currentWindowId, 1, "Crafting", 9));
        this.currentCraftingInventory = new ContainerWorkbench(this.inventory, this.worldObj, i, j, k);
        this.currentCraftingInventory.windowId = this.currentWindowId;
        this.currentCraftingInventory.onCraftGuiOpened(this);
    }

    public void displayGUIChest(IInventory iinventory) {
        this.getNextWidowId();
        this.playerNetServerHandler.sendPacket(new Packet100OpenWindow(this.currentWindowId, 0, iinventory.getInvName(), iinventory.getSizeInventory()));
        this.currentCraftingInventory = new ContainerChest(this.inventory, iinventory);
        this.currentCraftingInventory.windowId = this.currentWindowId;
        this.currentCraftingInventory.onCraftGuiOpened(this);
    }

    public void displayGUIFurnace(TileEntityFurnace tileentityfurnace) {
        this.getNextWidowId();
        this.playerNetServerHandler.sendPacket(new Packet100OpenWindow(this.currentWindowId, 2, tileentityfurnace.getInvName(), tileentityfurnace.getSizeInventory()));
        this.currentCraftingInventory = new ContainerFurnace(this.inventory, tileentityfurnace);
        this.currentCraftingInventory.windowId = this.currentWindowId;
        this.currentCraftingInventory.onCraftGuiOpened(this);
    }

    public void displayGUIDispenser(TileEntityDispenser tileentitydispenser) {
    }

    public void updateCraftingInventorySlot(Container container, int i, ItemStack itemstack) {
        if (container.getSlot(i) instanceof SlotCrafting) {
            return;
        }
        if (this.isChangingQuantityOnly) {
            return;
        }
        this.playerNetServerHandler.sendPacket(new Packet103SetSlot(container.windowId, i, itemstack));
    }

    public void func_28017_a(Container container) {
        this.updateCraftingInventory(container, container.func_28127_b());
    }

    public void updateCraftingInventory(Container container, List list) {
        this.playerNetServerHandler.sendPacket(new Packet104WindowItems(container.windowId, list));
        this.playerNetServerHandler.sendPacket(new Packet103SetSlot(-1, -1, this.inventory.getItemStack()));
    }

    public void updateCraftingInventoryInfo(Container container, int i, int j) {
        this.playerNetServerHandler.sendPacket(new Packet105UpdateProgressbar(container.windowId, i, j));
    }

    public void onItemStackChanged(ItemStack itemstack) {
    }

    public void usePersonalCraftingInventory() {
        this.playerNetServerHandler.sendPacket(new Packet101CloseWindow(this.currentCraftingInventory.windowId));
        this.closeCraftingGui();
    }

    public void updateHeldItem() {
        if (this.isChangingQuantityOnly) {
            return;
        }
        this.playerNetServerHandler.sendPacket(new Packet103SetSlot(-1, -1, this.inventory.getItemStack()));
    }

    public void closeCraftingGui() {
        this.currentCraftingInventory.onCraftGuiClosed(this);
        this.currentCraftingInventory = this.personalCraftingInventory;
    }

    public void setMovementType(float f, float f1, boolean flag, boolean flag1, float f2, float f3) {
        this.moveStrafing = f;
        this.moveForward = f1;
        this.isJumping = flag;
        this.setSneaking(flag1);
        this.rotationPitch = f2;
        this.rotationYaw = f3;
    }

    public void func_30002_A() {
        if (this.ridingEntity != null) {
            this.mountEntity(this.ridingEntity);
        }
        if (this.riddenByEntity != null) {
            this.riddenByEntity.mountEntity(this);
        }
        if (this.sleeping) {
            this.wakeUpPlayer(true, false, false);
        }
    }

    public void func_30001_B() {
        this.lastHealth = -99999999;
    }

    public void addChatMessage(String s) {
        this.playerNetServerHandler.sendPacket(new Packet3Chat(s));
    }

    public void setMeasuredBlock(int x, int y, int z) {
        super.setMeasuredBlock(x, y, z);
        this.playerNetServerHandler.sendPacket(new Packet62CompassPosition(x, y, z));
    }
}

