/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityAnimal;
import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.nbt.NBTTagCompound;
import java.util.Random;

public class EntitySheep
extends EntityAnimal {
    int field_754_i = 0;
    public static final float[][] field_21071_a = new float[][]{{1.0f, 1.0f, 1.0f}, {0.95f, 0.7f, 0.2f}, {0.9f, 0.5f, 0.85f}, {0.6f, 0.7f, 0.95f}, {0.9f, 0.9f, 0.2f}, {0.5f, 0.8f, 0.1f}, {0.95f, 0.7f, 0.8f}, {0.3f, 0.3f, 0.3f}, {0.6f, 0.6f, 0.6f}, {0.3f, 0.6f, 0.7f}, {0.7f, 0.4f, 0.9f}, {0.2f, 0.4f, 0.8f}, {0.5f, 0.4f, 0.3f}, {0.4f, 0.5f, 0.2f}, {0.8f, 0.3f, 0.3f}, {0.1f, 0.1f, 0.1f}};
    public boolean isSheared;

    public EntitySheep(World world) {
        super(world);
        this.scoreValue = 10;
        this.texture = "/mob/sheep.png";
        this.setSize(0.9f, 1.3f);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, new Byte(0));
    }

    public boolean attackEntityFrom(Entity entity, int i) {
        if (!this.getSheared() && entity instanceof EntityLiving && !this.worldObj.singleplayerWorld) {
            this.setSheared(true);
            int j = 1 + this.rand.nextInt(3);
            int k = 0;
            while (k < j) {
                EntityItem entityitem = this.dropItemWithOffset(Block.cloth.blockID, 1, 1.0f);
                entityitem.motionY += (double)(this.rand.nextFloat() * 0.05f);
                entityitem.motionX += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f);
                entityitem.motionZ += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f);
                this.field_754_i = this.rand.nextInt(1200);
                ++k;
            }
        }
        return super.attackEntityFrom(entity, i);
    }

    protected void dropFewItems() {
        if (!this.getSheared()) {
            this.entityDropItem(new ItemStack(Block.cloth.blockID, 1, this.getFleeceColor()), 0.0f);
        }
    }

    protected int getDropItemId() {
        return Block.cloth.blockID;
    }

    public boolean interact(EntityPlayer entityplayer) {
        ItemStack itemstack = entityplayer.inventory.getCurrentItem();
        return false;
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        nbttagcompound.setBoolean("Sheared", this.getSheared());
        nbttagcompound.setByte("Color", (byte)this.getFleeceColor());
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        this.setSheared(nbttagcompound.getBoolean("Sheared"));
        this.setFleeceColor(nbttagcompound.getByte("Color"));
    }

    protected String getLivingSound() {
        return "mob.sheep";
    }

    protected String getHurtSound() {
        return "mob.sheep";
    }

    protected String getDeathSound() {
        return "mob.sheep";
    }

    public int getFleeceColor() {
        return this.dataWatcher.getWatchableObjectByte(16) & 0xF;
    }

    public void setFleeceColor(int i) {
        byte byte0 = this.dataWatcher.getWatchableObjectByte(16);
        this.dataWatcher.updateObject(16, (byte)(byte0 & 0xF0 | i & 0xF));
    }

    public boolean getSheared() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 0x10) != 0;
    }

    public void setSheared(boolean flag) {
        byte byte0 = this.dataWatcher.getWatchableObjectByte(16);
        if (flag) {
            this.dataWatcher.updateObject(16, (byte)(byte0 | 0x10));
        } else {
            this.dataWatcher.updateObject(16, (byte)(byte0 & 0xFFFFFFEF));
        }
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.getSheared() && --this.field_754_i <= 0 && !this.worldObj.singleplayerWorld) {
            this.worldObj.playSoundAtEntity(this, "mob.chickenplop", 1.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            this.setSheared(false);
        }
    }

    public static int func_21066_a(Random random) {
        int i = random.nextInt(100);
        if (i < 5) {
            return 15;
        }
        if (i < 10) {
            return 7;
        }
        if (i < 15) {
            return 8;
        }
        if (i < 18) {
            return 12;
        }
        return random.nextInt(500) != 0 ? 0 : 6;
    }
}

