/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityArrow;
import com.mojang.minecraft.entity.EntityMob;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.util.MathHelper;

public class EntitySkeleton
extends EntityMob {
    private static final ItemStack defaultHeldItem = new ItemStack(Item.bow, 1);

    public EntitySkeleton(World world) {
        super(world);
        this.scoreValue = 40;
        this.texture = "/mob/skeleton.png";
    }

    protected String getLivingSound() {
        return "mob.skeleton";
    }

    protected String getHurtSound() {
        return "mob.skeletonhurt";
    }

    protected String getDeathSound() {
        return "mob.skeletonhurt";
    }

    public void onLivingUpdate() {
        float f;
        if (this.worldObj.isDaytime() && (f = this.getEntityBrightness(1.0f)) > 0.5f && this.worldObj.canBlockSeeTheSky(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ)) && this.rand.nextFloat() * 30.0f < (f - 0.4f) * 2.0f) {
            this.fire = 300;
        }
        super.onLivingUpdate();
    }

    protected void attackEntity(Entity entity, float f) {
        if (f < 10.0f) {
            double d = entity.posX - this.posX;
            double d1 = entity.posZ - this.posZ;
            if (this.attackTime == 0) {
                EntityArrow entityarrow = new EntityArrow(this.worldObj, this);
                if (this.fire > 0) {
                    entityarrow.fire = 300;
                }
                entityarrow.posY += (double)1.4f;
                double d2 = entity.posY + (double)entity.getEyeHeight() - (double)0.2f - entityarrow.posY;
                float f1 = MathHelper.sqrt_double(d * d + d1 * d1) * 0.2f;
                this.worldObj.playSoundAtEntity(this, "random.bow", 1.0f, 1.0f / (this.rand.nextFloat() * 0.4f + 0.8f));
                this.worldObj.entityJoinedWorld(entityarrow);
                entityarrow.setArrowHeading(d, d2 + (double)f1, d1, 0.6f, 12.0f);
                this.attackTime = 30;
            }
            this.rotationYaw = (float)(Math.atan2(d1, d) * 180.0 / 3.1415927410125732) - 90.0f;
            this.hasAttacked = true;
        }
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
    }

    protected int getDropItemId() {
        return Item.arrow.shiftedIndex;
    }

    protected void dropFewItems() {
        int i = this.rand.nextInt(3);
        int j = 0;
        while (j < i) {
            this.dropItem(Item.arrow.shiftedIndex, 1);
            ++j;
        }
        i = this.rand.nextInt(3);
        int k = 0;
        while (k < i) {
            this.dropItem(Item.bone.shiftedIndex, 1);
            ++k;
        }
    }
}

