/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.IMob;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.Chunk;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.util.MathHelper;

public class EntitySlime
extends EntityLiving
implements IMob {
    public float field_401_a;
    public float field_400_b;
    private int ticksTillJump = 0;

    public EntitySlime(World world) {
        super(world);
        this.scoreValue = 25;
        this.texture = "/mob/slime.png";
        int i = 1 << this.rand.nextInt(3);
        this.yOffset = 0.0f;
        this.ticksTillJump = this.rand.nextInt(20) + 10;
        this.setSlimeSize(i);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, new Byte(1));
    }

    public void setSlimeSize(int i) {
        this.dataWatcher.updateObject(16, new Byte((byte)i));
        this.setSize(0.6f * (float)i, 0.6f * (float)i);
        this.health = i * i;
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    public int getSlimeSize() {
        return this.dataWatcher.getWatchableObjectByte(16);
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        nbttagcompound.setInteger("Size", this.getSlimeSize() - 1);
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        this.setSlimeSize(nbttagcompound.getInteger("Size") + 1);
    }

    public void onUpdate() {
        this.field_400_b = this.field_401_a;
        boolean flag = this.onGround;
        super.onUpdate();
        if (this.onGround && !flag) {
            int i = this.getSlimeSize();
            int j = 0;
            while (j < i * 8) {
                float f = this.rand.nextFloat() * 3.141593f * 2.0f;
                float f1 = this.rand.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.sin(f) * (float)i * 0.5f * f1;
                float f3 = MathHelper.cos(f) * (float)i * 0.5f * f1;
                this.worldObj.spawnParticle("slime", this.posX + (double)f2, this.boundingBox.minY, this.posZ + (double)f3, 0.0, 0.0, 0.0);
                ++j;
            }
            if (i > 2) {
                this.worldObj.playSoundAtEntity(this, "mob.slime", this.getSoundVolume(), ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            }
            this.field_401_a = -0.5f;
        }
        this.field_401_a *= 0.6f;
    }

    protected void updateEntityActionState() {
        this.func_27013_Q();
        EntityPlayer entityplayer = this.worldObj.getClosestPlayerToEntity(this, 16.0);
        if (entityplayer != null) {
            this.faceEntity(entityplayer, 10.0f, 20.0f);
        }
        if (this.onGround && this.ticksTillJump-- <= 0) {
            this.ticksTillJump = this.rand.nextInt(20) + 10;
            if (entityplayer != null) {
                this.ticksTillJump /= 3;
            }
            this.isJumping = true;
            if (this.getSlimeSize() > 1) {
                this.worldObj.playSoundAtEntity(this, "mob.slime", this.getSoundVolume(), ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f) * 0.8f);
            }
            this.field_401_a = 1.0f;
            this.moveStrafing = 1.0f - this.rand.nextFloat() * 2.0f;
            this.moveForward = 1 * this.getSlimeSize();
        } else {
            this.isJumping = false;
            if (this.onGround) {
                this.moveForward = 0.0f;
                this.moveStrafing = 0.0f;
            }
        }
    }

    public void setEntityDead() {
        int i = this.getSlimeSize();
        if (!this.worldObj.singleplayerWorld && i > 1 && this.health <= 0) {
            int j = 0;
            while (j < 4) {
                float f = ((float)(j % 2) - 0.5f) * (float)i / 4.0f;
                float f1 = ((float)(j / 2) - 0.5f) * (float)i / 4.0f;
                EntitySlime entityslime = new EntitySlime(this.worldObj);
                entityslime.setSlimeSize(i / 2);
                entityslime.setLocationAndAngles(this.posX + (double)f, this.posY + 0.5, this.posZ + (double)f1, this.rand.nextFloat() * 360.0f, 0.0f);
                this.worldObj.entityJoinedWorld(entityslime);
                ++j;
            }
        }
        super.setEntityDead();
    }

    public void onCollideWithPlayer(EntityPlayer entityplayer) {
        int i = this.getSlimeSize();
        if (i > 1 && this.canEntityBeSeen(entityplayer) && (double)this.getDistanceToEntity(entityplayer) < 0.6 * (double)i && entityplayer.attackEntityFrom(this, i)) {
            this.worldObj.playSoundAtEntity(this, "mob.slimeattack", 1.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
        }
    }

    protected String getHurtSound() {
        return "mob.slime";
    }

    protected String getDeathSound() {
        return "mob.slime";
    }

    protected int getDropItemId() {
        if (this.getSlimeSize() == 1) {
            return Item.slimeBall.shiftedIndex;
        }
        return 0;
    }

    public boolean shouldSpawnOnTile() {
        Chunk chunk = this.worldObj.getChunkFromBlockCoords(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posZ));
        return (this.getSlimeSize() == 1 || this.worldObj.difficultySetting > 0) && this.rand.nextInt(10) == 0 && chunk.func_334_a(987234911L).nextInt(10) == 0 && this.posY < 16.0;
    }

    protected float getSoundVolume() {
        return 0.6f;
    }

    public boolean interact(EntityPlayer entityplayer) {
        ItemStack itemstack = entityplayer.inventory.getCurrentItem();
        if (itemstack != null && itemstack.itemID == Item.bucketEmpty.shiftedIndex && this.getSlimeSize() == 1) {
            entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, new ItemStack(Item.bucketSlime));
            super.setEntityDead();
            return true;
        }
        return false;
    }
}

