/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityMob;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.util.MathHelper;

public class EntitySpider
extends EntityMob {
    public EntitySpider(World world) {
        super(world);
        this.scoreValue = 30;
        this.texture = "/mob/spider.png";
        this.setSize(1.4f, 0.9f);
        this.move_Speed = 0.8f;
    }

    public double getMountedYOffset() {
        return (double)this.height * 0.75 - 0.5;
    }

    protected boolean func_25017_l() {
        return false;
    }

    protected Entity findPlayerToAttack() {
        float f = this.getEntityBrightness(1.0f);
        if (f < 0.5f) {
            double d = 16.0;
            return this.worldObj.getClosestPlayerToEntity(this, d);
        }
        return null;
    }

    protected String getLivingSound() {
        return "mob.spider";
    }

    protected String getHurtSound() {
        return "mob.spider";
    }

    protected String getDeathSound() {
        return "mob.spiderdeath";
    }

    protected void attackEntity(Entity entity, float f) {
        float f1 = this.getEntityBrightness(1.0f);
        if (f1 > 0.5f && this.rand.nextInt(100) == 0) {
            this.entityToAttack = null;
            return;
        }
        if (f > 2.0f && f < 6.0f && this.rand.nextInt(10) == 0) {
            if (this.onGround) {
                double d = entity.posX - this.posX;
                double d1 = entity.posZ - this.posZ;
                float f2 = MathHelper.sqrt_double(d * d + d1 * d1);
                this.motionX = d / (double)f2 * 0.5 * (double)0.8f + this.motionX * (double)0.2f;
                this.motionZ = d1 / (double)f2 * 0.5 * (double)0.8f + this.motionZ * (double)0.2f;
                this.motionY = 0.4f;
            }
        } else {
            super.attackEntity(entity, f);
        }
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
    }

    protected int getDropItemId() {
        return Item.silk.shiftedIndex;
    }

    public boolean isOnLadder() {
        return this.isCollidedHorizontally;
    }
}

