/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.EntityWaterMob;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.util.MathHelper;

public class EntitySquid
extends EntityWaterMob {
    public float field_21063_a = 0.0f;
    public float field_21062_b = 0.0f;
    public float field_21061_c = 0.0f;
    public float field_21059_f = 0.0f;
    public float field_21060_ak = 0.0f;
    public float field_21058_al = 0.0f;
    public float field_21057_am = 0.0f;
    public float field_21056_an = 0.0f;
    private float field_21055_ao = 0.0f;
    private float field_21054_ap = 0.0f;
    private float field_21053_aq = 0.0f;
    private float field_21052_ar = 0.0f;
    private float field_21051_as = 0.0f;
    private float field_21050_at = 0.0f;

    public EntitySquid(World world) {
        super(world);
        this.texture = "/mob/squid.png";
        this.setSize(0.95f, 0.95f);
        this.field_21054_ap = 1.0f / (this.rand.nextFloat() + 1.0f) * 0.2f;
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
    }

    protected String getLivingSound() {
        return null;
    }

    protected String getHurtSound() {
        return null;
    }

    protected String getDeathSound() {
        return null;
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    protected int getDropItemId() {
        return 0;
    }

    protected void dropFewItems() {
        int i = this.rand.nextInt(3) + 1;
    }

    public boolean interact(EntityPlayer entityplayer) {
        return false;
    }

    public boolean isInWater() {
        return this.worldObj.handleMaterialAcceleration(this.boundingBox.expand(0.0, -0.6f, 0.0), Material.water, this);
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        this.field_21062_b = this.field_21063_a;
        this.field_21059_f = this.field_21061_c;
        this.field_21058_al = this.field_21060_ak;
        this.field_21056_an = this.field_21057_am;
        this.field_21060_ak += this.field_21054_ap;
        if (this.field_21060_ak > 6.283185f) {
            this.field_21060_ak -= 6.283185f;
            if (this.rand.nextInt(10) == 0) {
                this.field_21054_ap = 1.0f / (this.rand.nextFloat() + 1.0f) * 0.2f;
            }
        }
        if (this.isInWater()) {
            if (this.field_21060_ak < 3.141593f) {
                float f = this.field_21060_ak / 3.141593f;
                this.field_21057_am = MathHelper.sin(f * f * 3.141593f) * 3.141593f * 0.25f;
                if ((double)f > 0.75) {
                    this.field_21055_ao = 1.0f;
                    this.field_21053_aq = 1.0f;
                } else {
                    this.field_21053_aq *= 0.8f;
                }
            } else {
                this.field_21057_am = 0.0f;
                this.field_21055_ao *= 0.9f;
                this.field_21053_aq *= 0.99f;
            }
            if (!this.isMultiplayerEntity) {
                this.motionX = this.field_21052_ar * this.field_21055_ao;
                this.motionY = this.field_21051_as * this.field_21055_ao;
                this.motionZ = this.field_21050_at * this.field_21055_ao;
            }
            float f1 = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionZ * this.motionZ);
            this.renderYawOffset += (-((float)Math.atan2(this.motionX, this.motionZ)) * 180.0f / 3.141593f - this.renderYawOffset) * 0.1f;
            this.rotationYaw = this.renderYawOffset;
            this.field_21061_c += 3.141593f * this.field_21053_aq * 1.5f;
            this.field_21063_a += (-((float)Math.atan2(f1, this.motionY)) * 180.0f / 3.141593f - this.field_21063_a) * 0.1f;
        } else {
            this.field_21057_am = MathHelper.abs(MathHelper.sin(this.field_21060_ak)) * 3.141593f * 0.25f;
            if (!this.isMultiplayerEntity) {
                this.motionX = 0.0;
                this.motionY -= 0.08;
                this.motionY *= (double)0.98f;
                this.motionZ = 0.0;
            }
            this.field_21063_a = (float)((double)this.field_21063_a + (double)(-90.0f - this.field_21063_a) * 0.02);
        }
    }

    public void moveEntityWithHeading(float f, float f1) {
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
    }

    protected void updateEntityActionState() {
        if (this.rand.nextInt(50) == 0 || !this.inWater || this.field_21052_ar == 0.0f && this.field_21051_as == 0.0f && this.field_21050_at == 0.0f) {
            float f = this.rand.nextFloat() * 3.141593f * 2.0f;
            this.field_21052_ar = MathHelper.cos(f) * 0.2f;
            this.field_21051_as = -0.1f + this.rand.nextFloat() * 0.2f;
            this.field_21050_at = MathHelper.sin(f) * 0.2f;
        }
        this.func_27013_Q();
    }
}

