/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityArrow;
import com.mojang.minecraft.entity.EntityBoat;
import com.mojang.minecraft.entity.EntityFallingSand;
import com.mojang.minecraft.entity.EntityFireExtinguisher;
import com.mojang.minecraft.entity.EntityFireball;
import com.mojang.minecraft.entity.EntityFish;
import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityMinecart;
import com.mojang.minecraft.entity.EntityPainting;
import com.mojang.minecraft.entity.EntityPlayerMP;
import com.mojang.minecraft.entity.EntitySnowball;
import com.mojang.minecraft.entity.EntityTNTPrimed;
import com.mojang.minecraft.entity.EntityTrackerEntry;
import com.mojang.minecraft.entity.IAnimals;
import com.mojang.minecraft.network.packet.Packet;
import com.mojang.minecraft.server.MinecraftServer;
import com.mojang.minecraft.util.MCHash;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class EntityTracker {
    private Set trackedEntitySet = new HashSet();
    private MCHash trackedEntityHashTable = new MCHash();
    private MinecraftServer mcServer;
    private int maxTrackingDistanceThreshold;
    private int field_28113_e;

    public EntityTracker(MinecraftServer minecraftserver, int i) {
        this.mcServer = minecraftserver;
        this.field_28113_e = i;
        this.maxTrackingDistanceThreshold = minecraftserver.configManager.getMaxTrackingDistance();
    }

    public void trackEntity(Entity entity) {
        if (entity instanceof EntityPlayerMP) {
            this.trackEntity(entity, 512, 2);
            EntityPlayerMP entityplayermp = (EntityPlayerMP)entity;
            for (EntityTrackerEntry entitytrackerentry : this.trackedEntitySet) {
                if (entitytrackerentry.trackedEntity == entityplayermp) continue;
                entitytrackerentry.updatePlayerEntity(entityplayermp);
            }
        } else if (entity instanceof EntityFish) {
            this.trackEntity(entity, 64, 5, true);
        } else if (entity instanceof EntityArrow) {
            this.trackEntity(entity, 64, 20, false);
        } else if (entity instanceof EntityFireball) {
            this.trackEntity(entity, 64, 10, false);
        } else if (entity instanceof EntitySnowball) {
            this.trackEntity(entity, 64, 10, true);
        } else if (entity instanceof EntityFireExtinguisher) {
            this.trackEntity(entity, 64, 10, true);
        } else if (entity instanceof EntityItem) {
            this.trackEntity(entity, 64, 20, true);
        } else if (entity instanceof EntityMinecart) {
            this.trackEntity(entity, 160, 5, true);
        } else if (entity instanceof EntityBoat) {
            this.trackEntity(entity, 160, 5, true);
        } else if (entity instanceof IAnimals) {
            this.trackEntity(entity, 160, 3);
        } else if (entity instanceof EntityTNTPrimed) {
            this.trackEntity(entity, 160, 10, true);
        } else if (entity instanceof EntityFallingSand) {
            this.trackEntity(entity, 160, 20, true);
        } else if (entity instanceof EntityPainting) {
            this.trackEntity(entity, 160, Integer.MAX_VALUE, false);
        }
    }

    public void trackEntity(Entity entity, int i, int j) {
        this.trackEntity(entity, i, j, false);
    }

    public void trackEntity(Entity entity, int i, int j, boolean flag) {
        if (i > this.maxTrackingDistanceThreshold) {
            i = this.maxTrackingDistanceThreshold;
        }
        if (this.trackedEntityHashTable.containsItem(entity.entityId)) {
            throw new IllegalStateException("Entity is already tracked!");
        }
        EntityTrackerEntry entitytrackerentry = new EntityTrackerEntry(entity, i, j, flag);
        this.trackedEntitySet.add(entitytrackerentry);
        this.trackedEntityHashTable.addKey(entity.entityId, entitytrackerentry);
        entitytrackerentry.updatePlayerEntities(this.mcServer.getWorldManager((int)this.field_28113_e).playerEntities);
    }

    public void untrackEntity(Entity entity) {
        EntityTrackerEntry entitytrackerentry;
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)entity;
            for (EntityTrackerEntry entitytrackerentry1 : this.trackedEntitySet) {
                entitytrackerentry1.removeFromTrackedPlayers(entityplayermp);
            }
        }
        if ((entitytrackerentry = (EntityTrackerEntry)this.trackedEntityHashTable.removeObject(entity.entityId)) != null) {
            this.trackedEntitySet.remove(entitytrackerentry);
            entitytrackerentry.sendDestroyEntityPacketToTrackedPlayers();
        }
    }

    public void updateTrackedEntities() {
        ArrayList<EntityPlayerMP> arraylist = new ArrayList<EntityPlayerMP>();
        for (EntityTrackerEntry entitytrackerentry : this.trackedEntitySet) {
            entitytrackerentry.updatePlayerList(this.mcServer.getWorldManager((int)this.field_28113_e).playerEntities);
            if (!entitytrackerentry.playerEntitiesUpdated || !(entitytrackerentry.trackedEntity instanceof EntityPlayerMP)) continue;
            arraylist.add((EntityPlayerMP)entitytrackerentry.trackedEntity);
        }
        int i = 0;
        while (i < arraylist.size()) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)arraylist.get(i);
            for (EntityTrackerEntry entitytrackerentry1 : this.trackedEntitySet) {
                if (entitytrackerentry1.trackedEntity == entityplayermp) continue;
                entitytrackerentry1.updatePlayerEntity(entityplayermp);
            }
            ++i;
        }
    }

    public void sendPacketToTrackedPlayers(Entity entity, Packet packet) {
        EntityTrackerEntry entitytrackerentry = (EntityTrackerEntry)this.trackedEntityHashTable.lookup(entity.entityId);
        if (entitytrackerentry != null) {
            entitytrackerentry.sendPacketToTrackedPlayers(packet);
        }
    }

    public void sendPacketToTrackedPlayersAndTrackedEntity(Entity entity, Packet packet) {
        EntityTrackerEntry entitytrackerentry = (EntityTrackerEntry)this.trackedEntityHashTable.lookup(entity.entityId);
        if (entitytrackerentry != null) {
            entitytrackerentry.sendPacketToTrackedPlayersAndTrackedEntity(packet);
        }
    }

    public void removeTrackedPlayerSymmetric(EntityPlayerMP entityplayermp) {
        for (EntityTrackerEntry entitytrackerentry : this.trackedEntitySet) {
            entitytrackerentry.removeTrackedPlayerSymmetric(entityplayermp);
        }
    }
}

