/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityArrow;
import com.mojang.minecraft.entity.EntityBoat;
import com.mojang.minecraft.entity.EntityFallingSand;
import com.mojang.minecraft.entity.EntityFireExtinguisher;
import com.mojang.minecraft.entity.EntityFireball;
import com.mojang.minecraft.entity.EntityFish;
import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityMinecart;
import com.mojang.minecraft.entity.EntityPainting;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.EntityPlayerMP;
import com.mojang.minecraft.entity.EntitySnowball;
import com.mojang.minecraft.entity.EntityTNTPrimed;
import com.mojang.minecraft.entity.IAnimals;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.network.DataWatcher;
import com.mojang.minecraft.network.packet.Packet;
import com.mojang.minecraft.network.packet.Packet17Sleep;
import com.mojang.minecraft.network.packet.Packet20NamedEntitySpawn;
import com.mojang.minecraft.network.packet.Packet21PickupSpawn;
import com.mojang.minecraft.network.packet.Packet23VehicleSpawn;
import com.mojang.minecraft.network.packet.Packet24MobSpawn;
import com.mojang.minecraft.network.packet.Packet25EntityPainting;
import com.mojang.minecraft.network.packet.Packet28EntityVelocity;
import com.mojang.minecraft.network.packet.Packet29DestroyEntity;
import com.mojang.minecraft.network.packet.Packet31RelEntityMove;
import com.mojang.minecraft.network.packet.Packet32EntityLook;
import com.mojang.minecraft.network.packet.Packet33RelEntityMoveLook;
import com.mojang.minecraft.network.packet.Packet34EntityTeleport;
import com.mojang.minecraft.network.packet.Packet40EntityMetadata;
import com.mojang.minecraft.network.packet.Packet5PlayerInventory;
import com.mojang.minecraft.util.MathHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EntityTrackerEntry {
    public Entity trackedEntity;
    public int trackingDistanceThreshold;
    public int field_9234_e;
    public int encodedPosX;
    public int encodedPosY;
    public int encodedPosZ;
    public int encodedRotationYaw;
    public int encodedRotationPitch;
    public double lastTrackedEntityMotionX;
    public double lastTrackedEntityMotionY;
    public double lastTrackedEntityMotionZ;
    public int updateCounter = 0;
    private double lastTrackedEntityPosX;
    private double lastTrackedEntityPosY;
    private double lastTrackedEntityPosZ;
    private boolean firstUpdateDone = false;
    private boolean shouldSendMotionUpdates;
    private int field_28165_t = 0;
    public boolean playerEntitiesUpdated = false;
    public Set trackedPlayers = new HashSet();

    public EntityTrackerEntry(Entity entity, int i, int j, boolean flag) {
        this.trackedEntity = entity;
        this.trackingDistanceThreshold = i;
        this.field_9234_e = j;
        this.shouldSendMotionUpdates = flag;
        this.encodedPosX = MathHelper.floor_double(entity.posX * 32.0);
        this.encodedPosY = MathHelper.floor_double(entity.posY * 32.0);
        this.encodedPosZ = MathHelper.floor_double(entity.posZ * 32.0);
        this.encodedRotationYaw = MathHelper.floor_float(entity.rotationYaw * 256.0f / 360.0f);
        this.encodedRotationPitch = MathHelper.floor_float(entity.rotationPitch * 256.0f / 360.0f);
    }

    public boolean equals(Object obj) {
        if (obj instanceof EntityTrackerEntry) {
            return ((EntityTrackerEntry)obj).trackedEntity.entityId == this.trackedEntity.entityId;
        }
        return false;
    }

    public int hashCode() {
        return this.trackedEntity.entityId;
    }

    public void updatePlayerList(List list) {
        this.playerEntitiesUpdated = false;
        if (!this.firstUpdateDone || this.trackedEntity.getDistanceSq(this.lastTrackedEntityPosX, this.lastTrackedEntityPosY, this.lastTrackedEntityPosZ) > 16.0) {
            this.lastTrackedEntityPosX = this.trackedEntity.posX;
            this.lastTrackedEntityPosY = this.trackedEntity.posY;
            this.lastTrackedEntityPosZ = this.trackedEntity.posZ;
            this.firstUpdateDone = true;
            this.playerEntitiesUpdated = true;
            this.updatePlayerEntities(list);
        }
        ++this.field_28165_t;
        if (++this.updateCounter % this.field_9234_e == 0) {
            DataWatcher datawatcher;
            double d3;
            double d2;
            double d1;
            double d;
            double d4;
            boolean flag1;
            int i = MathHelper.floor_double(this.trackedEntity.posX * 32.0);
            int j = MathHelper.floor_double(this.trackedEntity.posY * 32.0);
            int k = MathHelper.floor_double(this.trackedEntity.posZ * 32.0);
            int l = MathHelper.floor_float(this.trackedEntity.rotationYaw * 256.0f / 360.0f);
            int i1 = MathHelper.floor_float(this.trackedEntity.rotationPitch * 256.0f / 360.0f);
            int j1 = i - this.encodedPosX;
            int k1 = j - this.encodedPosY;
            int l1 = k - this.encodedPosZ;
            Packet obj = null;
            boolean flag = Math.abs(i) >= 8 || Math.abs(j) >= 8 || Math.abs(k) >= 8;
            boolean bl = flag1 = Math.abs(l - this.encodedRotationYaw) >= 8 || Math.abs(i1 - this.encodedRotationPitch) >= 8;
            if (j1 < -128 || j1 >= 128 || k1 < -128 || k1 >= 128 || l1 < -128 || l1 >= 128 || this.field_28165_t > 400) {
                this.field_28165_t = 0;
                this.trackedEntity.posX = (double)i / 32.0;
                this.trackedEntity.posY = (double)j / 32.0;
                this.trackedEntity.posZ = (double)k / 32.0;
                obj = new Packet34EntityTeleport(this.trackedEntity.entityId, i, j, k, (byte)l, (byte)i1);
            } else if (flag && flag1) {
                obj = new Packet33RelEntityMoveLook(this.trackedEntity.entityId, (byte)j1, (byte)k1, (byte)l1, (byte)l, (byte)i1);
            } else if (flag) {
                obj = new Packet31RelEntityMove(this.trackedEntity.entityId, (byte)j1, (byte)k1, (byte)l1);
            } else if (flag1) {
                obj = new Packet32EntityLook(this.trackedEntity.entityId, (byte)l, (byte)i1);
            }
            if (this.shouldSendMotionUpdates && ((d4 = (d = this.trackedEntity.motionX - this.lastTrackedEntityMotionX) * d + (d1 = this.trackedEntity.motionY - this.lastTrackedEntityMotionY) * d1 + (d2 = this.trackedEntity.motionZ - this.lastTrackedEntityMotionZ) * d2) > (d3 = 0.02) * d3 || d4 > 0.0 && this.trackedEntity.motionX == 0.0 && this.trackedEntity.motionY == 0.0 && this.trackedEntity.motionZ == 0.0)) {
                this.lastTrackedEntityMotionX = this.trackedEntity.motionX;
                this.lastTrackedEntityMotionY = this.trackedEntity.motionY;
                this.lastTrackedEntityMotionZ = this.trackedEntity.motionZ;
                this.sendPacketToTrackedPlayers(new Packet28EntityVelocity(this.trackedEntity.entityId, this.lastTrackedEntityMotionX, this.lastTrackedEntityMotionY, this.lastTrackedEntityMotionZ));
            }
            if (obj != null) {
                this.sendPacketToTrackedPlayers(obj);
            }
            if ((datawatcher = this.trackedEntity.getDataWatcher()).hasObjectChanged()) {
                this.sendPacketToTrackedPlayersAndTrackedEntity(new Packet40EntityMetadata(this.trackedEntity.entityId, datawatcher));
            }
            if (flag) {
                this.encodedPosX = i;
                this.encodedPosY = j;
                this.encodedPosZ = k;
            }
            if (flag1) {
                this.encodedRotationYaw = l;
                this.encodedRotationPitch = i1;
            }
        }
        if (this.trackedEntity.beenAttacked) {
            this.sendPacketToTrackedPlayersAndTrackedEntity(new Packet28EntityVelocity(this.trackedEntity));
            this.trackedEntity.beenAttacked = false;
        }
    }

    public void sendPacketToTrackedPlayers(Packet packet) {
        for (EntityPlayerMP entityplayermp : this.trackedPlayers) {
            entityplayermp.playerNetServerHandler.sendPacket(packet);
        }
    }

    public void sendPacketToTrackedPlayersAndTrackedEntity(Packet packet) {
        this.sendPacketToTrackedPlayers(packet);
        if (this.trackedEntity instanceof EntityPlayerMP) {
            ((EntityPlayerMP)this.trackedEntity).playerNetServerHandler.sendPacket(packet);
        }
    }

    public void sendDestroyEntityPacketToTrackedPlayers() {
        this.sendPacketToTrackedPlayers(new Packet29DestroyEntity(this.trackedEntity.entityId));
    }

    public void removeFromTrackedPlayers(EntityPlayerMP entityplayermp) {
        if (this.trackedPlayers.contains(entityplayermp)) {
            this.trackedPlayers.remove(entityplayermp);
        }
    }

    public void updatePlayerEntity(EntityPlayerMP entityplayermp) {
        if (entityplayermp == this.trackedEntity) {
            return;
        }
        double d = entityplayermp.posX - (double)(this.encodedPosX / 32);
        double d1 = entityplayermp.posZ - (double)(this.encodedPosZ / 32);
        if (d >= (double)(-this.trackingDistanceThreshold) && d <= (double)this.trackingDistanceThreshold && d1 >= (double)(-this.trackingDistanceThreshold) && d1 <= (double)this.trackingDistanceThreshold) {
            if (!this.trackedPlayers.contains(entityplayermp)) {
                EntityPlayer entityplayer;
                ItemStack[] aitemstack;
                this.trackedPlayers.add(entityplayermp);
                entityplayermp.playerNetServerHandler.sendPacket(this.getSpawnPacket());
                if (this.shouldSendMotionUpdates) {
                    entityplayermp.playerNetServerHandler.sendPacket(new Packet28EntityVelocity(this.trackedEntity.entityId, this.trackedEntity.motionX, this.trackedEntity.motionY, this.trackedEntity.motionZ));
                }
                if ((aitemstack = this.trackedEntity.getInventory()) != null) {
                    int i = 0;
                    while (i < aitemstack.length) {
                        entityplayermp.playerNetServerHandler.sendPacket(new Packet5PlayerInventory(this.trackedEntity.entityId, i, aitemstack[i]));
                        ++i;
                    }
                }
                if (this.trackedEntity instanceof EntityPlayer && (entityplayer = (EntityPlayer)this.trackedEntity).func_22057_E()) {
                    entityplayermp.playerNetServerHandler.sendPacket(new Packet17Sleep(this.trackedEntity, 0, MathHelper.floor_double(this.trackedEntity.posX), MathHelper.floor_double(this.trackedEntity.posY), MathHelper.floor_double(this.trackedEntity.posZ)));
                }
            }
        } else if (this.trackedPlayers.contains(entityplayermp)) {
            this.trackedPlayers.remove(entityplayermp);
            entityplayermp.playerNetServerHandler.sendPacket(new Packet29DestroyEntity(this.trackedEntity.entityId));
        }
    }

    public void updatePlayerEntities(List list) {
        int i = 0;
        while (i < list.size()) {
            this.updatePlayerEntity((EntityPlayerMP)list.get(i));
            ++i;
        }
    }

    private Packet getSpawnPacket() {
        if (this.trackedEntity instanceof EntityItem) {
            EntityItem entityitem = (EntityItem)this.trackedEntity;
            Packet21PickupSpawn packet21pickupspawn = new Packet21PickupSpawn(entityitem);
            entityitem.posX = (double)packet21pickupspawn.xPosition / 32.0;
            entityitem.posY = (double)packet21pickupspawn.yPosition / 32.0;
            entityitem.posZ = (double)packet21pickupspawn.zPosition / 32.0;
            return packet21pickupspawn;
        }
        if (this.trackedEntity instanceof EntityPlayerMP) {
            return new Packet20NamedEntitySpawn((EntityPlayer)this.trackedEntity);
        }
        if (this.trackedEntity instanceof EntityMinecart) {
            EntityMinecart entityminecart = (EntityMinecart)this.trackedEntity;
            if (entityminecart.minecartType == 0) {
                return new Packet23VehicleSpawn(this.trackedEntity, 10);
            }
            if (entityminecart.minecartType == 1) {
                return new Packet23VehicleSpawn(this.trackedEntity, 11);
            }
            if (entityminecart.minecartType == 2) {
                return new Packet23VehicleSpawn(this.trackedEntity, 12);
            }
        }
        if (this.trackedEntity instanceof EntityBoat) {
            return new Packet23VehicleSpawn(this.trackedEntity, 1);
        }
        if (this.trackedEntity instanceof IAnimals) {
            return new Packet24MobSpawn((EntityLiving)this.trackedEntity);
        }
        if (this.trackedEntity instanceof EntityFish) {
            return new Packet23VehicleSpawn(this.trackedEntity, 90);
        }
        if (this.trackedEntity instanceof EntityArrow) {
            EntityLiving entityliving = ((EntityArrow)this.trackedEntity).owner;
            return new Packet23VehicleSpawn(this.trackedEntity, 60, entityliving == null ? this.trackedEntity.entityId : entityliving.entityId);
        }
        if (this.trackedEntity instanceof EntitySnowball) {
            return new Packet23VehicleSpawn(this.trackedEntity, 61);
        }
        if (this.trackedEntity instanceof EntityFireball) {
            EntityFireball entityfireball = (EntityFireball)this.trackedEntity;
            Packet23VehicleSpawn packet23vehiclespawn = new Packet23VehicleSpawn(this.trackedEntity, 63, ((EntityFireball)this.trackedEntity).owner.entityId);
            packet23vehiclespawn.field_28044_e = (int)(entityfireball.field_9199_b * 8000.0);
            packet23vehiclespawn.field_28043_f = (int)(entityfireball.field_9198_c * 8000.0);
            packet23vehiclespawn.field_28042_g = (int)(entityfireball.field_9196_d * 8000.0);
            return packet23vehiclespawn;
        }
        if (this.trackedEntity instanceof EntityFireExtinguisher) {
            return new Packet23VehicleSpawn(this.trackedEntity, 62);
        }
        if (this.trackedEntity instanceof EntityTNTPrimed) {
            return new Packet23VehicleSpawn(this.trackedEntity, 50);
        }
        if (this.trackedEntity instanceof EntityFallingSand) {
            EntityFallingSand entityfallingsand = (EntityFallingSand)this.trackedEntity;
            if (entityfallingsand.blockID == Block.sand.blockID) {
                return new Packet23VehicleSpawn(this.trackedEntity, 70);
            }
            if (entityfallingsand.blockID == Block.gravel.blockID) {
                return new Packet23VehicleSpawn(this.trackedEntity, 71);
            }
        }
        if (this.trackedEntity instanceof EntityPainting) {
            return new Packet25EntityPainting((EntityPainting)this.trackedEntity);
        }
        throw new IllegalArgumentException("Don't know how to add " + this.trackedEntity.getClass() + "!");
    }

    public void removeTrackedPlayerSymmetric(EntityPlayerMP entityplayermp) {
        if (this.trackedPlayers.contains(entityplayermp)) {
            this.trackedPlayers.remove(entityplayermp);
            entityplayermp.playerNetServerHandler.sendPacket(new Packet29DestroyEntity(this.trackedEntity.entityId));
        }
    }
}

