/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityAnimal;
import com.mojang.minecraft.entity.EntityArrow;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.EntitySheep;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemFood;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.path.PathEntity;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.util.MathHelper;
import java.util.List;

public class EntityWolf
extends EntityAnimal {
    private boolean field_25039_a = false;
    private float field_25038_b;
    private float field_25044_c;
    private boolean isWet;
    private boolean field_25042_g;
    private float field_25041_h;
    private float field_25040_i;

    public EntityWolf(World world) {
        super(world);
        this.texture = "/mob/wolf.png";
        this.setSize(0.8f, 0.8f);
        this.move_Speed = 1.1f;
        this.health = 8;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (byte)0);
        this.dataWatcher.addObject(17, "");
        this.dataWatcher.addObject(18, new Integer(this.health));
    }

    protected boolean func_25017_l() {
        return false;
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        nbttagcompound.setBoolean("Angry", this.getIsAngry());
        nbttagcompound.setBoolean("Sitting", this.getIsSitting());
        if (this.getOwner() == null) {
            nbttagcompound.setString("Owner", "");
        } else {
            nbttagcompound.setString("Owner", this.getOwner());
        }
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        this.setIsAngry(nbttagcompound.getBoolean("Angry"));
        this.setIsSitting(nbttagcompound.getBoolean("Sitting"));
        String s = nbttagcompound.getString("Owner");
        if (s.length() > 0) {
            this.setOwner(s);
            this.setIsTamed(true);
        }
    }

    protected boolean func_25020_s() {
        return !this.func_25030_y();
    }

    protected String getLivingSound() {
        if (this.getIsAngry()) {
            return "mob.wolf.growl";
        }
        if (this.rand.nextInt(3) == 0) {
            if (this.func_25030_y() && this.dataWatcher.getWatchableObjectInteger(18) < 10) {
                return "mob.wolf.whine";
            }
            return "mob.wolf.panting";
        }
        return "mob.wolf.bark";
    }

    protected String getHurtSound() {
        return "mob.wolf.hurt";
    }

    protected String getDeathSound() {
        return "mob.wolf.death";
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    protected int getDropItemId() {
        return -1;
    }

    protected void updateEntityActionState() {
        List list;
        super.updateEntityActionState();
        if (!this.hasAttacked && !this.getGotPath() && this.func_25030_y() && this.ridingEntity == null) {
            EntityPlayer entityplayer = this.worldObj.getPlayerEntityByName(this.getOwner());
            if (entityplayer != null) {
                float f = entityplayer.getDistanceToEntity(this);
                if (f > 5.0f) {
                    this.setPathEntity(entityplayer, f);
                }
            } else if (!this.isInWater()) {
                this.setIsSitting(true);
            }
        } else if (!(this.entityToAttack != null || this.getGotPath() || this.func_25030_y() || this.worldObj.rand.nextInt(100) != 0 || (list = this.worldObj.getEntitiesWithinAABB(EntitySheep.class, AxisAlignedBB.getBoundingBoxFromPool(this.posX, this.posY, this.posZ, this.posX + 1.0, this.posY + 1.0, this.posZ + 1.0).expand(16.0, 4.0, 16.0))).isEmpty())) {
            this.setEntityToAttack((Entity)list.get(this.worldObj.rand.nextInt(list.size())));
        }
        if (this.isInWater()) {
            this.setIsSitting(false);
        }
        if (!this.worldObj.singleplayerWorld) {
            this.dataWatcher.updateObject(18, this.health);
        }
    }

    public void onLivingUpdate() {
        Entity entity;
        super.onLivingUpdate();
        this.field_25039_a = false;
        if (this.func_25021_O() && !this.getGotPath() && !this.getIsAngry() && (entity = this.getCurrentTarget()) instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            ItemStack itemstack = entityplayer.inventory.getCurrentItem();
            if (itemstack != null) {
                if (!this.func_25030_y() && itemstack.itemID == Item.bone.shiftedIndex) {
                    this.field_25039_a = true;
                } else if (this.func_25030_y() && Item.itemsList[itemstack.itemID] instanceof ItemFood) {
                    this.field_25039_a = ((ItemFood)Item.itemsList[itemstack.itemID]).func_25010_k();
                }
            }
        }
        if (!this.isMultiplayerEntity && this.isWet && !this.field_25042_g && !this.getGotPath() && this.onGround) {
            this.field_25042_g = true;
            this.field_25041_h = 0.0f;
            this.field_25040_i = 0.0f;
            this.worldObj.sendTrackedEntityStatusUpdatePacket(this, (byte)8);
        }
    }

    public void onUpdate() {
        super.onUpdate();
        this.field_25044_c = this.field_25038_b;
        this.field_25038_b = this.field_25039_a ? (this.field_25038_b += (1.0f - this.field_25038_b) * 0.4f) : (this.field_25038_b += (0.0f - this.field_25038_b) * 0.4f);
        if (this.field_25039_a) {
            this.numTicksToChaseTarget = 10;
        }
        if (this.func_27008_Y()) {
            this.isWet = true;
            this.field_25042_g = false;
            this.field_25041_h = 0.0f;
            this.field_25040_i = 0.0f;
        } else if ((this.isWet || this.field_25042_g) && this.field_25042_g) {
            if (this.field_25041_h == 0.0f) {
                this.worldObj.playSoundAtEntity(this, "mob.wolf.shake", this.getSoundVolume(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            }
            this.field_25040_i = this.field_25041_h;
            this.field_25041_h += 0.05f;
            if (this.field_25040_i >= 2.0f) {
                this.isWet = false;
                this.field_25042_g = false;
                this.field_25040_i = 0.0f;
                this.field_25041_h = 0.0f;
            }
            if (this.field_25041_h > 0.4f) {
                float f = (float)this.boundingBox.minY;
                int i = (int)(MathHelper.sin((this.field_25041_h - 0.4f) * 3.141593f) * 7.0f);
                int j = 0;
                while (j < i) {
                    float f1 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width * 0.5f;
                    float f2 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width * 0.5f;
                    this.worldObj.spawnParticle("splash", this.posX + (double)f1, f + 0.8f, this.posZ + (double)f2, this.motionX, this.motionY, this.motionZ);
                    ++j;
                }
            }
        }
    }

    public float getEyeHeight() {
        return this.height * 0.8f;
    }

    protected int func_25018_n_() {
        if (this.getIsSitting()) {
            return 20;
        }
        return super.func_25018_n_();
    }

    private void setPathEntity(Entity entity, float f) {
        PathEntity pathentity = this.worldObj.getPathToEntity(this, entity, 16.0f);
        if (pathentity == null && f > 12.0f) {
            int i = MathHelper.floor_double(entity.posX) - 2;
            int j = MathHelper.floor_double(entity.posZ) - 2;
            int k = MathHelper.floor_double(entity.boundingBox.minY);
            int l = 0;
            while (l <= 4) {
                int i1 = 0;
                while (i1 <= 4) {
                    if (!(l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.worldObj.isBlockNormalCube(i + l, k - 1, j + i1) || this.worldObj.isBlockNormalCube(i + l, k, j + i1) || this.worldObj.isBlockNormalCube(i + l, k + 1, j + i1))) {
                        this.setLocationAndAngles((float)(i + l) + 0.5f, k, (float)(j + i1) + 0.5f, this.rotationYaw, this.rotationPitch);
                        return;
                    }
                    ++i1;
                }
                ++l;
            }
        } else {
            this.setPathToEntity(pathentity);
        }
    }

    protected boolean func_25026_u() {
        return this.getIsSitting() || this.field_25042_g;
    }

    public boolean attackEntityFrom(Entity entity, int i) {
        this.setIsSitting(false);
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            i = (i + 1) / 2;
        }
        if (super.attackEntityFrom(entity, i)) {
            if (!this.func_25030_y() && !this.getIsAngry()) {
                if (entity instanceof EntityPlayer) {
                    this.setIsAngry(true);
                    this.entityToAttack = entity;
                }
                if (entity instanceof EntityArrow && ((EntityArrow)entity).owner != null) {
                    entity = ((EntityArrow)entity).owner;
                }
                if (entity instanceof EntityLiving) {
                    List list = this.worldObj.getEntitiesWithinAABB(EntityWolf.class, AxisAlignedBB.getBoundingBoxFromPool(this.posX, this.posY, this.posZ, this.posX + 1.0, this.posY + 1.0, this.posZ + 1.0).expand(16.0, 4.0, 16.0));
                    for (Entity entity1 : list) {
                        EntityWolf entitywolf = (EntityWolf)entity1;
                        if (entitywolf.func_25030_y() || entitywolf.entityToAttack != null) continue;
                        entitywolf.entityToAttack = entity;
                        if (!(entity instanceof EntityPlayer)) continue;
                        entitywolf.setIsAngry(true);
                    }
                }
            } else if (entity != this && entity != null) {
                if (this.func_25030_y() && entity instanceof EntityPlayer && ((EntityPlayer)entity).username.equalsIgnoreCase(this.getOwner())) {
                    return true;
                }
                this.entityToAttack = entity;
            }
            return true;
        }
        return false;
    }

    protected Entity findPlayerToAttack() {
        if (this.getIsAngry()) {
            return this.worldObj.getClosestPlayerToEntity(this, 16.0);
        }
        return null;
    }

    protected void attackEntity(Entity entity, float f) {
        if (f > 2.0f && f < 6.0f && this.rand.nextInt(10) == 0) {
            if (this.onGround) {
                double d = entity.posX - this.posX;
                double d1 = entity.posZ - this.posZ;
                float f1 = MathHelper.sqrt_double(d * d + d1 * d1);
                this.motionX = d / (double)f1 * 0.5 * (double)0.8f + this.motionX * (double)0.2f;
                this.motionZ = d1 / (double)f1 * 0.5 * (double)0.8f + this.motionZ * (double)0.2f;
                this.motionY = 0.4f;
            }
        } else if ((double)f < 1.5 && entity.boundingBox.maxY > this.boundingBox.minY && entity.boundingBox.minY < this.boundingBox.maxY) {
            this.attackTime = 20;
            int byte0 = 2;
            if (this.func_25030_y()) {
                byte0 = 4;
            }
            entity.attackEntityFrom(this, byte0);
        }
    }

    public boolean interact(EntityPlayer entityplayer) {
        ItemStack itemstack = entityplayer.inventory.getCurrentItem();
        if (!this.func_25030_y()) {
            if (itemstack != null && itemstack.itemID == Item.bone.shiftedIndex && !this.getIsAngry()) {
                --itemstack.stackSize;
                if (itemstack.stackSize <= 0) {
                    entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, null);
                }
                if (!this.worldObj.singleplayerWorld) {
                    if (this.rand.nextInt(3) == 0) {
                        this.setIsTamed(true);
                        this.setPathToEntity(null);
                        this.setIsSitting(true);
                        this.health = 20;
                        this.setOwner(entityplayer.username);
                        this.isNowTamed(true);
                        this.worldObj.sendTrackedEntityStatusUpdatePacket(this, (byte)7);
                    } else {
                        this.isNowTamed(false);
                        this.worldObj.sendTrackedEntityStatusUpdatePacket(this, (byte)6);
                    }
                }
                return true;
            }
        } else {
            ItemFood itemfood;
            if (itemstack != null && Item.itemsList[itemstack.itemID] instanceof ItemFood && (itemfood = (ItemFood)Item.itemsList[itemstack.itemID]).func_25010_k() && this.dataWatcher.getWatchableObjectInteger(18) < 20) {
                --itemstack.stackSize;
                if (itemstack.stackSize <= 0) {
                    entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, null);
                }
                this.heal(((ItemFood)Item.porkRaw).getHealAmount());
                return true;
            }
            if (entityplayer.username.equalsIgnoreCase(this.getOwner())) {
                if (!this.worldObj.singleplayerWorld) {
                    this.setIsSitting(!this.getIsSitting());
                    this.isJumping = false;
                    this.setPathToEntity(null);
                }
                return true;
            }
        }
        return false;
    }

    void isNowTamed(boolean flag) {
        String s = "heart";
        if (!flag) {
            s = "smoke";
        }
        int i = 0;
        while (i < 7) {
            double d = this.rand.nextGaussian() * 0.02;
            double d1 = this.rand.nextGaussian() * 0.02;
            double d2 = this.rand.nextGaussian() * 0.02;
            this.worldObj.spawnParticle(s, this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + 0.5 + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, d, d1, d2);
            ++i;
        }
    }

    public int getMaxSpawnedInChunk() {
        return 8;
    }

    public String getOwner() {
        return this.dataWatcher.getWatchableObjectString(17);
    }

    public void setOwner(String s) {
        this.dataWatcher.updateObject(17, s);
    }

    public boolean getIsSitting() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 1) != 0;
    }

    public void setIsSitting(boolean flag) {
        byte byte0 = this.dataWatcher.getWatchableObjectByte(16);
        if (flag) {
            this.dataWatcher.updateObject(16, (byte)(byte0 | 1));
        } else {
            this.dataWatcher.updateObject(16, (byte)(byte0 & 0xFFFFFFFE));
        }
    }

    public boolean getIsAngry() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 2) != 0;
    }

    public void setIsAngry(boolean flag) {
        byte byte0 = this.dataWatcher.getWatchableObjectByte(16);
        if (flag) {
            this.dataWatcher.updateObject(16, (byte)(byte0 | 2));
        } else {
            this.dataWatcher.updateObject(16, (byte)(byte0 & 0xFFFFFFFD));
        }
    }

    public boolean func_25030_y() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 4) != 0;
    }

    public void setIsTamed(boolean flag) {
        byte byte0 = this.dataWatcher.getWatchableObjectByte(16);
        if (flag) {
            this.dataWatcher.updateObject(16, (byte)(byte0 | 4));
        } else {
            this.dataWatcher.updateObject(16, (byte)(byte0 & 0xFFFFFFFB));
        }
    }
}

