/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityMob;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.util.MathHelper;

public class EntityZombie
extends EntityMob {
    public EntityZombie(World world) {
        super(world);
        this.scoreValue = 30;
        this.texture = "/mob/zombie.png";
        this.move_Speed = 0.5f;
        this.attackStrength = 5;
    }

    public void onLivingUpdate() {
        float f;
        if (this.worldObj.isDaytime() && (f = this.getEntityBrightness(1.0f)) > 0.5f && this.worldObj.canBlockSeeTheSky(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ)) && this.rand.nextFloat() * 30.0f < (f - 0.4f) * 2.0f) {
            this.fire = 300;
        }
        super.onLivingUpdate();
    }

    public void onDeath(Entity entity) {
        super.onDeath(entity);
        int i = Item.flint.shiftedIndex;
        if (i > 0) {
            int j = this.rand.nextInt(3);
            int k = 0;
            while (k < j) {
                this.dropItem(i, 1);
                ++k;
            }
        }
    }

    protected String getLivingSound() {
        return "mob.zombie";
    }

    protected String getHurtSound() {
        return "mob.zombiehurt";
    }

    protected String getDeathSound() {
        return "mob.zombiedeath";
    }

    protected int getDropItemId() {
        return Item.feather.shiftedIndex;
    }
}

