/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity.item;

import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;

public class ItemBlock
extends Item {
    private int blockID;

    public ItemBlock(int i) {
        super(i);
        this.blockID = i + 256;
        this.setIconIndex(Block.allBlocks[i + 256].getBlockTextureFromSide(2));
    }

    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int l) {
        boolean alreadyPlaced = false;
        if (itemstack.itemID == Block.stepSingle.blockID && itemstack.stackSize != 0 && world.getBlockId(i, j, k) == Block.stepSingle.blockID && !entityplayer.isSneaking()) {
            Block doubleStep;
            int orientation = world.getBlockMetadata(i, j, k);
            if (l == 0 && orientation == 1) {
                doubleStep = Block.stepDouble;
                if (world.setBlockWithNotify(i, j, k, doubleStep.blockID)) {
                    doubleStep.onBlockPlaced(world, i, j, k, l);
                    doubleStep.onBlockPlacedBy(world, i, j, k, entityplayer);
                    world.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, doubleStep.stepSound.stepSoundDir(), (doubleStep.stepSound.getVolume() + 1.0f) / 2.0f, doubleStep.stepSound.getPitch() * 0.8f);
                    --itemstack.stackSize;
                    alreadyPlaced = true;
                }
            }
            if (l == 1 && orientation == 0) {
                doubleStep = Block.stepDouble;
                if (world.setBlockWithNotify(i, j, k, doubleStep.blockID)) {
                    doubleStep.onBlockPlaced(world, i, j, k, l);
                    doubleStep.onBlockPlacedBy(world, i, j, k, entityplayer);
                    world.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, doubleStep.stepSound.stepSoundDir(), (doubleStep.stepSound.getVolume() + 1.0f) / 2.0f, doubleStep.stepSound.getPitch() * 0.8f);
                    --itemstack.stackSize;
                    alreadyPlaced = true;
                }
            }
            if (l > 1 && orientation > 0 && l == orientation) {
                doubleStep = Block.stepDouble;
                if (world.setBlockWithNotify(i, j, k, doubleStep.blockID)) {
                    doubleStep.onBlockPlaced(world, i, j, k, l);
                    doubleStep.onBlockPlacedBy(world, i, j, k, entityplayer);
                    world.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, doubleStep.stepSound.stepSoundDir(), (doubleStep.stepSound.getVolume() + 1.0f) / 2.0f, doubleStep.stepSound.getPitch() * 0.8f);
                    --itemstack.stackSize;
                    alreadyPlaced = true;
                }
            }
        }
        if (world.getBlockId(i, j, k) == Block.snow.blockID) {
            l = 0;
        } else {
            if (l == 0) {
                --j;
            }
            if (l == 1) {
                ++j;
            }
            if (l == 2) {
                --k;
            }
            if (l == 3) {
                ++k;
            }
            if (l == 4) {
                --i;
            }
            if (l == 5) {
                ++i;
            }
        }
        if (itemstack.stackSize == 0) {
            return false;
        }
        if (j == 127 && Block.allBlocks[this.blockID].blockMaterial.isSolidMaterial()) {
            return false;
        }
        if (world.canBlockBePlacedAt(this.blockID, i, j, k, false, l)) {
            Block block = Block.allBlocks[this.blockID];
            if (world.setBlockAndMetadataWithNotify(i, j, k, this.blockID, this.getMetadata(itemstack.getItemDamage()))) {
                Block.allBlocks[this.blockID].onBlockPlaced(world, i, j, k, l);
                Block.allBlocks[this.blockID].onBlockPlacedBy(world, i, j, k, entityplayer);
                Block.allBlocks[this.blockID].onBlockPlacedByAt(world, i, j, k, l, entityplayer);
                world.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, block.stepSound.stepSoundDir(), (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
                --itemstack.stackSize;
            }
            return true;
        }
        return false;
    }

    public String getItemName() {
        return Block.allBlocks[this.blockID].getBlockName();
    }
}

