/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity.item;

import com.mojang.minecraft.entity.EntityArrow;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.World;

public class ItemBow
extends Item {
    public ItemBow(int i) {
        super(i);
        this.maxStackSize = 1;
    }

    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        System.out.println("Drawing!");
        float damageMult = 1.0f;
        if (entityplayer.inventory.armorInventory[2] != null && entityplayer.inventory.armorInventory[2].itemID == Item.quiver.shiftedIndex) {
            damageMult = 2.0f;
            entityplayer.startUsing(itemstack, this.getMaxItemUseDuration(itemstack));
            return itemstack;
        }
        if (entityplayer.inventory.consumeInventoryItem(Item.arrow.shiftedIndex)) {
            world.playSoundAtEntity(entityplayer, "random.bow", 1.0f, 1.0f / (itemRand.nextFloat() * 0.4f + 0.8f));
            if (!world.singleplayerWorld) {
                world.entityJoinedWorld(new EntityArrow(world, entityplayer, damageMult));
            }
        }
        return itemstack;
    }

    public int getMaxItemUseDuration(ItemStack par1ItemStack) {
        return 72000;
    }

    public void onPlayerStoppedUsing(ItemStack itemstack, World world, EntityPlayer entityplayer, int par4) {
        System.out.println("Firing with strength: " + (this.getMaxItemUseDuration(itemstack) - par4));
        if (entityplayer.inventory.consumeInventoryItem(Item.arrow.shiftedIndex)) {
            int i = this.getMaxItemUseDuration(itemstack) - par4;
            float f = (float)i / 20.0f;
            if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
                return;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            world.playSoundAtEntity(entityplayer, "random.bow", 1.0f, 1.0f / (itemRand.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            world.entityJoinedWorld(new EntityArrow(world, entityplayer, f * 2.0f));
        }
    }
}

