/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity.item;

import com.mojang.minecraft.entity.EntityCow;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.EntitySlime;
import com.mojang.minecraft.entity.MovingObjectPosition;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.enums.EnumMovingObjectType;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.render.Vec3D;
import com.mojang.minecraft.util.MathHelper;

public class ItemBucket
extends Item {
    private int bucketItem;

    public ItemBucket(int i, int j) {
        super(i);
        this.maxStackSize = 1;
        this.bucketItem = j;
    }

    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        float f9;
        float f6;
        float f8;
        double d3;
        float f5;
        float f = 1.0f;
        float f1 = entityplayer.prevRotationPitch + (entityplayer.rotationPitch - entityplayer.prevRotationPitch) * f;
        float f2 = entityplayer.prevRotationYaw + (entityplayer.rotationYaw - entityplayer.prevRotationYaw) * f;
        double d = entityplayer.prevPosX + (entityplayer.posX - entityplayer.prevPosX) * (double)f;
        double d1 = entityplayer.prevPosY + (entityplayer.posY - entityplayer.prevPosY) * (double)f + 1.62 - (double)entityplayer.yOffset;
        double d2 = entityplayer.prevPosZ + (entityplayer.posZ - entityplayer.prevPosZ) * (double)f;
        Vec3D vec3d = Vec3D.createVector(d, d1, d2);
        float f3 = MathHelper.cos(-f2 * 0.01745329f - 3.141593f);
        float f4 = MathHelper.sin(-f2 * 0.01745329f - 3.141593f);
        float f7 = f4 * (f5 = -MathHelper.cos(-f1 * 0.01745329f));
        Vec3D vec3d1 = vec3d.addVector((double)f7 * (d3 = 5.0), (double)(f8 = (f6 = MathHelper.sin(-f1 * 0.01745329f))) * d3, (double)(f9 = f3 * f5) * d3);
        MovingObjectPosition movingobjectposition = world.rayTraceBlocks_do(vec3d, vec3d1, this.bucketItem == 0);
        if (movingobjectposition == null && this.shiftedIndex != Item.bucketMilk.shiftedIndex) {
            return itemstack;
        }
        if (this.shiftedIndex != Item.bucketMilk.shiftedIndex && movingobjectposition.typeOfHit == EnumMovingObjectType.TILE) {
            int i = movingobjectposition.blockX;
            int j = movingobjectposition.blockY;
            int k = movingobjectposition.blockZ;
            if (!world.canMineBlock(entityplayer, i, j, k)) {
                return itemstack;
            }
            if (this.bucketItem == 0) {
                if (world.getMaterialXYZ(i, j, k) == Material.water && world.getBlockMetadata(i, j, k) == 0) {
                    world.setBlockWithNotify(i, j, k, 0);
                    return new ItemStack(Item.bucketWater);
                }
                if (world.getMaterialXYZ(i, j, k) == Material.lava && world.getBlockMetadata(i, j, k) == 0) {
                    world.setBlockWithNotify(i, j, k, 0);
                    return new ItemStack(Item.bucketLava);
                }
            } else {
                if (movingobjectposition.sideHit == 0) {
                    --j;
                }
                if (movingobjectposition.sideHit == 1) {
                    ++j;
                }
                if (movingobjectposition.sideHit == 2) {
                    --k;
                }
                if (movingobjectposition.sideHit == 3) {
                    ++k;
                }
                if (movingobjectposition.sideHit == 4) {
                    --i;
                }
                if (movingobjectposition.sideHit == 5) {
                    ++i;
                }
                if (!(world.getBlockId(i, j, k) != 0 && world.getMaterialXYZ(i, j, k).isSolidMaterial() || this.shiftedIndex == Item.bucketMilk.shiftedIndex || this.shiftedIndex == Item.bucketSlime.shiftedIndex)) {
                    world.setBlockAndMetadataWithNotify(i, j, k, this.bucketItem, 0);
                    return new ItemStack(Item.bucketEmpty);
                }
                if (!(world.getBlockId(i, j, k) != 0 && world.getMaterialXYZ(i, j, k).isSolidMaterial() || this.shiftedIndex != Item.bucketSlime.shiftedIndex)) {
                    world.playSoundAtEntity(entityplayer, "mob.slimeattack", 0.5f, 1.0f);
                    if (!world.singleplayerWorld) {
                        EntitySlime slime = new EntitySlime(world);
                        slime.setSlimeSize(1);
                        slime.setPosition((double)i + 0.5, (double)j + 0.5, (double)k + 0.5);
                        world.entityJoinedWorld(slime);
                        slime.isSpecial = true;
                        System.out.println("Spawning slime from bucket");
                        return new ItemStack(Item.bucketEmpty);
                    }
                }
            }
        } else if (this.bucketItem == 0 && movingobjectposition.entityHit instanceof EntityCow) {
            return new ItemStack(Item.bucketMilk);
        }
        if (this.shiftedIndex == Item.bucketMilk.shiftedIndex) {
            if (movingobjectposition != null && movingobjectposition.entityHit instanceof EntityCow) {
                return new ItemStack(Item.bucketMilk);
            }
            return new ItemStack(Item.bucketEmpty);
        }
        return itemstack;
    }
}

