/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity.item;

import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.EntityPlayerMP;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.network.packet.Packet53BlockChange;
import com.mojang.minecraft.server.WorldServer;

public class ItemInWorldManager {
    private WorldServer thisWorld;
    public EntityPlayer thisPlayer;
    private float field_672_d = 0.0f;
    private int field_22055_d;
    private int field_22054_g;
    private int field_22053_h;
    private int field_22052_i;
    private int blockMineTime;
    private boolean blockMineSuccessful;
    private int miningPosX;
    private int miningPosY;
    private int miningPosZ;
    private int field_22046_o;

    public ItemInWorldManager(WorldServer worldserver) {
        this.thisWorld = worldserver;
    }

    public void func_328_a() {
        ++this.blockMineTime;
        if (this.blockMineSuccessful) {
            int i = this.blockMineTime - this.field_22046_o;
            int j = this.thisWorld.getBlockId(this.miningPosX, this.miningPosY, this.miningPosZ);
            if (j != 0) {
                Block block = Block.allBlocks[j];
                float f = block.blockStrength(this.thisPlayer) * (float)(i + 1);
                if (f >= 1.0f) {
                    this.blockMineSuccessful = false;
                    this.checkIfCanHarvestThisBlock(this.miningPosX, this.miningPosY, this.miningPosZ);
                }
            } else {
                this.blockMineSuccessful = false;
            }
        }
    }

    public void itemDoAClickABlock(int i, int j, int k, int l) {
        this.thisWorld.func_28096_a(null, i, j, k, l);
        this.field_22055_d = this.blockMineTime;
        int blockID = this.thisWorld.getBlockId(i, j, k);
        if (blockID > 0) {
            Block.allBlocks[blockID].onBlockClicked(this.thisWorld, i, j, k, this.thisPlayer);
        }
        if (blockID > 0 && Block.allBlocks[blockID].blockStrength(this.thisPlayer) >= 1.0f) {
            this.checkIfCanHarvestThisBlock(i, j, k);
        } else {
            this.field_22054_g = i;
            this.field_22053_h = j;
            this.field_22052_i = k;
        }
    }

    public void itemDoADigABlock(int posX, int posY, int posZ) {
        if (posX == this.field_22054_g && posY == this.field_22053_h && posZ == this.field_22052_i) {
            int l = this.blockMineTime - this.field_22055_d;
            int blockID = this.thisWorld.getBlockId(posX, posY, posZ);
            if (blockID != 0) {
                Block block = Block.allBlocks[blockID];
                float calculateBlockStrength = block.blockStrength(this.thisPlayer) * (float)(l + 1);
                if (calculateBlockStrength >= 0.0f) {
                    this.checkIfCanHarvestThisBlock(posX, posY, posZ);
                } else if (!this.blockMineSuccessful) {
                    this.blockMineSuccessful = true;
                    this.miningPosX = posX;
                    this.miningPosY = posY;
                    this.miningPosZ = posZ;
                    this.field_22046_o = this.field_22055_d;
                }
            }
        }
        this.field_672_d = 0.0f;
    }

    public boolean removeBlock(int x, int y, int z) {
        Block block = Block.allBlocks[this.thisWorld.getBlockId(x, y, z)];
        int meta = this.thisWorld.getBlockMetadata(x, y, z);
        boolean flag = this.thisWorld.setBlockWithNotify(x, y, z, 0);
        if (block != null && flag) {
            block.onBlockDestroyedByPlayer(this.thisWorld, x, y, z, meta);
        }
        return flag;
    }

    public boolean checkIfCanHarvestThisBlock(int x, int y, int z) {
        int blockID = this.thisWorld.getBlockId(x, y, z);
        int blockMeta = this.thisWorld.getBlockMetadata(x, y, z);
        this.thisWorld.sendDoorChangeState(this.thisPlayer, 2001, x, y, z, blockID + this.thisWorld.getBlockMetadata(x, y, z) * 256);
        boolean flag = this.removeBlock(x, y, z);
        ItemStack itemstack = this.thisPlayer.getCurrentEquippedItem();
        if (itemstack != null) {
            itemstack.hitBlock(blockID, x, y, z, this.thisPlayer);
            if (itemstack.stackSize == 0) {
                itemstack.func_577_a(this.thisPlayer);
                this.thisPlayer.destroyCurrentEquippedItem();
            }
        }
        if (flag && this.thisPlayer.canHarvestBlock(Block.allBlocks[blockID])) {
            if (this.thisPlayer.checkGoldTouch(Block.allBlocks[blockID])) {
                Block.allBlocks[blockID].dropBlockGoldTouch(this.thisWorld, x, y, z, blockMeta, 1.0f);
            } else {
                Block.allBlocks[blockID].harvestBlock(this.thisWorld, this.thisPlayer, x, y, z, blockMeta);
            }
            ((EntityPlayerMP)this.thisPlayer).playerNetServerHandler.sendPacket(new Packet53BlockChange(x, y, z, this.thisWorld));
        }
        return flag;
    }

    public boolean startUsingItem(EntityPlayer entityplayer, World world, ItemStack itemstack) {
        int i = itemstack.stackSize;
        ItemStack itemstack1 = itemstack.useItemRightClick(world, entityplayer);
        if (itemstack1 != itemstack || itemstack1 != null && itemstack1.stackSize != i) {
            entityplayer.inventory.mainInventory[entityplayer.inventory.currentItem] = itemstack1;
            if (itemstack1.stackSize == 0) {
                entityplayer.inventory.mainInventory[entityplayer.inventory.currentItem] = null;
            }
            return true;
        }
        return false;
    }

    public boolean stopUsingItem(EntityPlayer entityplayer, World world, ItemStack itemstack) {
        itemstack.onPlayerStoppedUsing(world, entityplayer, entityplayer.itemUseTime);
        return true;
    }

    public boolean activeBlockOrUseItem(EntityPlayer entityplayer, World world, ItemStack itemstack, int i, int j, int k, int l) {
        int i1 = world.getBlockId(i, j, k);
        if (i1 > 0 && !entityplayer.isSneaking() && Block.allBlocks[i1].blockActivated(world, i, j, k, entityplayer)) {
            return true;
        }
        if (itemstack == null) {
            return false;
        }
        return itemstack.useItem(entityplayer, world, i, j, k, l);
    }
}

